/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import com.sun.imageio.stream.StreamCloser;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import javax.imageio.stream.ImageOutputStreamImpl;

public class FileCacheImageOutputStream
extends ImageOutputStreamImpl {
    private OutputStream stream;
    private File cacheFile;
    private RandomAccessFile cache;
    private long maxStreamPos = 0L;

    public FileCacheImageOutputStream(OutputStream outputStream, File file) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("stream == null!");
        }
        if (file != null && !file.isDirectory()) {
            throw new IllegalArgumentException("Not a directory!");
        }
        this.stream = outputStream;
        this.cacheFile = File.createTempFile("imageio", ".tmp", file);
        this.cache = new RandomAccessFile(this.cacheFile, "rw");
        StreamCloser.addToQueue(this);
    }

    public int read() throws IOException {
        this.bitOffset = 0;
        int n2 = this.cache.read();
        if (n2 != -1) {
            ++this.streamPos;
        }
        return n2;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        this.bitOffset = 0;
        int n4 = this.cache.read(byArray, n2, n3);
        if (n4 != -1) {
            this.streamPos += (long)n4;
        }
        return n4;
    }

    public void write(int n2) throws IOException {
        this.flushBits();
        this.cache.write(n2);
        ++this.streamPos;
        this.maxStreamPos = Math.max(this.maxStreamPos, this.streamPos);
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.flushBits();
        this.cache.write(byArray, n2, n3);
        this.streamPos += (long)n3;
        this.maxStreamPos = Math.max(this.maxStreamPos, this.streamPos);
    }

    public long length() {
        try {
            return this.cache.length();
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    public void seek(long l2) throws IOException {
        this.checkClosed();
        if (l2 < this.flushedPos) {
            throw new IndexOutOfBoundsException();
        }
        this.cache.seek(l2);
        this.streamPos = this.cache.getFilePointer();
        this.maxStreamPos = Math.max(this.maxStreamPos, this.streamPos);
        this.bitOffset = 0;
    }

    public boolean isCached() {
        return true;
    }

    public boolean isCachedFile() {
        return true;
    }

    public boolean isCachedMemory() {
        return false;
    }

    public void close() throws IOException {
        this.maxStreamPos = this.cache.length();
        this.seek(this.maxStreamPos);
        this.flushBefore(this.maxStreamPos);
        super.close();
        this.cache.close();
        this.cacheFile.delete();
        this.stream.flush();
        this.stream = null;
        StreamCloser.removeFromQueue(this);
    }

    public void flushBefore(long l2) throws IOException {
        long l3;
        long l4 = this.flushedPos;
        super.flushBefore(l2);
        if (l3 > 0L) {
            int n2;
            int n3 = 512;
            byte[] byArray = new byte[n3];
            this.cache.seek(l4);
            for (l3 = this.flushedPos - l4; l3 > 0L; l3 -= (long)n2) {
                n2 = (int)Math.min(l3, (long)n3);
                this.cache.readFully(byArray, 0, n2);
                this.stream.write(byArray, 0, n2);
            }
            this.stream.flush();
        }
    }
}

