/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Serializable,
Cloneable {
    private static final int DEFAULT_CAPACITY = 32;
    private static final int MINIMUM_CAPACITY = 4;
    private static final int MAXIMUM_CAPACITY = 0x20000000;
    private transient Object[] table;
    private int size;
    private volatile transient int modCount;
    private transient int threshold;
    private static final Object NULL_KEY = new Object();
    private transient Set<Map.Entry<K, V>> entrySet = null;
    private static final long serialVersionUID = 8188218128353913216L;

    private static Object maskNull(Object object) {
        return object == null ? NULL_KEY : object;
    }

    private static Object unmaskNull(Object object) {
        return object == NULL_KEY ? null : object;
    }

    public IdentityHashMap() {
        this.init(32);
    }

    public IdentityHashMap(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("expectedMaxSize is negative: " + n2);
        }
        this.init(this.capacity(n2));
    }

    private int capacity(int n2) {
        int n3;
        int n4 = 3 * n2 / 2;
        if (n4 > 0x20000000 || n4 < 0) {
            n3 = 0x20000000;
        } else {
            for (n3 = 4; n3 < n4; n3 <<= 1) {
            }
        }
        return n3;
    }

    private void init(int n2) {
        this.threshold = n2 * 2 / 3;
        this.table = new Object[2 * n2];
    }

    public IdentityHashMap(Map<? extends K, ? extends V> map) {
        this((int)((double)(1 + map.size()) * 1.1));
        this.putAll(map);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    private static int hash(Object object, int n2) {
        int n3 = System.identityHashCode(object);
        return (n3 << 1) - (n3 << 8) & n2 - 1;
    }

    private static int nextKeyIndex(int n2, int n3) {
        return n2 + 2 < n3 ? n2 + 2 : 0;
    }

    @Override
    public V get(Object object) {
        Object object2 = IdentityHashMap.maskNull(object);
        Object[] objectArray = this.table;
        int n2 = objectArray.length;
        int n3 = IdentityHashMap.hash(object2, n2);
        Object object3;
        while ((object3 = objectArray[n3]) != object2) {
            if (object3 == null) {
                return null;
            }
            n3 = IdentityHashMap.nextKeyIndex(n3, n2);
        }
        return (V)objectArray[n3 + 1];
    }

    @Override
    public boolean containsKey(Object object) {
        Object object2 = IdentityHashMap.maskNull(object);
        Object[] objectArray = this.table;
        int n2 = objectArray.length;
        int n3 = IdentityHashMap.hash(object2, n2);
        Object object3;
        while ((object3 = objectArray[n3]) != object2) {
            if (object3 == null) {
                return false;
            }
            n3 = IdentityHashMap.nextKeyIndex(n3, n2);
        }
        return true;
    }

    @Override
    public boolean containsValue(Object object) {
        Object[] objectArray = this.table;
        for (int i2 = 1; i2 < objectArray.length; i2 += 2) {
            if (objectArray[i2] != object) continue;
            return true;
        }
        return false;
    }

    private boolean containsMapping(Object object, Object object2) {
        Object object3 = IdentityHashMap.maskNull(object);
        Object[] objectArray = this.table;
        int n2 = objectArray.length;
        int n3 = IdentityHashMap.hash(object3, n2);
        Object object4;
        while ((object4 = objectArray[n3]) != object3) {
            if (object4 == null) {
                return false;
            }
            n3 = IdentityHashMap.nextKeyIndex(n3, n2);
        }
        return objectArray[n3 + 1] == object2;
    }

    @Override
    public V put(K k2, V v2) {
        Object object;
        Object object2 = IdentityHashMap.maskNull(k2);
        Object[] objectArray = this.table;
        int n2 = objectArray.length;
        int n3 = IdentityHashMap.hash(object2, n2);
        while ((object = objectArray[n3]) != null) {
            if (object == object2) {
                Object object3 = objectArray[n3 + 1];
                objectArray[n3 + 1] = v2;
                return (V)object3;
            }
            n3 = IdentityHashMap.nextKeyIndex(n3, n2);
        }
        ++this.modCount;
        objectArray[n3] = object2;
        objectArray[n3 + 1] = v2;
        if (++this.size >= this.threshold) {
            this.resize(n2);
        }
        return null;
    }

    private void resize(int n2) {
        int n3 = n2 * 2;
        Object[] objectArray = this.table;
        int n4 = objectArray.length;
        if (n4 == 0x40000000) {
            if (this.threshold == 0x1FFFFFFF) {
                throw new IllegalStateException("Capacity exhausted.");
            }
            this.threshold = 0x1FFFFFFF;
            return;
        }
        if (n4 >= n3) {
            return;
        }
        Object[] objectArray2 = new Object[n3];
        this.threshold = n3 / 3;
        for (int i2 = 0; i2 < n4; i2 += 2) {
            Object object = objectArray[i2];
            if (object == null) continue;
            Object object2 = objectArray[i2 + 1];
            objectArray[i2] = null;
            objectArray[i2 + 1] = null;
            int n5 = IdentityHashMap.hash(object, n3);
            while (objectArray2[n5] != null) {
                n5 = IdentityHashMap.nextKeyIndex(n5, n3);
            }
            objectArray2[n5] = object;
            objectArray2[n5 + 1] = object2;
        }
        this.table = objectArray2;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        int n2 = map.size();
        if (n2 == 0) {
            return;
        }
        if (n2 > this.threshold) {
            this.resize(this.capacity(n2));
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        Object object2 = IdentityHashMap.maskNull(object);
        Object[] objectArray = this.table;
        int n2 = objectArray.length;
        int n3 = IdentityHashMap.hash(object2, n2);
        while (true) {
            Object object3;
            if ((object3 = objectArray[n3]) == object2) {
                ++this.modCount;
                --this.size;
                Object object4 = objectArray[n3 + 1];
                objectArray[n3 + 1] = null;
                objectArray[n3] = null;
                this.closeDeletion(n3);
                return (V)object4;
            }
            if (object3 == null) {
                return null;
            }
            n3 = IdentityHashMap.nextKeyIndex(n3, n2);
        }
    }

    private boolean removeMapping(Object object, Object object2) {
        Object object3 = IdentityHashMap.maskNull(object);
        Object[] objectArray = this.table;
        int n2 = objectArray.length;
        int n3 = IdentityHashMap.hash(object3, n2);
        while (true) {
            Object object4;
            if ((object4 = objectArray[n3]) == object3) {
                if (objectArray[n3 + 1] != object2) {
                    return false;
                }
                ++this.modCount;
                --this.size;
                objectArray[n3] = null;
                objectArray[n3 + 1] = null;
                this.closeDeletion(n3);
                return true;
            }
            if (object4 == null) {
                return false;
            }
            n3 = IdentityHashMap.nextKeyIndex(n3, n2);
        }
    }

    private void closeDeletion(int n2) {
        Object object;
        Object[] objectArray = this.table;
        int n3 = objectArray.length;
        int n4 = IdentityHashMap.nextKeyIndex(n2, n3);
        while ((object = objectArray[n4]) != null) {
            int n5 = IdentityHashMap.hash(object, n3);
            if (n4 < n5 && (n5 <= n2 || n2 <= n4) || n5 <= n2 && n2 <= n4) {
                objectArray[n2] = object;
                objectArray[n2 + 1] = objectArray[n4 + 1];
                objectArray[n4] = null;
                objectArray[n4 + 1] = null;
                n2 = n4;
            }
            n4 = IdentityHashMap.nextKeyIndex(n4, n3);
        }
    }

    @Override
    public void clear() {
        ++this.modCount;
        Object[] objectArray = this.table;
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            objectArray[i2] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof IdentityHashMap) {
            IdentityHashMap identityHashMap = (IdentityHashMap)object;
            if (identityHashMap.size() != this.size) {
                return false;
            }
            Object[] objectArray = identityHashMap.table;
            for (int i2 = 0; i2 < objectArray.length; i2 += 2) {
                Object object2 = objectArray[i2];
                if (object2 == null || this.containsMapping(object2, objectArray[i2 + 1])) continue;
                return false;
            }
            return true;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return ((Object)this.entrySet()).equals(map.entrySet());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        Object[] objectArray = this.table;
        for (int i2 = 0; i2 < objectArray.length; i2 += 2) {
            Object object = objectArray[i2];
            if (object == null) continue;
            Object object2 = IdentityHashMap.unmaskNull(object);
            n2 += System.identityHashCode(object2) ^ System.identityHashCode(objectArray[i2 + 1]);
        }
        return n2;
    }

    @Override
    public Object clone() {
        try {
            IdentityHashMap identityHashMap = (IdentityHashMap)super.clone();
            identityHashMap.entrySet = null;
            identityHashMap.table = (Object[])this.table.clone();
            return identityHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public Set<K> keySet() {
        Set set = this.keySet;
        if (set != null) {
            return set;
        }
        this.keySet = new KeySet();
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        Collection collection = this.values;
        if (collection != null) {
            return collection;
        }
        this.values = new Values();
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> set = this.entrySet;
        if (set != null) {
            return set;
        }
        this.entrySet = new EntrySet();
        return this.entrySet;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        Object[] objectArray = this.table;
        for (int i2 = 0; i2 < objectArray.length; i2 += 2) {
            Object object = objectArray[i2];
            if (object == null) continue;
            objectOutputStream.writeObject(IdentityHashMap.unmaskNull(object));
            objectOutputStream.writeObject(objectArray[i2 + 1]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt();
        this.init(this.capacity(n2 * 4 / 3));
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.putForCreate(object, object2);
        }
    }

    private void putForCreate(K k2, V v2) throws IOException {
        Object object;
        Object object2 = IdentityHashMap.maskNull(k2);
        Object[] objectArray = this.table;
        int n2 = objectArray.length;
        int n3 = IdentityHashMap.hash(object2, n2);
        while ((object = objectArray[n3]) != null) {
            if (object == object2) {
                throw new StreamCorruptedException();
            }
            n3 = IdentityHashMap.nextKeyIndex(n3, n2);
        }
        objectArray[n3] = object2;
        objectArray[n3 + 1] = v2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends IdentityHashMapIterator<Map.Entry<K, V>>
    implements Map.Entry<K, V> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            this.nextIndex();
            return this;
        }

        @Override
        public K getKey() {
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException("Entry was removed");
            }
            return IdentityHashMap.unmaskNull(this.traversalTable[this.lastReturnedIndex]);
        }

        @Override
        public V getValue() {
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException("Entry was removed");
            }
            return this.traversalTable[this.lastReturnedIndex + 1];
        }

        @Override
        public V setValue(V v2) {
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException("Entry was removed");
            }
            Object object = this.traversalTable[this.lastReturnedIndex + 1];
            this.traversalTable[this.lastReturnedIndex + 1] = v2;
            if (this.traversalTable != IdentityHashMap.this.table) {
                IdentityHashMap.this.put(this.traversalTable[this.lastReturnedIndex], v2);
            }
            return object;
        }

        @Override
        public boolean equals(Object object) {
            if (this.lastReturnedIndex < 0) {
                return super.equals(object);
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return entry.getKey() == this.getKey() && entry.getValue() == this.getValue();
        }

        @Override
        public int hashCode() {
            if (this.lastReturnedIndex < 0) {
                return super.hashCode();
            }
            return System.identityHashCode(this.getKey()) ^ System.identityHashCode(this.getValue());
        }

        public String toString() {
            if (this.lastReturnedIndex < 0) {
                return super.toString();
            }
            return this.getKey() + "=" + this.getValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return IdentityHashMap.this.containsMapping(entry.getKey(), entry.getValue());
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return IdentityHashMap.this.removeMapping(entry.getKey(), entry.getValue());
        }

        @Override
        public int size() {
            return IdentityHashMap.this.size;
        }

        @Override
        public void clear() {
            IdentityHashMap.this.clear();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean bl2 = false;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (!collection.contains(iterator.next())) continue;
                iterator.remove();
                bl2 = true;
            }
            return bl2;
        }

        @Override
        public Object[] toArray() {
            ArrayList arrayList = new ArrayList(this.size());
            for (Map.Entry entry : this) {
                arrayList.add(new AbstractMap.SimpleEntry(entry));
            }
            return arrayList.toArray();
        }

        @Override
        public <T> T[] toArray(T[] objectArray) {
            int n2 = this.size();
            if (objectArray.length < n2) {
                objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n2);
            }
            Iterator iterator = this.iterator();
            for (int i2 = 0; i2 < n2; ++i2) {
                objectArray[i2] = new AbstractMap.SimpleEntry(iterator.next());
            }
            if (objectArray.length > n2) {
                objectArray[n2] = null;
            }
            return objectArray;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class IdentityHashMapIterator<T>
    implements Iterator<T> {
        int index;
        int expectedModCount;
        int lastReturnedIndex;
        boolean indexValid;
        Object[] traversalTable;

        private IdentityHashMapIterator() {
            this.index = IdentityHashMap.this.size != 0 ? 0 : IdentityHashMap.this.table.length;
            this.expectedModCount = IdentityHashMap.this.modCount;
            this.lastReturnedIndex = -1;
            this.traversalTable = IdentityHashMap.this.table;
        }

        @Override
        public boolean hasNext() {
            Object[] objectArray = this.traversalTable;
            for (int i2 = this.index; i2 < objectArray.length; i2 += 2) {
                Object object = objectArray[i2];
                if (object == null) continue;
                this.index = i2;
                this.indexValid = true;
                return true;
            }
            this.index = objectArray.length;
            return false;
        }

        protected int nextIndex() {
            if (IdentityHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (!this.indexValid && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.indexValid = false;
            this.lastReturnedIndex = this.index;
            this.index += 2;
            return this.lastReturnedIndex;
        }

        @Override
        public void remove() {
            Object object;
            if (this.lastReturnedIndex == -1) {
                throw new IllegalStateException();
            }
            if (IdentityHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.expectedModCount = ++IdentityHashMap.this.modCount;
            int n2 = this.lastReturnedIndex;
            this.lastReturnedIndex = -1;
            IdentityHashMap.this.size--;
            this.index = n2;
            this.indexValid = false;
            Object[] objectArray = this.traversalTable;
            int n3 = objectArray.length;
            int n4 = n2;
            Object object2 = objectArray[n4];
            objectArray[n4] = null;
            objectArray[n4 + 1] = null;
            if (objectArray != IdentityHashMap.this.table) {
                IdentityHashMap.this.remove(object2);
                this.expectedModCount = IdentityHashMap.this.modCount;
                return;
            }
            int n5 = IdentityHashMap.nextKeyIndex(n4, n3);
            while ((object = objectArray[n5]) != null) {
                int n6 = IdentityHashMap.hash(object, n3);
                if (n5 < n6 && (n6 <= n4 || n4 <= n5) || n6 <= n4 && n4 <= n5) {
                    if (n5 < n2 && n4 >= n2 && this.traversalTable == IdentityHashMap.this.table) {
                        int n7 = n3 - n2;
                        Object[] objectArray2 = new Object[n7];
                        System.arraycopy(objectArray, n2, objectArray2, 0, n7);
                        this.traversalTable = objectArray2;
                        this.index = 0;
                    }
                    objectArray[n4] = object;
                    objectArray[n4 + 1] = objectArray[n5 + 1];
                    objectArray[n5] = null;
                    objectArray[n5 + 1] = null;
                    n4 = n5;
                }
                n5 = IdentityHashMap.nextKeyIndex(n5, n3);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyIterator
    extends IdentityHashMapIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return IdentityHashMap.unmaskNull(this.traversalTable[this.nextIndex()]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return IdentityHashMap.this.size;
        }

        @Override
        public boolean contains(Object object) {
            return IdentityHashMap.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            int n2 = IdentityHashMap.this.size;
            IdentityHashMap.this.remove(object);
            return IdentityHashMap.this.size != n2;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean bl2 = false;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (!collection.contains(iterator.next())) continue;
                iterator.remove();
                bl2 = true;
            }
            return bl2;
        }

        @Override
        public void clear() {
            IdentityHashMap.this.clear();
        }

        @Override
        public int hashCode() {
            int n2 = 0;
            for (Object k2 : this) {
                n2 += System.identityHashCode(k2);
            }
            return n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueIterator
    extends IdentityHashMapIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.traversalTable[this.nextIndex() + 1];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return IdentityHashMap.this.size;
        }

        @Override
        public boolean contains(Object object) {
            return IdentityHashMap.this.containsValue(object);
        }

        @Override
        public boolean remove(Object object) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != object) continue;
                iterator.remove();
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            IdentityHashMap.this.clear();
        }
    }
}

