/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import sun.util.calendar.BaseCalendar;
import sun.util.calendar.CalendarDate;
import sun.util.calendar.CalendarSystem;
import sun.util.calendar.CalendarUtils;
import sun.util.calendar.Era;
import sun.util.calendar.Gregorian;
import sun.util.calendar.JulianCalendar;
import sun.util.calendar.ZoneInfo;

public class GregorianCalendar
extends Calendar {
    public static final int BC = 0;
    static final int BCE = 0;
    public static final int AD = 1;
    static final int CE = 1;
    private static final int EPOCH_OFFSET = 719163;
    private static final int EPOCH_YEAR = 1970;
    static final int[] MONTH_LENGTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    static final int[] LEAP_MONTH_LENGTH = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int ONE_SECOND = 1000;
    private static final int ONE_MINUTE = 60000;
    private static final int ONE_HOUR = 3600000;
    private static final long ONE_DAY = 86400000L;
    private static final long ONE_WEEK = 604800000L;
    static final int[] MIN_VALUES = new int[]{0, 1, 0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, -46800000, 0};
    static final int[] LEAST_MAX_VALUES = new int[]{1, 292269054, 11, 52, 4, 28, 365, 7, 4, 1, 11, 23, 59, 59, 999, 50400000, 1200000};
    static final int[] MAX_VALUES = new int[]{1, 292278994, 11, 53, 6, 31, 366, 7, 6, 1, 11, 23, 59, 59, 999, 50400000, 0x6DDD00};
    static final long serialVersionUID = -8125100834729963327L;
    private static final Gregorian gcal = CalendarSystem.getGregorianCalendar();
    private static JulianCalendar jcal;
    private static Era[] jeras;
    static final long DEFAULT_GREGORIAN_CUTOVER = -12219292800000L;
    private long gregorianCutover = -12219292800000L;
    private transient long gregorianCutoverDate = 577736L;
    private transient int gregorianCutoverYear = 1582;
    private transient int gregorianCutoverYearJulian = 1582;
    private transient BaseCalendar.Date gdate;
    private transient BaseCalendar.Date cdate;
    private transient BaseCalendar calsys;
    private transient int[] zoneOffsets;
    private transient int[] originalFields;
    private transient long cachedFixedDate = Long.MIN_VALUE;

    public GregorianCalendar() {
        this(TimeZone.getDefaultRef(), Locale.getDefault());
        this.setZoneShared(true);
    }

    public GregorianCalendar(TimeZone timeZone) {
        this(timeZone, Locale.getDefault());
    }

    public GregorianCalendar(Locale locale) {
        this(TimeZone.getDefaultRef(), locale);
        this.setZoneShared(true);
    }

    public GregorianCalendar(TimeZone timeZone, Locale locale) {
        super(timeZone, locale);
        this.gdate = (BaseCalendar.Date)gcal.newCalendarDate(timeZone);
        this.setTimeInMillis(System.currentTimeMillis());
    }

    public GregorianCalendar(int n2, int n3, int n4) {
        this(n2, n3, n4, 0, 0, 0, 0);
    }

    public GregorianCalendar(int n2, int n3, int n4, int n5, int n6) {
        this(n2, n3, n4, n5, n6, 0, 0);
    }

    public GregorianCalendar(int n2, int n3, int n4, int n5, int n6, int n7) {
        this(n2, n3, n4, n5, n6, n7, 0);
    }

    GregorianCalendar(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.gdate = (BaseCalendar.Date)gcal.newCalendarDate(this.getZone());
        this.set(1, n2);
        this.set(2, n3);
        this.set(5, n4);
        this.set(11, n5);
        this.set(12, n6);
        this.set(13, n7);
        this.internalSet(14, n8);
    }

    public void setGregorianChange(Date date) {
        long l2 = date.getTime();
        if (l2 == this.gregorianCutover) {
            return;
        }
        this.complete();
        this.setGregorianChange(l2);
    }

    private void setGregorianChange(long l2) {
        this.gregorianCutover = l2;
        this.gregorianCutoverDate = CalendarUtils.floorDivide(l2, 86400000L) + 719163L;
        if (l2 == Long.MAX_VALUE) {
            ++this.gregorianCutoverDate;
        }
        BaseCalendar.Date date = this.getGregorianCutoverDate();
        this.gregorianCutoverYear = date.getYear();
        BaseCalendar baseCalendar = GregorianCalendar.getJulianCalendarSystem();
        date = (BaseCalendar.Date)baseCalendar.newCalendarDate(TimeZone.NO_TIMEZONE);
        baseCalendar.getCalendarDateFromFixedDate(date, this.gregorianCutoverDate - 1L);
        this.gregorianCutoverYearJulian = date.getNormalizedYear();
        if (this.time < this.gregorianCutover) {
            this.setUnnormalized();
        }
    }

    public final Date getGregorianChange() {
        return new Date(this.gregorianCutover);
    }

    public boolean isLeapYear(int n2) {
        boolean bl2;
        if ((n2 & 3) != 0) {
            return false;
        }
        if (n2 > this.gregorianCutoverYear) {
            return n2 % 100 != 0 || n2 % 400 == 0;
        }
        if (n2 < this.gregorianCutoverYearJulian) {
            return true;
        }
        if (this.gregorianCutoverYear == this.gregorianCutoverYearJulian) {
            BaseCalendar.Date date = this.getCalendarDate(this.gregorianCutoverDate);
            bl2 = date.getMonth() < 3;
        } else {
            boolean bl3 = bl2 = n2 == this.gregorianCutoverYear;
        }
        return bl2 ? n2 % 100 != 0 || n2 % 400 == 0 : true;
    }

    public boolean equals(Object object) {
        return object instanceof GregorianCalendar && super.equals(object) && this.gregorianCutover == ((GregorianCalendar)object).gregorianCutover;
    }

    public int hashCode() {
        return super.hashCode() ^ (int)this.gregorianCutoverDate;
    }

    public void add(int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        if (n2 < 0 || n2 >= 15) {
            throw new IllegalArgumentException();
        }
        this.complete();
        if (n2 == 1) {
            int n4 = this.internalGet(1);
            if (this.internalGetEra() == 1) {
                if ((n4 += n3) > 0) {
                    this.set(1, n4);
                } else {
                    this.set(1, 1 - n4);
                    this.set(0, 0);
                }
            } else if ((n4 -= n3) > 0) {
                this.set(1, n4);
            } else {
                this.set(1, 1 - n4);
                this.set(0, 1);
            }
            this.pinDayOfMonth();
        } else if (n2 == 2) {
            int n5 = this.internalGet(2) + n3;
            int n6 = this.internalGet(1);
            int n7 = n5 >= 0 ? n5 / 12 : (n5 + 1) / 12 - 1;
            if (n7 != 0) {
                if (this.internalGetEra() == 1) {
                    if ((n6 += n7) > 0) {
                        this.set(1, n6);
                    } else {
                        this.set(1, 1 - n6);
                        this.set(0, 0);
                    }
                } else if ((n6 -= n7) > 0) {
                    this.set(1, n6);
                } else {
                    this.set(1, 1 - n6);
                    this.set(0, 1);
                }
            }
            if (n5 >= 0) {
                this.set(2, n5 % 12);
            } else {
                if ((n5 %= 12) < 0) {
                    n5 += 12;
                }
                this.set(2, 0 + n5);
            }
            this.pinDayOfMonth();
        } else if (n2 == 0) {
            int n8 = this.internalGet(0) + n3;
            if (n8 < 0) {
                n8 = 0;
            }
            if (n8 > 1) {
                n8 = 1;
            }
            this.set(0, n8);
        } else {
            long l2 = n3;
            long l3 = 0L;
            switch (n2) {
                case 10: 
                case 11: {
                    l2 *= 3600000L;
                    break;
                }
                case 12: {
                    l2 *= 60000L;
                    break;
                }
                case 13: {
                    l2 *= 1000L;
                    break;
                }
                case 14: {
                    break;
                }
                case 3: 
                case 4: 
                case 8: {
                    l2 *= 7L;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 9: {
                    l2 = n3 / 2;
                    l3 = 12 * (n3 % 2);
                }
            }
            if (n2 >= 10) {
                this.setTimeInMillis(this.time + l2);
                return;
            }
            long l4 = this.getCurrentFixedDate();
            l3 += (long)this.internalGet(11);
            l3 *= 60L;
            l3 += (long)this.internalGet(12);
            l3 *= 60L;
            l3 += (long)this.internalGet(13);
            l3 *= 1000L;
            if ((l3 += (long)this.internalGet(14)) >= 86400000L) {
                ++l4;
                l3 -= 86400000L;
            } else if (l3 < 0L) {
                --l4;
                l3 += 86400000L;
            }
            int n9 = this.internalGet(15) + this.internalGet(16);
            this.setTimeInMillis(((l4 += l2) - 719163L) * 86400000L + l3 - (long)n9);
            if ((n9 -= this.internalGet(15) + this.internalGet(16)) != 0) {
                this.setTimeInMillis(this.time + (long)n9);
                long l5 = this.getCurrentFixedDate();
                if (l5 != l4) {
                    this.setTimeInMillis(this.time - (long)n9);
                }
            }
        }
    }

    public void roll(int n2, boolean bl2) {
        this.roll(n2, bl2 ? 1 : -1);
    }

    public void roll(int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        if (n2 < 0 || n2 >= 15) {
            throw new IllegalArgumentException();
        }
        this.complete();
        int n4 = this.getMinimum(n2);
        int n5 = this.getMaximum(n2);
        switch (n2) {
            case 0: 
            case 1: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 10: 
            case 11: {
                int n6 = n5 + 1;
                int n7 = this.internalGet(n2);
                int n8 = (n7 + n3) % n6;
                if (n8 < 0) {
                    n8 += n6;
                }
                this.time += (long)(3600000 * (n8 - n7));
                CalendarDate calendarDate = this.calsys.getCalendarDate(this.time, this.getZone());
                if (this.internalGet(5) != calendarDate.getDayOfMonth()) {
                    calendarDate.setDate(this.internalGet(1), this.internalGet(2) + 1, this.internalGet(5));
                    if (n2 == 10) {
                        assert (this.internalGet(9) == 1);
                        calendarDate.addHours(12);
                    }
                    this.time = this.calsys.getTime(calendarDate);
                }
                this.internalSet(n2, calendarDate.getHours() % n6);
                int n9 = calendarDate.getZoneOffset();
                int n10 = calendarDate.getDaylightSaving();
                this.internalSet(15, n9 - n10);
                this.internalSet(16, n10);
                return;
            }
            case 2: {
                if (!this.isCutoverYear(this.cdate.getNormalizedYear())) {
                    int n11 = (this.internalGet(2) + n3) % 12;
                    if (n11 < 0) {
                        n11 += 12;
                    }
                    this.set(2, n11);
                    int n12 = this.monthLength(n11);
                    if (this.internalGet(5) > n12) {
                        this.set(5, n12);
                    }
                } else {
                    int n13 = this.getActualMaximum(2) + 1;
                    int n14 = (this.internalGet(2) + n3) % n13;
                    if (n14 < 0) {
                        n14 += n13;
                    }
                    this.set(2, n14);
                    int n15 = this.getActualMaximum(5);
                    if (this.internalGet(5) > n15) {
                        this.set(5, n15);
                    }
                }
                return;
            }
            case 3: {
                long l2;
                long l3;
                int n16 = this.cdate.getNormalizedYear();
                n5 = this.getActualMaximum(3);
                this.set(7, this.internalGet(7));
                int n17 = this.internalGet(3);
                int n18 = n17 + n3;
                if (!this.isCutoverYear(n16)) {
                    if (n18 > n4 && n18 < n5) {
                        this.set(3, n18);
                        return;
                    }
                    long l4 = this.getCurrentFixedDate();
                    long l5 = l4 - (long)(7 * (n17 - n4));
                    if (this.calsys.getYearFromFixedDate(l5) != n16) {
                        ++n4;
                    }
                    if (this.calsys.getYearFromFixedDate(l4 += (long)(7 * (n5 - this.internalGet(3)))) == n16) break;
                    --n5;
                    break;
                }
                BaseCalendar baseCalendar = this.gregorianCutoverYear == this.gregorianCutoverYearJulian ? this.getCutoverCalendarSystem() : (n16 == this.gregorianCutoverYear ? gcal : GregorianCalendar.getJulianCalendarSystem());
                if (baseCalendar.getYearFromFixedDate(l3 = (l2 = this.getCurrentFixedDate()) - (long)(7 * (n17 - n4))) != n16) {
                    ++n4;
                }
                BaseCalendar baseCalendar2 = baseCalendar = (l2 += (long)(7 * (n5 - n17))) >= this.gregorianCutoverDate ? gcal : GregorianCalendar.getJulianCalendarSystem();
                if (baseCalendar.getYearFromFixedDate(l2) != n16) {
                    --n5;
                }
                n18 = GregorianCalendar.getRolledValue(n17, n3, n4, n5) - 1;
                BaseCalendar.Date date = this.getCalendarDate(l3 + (long)(n18 * 7));
                this.set(2, date.getMonth() - 1);
                this.set(5, date.getDayOfMonth());
                return;
            }
            case 4: {
                int n19;
                int n20;
                long l6;
                boolean bl2 = this.isCutoverYear(this.cdate.getNormalizedYear());
                int n21 = this.internalGet(7) - this.getFirstDayOfWeek();
                if (n21 < 0) {
                    n21 += 7;
                }
                long l7 = this.getCurrentFixedDate();
                if (bl2) {
                    l6 = this.getFixedDateMonth1(this.cdate, l7);
                    n20 = this.actualMonthLength();
                } else {
                    l6 = l7 - (long)this.internalGet(5) + 1L;
                    n20 = this.calsys.getMonthLength(this.cdate);
                }
                long l8 = BaseCalendar.getDayOfWeekDateOnOrBefore(l6 + 6L, this.getFirstDayOfWeek());
                if ((int)(l8 - l6) >= this.getMinimalDaysInFirstWeek()) {
                    l8 -= 7L;
                }
                n5 = this.getActualMaximum(n2);
                int n22 = GregorianCalendar.getRolledValue(this.internalGet(n2), n3, 1, n5) - 1;
                long l9 = l8 + (long)(n22 * 7) + (long)n21;
                if (l9 < l6) {
                    l9 = l6;
                } else if (l9 >= l6 + (long)n20) {
                    l9 = l6 + (long)n20 - 1L;
                }
                if (bl2) {
                    BaseCalendar.Date date = this.getCalendarDate(l9);
                    n19 = date.getDayOfMonth();
                } else {
                    n19 = (int)(l9 - l6) + 1;
                }
                this.set(5, n19);
                return;
            }
            case 5: {
                if (!this.isCutoverYear(this.cdate.getNormalizedYear())) {
                    n5 = this.calsys.getMonthLength(this.cdate);
                    break;
                }
                long l10 = this.getCurrentFixedDate();
                long l11 = this.getFixedDateMonth1(this.cdate, l10);
                int n23 = GregorianCalendar.getRolledValue((int)(l10 - l11), n3, 0, this.actualMonthLength() - 1);
                BaseCalendar.Date date = this.getCalendarDate(l11 + (long)n23);
                assert (date.getMonth() - 1 == this.internalGet(2));
                this.set(5, date.getDayOfMonth());
                return;
            }
            case 6: {
                n5 = this.getActualMaximum(n2);
                if (!this.isCutoverYear(this.cdate.getNormalizedYear())) break;
                long l12 = this.getCurrentFixedDate();
                long l13 = l12 - (long)this.internalGet(6) + 1L;
                int n24 = GregorianCalendar.getRolledValue((int)(l12 - l13) + 1, n3, n4, n5);
                BaseCalendar.Date date = this.getCalendarDate(l13 + (long)n24 - 1L);
                this.set(2, date.getMonth() - 1);
                this.set(5, date.getDayOfMonth());
                return;
            }
            case 7: {
                long l14;
                int n25;
                if (!this.isCutoverYear(this.cdate.getNormalizedYear()) && (n25 = this.internalGet(3)) > 1 && n25 < 52) {
                    this.set(3, n25);
                    n5 = 7;
                    break;
                }
                if ((n3 %= 7) == 0) {
                    return;
                }
                long l15 = this.getCurrentFixedDate();
                if ((l15 += (long)n3) < (l14 = BaseCalendar.getDayOfWeekDateOnOrBefore(l15, this.getFirstDayOfWeek()))) {
                    l15 += 7L;
                } else if (l15 >= l14 + 7L) {
                    l15 -= 7L;
                }
                BaseCalendar.Date date = this.getCalendarDate(l15);
                this.set(0, date.getNormalizedYear() <= 0 ? 0 : 1);
                this.set(date.getYear(), date.getMonth() - 1, date.getDayOfMonth());
                return;
            }
            case 8: {
                int n26;
                n4 = 1;
                if (!this.isCutoverYear(this.cdate.getNormalizedYear())) {
                    int n27 = this.internalGet(5);
                    int n28 = this.calsys.getMonthLength(this.cdate);
                    int n29 = n28 % 7;
                    n5 = n28 / 7;
                    int n30 = (n27 - 1) % 7;
                    if (n30 < n29) {
                        ++n5;
                    }
                    this.set(7, this.internalGet(7));
                    break;
                }
                long l16 = this.getCurrentFixedDate();
                long l17 = this.getFixedDateMonth1(this.cdate, l16);
                int n31 = this.actualMonthLength();
                int n32 = n31 % 7;
                n5 = n31 / 7;
                int n33 = (int)(l16 - l17) % 7;
                if (n33 < n32) {
                    ++n5;
                }
                BaseCalendar baseCalendar = (l16 = l17 + (long)((n26 = GregorianCalendar.getRolledValue(this.internalGet(n2), n3, n4, n5) - 1) * 7) + (long)n33) >= this.gregorianCutoverDate ? gcal : GregorianCalendar.getJulianCalendarSystem();
                BaseCalendar.Date date = (BaseCalendar.Date)baseCalendar.newCalendarDate(TimeZone.NO_TIMEZONE);
                baseCalendar.getCalendarDateFromFixedDate(date, l16);
                this.set(5, date.getDayOfMonth());
                return;
            }
        }
        this.set(n2, GregorianCalendar.getRolledValue(this.internalGet(n2), n3, n4, n5));
    }

    public int getMinimum(int n2) {
        return MIN_VALUES[n2];
    }

    public int getMaximum(int n2) {
        switch (n2) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                if (this.gregorianCutoverYear > 200) break;
                GregorianCalendar gregorianCalendar = (GregorianCalendar)this.clone();
                gregorianCalendar.setLenient(true);
                gregorianCalendar.setTimeInMillis(this.gregorianCutover);
                int n3 = gregorianCalendar.getActualMaximum(n2);
                gregorianCalendar.setTimeInMillis(this.gregorianCutover - 1L);
                int n4 = gregorianCalendar.getActualMaximum(n2);
                return Math.max(MAX_VALUES[n2], Math.max(n3, n4));
            }
        }
        return MAX_VALUES[n2];
    }

    public int getGreatestMinimum(int n2) {
        if (n2 == 5) {
            BaseCalendar.Date date = this.getGregorianCutoverDate();
            long l2 = this.getFixedDateMonth1(date, this.gregorianCutoverDate);
            date = this.getCalendarDate(l2);
            return Math.max(MIN_VALUES[n2], date.getDayOfMonth());
        }
        return MIN_VALUES[n2];
    }

    public int getLeastMaximum(int n2) {
        switch (n2) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                GregorianCalendar gregorianCalendar = (GregorianCalendar)this.clone();
                gregorianCalendar.setLenient(true);
                gregorianCalendar.setTimeInMillis(this.gregorianCutover);
                int n3 = gregorianCalendar.getActualMaximum(n2);
                gregorianCalendar.setTimeInMillis(this.gregorianCutover - 1L);
                int n4 = gregorianCalendar.getActualMaximum(n2);
                return Math.min(LEAST_MAX_VALUES[n2], Math.min(n3, n4));
            }
        }
        return LEAST_MAX_VALUES[n2];
    }

    public int getActualMinimum(int n2) {
        if (n2 == 5) {
            GregorianCalendar gregorianCalendar = this.getNormalizedCalendar();
            int n3 = gregorianCalendar.cdate.getNormalizedYear();
            if (n3 == this.gregorianCutoverYear || n3 == this.gregorianCutoverYearJulian) {
                long l2 = this.getFixedDateMonth1(gregorianCalendar.cdate, gregorianCalendar.calsys.getFixedDate(gregorianCalendar.cdate));
                BaseCalendar.Date date = this.getCalendarDate(l2);
                return date.getDayOfMonth();
            }
        }
        return this.getMinimum(n2);
    }

    public int getActualMaximum(int n2) {
        if ((0x1FE81 & 1 << n2) != 0) {
            return this.getMaximum(n2);
        }
        GregorianCalendar gregorianCalendar = this.getNormalizedCalendar();
        BaseCalendar.Date date = gregorianCalendar.cdate;
        BaseCalendar baseCalendar = gregorianCalendar.calsys;
        int n3 = date.getNormalizedYear();
        int n4 = -1;
        switch (n2) {
            case 2: {
                long l2;
                if (!gregorianCalendar.isCutoverYear(n3)) {
                    n4 = 11;
                    break;
                }
                while ((l2 = gcal.getFixedDate(++n3, 1, 1, null)) < this.gregorianCutoverDate) {
                }
                BaseCalendar.Date date2 = (BaseCalendar.Date)date.clone();
                baseCalendar.getCalendarDateFromFixedDate(date2, l2 - 1L);
                n4 = date2.getMonth() - 1;
                break;
            }
            case 5: {
                long l3;
                n4 = baseCalendar.getMonthLength(date);
                if (!gregorianCalendar.isCutoverYear(n3) || date.getDayOfMonth() == n4 || (l3 = gregorianCalendar.getCurrentFixedDate()) >= this.gregorianCutoverDate) break;
                int n5 = gregorianCalendar.actualMonthLength();
                long l4 = gregorianCalendar.getFixedDateMonth1(gregorianCalendar.cdate, l3) + (long)n5 - 1L;
                BaseCalendar.Date date3 = gregorianCalendar.getCalendarDate(l4);
                n4 = date3.getDayOfMonth();
                break;
            }
            case 6: {
                long l5;
                if (!gregorianCalendar.isCutoverYear(n3)) {
                    n4 = baseCalendar.getYearLength(date);
                    break;
                }
                if (this.gregorianCutoverYear == this.gregorianCutoverYearJulian) {
                    BaseCalendar baseCalendar2 = gregorianCalendar.getCutoverCalendarSystem();
                    l5 = baseCalendar2.getFixedDate(n3, 1, 1, null);
                } else {
                    l5 = n3 == this.gregorianCutoverYearJulian ? baseCalendar.getFixedDate(n3, 1, 1, null) : this.gregorianCutoverDate;
                }
                long l6 = gcal.getFixedDate(++n3, 1, 1, null);
                if (l6 < this.gregorianCutoverDate) {
                    l6 = this.gregorianCutoverDate;
                }
                assert (l5 <= baseCalendar.getFixedDate(date.getNormalizedYear(), date.getMonth(), date.getDayOfMonth(), date));
                assert (l6 >= baseCalendar.getFixedDate(date.getNormalizedYear(), date.getMonth(), date.getDayOfMonth(), date));
                n4 = (int)(l6 - l5);
                break;
            }
            case 3: {
                if (!gregorianCalendar.isCutoverYear(n3)) {
                    CalendarDate calendarDate = baseCalendar.newCalendarDate(TimeZone.NO_TIMEZONE);
                    calendarDate.setDate(date.getYear(), 1, 1);
                    int n6 = baseCalendar.getDayOfWeek(calendarDate);
                    if ((n6 -= this.getFirstDayOfWeek()) < 0) {
                        n6 += 7;
                    }
                    n4 = 52;
                    int n7 = n6 + this.getMinimalDaysInFirstWeek() - 1;
                    if (n7 != 6 && (!date.isLeapYear() || n7 != 5 && n7 != 12)) break;
                    ++n4;
                    break;
                }
                if (gregorianCalendar == this) {
                    gregorianCalendar = (GregorianCalendar)gregorianCalendar.clone();
                }
                gregorianCalendar.set(6, this.getActualMaximum(6));
                n4 = gregorianCalendar.get(3);
                break;
            }
            case 4: {
                if (!gregorianCalendar.isCutoverYear(n3)) {
                    CalendarDate calendarDate = baseCalendar.newCalendarDate(null);
                    calendarDate.setDate(date.getYear(), date.getMonth(), 1);
                    int n8 = baseCalendar.getDayOfWeek(calendarDate);
                    int n9 = baseCalendar.getMonthLength(calendarDate);
                    if ((n8 -= this.getFirstDayOfWeek()) < 0) {
                        n8 += 7;
                    }
                    int n10 = 7 - n8;
                    n4 = 3;
                    if (n10 >= this.getMinimalDaysInFirstWeek()) {
                        ++n4;
                    }
                    if ((n9 -= n10 + 21) <= 0) break;
                    ++n4;
                    if (n9 <= 7) break;
                    ++n4;
                    break;
                }
                if (gregorianCalendar == this) {
                    gregorianCalendar = (GregorianCalendar)gregorianCalendar.clone();
                }
                int n11 = gregorianCalendar.internalGet(1);
                int n12 = gregorianCalendar.internalGet(2);
                do {
                    n4 = gregorianCalendar.get(4);
                    gregorianCalendar.add(4, 1);
                } while (gregorianCalendar.get(1) == n11 && gregorianCalendar.get(2) == n12);
                break;
            }
            case 8: {
                int n13;
                int n14;
                int n15 = date.getDayOfWeek();
                if (!gregorianCalendar.isCutoverYear(n3)) {
                    BaseCalendar.Date date4 = (BaseCalendar.Date)date.clone();
                    n14 = baseCalendar.getMonthLength(date4);
                    date4.setDayOfMonth(1);
                    baseCalendar.normalize(date4);
                    n13 = date4.getDayOfWeek();
                } else {
                    if (gregorianCalendar == this) {
                        gregorianCalendar = (GregorianCalendar)this.clone();
                    }
                    n14 = gregorianCalendar.actualMonthLength();
                    gregorianCalendar.set(5, gregorianCalendar.getActualMinimum(5));
                    n13 = gregorianCalendar.get(7);
                }
                int n16 = n15 - n13;
                if (n16 < 0) {
                    n16 += 7;
                }
                n4 = ((n14 -= n16) + 6) / 7;
                break;
            }
            case 1: {
                if (gregorianCalendar == this) {
                    gregorianCalendar = (GregorianCalendar)this.clone();
                }
                long l7 = gregorianCalendar.getYearOffsetInMillis();
                if (gregorianCalendar.internalGetEra() == 1) {
                    gregorianCalendar.setTimeInMillis(Long.MAX_VALUE);
                    n4 = gregorianCalendar.get(1);
                    long l8 = gregorianCalendar.getYearOffsetInMillis();
                    if (l7 <= l8) break;
                    --n4;
                    break;
                }
                BaseCalendar baseCalendar3 = gregorianCalendar.getTimeInMillis() >= this.gregorianCutover ? gcal : GregorianCalendar.getJulianCalendarSystem();
                CalendarDate calendarDate = ((CalendarSystem)baseCalendar3).getCalendarDate(Long.MIN_VALUE, this.getZone());
                long l9 = (baseCalendar.getDayOfYear(calendarDate) - 1L) * 24L + (long)calendarDate.getHours();
                l9 *= 60L;
                l9 += (long)calendarDate.getMinutes();
                l9 *= 60L;
                l9 += (long)calendarDate.getSeconds();
                l9 *= 1000L;
                l9 += (long)calendarDate.getMillis();
                n4 = calendarDate.getYear();
                if (n4 <= 0) {
                    assert (baseCalendar3 == gcal);
                    n4 = 1 - n4;
                }
                if (l7 >= l9) break;
                --n4;
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(n2);
            }
        }
        return n4;
    }

    private final long getYearOffsetInMillis() {
        long l2 = (this.internalGet(6) - 1) * 24;
        l2 += (long)this.internalGet(11);
        l2 *= 60L;
        l2 += (long)this.internalGet(12);
        l2 *= 60L;
        l2 += (long)this.internalGet(13);
        return (l2 *= 1000L) + (long)this.internalGet(14) - (long)(this.internalGet(15) + this.internalGet(16));
    }

    public Object clone() {
        GregorianCalendar gregorianCalendar = (GregorianCalendar)super.clone();
        gregorianCalendar.gdate = (BaseCalendar.Date)this.gdate.clone();
        if (this.cdate != null) {
            gregorianCalendar.cdate = this.cdate != this.gdate ? (BaseCalendar.Date)this.cdate.clone() : gregorianCalendar.gdate;
        }
        gregorianCalendar.originalFields = null;
        gregorianCalendar.zoneOffsets = null;
        return gregorianCalendar;
    }

    public TimeZone getTimeZone() {
        TimeZone timeZone = super.getTimeZone();
        this.gdate.setZone(timeZone);
        if (this.cdate != null && this.cdate != this.gdate) {
            this.cdate.setZone(timeZone);
        }
        return timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        super.setTimeZone(timeZone);
        this.gdate.setZone(timeZone);
        if (this.cdate != null && this.cdate != this.gdate) {
            this.cdate.setZone(timeZone);
        }
    }

    protected void computeFields() {
        int n2 = 0;
        if (this.isPartiallyNormalized()) {
            n2 = this.getSetStateFields();
            int n3 = ~n2 & 0x1FFFF;
            if (n3 != 0) {
                n2 |= this.computeFields(n3, n2 & 0x18000);
                assert (n2 == 131071);
            }
        } else {
            n2 = 131071;
            this.computeFields(n2, 0);
        }
        this.setFieldsComputed(n2);
    }

    private int computeFields(int n2, int n3) {
        int n4;
        int n5;
        int n6 = 0;
        TimeZone timeZone = this.getZone();
        if (this.zoneOffsets == null) {
            this.zoneOffsets = new int[2];
        }
        if (n3 != 98304) {
            if (timeZone instanceof ZoneInfo) {
                n6 = ((ZoneInfo)timeZone).getOffsets(this.time, this.zoneOffsets);
            } else {
                n6 = timeZone.getOffset(this.time);
                this.zoneOffsets[0] = timeZone.getRawOffset();
                this.zoneOffsets[1] = n6 - this.zoneOffsets[0];
            }
        }
        if (n3 != 0) {
            if (GregorianCalendar.isFieldSet(n3, 15)) {
                this.zoneOffsets[0] = this.internalGet(15);
            }
            if (GregorianCalendar.isFieldSet(n3, 16)) {
                this.zoneOffsets[1] = this.internalGet(16);
            }
            n6 = this.zoneOffsets[0] + this.zoneOffsets[1];
        }
        long l2 = (long)n6 / 86400000L;
        int n7 = n6 % 86400000;
        l2 += this.time / 86400000L;
        if ((long)(n7 += (int)(this.time % 86400000L)) >= 86400000L) {
            n7 = (int)((long)n7 - 86400000L);
            ++l2;
        } else {
            while (n7 < 0) {
                n7 = (int)((long)n7 + 86400000L);
                --l2;
            }
        }
        int n8 = 1;
        if ((l2 += 719163L) >= this.gregorianCutoverDate) {
            assert (this.cachedFixedDate == Long.MIN_VALUE || this.gdate.isNormalized()) : "cache control: not normalized";
            assert (this.cachedFixedDate == Long.MIN_VALUE || gcal.getFixedDate(this.gdate.getNormalizedYear(), this.gdate.getMonth(), this.gdate.getDayOfMonth(), this.gdate) == this.cachedFixedDate) : "cache control: inconsictency, cachedFixedDate=" + this.cachedFixedDate + ", computed=" + gcal.getFixedDate(this.gdate.getNormalizedYear(), this.gdate.getMonth(), this.gdate.getDayOfMonth(), this.gdate) + ", date=" + this.gdate;
            if (l2 != this.cachedFixedDate) {
                gcal.getCalendarDateFromFixedDate(this.gdate, l2);
                this.cachedFixedDate = l2;
            }
            if ((n5 = this.gdate.getYear()) <= 0) {
                n5 = 1 - n5;
                n8 = 0;
            }
            this.calsys = gcal;
            this.cdate = this.gdate;
            assert (this.cdate.getDayOfWeek() > 0) : "dow=" + this.cdate.getDayOfWeek() + ", date=" + this.cdate;
        } else {
            this.calsys = GregorianCalendar.getJulianCalendarSystem();
            this.cdate = (BaseCalendar.Date)jcal.newCalendarDate(this.getZone());
            jcal.getCalendarDateFromFixedDate(this.cdate, l2);
            Era era = this.cdate.getEra();
            if (era == jeras[0]) {
                n8 = 0;
            }
            n5 = this.cdate.getYear();
        }
        this.internalSet(0, n8);
        this.internalSet(1, n5);
        int n9 = n2 | 3;
        int n10 = this.cdate.getMonth() - 1;
        int n11 = this.cdate.getDayOfMonth();
        if ((n2 & 0xA4) != 0) {
            this.internalSet(2, n10);
            this.internalSet(5, n11);
            this.internalSet(7, this.cdate.getDayOfWeek());
            n9 |= 0xA4;
        }
        if ((n2 & 0x7E00) != 0) {
            if (n7 != 0) {
                n4 = n7 / 3600000;
                this.internalSet(11, n4);
                this.internalSet(9, n4 / 12);
                this.internalSet(10, n4 % 12);
                int n12 = n7 % 3600000;
                this.internalSet(12, n12 / 60000);
                this.internalSet(13, (n12 %= 60000) / 1000);
                this.internalSet(14, n12 % 1000);
            } else {
                this.internalSet(11, 0);
                this.internalSet(9, 0);
                this.internalSet(10, 0);
                this.internalSet(12, 0);
                this.internalSet(13, 0);
                this.internalSet(14, 0);
            }
            n9 |= 0x7E00;
        }
        if ((n2 & 0x18000) != 0) {
            this.internalSet(15, this.zoneOffsets[0]);
            this.internalSet(16, this.zoneOffsets[1]);
            n9 |= 0x18000;
        }
        if ((n2 & 0x158) != 0) {
            int n13;
            n4 = this.cdate.getNormalizedYear();
            long l3 = this.calsys.getFixedDate(n4, 1, 1, this.cdate);
            int n14 = (int)(l2 - l3) + 1;
            long l4 = l2 - (long)n11 + 1L;
            int n15 = 0;
            int n16 = this.calsys == gcal ? this.gregorianCutoverYear : this.gregorianCutoverYearJulian;
            int n17 = n11 - 1;
            if (n4 == n16) {
                if (this.getCutoverCalendarSystem() == jcal) {
                    l3 = this.getFixedDateJan1(this.cdate, l2);
                    if (l2 >= this.gregorianCutoverDate) {
                        l4 = this.getFixedDateMonth1(this.cdate, l2);
                    }
                }
                n13 = (int)(l2 - l3) + 1;
                n15 = n14 - n13;
                n14 = n13;
                n17 = (int)(l2 - l4);
            }
            this.internalSet(6, n14);
            this.internalSet(8, n17 / 7 + 1);
            n13 = this.getWeekNumber(l3, l2);
            if (n13 == 0) {
                long l5;
                long l6 = l3 - 1L;
                if (n4 > n16 + 1) {
                    l5 = l3 - 365L;
                    if (CalendarUtils.isGregorianLeapYear(n4 - 1)) {
                        --l5;
                    }
                } else {
                    BaseCalendar baseCalendar = this.calsys;
                    int n18 = n4 - 1;
                    if (n18 == n16) {
                        baseCalendar = this.getCutoverCalendarSystem();
                    }
                    l5 = baseCalendar.getFixedDate(n18, 1, 1, null);
                    while (l5 > l6) {
                        l5 = GregorianCalendar.getJulianCalendarSystem().getFixedDate(--n18, 1, 1, null);
                    }
                }
                n13 = this.getWeekNumber(l5, l6);
            } else if (n4 > this.gregorianCutoverYear || n4 < this.gregorianCutoverYearJulian - 1) {
                if (n13 >= 52) {
                    long l7;
                    int n19;
                    long l8 = l3 + 365L;
                    if (this.cdate.isLeapYear()) {
                        ++l8;
                    }
                    if ((n19 = (int)((l7 = BaseCalendar.getDayOfWeekDateOnOrBefore(l8 + 6L, this.getFirstDayOfWeek())) - l8)) >= this.getMinimalDaysInFirstWeek() && l2 >= l7 - 7L) {
                        n13 = 1;
                    }
                }
            } else {
                long l9;
                int n20;
                long l10;
                BaseCalendar baseCalendar = this.calsys;
                int n21 = n4 + 1;
                if (n21 == this.gregorianCutoverYearJulian + 1 && n21 < this.gregorianCutoverYear) {
                    n21 = this.gregorianCutoverYear;
                }
                if (n21 == this.gregorianCutoverYear) {
                    baseCalendar = this.getCutoverCalendarSystem();
                }
                if ((l10 = baseCalendar.getFixedDate(n21, 1, 1, null)) < l2) {
                    l10 = this.gregorianCutoverDate;
                    baseCalendar = gcal;
                }
                if ((n20 = (int)((l9 = BaseCalendar.getDayOfWeekDateOnOrBefore(l10 + 6L, this.getFirstDayOfWeek())) - l10)) >= this.getMinimalDaysInFirstWeek() && l2 >= l9 - 7L) {
                    n13 = 1;
                }
            }
            this.internalSet(3, n13);
            this.internalSet(4, this.getWeekNumber(l4, l2));
            n9 |= 0x158;
        }
        return n9;
    }

    private final int getWeekNumber(long l2, long l3) {
        int n2;
        long l4 = Gregorian.getDayOfWeekDateOnOrBefore(l2 + 6L, this.getFirstDayOfWeek());
        int n3 = (int)(l4 - l2);
        assert (n3 <= 7);
        if (n3 >= this.getMinimalDaysInFirstWeek()) {
            l4 -= 7L;
        }
        if ((n2 = (int)(l3 - l4)) >= 0) {
            return n2 / 7 + 1;
        }
        return CalendarUtils.floorDivide(n2, 7) + 1;
    }

    protected void computeTime() {
        int n2;
        int n3;
        long l2;
        long l3;
        long l4;
        int n4;
        block28: {
            long l5;
            block29: {
                int n5;
                block30: {
                    block31: {
                        block26: {
                            block27: {
                                if (!this.isLenient()) {
                                    if (this.originalFields == null) {
                                        this.originalFields = new int[17];
                                    }
                                    for (n4 = 0; n4 < 17; ++n4) {
                                        n5 = this.internalGet(n4);
                                        if (this.isExternallySet(n4) && (n5 < this.getMinimum(n4) || n5 > this.getMaximum(n4))) {
                                            throw new IllegalArgumentException(GregorianCalendar.getFieldName(n4));
                                        }
                                        this.originalFields[n4] = n5;
                                    }
                                }
                                n4 = this.selectFields();
                                n5 = this.isSet(1) ? this.internalGet(1) : 1970;
                                int n6 = this.internalGetEra();
                                if (n6 == 0) {
                                    n5 = 1 - n5;
                                } else if (n6 != 1) {
                                    throw new IllegalArgumentException("Invalid era");
                                }
                                if (n5 <= 0 && !this.isSet(0)) {
                                    n4 |= 1;
                                    this.setFieldsComputed(1);
                                }
                                l4 = 0L;
                                if (GregorianCalendar.isFieldSet(n4, 11)) {
                                    l4 += (long)this.internalGet(11);
                                } else {
                                    l4 += (long)this.internalGet(10);
                                    if (GregorianCalendar.isFieldSet(n4, 9)) {
                                        l4 += (long)(12 * this.internalGet(9));
                                    }
                                }
                                l4 *= 60L;
                                l4 += (long)this.internalGet(12);
                                l4 *= 60L;
                                l4 += (long)this.internalGet(13);
                                l4 *= 1000L;
                                l3 = (l4 += (long)this.internalGet(14)) / 86400000L;
                                l4 %= 86400000L;
                                while (l4 < 0L) {
                                    l4 += 86400000L;
                                    --l3;
                                }
                                if (n5 <= this.gregorianCutoverYear || n5 <= this.gregorianCutoverYearJulian) break block26;
                                l2 = l3 + this.getFixedDate(gcal, n5, n4);
                                if (l2 < this.gregorianCutoverDate) break block27;
                                l3 = l2;
                                break block28;
                            }
                            l5 = l3 + this.getFixedDate(GregorianCalendar.getJulianCalendarSystem(), n5, n4);
                            break block29;
                        }
                        if (n5 >= this.gregorianCutoverYear || n5 >= this.gregorianCutoverYearJulian) break block30;
                        l5 = l3 + this.getFixedDate(GregorianCalendar.getJulianCalendarSystem(), n5, n4);
                        if (l5 >= this.gregorianCutoverDate) break block31;
                        l3 = l5;
                        break block28;
                    }
                    l2 = l3 + this.getFixedDate(gcal, n5, n4);
                    break block29;
                }
                l2 = l3 + this.getFixedDate(gcal, n5, n4);
                l5 = l3 + this.getFixedDate(GregorianCalendar.getJulianCalendarSystem(), n5, n4);
            }
            if (l2 >= this.gregorianCutoverDate) {
                l3 = l5 >= this.gregorianCutoverDate ? l2 : (this.calsys == gcal || this.calsys == null ? l2 : l5);
            } else if (l5 < this.gregorianCutoverDate) {
                l3 = l5;
            } else {
                if (!this.isLenient()) {
                    throw new IllegalArgumentException("the specified date doesn't exist");
                }
                l3 = l5;
            }
        }
        l2 = (l3 - 719163L) * 86400000L + l4;
        TimeZone timeZone = this.getZone();
        if (this.zoneOffsets == null) {
            this.zoneOffsets = new int[2];
        }
        if ((n3 = n4 & 0x18000) != 98304) {
            if (timeZone instanceof ZoneInfo) {
                ((ZoneInfo)timeZone).getOffsetsByWall(l2, this.zoneOffsets);
            } else {
                n2 = GregorianCalendar.isFieldSet(n4, 15) ? this.internalGet(15) : timeZone.getRawOffset();
                timeZone.getOffsets(l2 - (long)n2, this.zoneOffsets);
            }
        }
        if (n3 != 0) {
            if (GregorianCalendar.isFieldSet(n3, 15)) {
                this.zoneOffsets[0] = this.internalGet(15);
            }
            if (GregorianCalendar.isFieldSet(n3, 16)) {
                this.zoneOffsets[1] = this.internalGet(16);
            }
        }
        this.time = l2 -= (long)(this.zoneOffsets[0] + this.zoneOffsets[1]);
        n2 = this.computeFields(n4 | this.getSetStateFields(), n3);
        if (!this.isLenient()) {
            for (int i2 = 0; i2 < 17; ++i2) {
                if (!this.isExternallySet(i2) || this.originalFields[i2] == this.internalGet(i2)) continue;
                System.arraycopy(this.originalFields, 0, this.fields, 0, this.fields.length);
                throw new IllegalArgumentException(GregorianCalendar.getFieldName(i2));
            }
        }
        this.setFieldsNormalized(n2);
    }

    private long getFixedDate(BaseCalendar baseCalendar, int n2, int n3) {
        int n4 = 0;
        if (GregorianCalendar.isFieldSet(n3, 2)) {
            n4 = this.internalGet(2);
            if (n4 > 11) {
                n2 += n4 / 12;
                n4 %= 12;
            } else if (n4 < 0) {
                int[] nArray = new int[1];
                n2 += CalendarUtils.floorDivide(n4, 12, nArray);
                n4 = nArray[0];
            }
        }
        long l2 = baseCalendar.getFixedDate(n2, n4 + 1, 1, baseCalendar == gcal ? this.gdate : null);
        if (GregorianCalendar.isFieldSet(n3, 2)) {
            if (GregorianCalendar.isFieldSet(n3, 5)) {
                if (this.isSet(5)) {
                    l2 += (long)this.internalGet(5);
                    --l2;
                }
            } else if (GregorianCalendar.isFieldSet(n3, 4)) {
                long l3 = BaseCalendar.getDayOfWeekDateOnOrBefore(l2 + 6L, this.getFirstDayOfWeek());
                if (l3 - l2 >= (long)this.getMinimalDaysInFirstWeek()) {
                    l3 -= 7L;
                }
                if (GregorianCalendar.isFieldSet(n3, 7)) {
                    l3 = BaseCalendar.getDayOfWeekDateOnOrBefore(l3 + 6L, this.internalGet(7));
                }
                l2 = l3 + (long)(7 * (this.internalGet(4) - 1));
            } else {
                int n5 = GregorianCalendar.isFieldSet(n3, 7) ? this.internalGet(7) : this.getFirstDayOfWeek();
                int n6 = GregorianCalendar.isFieldSet(n3, 8) ? this.internalGet(8) : 1;
                if (n6 >= 0) {
                    l2 = BaseCalendar.getDayOfWeekDateOnOrBefore(l2 + (long)(7 * n6) - 1L, n5);
                } else {
                    int n7 = this.monthLength(n4, n2) + 7 * (n6 + 1);
                    l2 = BaseCalendar.getDayOfWeekDateOnOrBefore(l2 + (long)n7 - 1L, n5);
                }
            }
        } else {
            if (n2 == this.gregorianCutoverYear && baseCalendar == gcal && l2 < this.gregorianCutoverDate && this.gregorianCutoverYear != this.gregorianCutoverYearJulian) {
                l2 = this.gregorianCutoverDate;
            }
            if (GregorianCalendar.isFieldSet(n3, 6)) {
                l2 += (long)this.internalGet(6);
                --l2;
            } else {
                int n8;
                long l4 = BaseCalendar.getDayOfWeekDateOnOrBefore(l2 + 6L, this.getFirstDayOfWeek());
                if (l4 - l2 >= (long)this.getMinimalDaysInFirstWeek()) {
                    l4 -= 7L;
                }
                if (GregorianCalendar.isFieldSet(n3, 7) && (n8 = this.internalGet(7)) != this.getFirstDayOfWeek()) {
                    l4 = BaseCalendar.getDayOfWeekDateOnOrBefore(l4 + 6L, n8);
                }
                l2 = l4 + 7L * ((long)this.internalGet(3) - 1L);
            }
        }
        return l2;
    }

    private final GregorianCalendar getNormalizedCalendar() {
        GregorianCalendar gregorianCalendar;
        if (this.isFullyNormalized()) {
            gregorianCalendar = this;
        } else {
            gregorianCalendar = (GregorianCalendar)this.clone();
            gregorianCalendar.setLenient(true);
            gregorianCalendar.complete();
        }
        return gregorianCalendar;
    }

    private static final synchronized BaseCalendar getJulianCalendarSystem() {
        if (jcal == null) {
            jcal = (JulianCalendar)CalendarSystem.forName("julian");
            jeras = jcal.getEras();
        }
        return jcal;
    }

    private BaseCalendar getCutoverCalendarSystem() {
        BaseCalendar.Date date = this.getGregorianCutoverDate();
        if (date.getMonth() == 1 && date.getDayOfMonth() == 1) {
            return gcal;
        }
        return GregorianCalendar.getJulianCalendarSystem();
    }

    private final boolean isCutoverYear(int n2) {
        int n3 = this.calsys == gcal ? this.gregorianCutoverYear : this.gregorianCutoverYearJulian;
        return n2 == n3;
    }

    private final long getFixedDateJan1(BaseCalendar.Date date, long l2) {
        assert (date.getNormalizedYear() == this.gregorianCutoverYear || date.getNormalizedYear() == this.gregorianCutoverYearJulian);
        if (this.gregorianCutoverYear != this.gregorianCutoverYearJulian && l2 >= this.gregorianCutoverDate) {
            return this.gregorianCutoverDate;
        }
        BaseCalendar baseCalendar = GregorianCalendar.getJulianCalendarSystem();
        return baseCalendar.getFixedDate(date.getNormalizedYear(), 1, 1, null);
    }

    private final long getFixedDateMonth1(BaseCalendar.Date date, long l2) {
        long l3;
        assert (date.getNormalizedYear() == this.gregorianCutoverYear || date.getNormalizedYear() == this.gregorianCutoverYearJulian);
        BaseCalendar.Date date2 = this.getGregorianCutoverDate();
        if (date2.getMonth() == 1 && date2.getDayOfMonth() == 1) {
            return l2 - (long)date.getDayOfMonth() + 1L;
        }
        if (date.getMonth() == date2.getMonth()) {
            BaseCalendar.Date date3 = this.getLastJulianDate();
            l3 = this.gregorianCutoverYear == this.gregorianCutoverYearJulian && date2.getMonth() == date3.getMonth() ? jcal.getFixedDate(date.getNormalizedYear(), date.getMonth(), 1, null) : this.gregorianCutoverDate;
        } else {
            l3 = l2 - (long)date.getDayOfMonth() + 1L;
        }
        return l3;
    }

    private final BaseCalendar.Date getCalendarDate(long l2) {
        BaseCalendar baseCalendar = l2 >= this.gregorianCutoverDate ? gcal : GregorianCalendar.getJulianCalendarSystem();
        BaseCalendar.Date date = (BaseCalendar.Date)baseCalendar.newCalendarDate(TimeZone.NO_TIMEZONE);
        baseCalendar.getCalendarDateFromFixedDate(date, l2);
        return date;
    }

    private final BaseCalendar.Date getGregorianCutoverDate() {
        return this.getCalendarDate(this.gregorianCutoverDate);
    }

    private final BaseCalendar.Date getLastJulianDate() {
        return this.getCalendarDate(this.gregorianCutoverDate - 1L);
    }

    private final int monthLength(int n2, int n3) {
        return this.isLeapYear(n3) ? LEAP_MONTH_LENGTH[n2] : MONTH_LENGTH[n2];
    }

    private final int monthLength(int n2) {
        int n3 = this.internalGet(1);
        if (this.internalGetEra() == 0) {
            n3 = 1 - n3;
        }
        return this.monthLength(n2, n3);
    }

    private final int actualMonthLength() {
        long l2;
        int n2 = this.cdate.getNormalizedYear();
        if (n2 != this.gregorianCutoverYear && n2 != this.gregorianCutoverYearJulian) {
            return this.calsys.getMonthLength(this.cdate);
        }
        BaseCalendar.Date date = (BaseCalendar.Date)this.cdate.clone();
        long l3 = this.getFixedDateMonth1(date, l2 = this.calsys.getFixedDate(date));
        long l4 = l3 + (long)this.calsys.getMonthLength(date);
        if (l4 < this.gregorianCutoverDate) {
            return (int)(l4 - l3);
        }
        if (this.cdate != this.gdate) {
            date = (BaseCalendar.Date)gcal.newCalendarDate(TimeZone.NO_TIMEZONE);
        }
        gcal.getCalendarDateFromFixedDate(date, l4);
        l4 = this.getFixedDateMonth1(date, l4);
        return (int)(l4 - l3);
    }

    private final int yearLength(int n2) {
        return this.isLeapYear(n2) ? 366 : 365;
    }

    private final int yearLength() {
        int n2 = this.internalGet(1);
        if (this.internalGetEra() == 0) {
            n2 = 1 - n2;
        }
        return this.yearLength(n2);
    }

    private final void pinDayOfMonth() {
        int n2;
        int n3 = this.internalGet(1);
        if (n3 > this.gregorianCutoverYear || n3 < this.gregorianCutoverYearJulian) {
            n2 = this.monthLength(this.internalGet(2));
        } else {
            GregorianCalendar gregorianCalendar = this.getNormalizedCalendar();
            n2 = gregorianCalendar.getActualMaximum(5);
        }
        int n4 = this.internalGet(5);
        if (n4 > n2) {
            this.set(5, n2);
        }
    }

    private final long getCurrentFixedDate() {
        return this.calsys == gcal ? this.cachedFixedDate : this.calsys.getFixedDate(this.cdate);
    }

    private static final int getRolledValue(int n2, int n3, int n4, int n5) {
        assert (n2 >= n4 && n2 <= n5);
        int n6 = n5 - n4 + 1;
        int n7 = n2 + (n3 %= n6);
        if (n7 > n5) {
            n7 -= n6;
        } else if (n7 < n4) {
            n7 += n6;
        }
        assert (n7 >= n4 && n7 <= n5);
        return n7;
    }

    private final int internalGetEra() {
        return this.isSet(0) ? this.internalGet(0) : 1;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.gdate == null) {
            this.gdate = (BaseCalendar.Date)gcal.newCalendarDate(this.getZone());
            this.cachedFixedDate = Long.MIN_VALUE;
        }
        this.setGregorianChange(this.gregorianCutover);
    }
}

