/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.text.BreakIterator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import sun.text.Normalizer;

final class ConditionalSpecialCasing {
    static final int FINAL_CASED = 1;
    static final int AFTER_SOFT_DOTTED = 2;
    static final int MORE_ABOVE = 3;
    static final int AFTER_I = 4;
    static final int NOT_BEFORE_DOT = 5;
    static final int COMBINING_CLASS_ABOVE = 230;
    static Entry[] entry = new Entry[]{new Entry(931, new char[]{'\u03c2'}, new char[]{'\u03a3'}, null, 1), new Entry(775, new char[]{'\u0307'}, new char[0], "lt", 2), new Entry(73, new char[]{'i', '\u0307'}, new char[]{'I'}, "lt", 3), new Entry(74, new char[]{'j', '\u0307'}, new char[]{'J'}, "lt", 3), new Entry(302, new char[]{'\u012f', '\u0307'}, new char[]{'\u012e'}, "lt", 3), new Entry(204, new char[]{'i', '\u0307', '\u0300'}, new char[]{'\u00cc'}, "lt", 0), new Entry(205, new char[]{'i', '\u0307', '\u0301'}, new char[]{'\u00cd'}, "lt", 0), new Entry(296, new char[]{'i', '\u0307', '\u0303'}, new char[]{'\u0128'}, "lt", 0), new Entry(775, new char[0], new char[]{'\u0307'}, "tr", 4), new Entry(775, new char[0], new char[]{'\u0307'}, "az", 4), new Entry(73, new char[]{'\u0131'}, new char[]{'I'}, "tr", 5), new Entry(73, new char[]{'\u0131'}, new char[]{'I'}, "az", 5), new Entry(105, new char[]{'i'}, new char[]{'\u0130'}, "tr", 0), new Entry(105, new char[]{'i'}, new char[]{'\u0130'}, "az", 0)};
    static Hashtable entryTable = new Hashtable();

    ConditionalSpecialCasing() {
    }

    static int toLowerCaseEx(String string, int n2, Locale locale) {
        char[] cArray = ConditionalSpecialCasing.lookUpTable(string, n2, locale, true);
        if (cArray != null) {
            if (cArray.length == 1) {
                return cArray[0];
            }
            return -1;
        }
        return Character.toLowerCase(string.codePointAt(n2));
    }

    static int toUpperCaseEx(String string, int n2, Locale locale) {
        char[] cArray = ConditionalSpecialCasing.lookUpTable(string, n2, locale, false);
        if (cArray != null) {
            if (cArray.length == 1) {
                return cArray[0];
            }
            return -1;
        }
        return Character.toUpperCaseEx(string.codePointAt(n2));
    }

    static char[] toLowerCaseCharArray(String string, int n2, Locale locale) {
        return ConditionalSpecialCasing.lookUpTable(string, n2, locale, true);
    }

    static char[] toUpperCaseCharArray(String string, int n2, Locale locale) {
        char[] cArray = ConditionalSpecialCasing.lookUpTable(string, n2, locale, false);
        if (cArray != null) {
            return cArray;
        }
        return Character.toUpperCaseCharArray(string.codePointAt(n2));
    }

    private static char[] lookUpTable(String string, int n2, Locale locale, boolean bl2) {
        HashSet hashSet = (HashSet)entryTable.get(new Integer(string.codePointAt(n2)));
        if (hashSet != null) {
            Iterator iterator = hashSet.iterator();
            String string2 = locale.getLanguage();
            while (iterator.hasNext()) {
                Entry entry = (Entry)iterator.next();
                String string3 = entry.getLanguage();
                if (string3 != null && !string3.equals(string2) || !ConditionalSpecialCasing.isConditionMet(string, n2, locale, entry.getCondition())) continue;
                return bl2 ? entry.getLowerCase() : entry.getUpperCase();
            }
        }
        return null;
    }

    private static boolean isConditionMet(String string, int n2, Locale locale, int n3) {
        switch (n3) {
            case 1: {
                return ConditionalSpecialCasing.isFinalCased(string, n2, locale);
            }
            case 2: {
                return ConditionalSpecialCasing.isAfterSoftDotted(string, n2);
            }
            case 3: {
                return ConditionalSpecialCasing.isMoreAbove(string, n2);
            }
            case 4: {
                return ConditionalSpecialCasing.isAfterI(string, n2);
            }
            case 5: {
                return !ConditionalSpecialCasing.isBeforeDot(string, n2);
            }
        }
        return true;
    }

    private static boolean isFinalCased(String string, int n2, Locale locale) {
        int n3;
        BreakIterator breakIterator = BreakIterator.getWordInstance(locale);
        breakIterator.setText(string);
        for (int i2 = n2; i2 >= 0 && !breakIterator.isBoundary(i2); i2 -= Character.charCount(n3)) {
            n3 = string.codePointBefore(i2);
            if (!ConditionalSpecialCasing.isCased(n3)) continue;
            int n4 = string.length();
            for (i2 = n2 + Character.charCount(string.codePointAt(n2)); i2 < n4 && !breakIterator.isBoundary(i2); i2 += Character.charCount(n3)) {
                n3 = string.codePointAt(i2);
                if (!ConditionalSpecialCasing.isCased(n3)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isAfterI(String string, int n2) {
        int n3;
        for (int i2 = n2; i2 > 0; i2 -= Character.charCount(n3)) {
            n3 = string.codePointBefore(i2);
            if (n3 == 73) {
                return true;
            }
            int n4 = Normalizer.getClass(n3);
            if (n4 != 0 && n4 != 230) continue;
            return false;
        }
        return false;
    }

    private static boolean isAfterSoftDotted(String string, int n2) {
        int n3;
        for (int i2 = n2; i2 > 0; i2 -= Character.charCount(n3)) {
            n3 = string.codePointBefore(i2);
            if (ConditionalSpecialCasing.isSoftDotted(n3)) {
                return true;
            }
            int n4 = Normalizer.getClass(n3);
            if (n4 != 0 && n4 != 230) continue;
            return false;
        }
        return false;
    }

    private static boolean isMoreAbove(String string, int n2) {
        int n3;
        int n4 = string.length();
        for (int i2 = n2 + Character.charCount(string.codePointAt(n2)); i2 < n4; i2 += Character.charCount(n3)) {
            n3 = string.codePointAt(i2);
            int n5 = Normalizer.getClass(n3);
            if (n5 == 230) {
                return true;
            }
            if (n5 != 0) continue;
            return false;
        }
        return false;
    }

    private static boolean isBeforeDot(String string, int n2) {
        int n3;
        int n4 = string.length();
        for (int i2 = n2 + Character.charCount(string.codePointAt(n2)); i2 < n4; i2 += Character.charCount(n3)) {
            n3 = string.codePointAt(i2);
            if (n3 == 775) {
                return true;
            }
            int n5 = Normalizer.getClass(n3);
            if (n5 != 0 && n5 != 230) continue;
            return false;
        }
        return false;
    }

    private static boolean isCased(int n2) {
        int n3 = Character.getType(n2);
        if (n3 == 2 || n3 == 1 || n3 == 3) {
            return true;
        }
        if (n2 >= 688 && n2 <= 696) {
            return true;
        }
        if (n2 >= 704 && n2 <= 705) {
            return true;
        }
        if (n2 >= 736 && n2 <= 740) {
            return true;
        }
        if (n2 == 837) {
            return true;
        }
        if (n2 == 890) {
            return true;
        }
        if (n2 >= 7468 && n2 <= 7521) {
            return true;
        }
        if (n2 >= 8544 && n2 <= 8575) {
            return true;
        }
        return n2 >= 9398 && n2 <= 9449;
    }

    private static boolean isSoftDotted(int n2) {
        switch (n2) {
            case 105: 
            case 106: 
            case 303: 
            case 616: 
            case 1110: 
            case 1112: 
            case 7522: 
            case 7725: 
            case 7883: 
            case 8305: {
                return true;
            }
        }
        return false;
    }

    static {
        for (int i2 = 0; i2 < entry.length; ++i2) {
            Entry entry = ConditionalSpecialCasing.entry[i2];
            Integer n2 = new Integer(entry.getCodePoint());
            HashSet<Entry> hashSet = (HashSet<Entry>)entryTable.get(n2);
            if (hashSet == null) {
                hashSet = new HashSet<Entry>();
            }
            hashSet.add(entry);
            entryTable.put(n2, hashSet);
        }
    }

    static class Entry {
        int ch;
        char[] lower;
        char[] upper;
        String lang;
        int condition;

        Entry(int n2, char[] cArray, char[] cArray2, String string, int n3) {
            this.ch = n2;
            this.lower = cArray;
            this.upper = cArray2;
            this.lang = string;
            this.condition = n3;
        }

        int getCodePoint() {
            return this.ch;
        }

        char[] getLowerCase() {
            return this.lower;
        }

        char[] getUpperCase() {
            return this.upper;
        }

        String getLanguage() {
            return this.lang;
        }

        int getCondition() {
            return this.condition;
        }
    }
}

