/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FileFilter;
import java.io.FileSystem;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Random;
import sun.security.action.GetPropertyAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class File
implements Serializable,
Comparable<File> {
    private static FileSystem fs = FileSystem.getFileSystem();
    private String path;
    private transient int prefixLength;
    public static final char separatorChar = fs.getSeparator();
    public static final String separator = "" + separatorChar;
    public static final char pathSeparatorChar = fs.getPathSeparator();
    public static final String pathSeparator = "" + pathSeparatorChar;
    private static final Object tmpFileLock = new Object();
    private static int counter = -1;
    private static String tmpdir;
    private static final long serialVersionUID = 301077366599181567L;

    int getPrefixLength() {
        return this.prefixLength;
    }

    private File(String string, int n2) {
        this.path = string;
        this.prefixLength = n2;
    }

    private File(String string, File file) {
        assert (file.path != null);
        assert (!file.path.equals(""));
        this.path = fs.resolve(file.path, string);
        this.prefixLength = file.prefixLength;
    }

    public File(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.path = fs.normalize(string);
        this.prefixLength = fs.prefixLength(this.path);
    }

    public File(String string, String string2) {
        if (string2 == null) {
            throw new NullPointerException();
        }
        this.path = string != null ? (string.equals("") ? fs.resolve(fs.getDefaultParent(), fs.normalize(string2)) : fs.resolve(fs.normalize(string), fs.normalize(string2))) : fs.normalize(string2);
        this.prefixLength = fs.prefixLength(this.path);
    }

    public File(File file, String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.path = file != null ? (file.path.equals("") ? fs.resolve(fs.getDefaultParent(), fs.normalize(string)) : fs.resolve(file.path, fs.normalize(string))) : fs.normalize(string);
        this.prefixLength = fs.prefixLength(this.path);
    }

    public File(URI uRI) {
        if (!uRI.isAbsolute()) {
            throw new IllegalArgumentException("URI is not absolute");
        }
        if (uRI.isOpaque()) {
            throw new IllegalArgumentException("URI is not hierarchical");
        }
        String string = uRI.getScheme();
        if (string == null || !string.equalsIgnoreCase("file")) {
            throw new IllegalArgumentException("URI scheme is not \"file\"");
        }
        if (uRI.getAuthority() != null) {
            throw new IllegalArgumentException("URI has an authority component");
        }
        if (uRI.getFragment() != null) {
            throw new IllegalArgumentException("URI has a fragment component");
        }
        if (uRI.getQuery() != null) {
            throw new IllegalArgumentException("URI has a query component");
        }
        String string2 = uRI.getPath();
        if (string2.equals("")) {
            throw new IllegalArgumentException("URI path component is empty");
        }
        string2 = fs.fromURIPath(string2);
        if (separatorChar != '/') {
            string2 = string2.replace('/', separatorChar);
        }
        this.path = fs.normalize(string2);
        this.prefixLength = fs.prefixLength(this.path);
    }

    public String getName() {
        int n2 = this.path.lastIndexOf(separatorChar);
        if (n2 < this.prefixLength) {
            return this.path.substring(this.prefixLength);
        }
        return this.path.substring(n2 + 1);
    }

    public String getParent() {
        int n2 = this.path.lastIndexOf(separatorChar);
        if (n2 < this.prefixLength) {
            if (this.prefixLength > 0 && this.path.length() > this.prefixLength) {
                return this.path.substring(0, this.prefixLength);
            }
            return null;
        }
        return this.path.substring(0, n2);
    }

    public File getParentFile() {
        String string = this.getParent();
        if (string == null) {
            return null;
        }
        return new File(string, this.prefixLength);
    }

    public String getPath() {
        return this.path;
    }

    public boolean isAbsolute() {
        return fs.isAbsolute(this);
    }

    public String getAbsolutePath() {
        return fs.resolve(this);
    }

    public File getAbsoluteFile() {
        String string = this.getAbsolutePath();
        return new File(string, fs.prefixLength(string));
    }

    public String getCanonicalPath() throws IOException {
        return fs.canonicalize(fs.resolve(this));
    }

    public File getCanonicalFile() throws IOException {
        String string = this.getCanonicalPath();
        return new File(string, fs.prefixLength(string));
    }

    private static String slashify(String string, boolean bl2) {
        String string2 = string;
        if (separatorChar != '/') {
            string2 = string2.replace(separatorChar, '/');
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        if (!string2.endsWith("/") && bl2) {
            string2 = string2 + "/";
        }
        return string2;
    }

    public URL toURL() throws MalformedURLException {
        return new URL("file", "", File.slashify(this.getAbsolutePath(), this.isDirectory()));
    }

    public URI toURI() {
        try {
            File file = this.getAbsoluteFile();
            String string = File.slashify(file.getPath(), file.isDirectory());
            if (string.startsWith("//")) {
                string = "//" + string;
            }
            return new URI("file", null, string, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new Error(uRISyntaxException);
        }
    }

    public boolean canRead() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.path);
        }
        return fs.checkAccess(this, false);
    }

    public boolean canWrite() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.path);
        }
        return fs.checkAccess(this, true);
    }

    public boolean exists() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.path);
        }
        return (fs.getBooleanAttributes(this) & 1) != 0;
    }

    public boolean isDirectory() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.path);
        }
        return (fs.getBooleanAttributes(this) & 4) != 0;
    }

    public boolean isFile() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.path);
        }
        return (fs.getBooleanAttributes(this) & 2) != 0;
    }

    public boolean isHidden() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.path);
        }
        return (fs.getBooleanAttributes(this) & 8) != 0;
    }

    public long lastModified() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.path);
        }
        return fs.getLastModifiedTime(this);
    }

    public long length() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.path);
        }
        return fs.getLength(this);
    }

    public boolean createNewFile() throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.path);
        }
        return fs.createFileExclusively(this.path);
    }

    public boolean delete() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkDelete(this.path);
        }
        return fs.delete(this);
    }

    public void deleteOnExit() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkDelete(this.path);
        }
        fs.deleteOnExit(this);
    }

    public String[] list() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.path);
        }
        return fs.list(this);
    }

    public String[] list(FilenameFilter filenameFilter) {
        String[] stringArray = this.list();
        if (stringArray == null || filenameFilter == null) {
            return stringArray;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!filenameFilter.accept(this, stringArray[i2])) continue;
            arrayList.add(stringArray[i2]);
        }
        return arrayList.toArray(new String[0]);
    }

    public File[] listFiles() {
        String[] stringArray = this.list();
        if (stringArray == null) {
            return null;
        }
        int n2 = stringArray.length;
        File[] fileArray = new File[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            fileArray[i2] = new File(stringArray[i2], this);
        }
        return fileArray;
    }

    public File[] listFiles(FilenameFilter filenameFilter) {
        String[] stringArray = this.list();
        if (stringArray == null) {
            return null;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (filenameFilter != null && !filenameFilter.accept(this, stringArray[i2])) continue;
            arrayList.add(new File(stringArray[i2], this));
        }
        return arrayList.toArray(new File[0]);
    }

    public File[] listFiles(FileFilter fileFilter) {
        String[] stringArray = this.list();
        if (stringArray == null) {
            return null;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            File file = new File(stringArray[i2], this);
            if (fileFilter != null && !fileFilter.accept(file)) continue;
            arrayList.add(file);
        }
        return arrayList.toArray(new File[0]);
    }

    public boolean mkdir() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.path);
        }
        return fs.createDirectory(this);
    }

    public boolean mkdirs() {
        if (this.exists()) {
            return false;
        }
        if (this.mkdir()) {
            return true;
        }
        File file = null;
        try {
            file = this.getCanonicalFile();
        }
        catch (IOException iOException) {
            return false;
        }
        String string = file.getParent();
        return string != null && new File(string, fs.prefixLength(string)).mkdirs() && file.mkdir();
    }

    public boolean renameTo(File file) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.path);
            securityManager.checkWrite(file.path);
        }
        return fs.rename(this, file);
    }

    public boolean setLastModified(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Negative time");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.path);
        }
        return fs.setLastModifiedTime(this, l2);
    }

    public boolean setReadOnly() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.path);
        }
        return fs.setReadOnly(this);
    }

    public static File[] listRoots() {
        return fs.listRoots();
    }

    private static File generateFile(String string, String string2, File file) throws IOException {
        if (counter == -1) {
            counter = new Random().nextInt() & 0xFFFF;
        }
        return new File(file, string + Integer.toString(++counter) + string2);
    }

    private static String getTempDir() {
        if (tmpdir == null) {
            GetPropertyAction getPropertyAction = new GetPropertyAction("java.io.tmpdir");
            tmpdir = (String)AccessController.doPrivileged(getPropertyAction);
            tmpdir = fs.normalize(tmpdir);
        }
        return tmpdir;
    }

    private static boolean checkAndCreate(String string, SecurityManager securityManager) throws IOException {
        if (securityManager != null) {
            try {
                securityManager.checkWrite(string);
            }
            catch (AccessControlException accessControlException) {
                throw new SecurityException("Unable to create temporary file");
            }
        }
        return fs.createFileExclusively(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createTempFile(String string, String string2, File file) throws IOException {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.length() < 3) {
            throw new IllegalArgumentException("Prefix string too short");
        }
        String string3 = string2 == null ? ".tmp" : string2;
        Object object = tmpFileLock;
        synchronized (object) {
            File file2;
            Object object2;
            if (file == null) {
                object2 = File.getTempDir();
                file = new File((String)object2, fs.prefixLength((String)object2));
            }
            object2 = System.getSecurityManager();
            while (!File.checkAndCreate((file2 = File.generateFile(string, string3, file)).getPath(), (SecurityManager)object2)) {
            }
            return file2;
        }
    }

    public static File createTempFile(String string, String string2) throws IOException {
        return File.createTempFile(string, string2, null);
    }

    @Override
    public int compareTo(File file) {
        return fs.compare(this, file);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof File) {
            return this.compareTo((File)object) == 0;
        }
        return false;
    }

    public int hashCode() {
        return fs.hashCode(this);
    }

    public String toString() {
        return this.getPath();
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeChar(separatorChar);
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        char c2 = objectInputStream.readChar();
        if (c2 != separatorChar) {
            this.path = this.path.replace(c2, separatorChar);
        }
        this.path = fs.normalize(this.path);
        this.prefixLength = fs.prefixLength(this.path);
    }
}

