/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassPath {
    private PathEntry[] paths;

    public ClassPath(String string) {
        ArrayList<PathEntry> arrayList = new ArrayList<PathEntry>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("")) continue;
            File file = new File(string2);
            try {
                if (!file.exists()) continue;
                if (file.isDirectory()) {
                    arrayList.add(new Dir(string2));
                    continue;
                }
                arrayList.add(new Zip(new ZipFile(file)));
            }
            catch (IOException iOException) {
                System.err.println("CLASSPATH component " + file + ": " + iOException);
            }
        }
        this.paths = new PathEntry[arrayList.size()];
        arrayList.toArray(this.paths);
    }

    public ClassPath() {
        this(ClassPath.getClassPath());
    }

    private static final void getPathComponents(String string, ArrayList arrayList) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                File file = new File(string2);
                if (!file.exists()) continue;
                arrayList.add(string2);
            }
        }
    }

    private static final String getClassPath() {
        Object object;
        String string = System.getProperty("java.class.path");
        String string2 = System.getProperty("sun.boot.class.path");
        String string3 = System.getProperty("java.ext.dirs");
        ArrayList<String> arrayList = new ArrayList<String>();
        ClassPath.getPathComponents(string, arrayList);
        ClassPath.getPathComponents(string2, arrayList);
        ArrayList arrayList2 = new ArrayList();
        ClassPath.getPathComponents(string3, arrayList2);
        Object object2 = arrayList2.iterator();
        while (object2.hasNext()) {
            object = new File((String)object2.next());
            String[] stringArray = ((File)object).list(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return (string = string.toLowerCase()).endsWith(".zip") || string.endsWith(".jar");
                }
            });
            if (stringArray == null) continue;
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                arrayList.add(string3 + File.separatorChar + stringArray[i2]);
            }
        }
        object2 = new StringBuffer();
        object = arrayList.iterator();
        while (object.hasNext()) {
            ((StringBuffer)object2).append((String)object.next());
            if (!object.hasNext()) continue;
            ((StringBuffer)object2).append(File.pathSeparatorChar);
        }
        return ((StringBuffer)object2).toString();
    }

    public InputStream getInputStream(String string) throws IOException {
        return this.getInputStream(string, ".class");
    }

    public InputStream getInputStream(String string, String string2) throws IOException {
        return this.getClassFile(string, string2).getInputStream();
    }

    public ClassFile getClassFile(String string, String string2) throws IOException {
        for (int i2 = 0; i2 < this.paths.length; ++i2) {
            ClassFile classFile = this.paths[i2].getClassFile(string, string2);
            if (classFile == null) continue;
            return classFile;
        }
        throw new IOException("Couldn't find: " + string + string2);
    }

    public ClassFile getClassFile(String string) throws IOException {
        return this.getClassFile(string, ".class");
    }

    public byte[] getBytes(String string, String string2) throws IOException {
        InputStream inputStream = this.getInputStream(string, string2);
        if (inputStream == null) {
            throw new IOException("Couldn't find: " + string + string2);
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte[] byArray = new byte[inputStream.available()];
        dataInputStream.readFully(byArray);
        dataInputStream.close();
        inputStream.close();
        return byArray;
    }

    public byte[] getBytes(String string) throws IOException {
        return this.getBytes(string, ".class");
    }

    public String getPath(String string) throws IOException {
        int n2 = string.lastIndexOf(46);
        String string2 = "";
        if (n2 > 0) {
            string2 = string.substring(n2);
            string = string.substring(0, n2);
        }
        return this.getPath(string, string2);
    }

    public String getPath(String string, String string2) throws IOException {
        return this.getClassFile(string, string2).getPath();
    }

    public static abstract class ClassFile {
        public abstract InputStream getInputStream() throws IOException;

        public abstract String getPath();

        public abstract long getTime();

        public abstract long getSize();
    }

    private static class Dir
    extends PathEntry {
        private String dir;

        Dir(String string) {
            this.dir = string;
        }

        ClassFile getClassFile(String string, String string2) throws IOException {
            final File file = new File(this.dir + File.separatorChar + string.replace('.', File.separatorChar) + string2);
            return file.exists() ? new ClassFile(){

                public InputStream getInputStream() throws IOException {
                    return new FileInputStream(file);
                }

                public String getPath() {
                    try {
                        return file.getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                }

                public long getTime() {
                    return file.lastModified();
                }

                public long getSize() {
                    return file.length();
                }
            } : null;
        }

        public String toString() {
            return this.dir;
        }
    }

    private static abstract class PathEntry {
        private PathEntry() {
        }

        abstract ClassFile getClassFile(String var1, String var2) throws IOException;
    }

    private static class Zip
    extends PathEntry {
        private ZipFile zip;

        Zip(ZipFile zipFile) {
            this.zip = zipFile;
        }

        ClassFile getClassFile(String string, String string2) throws IOException {
            final ZipEntry zipEntry = this.zip.getEntry(string.replace('.', '/') + string2);
            return zipEntry != null ? new ClassFile(){

                public InputStream getInputStream() throws IOException {
                    return Zip.this.zip.getInputStream(zipEntry);
                }

                public String getPath() {
                    return zipEntry.toString();
                }

                public long getTime() {
                    return zipEntry.getTime();
                }

                public long getSize() {
                    return zipEntry.getSize();
                }
            } : null;
        }
    }
}

