/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.generic.InstructionHandle;
import com.sun.org.apache.bcel.internal.generic.Select;
import com.sun.org.apache.bcel.internal.generic.Visitor;
import com.sun.org.apache.bcel.internal.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public class LOOKUPSWITCH
extends Select {
    LOOKUPSWITCH() {
    }

    public LOOKUPSWITCH(int[] nArray, InstructionHandle[] instructionHandleArray, InstructionHandle instructionHandle) {
        super((short)171, nArray, instructionHandleArray, instructionHandle);
        this.length = (short)(9 + this.match_length * 8);
        this.fixed_length = this.length;
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeInt(this.match_length);
        for (int i2 = 0; i2 < this.match_length; ++i2) {
            dataOutputStream.writeInt(this.match[i2]);
            this.indices[i2] = this.getTargetOffset(this.targets[i2]);
            dataOutputStream.writeInt(this.indices[i2]);
        }
    }

    protected void initFromFile(ByteSequence byteSequence, boolean bl2) throws IOException {
        super.initFromFile(byteSequence, bl2);
        this.match_length = byteSequence.readInt();
        this.fixed_length = (short)(9 + this.match_length * 8);
        this.length = (short)(this.fixed_length + this.padding);
        this.match = new int[this.match_length];
        this.indices = new int[this.match_length];
        this.targets = new InstructionHandle[this.match_length];
        for (int i2 = 0; i2 < this.match_length; ++i2) {
            this.match[i2] = byteSequence.readInt();
            this.indices[i2] = byteSequence.readInt();
        }
    }

    public void accept(Visitor visitor) {
        visitor.visitVariableLengthInstruction(this);
        visitor.visitStackProducer(this);
        visitor.visitBranchInstruction(this);
        visitor.visitSelect(this);
        visitor.visitLOOKUPSWITCH(this);
    }
}

