/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.monitor.dialog;

import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.performance.monitor.action.AddPerformance;
import com.clustercontrol.performance.monitor.action.DeletePerformance;
import com.clustercontrol.performance.monitor.action.ModifyPerformance;
import com.clustercontrol.performance.monitor.composite.PerformanceListComposite;
import com.clustercontrol.performance.monitor.dialog.PerformanceCreateDialog;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class PerformanceListDialog
extends CommonDialog {
    private PerformanceListComposite perfList = null;
    private Button buttonAdd = null;
    private Button buttonModify = null;
    private Button buttonDelete = null;

    public PerformanceListDialog(Shell parent) {
        super(parent);
    }

    protected Point getInitialSize() {
        return new Point(800, 350);
    }

    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString((String)"dialog.performance.monitor.list"));
        GridLayout layout = new GridLayout(8, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 8;
        parent.setLayout((Layout)layout);
        this.perfList = new PerformanceListComposite(parent, 2048);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 7;
        this.perfList.setLayoutData(gridData);
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout(1, true);
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        composite.setLayoutData((Object)gridData);
        this.buttonAdd = this.createButton(composite, Messages.getString((String)"add"));
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MonitorInfo info;
                PerformanceCreateDialog dialog = new PerformanceCreateDialog(PerformanceListDialog.this.getParentShell());
                if (dialog.open() == 0 && (info = dialog.getInputData()) != null) {
                    boolean result = new AddPerformance().add(info);
                    Object[] args = new String[]{info.getMonitorId()};
                    if (result) {
                        MessageBox box = new MessageBox(PerformanceListDialog.this.getShell(), 34);
                        box.setText(Messages.getString((String)"successful"));
                        box.setMessage(Messages.getString((String)"message.performance.monitor.1", (Object[])args));
                        box.open();
                        PerformanceListDialog.this.perfList.update();
                    } else {
                        MessageBox box = new MessageBox(PerformanceListDialog.this.getShell(), 33);
                        box.setText(Messages.getString((String)"failed"));
                        box.setMessage(Messages.getString((String)"message.performance.monitor.2", (Object[])args));
                        box.open();
                    }
                }
            }
        });
        new Label(composite, 0);
        this.buttonModify = this.createButton(composite, Messages.getString((String)"modify"));
        this.buttonModify.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String monitorId = null;
                Table table = PerformanceListDialog.this.perfList.getTableViewer().getTable();
                TableItem[] item = table.getSelection();
                if (item != null && item.length > 0) {
                    try {
                        monitorId = (String)((ArrayList)item[0].getData()).get(0);
                    }
                    catch (Exception exception) {}
                }
                if (monitorId != null) {
                    PerformanceCreateDialog dialog = new PerformanceCreateDialog(PerformanceListDialog.this.getParentShell(), monitorId);
                    if (dialog.open() == 0) {
                        boolean result = new ModifyPerformance().modify(dialog.getInputData());
                        Object[] args = new String[]{monitorId};
                        if (result) {
                            MessageBox box = new MessageBox(PerformanceListDialog.this.getShell(), 34);
                            box.setText(Messages.getString((String)"successful"));
                            box.setMessage(Messages.getString((String)"message.performance.monitor.3", (Object[])args));
                            box.open();
                            int selectIndex = table.getSelectionIndex();
                            PerformanceListDialog.this.perfList.update();
                            table.setSelection(selectIndex);
                        } else {
                            MessageBox box = new MessageBox(PerformanceListDialog.this.getShell(), 33);
                            box.setText(Messages.getString((String)"failed"));
                            box.setMessage(Messages.getString((String)"message.performance.monitor.4", (Object[])args));
                            box.open();
                        }
                    }
                } else {
                    MessageBox box = new MessageBox(PerformanceListDialog.this.getShell(), 40);
                    box.setText(Messages.getString((String)"warning"));
                    box.setMessage(Messages.getString((String)"message.performance.monitor.8"));
                    box.open();
                }
            }
        });
        new Label(composite, 0);
        this.buttonDelete = this.createButton(composite, Messages.getString((String)"delete"));
        this.buttonDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String monitorId = null;
                Table table = PerformanceListDialog.this.perfList.getTableViewer().getTable();
                TableItem[] item = table.getSelection();
                if (item != null && item.length > 0) {
                    try {
                        monitorId = (String)((ArrayList)item[0].getData()).get(0);
                    }
                    catch (Exception exception) {}
                }
                if (monitorId != null) {
                    MessageBox confirmBox = new MessageBox(PerformanceListDialog.this.getShell(), 296);
                    confirmBox.setText(Messages.getString((String)"confirmed"));
                    Object[] args = new String[]{monitorId};
                    String message = Messages.getString((String)"message.performance.monitor.7", (Object[])args);
                    confirmBox.setMessage(message);
                    if (confirmBox.open() == 32) {
                        boolean result = new DeletePerformance().delete(monitorId);
                        if (result) {
                            MessageBox box = new MessageBox(PerformanceListDialog.this.getShell(), 34);
                            box.setText(Messages.getString((String)"successful"));
                            box.setMessage(Messages.getString((String)"message.performance.monitor.5", (Object[])args));
                            box.open();
                            PerformanceListDialog.this.perfList.update();
                        } else {
                            MessageBox box = new MessageBox(PerformanceListDialog.this.getShell(), 33);
                            box.setText(Messages.getString((String)"failed"));
                            box.setMessage(Messages.getString((String)"message.performance.monitor.6", (Object[])args));
                            box.open();
                        }
                    }
                } else {
                    MessageBox box = new MessageBox(PerformanceListDialog.this.getShell(), 40);
                    box.setText(Messages.getString((String)"warning"));
                    box.setMessage(Messages.getString((String)"message.performance.monitor.9"));
                    box.open();
                }
            }
        });
        Label line = new Label(parent, 258);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 8;
        line.setLayoutData((Object)gridData);
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2, (display.getBounds().height - shell.getSize().y) / 2);
    }

    protected ValidateResult validate() {
        return super.validate();
    }

    private Button createButton(Composite parent, String label) {
        Button button = new Button(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)gridData);
        button.setText(label);
        return button;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, false);
    }
}

