/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.monitor.composite;

import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.run.bean.MonitorCheckInfo;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.performance.util.CollectorItemCodeFactory;
import com.clustercontrol.performanceMGR.bean.CollectorItemInfo;
import com.clustercontrol.performanceMGR.monitor.bean.MonitorPerfCheckInfo;
import com.clustercontrol.util.Messages;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CollectorItemComboComposite
extends Composite {
    public static final int WIDTH_TITLE = 5;
    public static final int WIDTH_VALUE = 8;
    private Combo m_comboCollectorItem = null;

    public CollectorItemComboComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        Label label = null;
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 15;
        this.setLayout((Layout)layout);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"monitor.item")) + " : ");
        this.m_comboCollectorItem = new Combo((Composite)this, 12);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboCollectorItem.setLayoutData((Object)gridData);
    }

    public void setCollectorItemCombo(String facilityId) {
        List itemInfoList = CollectorItemCodeFactory.getAvailableCollectorItemList(facilityId);
        this.m_comboCollectorItem.removeAll();
        for (CollectorItemInfo itemInfo : itemInfoList) {
            String itemName = CollectorItemCodeFactory.getFullItemName(itemInfo);
            this.m_comboCollectorItem.add(itemName);
            this.m_comboCollectorItem.setData(itemName, (Object)itemInfo);
        }
    }

    public CollectorItemInfo getCollectorItem() {
        String itemName = this.m_comboCollectorItem.getText();
        CollectorItemInfo itemInfo = (CollectorItemInfo)this.m_comboCollectorItem.getData(itemName);
        return itemInfo;
    }

    public void select(MonitorInfo monitor) {
        MonitorPerfCheckInfo perfCheckInfo = (MonitorPerfCheckInfo)monitor.getCheckInfo();
        if (perfCheckInfo == null) {
            return;
        }
        String facilityId = monitor.getFacilityId();
        this.setCollectorItemCombo(facilityId);
        int index = 0;
        List itemInfoList = CollectorItemCodeFactory.getAvailableCollectorItemList(facilityId);
        Iterator itr = itemInfoList.iterator();
        int i = 0;
        while (itr.hasNext()) {
            CollectorItemInfo itemInfo = (CollectorItemInfo)itr.next();
            if (itemInfo.getCollectorItemCode().equals(perfCheckInfo.getItemCode()) && itemInfo.getDeviceName().equals(perfCheckInfo.getDeviceName())) {
                index = i;
            }
            ++i;
        }
        this.m_comboCollectorItem.select(index);
    }

    public ValidateResult createInputData(MonitorInfo info) {
        if (info != null) {
            MonitorPerfCheckInfo perfCheckInfo = (MonitorPerfCheckInfo)info.getCheckInfo();
            if (this.m_comboCollectorItem.getText() != null && !"".equals(this.m_comboCollectorItem.getText().trim())) {
                String itemName = this.m_comboCollectorItem.getText();
                CollectorItemInfo itemInfo = (CollectorItemInfo)this.m_comboCollectorItem.getData(itemName);
                perfCheckInfo.setMonitorTypeId("PERF");
                perfCheckInfo.setMonitorId(info.getMonitorId());
                perfCheckInfo.setItemCode(itemInfo.getCollectorItemCode());
                perfCheckInfo.setDeviceIndex(Integer.valueOf(itemInfo.getDeviceIndex()));
                perfCheckInfo.setDeviceName(itemInfo.getDeviceName());
                info.setCheckInfo((MonitorCheckInfo)perfCheckInfo);
            } else {
                return this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.performance.monitor.10"));
            }
        }
        return null;
    }

    protected ValidateResult setValidateResult(String id, String message) {
        ValidateResult validateResult = new ValidateResult();
        validateResult.setValid(false);
        validateResult.setID(id);
        validateResult.setMessage(message);
        return validateResult;
    }
}

