/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.proxy;

import com.sun.deploy.net.proxy.BrowserProxyInfo;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;

public final class ProxyUtils {
    private static void parseProxyAddress(int n, String string, BrowserProxyInfo browserProxyInfo) {
        String string2 = null;
        try {
            URL uRL = new URL(string);
            string2 = new String(uRL.getHost() + ":" + uRL.getPort());
        }
        catch (MalformedURLException malformedURLException) {
            string2 = new String(string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
        if (!stringTokenizer.hasMoreTokens()) {
            return;
        }
        String string3 = stringTokenizer.nextToken();
        int n2 = -1;
        if (stringTokenizer.hasMoreTokens()) {
            try {
                n2 = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        switch (n) {
            case 1: {
                browserProxyInfo.setHttpHost(string3);
                browserProxyInfo.setHttpPort(n2);
                break;
            }
            case 2: {
                browserProxyInfo.setHttpsHost(string3);
                browserProxyInfo.setHttpsPort(n2);
                break;
            }
            case 4: {
                browserProxyInfo.setFtpHost(string3);
                browserProxyInfo.setFtpPort(n2);
                break;
            }
            case 8: {
                browserProxyInfo.setGopherHost(string3);
                browserProxyInfo.setGopherPort(n2);
                break;
            }
            case 16: {
                browserProxyInfo.setSocksHost(string3);
                browserProxyInfo.setSocksPort(n2);
                break;
            }
            default: {
                throw new IllegalStateException("ProxyUtils: ProtocolType not valid");
            }
        }
    }

    public static void parseProxyServer(String string, BrowserProxyInfo browserProxyInfo) {
        if (string.indexOf("=") != -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.startsWith("http=")) {
                    ProxyUtils.parseProxyAddress(1, string2.substring(5, string2.length()), browserProxyInfo);
                    continue;
                }
                if (string2.startsWith("https=")) {
                    ProxyUtils.parseProxyAddress(2, string2.substring(6, string2.length()), browserProxyInfo);
                    continue;
                }
                if (string2.startsWith("ftp=")) {
                    ProxyUtils.parseProxyAddress(4, string2.substring(4, string2.length()), browserProxyInfo);
                    continue;
                }
                if (string2.startsWith("gopher=")) {
                    ProxyUtils.parseProxyAddress(8, string2.substring(7, string2.length()), browserProxyInfo);
                    continue;
                }
                if (!string2.startsWith("socks=")) continue;
                ProxyUtils.parseProxyAddress(16, string2.substring(6, string2.length()), browserProxyInfo);
            }
        } else {
            ProxyUtils.parseProxyAddress(1, string, browserProxyInfo);
            ProxyUtils.parseProxyAddress(2, string, browserProxyInfo);
            ProxyUtils.parseProxyAddress(4, string, browserProxyInfo);
            ProxyUtils.parseProxyAddress(8, string, browserProxyInfo);
        }
    }
}

