/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.composite;

import com.clustercontrol.bean.Property;
import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.jobmanagement.action.GetHistory;
import com.clustercontrol.jobmanagement.action.GetHistoryTableDefine;
import com.clustercontrol.jobmanagement.composite.action.HistorySelectionChangedListener;
import com.clustercontrol.jobmanagement.composite.action.SessionJonDoubleClickListener;
import com.clustercontrol.util.Messages;
import java.rmi.AccessException;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class HistoryComposite
extends Composite {
    protected CommonTableViewer m_viewer = null;
    protected Label m_labelType = null;
    protected Label m_labelCount = null;
    protected String m_sessionId = null;
    protected String m_jobId = null;
    private boolean openAccessInformation = false;
    private boolean openInformation = false;

    public HistoryComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.m_labelType = new Label((Composite)this, 16384);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.m_labelType.setLayoutData((Object)gridData);
        Table table = new Table((Composite)this, 66308);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData((Object)gridData);
        this.m_labelCount = new Label((Composite)this, 131072);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.m_labelCount.setLayoutData((Object)gridData);
        this.m_viewer = new CommonTableViewer(table);
        this.m_viewer.createTableColumn(GetHistoryTableDefine.get(), 3, -1);
        this.m_viewer.addSelectionChangedListener((ISelectionChangedListener)new HistorySelectionChangedListener(this));
        this.m_viewer.addDoubleClickListener((IDoubleClickListener)new SessionJonDoubleClickListener(this));
    }

    public void update() {
        ArrayList historyInfo;
        block5: {
            historyInfo = null;
            GetHistory getHistory = new GetHistory();
            try {
                historyInfo = getHistory.getHistory();
            }
            catch (AccessException accessException) {
                if (!this.openAccessInformation) {
                    this.openAccessInformation = true;
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                historyInfo = new ArrayList();
                if (this.openInformation) break block5;
                this.openInformation = true;
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.job.33"));
                this.openInformation = false;
            }
        }
        if (historyInfo == null) {
            historyInfo = new ArrayList();
        }
        this.m_viewer.setInput(historyInfo);
        this.selectHistory(historyInfo);
        this.m_labelType.setText("");
        Object[] args = new Object[]{new Integer(historyInfo.size())};
        this.m_labelCount.setText(Messages.getString((String)"records", (Object[])args));
    }

    public void update(Property condition) {
        ArrayList historyInfo;
        block4: {
            historyInfo = null;
            GetHistory getHistory = new GetHistory();
            try {
                historyInfo = getHistory.getHistory(condition);
            }
            catch (AccessException accessException) {
                if (!this.openAccessInformation) {
                    this.openAccessInformation = true;
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                historyInfo = new ArrayList();
                if (this.openInformation) break block4;
                this.openInformation = true;
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.job.33"));
                this.openInformation = false;
            }
        }
        this.m_viewer.setInput(historyInfo);
        this.selectHistory(historyInfo);
        this.m_labelType.setText(Messages.getString((String)"filtered.list"));
        Object[] args = new Object[]{new Integer(historyInfo.size())};
        this.m_labelCount.setText(Messages.getString((String)"filtered.records", (Object[])args));
    }

    public void selectHistory(ArrayList historyInfo) {
        if (this.m_sessionId != null && this.m_sessionId.length() > 0) {
            int index = -1;
            int i = 0;
            while (i < historyInfo.size()) {
                ArrayList line = (ArrayList)historyInfo.get(i);
                String sessionId = (String)line.get(3);
                if (this.m_sessionId.compareTo(sessionId) == 0) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index == -1) {
                this.m_sessionId = null;
                this.m_jobId = null;
            } else {
                this.m_viewer.setSelection((ISelection)new StructuredSelection(historyInfo.get(index)), true);
            }
        }
    }

    public TableViewer getTableViewer() {
        return this.m_viewer;
    }

    public Table getTable() {
        return this.m_viewer.getTable();
    }

    public String getSessionId() {
        return this.m_sessionId;
    }

    public void setSessionId(String sessionId) {
        this.m_sessionId = sessionId;
    }

    public String getJobId() {
        return this.m_jobId;
    }

    public void setJobId(String jobId) {
        this.m_jobId = jobId;
    }
}

