/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.ui;

import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.util.DeployUIManager;
import com.sun.deploy.util.Trace;
import com.sun.javaws.Globals;
import com.sun.javaws.LaunchDownload;
import com.sun.javaws.Main;
import com.sun.javaws.cache.CacheImageLoader;
import com.sun.javaws.cache.CacheImageLoaderCallback;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.LaunchDesc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;

public class DownloadWindow
extends WindowAdapter
implements ActionListener,
LaunchDownload.DownloadProgress,
CacheImageLoaderCallback {
    private JFrame _frame = null;
    private String _title;
    private String _vendor;
    private long _estimatedDownloadSize = 0L;
    private long _totalDownloadedBytes = 0L;
    private URL _currentUrl = null;
    static final int TIMER_UPDATE_RATE = 1000;
    static final int TIMER_INITIAL_DELAY = 10;
    static final int TIMER_AVERAGE_SIZE = 10;
    Timer _timerObject = null;
    long[] _timerDownloadAverage = new long[10];
    int _timerCount = 0;
    long _timerLastBytesCount = 0L;
    boolean _timerOn = false;
    static final int HEART_BEAT_RATE = 250;
    static final boolean[] HEART_BEAT_RYTHM = new boolean[]{false, false, false, true, false, true};
    Timer _heartbeatTimer = null;
    Object _heartbeatLock = new Object();
    int _heartbeatCount = 0;
    boolean _heartbeatOn = false;
    boolean _isCanceled = false;
    boolean _exitOnCancel = true;
    private Image _appImage;
    private JButton _cancelButton = null;
    private JLabel _titleLabel = null;
    private JLabel _vendorLabel = null;
    private JLabel _infoStatus = null;
    private JLabel _infoProgressTxt = null;
    private JLabel _infoEstimatedTime = null;
    private JProgressBar _infoProgressBar = null;
    private JLabel _imageLabel = null;
    private static final int _yRestriction = 20;
    private static final int MAX_DISPLAY = 20;
    private static final String LEAD = "...";
    private DefaultBoundedRangeModel _loadingModel;
    private ActionListener _cancelActionListener;

    public DownloadWindow(LaunchDesc launchDesc, boolean bl) {
        this.setLaunchDesc(launchDesc, bl);
    }

    public DownloadWindow() {
    }

    public void setLaunchDesc(LaunchDesc launchDesc, boolean bl) {
        IconDesc iconDesc;
        InformationDesc informationDesc = launchDesc.getInformation();
        this._title = informationDesc.getTitle();
        this._vendor = informationDesc.getVendor();
        if (this._titleLabel != null) {
            this._titleLabel.setText(this._title);
            this._vendorLabel.setText(this._vendor);
        }
        this._isCanceled = false;
        this._exitOnCancel = bl;
        if (informationDesc != null && (iconDesc = informationDesc.getIconLocation(2, 0)) != null) {
            CacheImageLoader.getInstance().loadImage(iconDesc, (CacheImageLoaderCallback)this);
        }
    }

    public void imageAvailable(IconDesc iconDesc, Image image, File file) {
        this.updateImage(image, true);
    }

    public void finalImageAvailable(IconDesc iconDesc, Image image, File file) {
    }

    public JFrame getFrame() {
        return this._frame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildIntroScreen() {
        LookAndFeel lookAndFeel = null;
        try {
            lookAndFeel = DeployUIManager.setLookAndFeel();
            this._frame = new JFrame(ResourceManager.getString((String)"product.javaws.name", (String)""));
            this._frame.addWindowListener(this);
            JPanel jPanel = new JPanel(new BorderLayout());
            Container container = this._frame.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)jPanel, "Center");
            jPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8), new BevelBorder(1)));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel.add((Component)jPanel2, "North");
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel.add((Component)jPanel3, "Center");
            JPanel jPanel4 = new JPanel(new BorderLayout());
            this._imageLabel = new BLabel();
            jPanel4.add((Component)this._imageLabel, "Center");
            jPanel4.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            this.updateImage(ResourceManager.getIcon((String)"java48.image").getImage(), false);
            jPanel2.add((Component)jPanel4, "West");
            Font font = ResourceManager.getUIFont();
            Font font2 = font.deriveFont(22.0f);
            Font font3 = font.deriveFont(18.0f);
            JPanel jPanel5 = new JPanel(new GridLayout(2, 3));
            jPanel2.add((Component)jPanel5, "Center");
            this._titleLabel = new BLabel(this._title, 360, 0);
            this._titleLabel.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
            this._titleLabel.setFont(font2);
            jPanel5.add(this._titleLabel);
            this._vendorLabel = new BLabel(this._vendor, 0, 0);
            this._vendorLabel.setFont(font3);
            this._vendorLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
            jPanel5.add(this._vendorLabel);
            JPanel jPanel6 = new JPanel(new BorderLayout());
            container.add((Component)jPanel6, "South");
            this._cancelButton = new JButton(ResourceManager.getString((String)"launch.cancel"));
            this._cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DownloadWindow.this.cancelAction();
                }
            });
            this._infoStatus = new BLabel(ResourceManager.getString((String)"launch.initializing", (String)this._title, (String)this._vendor), 0, 0);
            this._infoProgressTxt = new BLabel(" ", 0, 0);
            this._infoEstimatedTime = new BLabel(" ", 0, 0);
            this._loadingModel = new DefaultBoundedRangeModel(0, 1, 0, 100);
            this._infoProgressBar = new JProgressBar(this._loadingModel);
            this._infoProgressBar.setOpaque(true);
            this._infoProgressBar.setVisible(true);
            jPanel3.add((Component)this._infoStatus, "North");
            jPanel3.add((Component)this._infoProgressTxt, "Center");
            jPanel3.add((Component)this._infoEstimatedTime, "South");
            jPanel3.setBorder(BorderFactory.createEmptyBorder(2, 8, 2, 8));
            this._infoProgressBar.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
            jPanel6.add((Component)this._infoProgressBar, "Center");
            jPanel6.add((Component)this._cancelButton, "East");
            jPanel6.setBorder(BorderFactory.createEmptyBorder(0, 10, 8, 10));
            this._frame.pack();
            this.setIndeterminedProgressBar(true);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = (dimension.width - this._frame.getWidth()) / 2;
            int n2 = (dimension.height - this._frame.getHeight()) / 2;
            this._frame.setLocation(n, n2);
        }
        finally {
            DeployUIManager.restoreLookAndFeel((LookAndFeel)lookAndFeel);
        }
    }

    public void showLoadingProgressScreen() {
        this.setStatus(ResourceManager.getString((String)"launch.progressScreen"));
        this._timerObject = new Timer(1000, this);
        this._timerObject.start();
    }

    public void setStatus(final String string) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (DownloadWindow.this._infoStatus != null) {
                    DownloadWindow.this._infoStatus.setText(string == null ? " " : string);
                }
            }
        };
        if (this._infoStatus != null && this._infoStatus.isShowing()) {
            SwingUtilities.invokeLater(runnable);
        } else {
            runnable.run();
        }
    }

    public void setProgressText(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (DownloadWindow.this._infoProgressTxt != null) {
                    DownloadWindow.this._infoProgressTxt.setText(string == null ? " " : string);
                }
            }
        });
    }

    public void setProgressBarVisible(final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (DownloadWindow.this._infoProgressBar != null) {
                    DownloadWindow.this._infoProgressBar.setVisible(bl);
                }
            }
        });
    }

    public void setProgressBarValue(int n) {
        if (this._heartbeatOn) {
            this.setIndeterminedProgressBar(false);
        }
        if (this._loadingModel != null) {
            this._loadingModel.setValue(n);
        }
        this.setProgressBarVisible(n != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIndeterminedProgressBar(boolean bl) {
        if (this._heartbeatTimer == null) {
            this._heartbeatTimer = new Timer(250, new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void actionPerformed(ActionEvent actionEvent) {
                    Object object = DownloadWindow.this._heartbeatLock;
                    synchronized (object) {
                        if (DownloadWindow.this._heartbeatOn && DownloadWindow.this._heartbeatTimer != null) {
                            DownloadWindow.this._heartbeatCount = (DownloadWindow.this._heartbeatCount + 1) % HEART_BEAT_RYTHM.length;
                            boolean bl = HEART_BEAT_RYTHM[DownloadWindow.this._heartbeatCount];
                            if (bl) {
                                DownloadWindow.this._loadingModel.setValue(100);
                            } else {
                                DownloadWindow.this._loadingModel.setValue(0);
                            }
                        }
                    }
                }
            });
        }
        Object object = this._heartbeatLock;
        synchronized (object) {
            if (bl) {
                this.setProgressBarVisible(true);
                this._loadingModel.setValue(0);
                this._heartbeatTimer.start();
                this._heartbeatOn = true;
            } else {
                this.setProgressBarVisible(false);
                this._heartbeatTimer.stop();
                this._heartbeatOn = false;
            }
        }
    }

    public void showLaunchingApplication(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (DownloadWindow.this._loadingModel != null) {
                    DownloadWindow.this._infoStatus.setText(string);
                    DownloadWindow.this._infoProgressTxt.setText(" ");
                    DownloadWindow.this._infoEstimatedTime.setText(" ");
                    DownloadWindow.this._loadingModel.setValue(0);
                }
            }
        });
    }

    private void setEstimatedTime(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (DownloadWindow.this._infoEstimatedTime != null) {
                    DownloadWindow.this._infoEstimatedTime.setText(string == null ? " " : string);
                }
            }
        });
    }

    public void clearWindow() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.clearWindowHelper();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        DownloadWindow.this.clearWindowHelper();
                    }
                });
            }
            catch (Exception exception) {
                Trace.ignoredException((Exception)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearWindowHelper() {
        if (this._timerObject != null) {
            this._timerObject.stop();
            this._timerObject = null;
            this._timerDownloadAverage = null;
        }
        if (this._heartbeatTimer != null) {
            Object object = this._heartbeatLock;
            synchronized (object) {
                this._heartbeatTimer.stop();
                this._heartbeatTimer = null;
            }
        }
        if (this._frame != null) {
            this._infoStatus = null;
            this._infoProgressTxt = null;
            this._infoProgressBar = null;
            this._loadingModel = null;
            this._infoEstimatedTime = null;
            this._cancelButton.removeActionListener(this._cancelActionListener);
            this._cancelButton = null;
            this._cancelActionListener = null;
            this._frame.getContentPane().removeAll();
        }
    }

    public void disposeWindow() {
        if (this._frame != null) {
            this.clearWindow();
            this._frame.removeWindowListener(this);
            this._frame.setVisible(false);
            this._frame.dispose();
            this._frame = null;
        }
    }

    public void reset() {
        this.setStatus(null);
        this.setProgressText(null);
        this.setProgressBarVisible(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this._timerOn) {
            return;
        }
        if (this._estimatedDownloadSize <= 0L) {
            return;
        }
        long l = this._totalDownloadedBytes - this._timerLastBytesCount;
        this._timerLastBytesCount = this._totalDownloadedBytes;
        this._timerDownloadAverage[this._timerCount % 10] = l;
        if (this._totalDownloadedBytes > this._estimatedDownloadSize) {
            this._estimatedDownloadSize = this._totalDownloadedBytes;
        }
        if (this._timerCount > 10) {
            int n;
            float f = 0.0f;
            for (n = 0; n < 10; ++n) {
                f += (float)this._timerDownloadAverage[n];
            }
            f /= 10.0f;
            if ((f /= 1.0f) == 0.0f) {
                this.setEstimatedTime(ResourceManager.getString((String)"launch.stalledDownload"));
            } else if (this._estimatedDownloadSize > 0L) {
                n = (int)((float)(this._estimatedDownloadSize - this._totalDownloadedBytes) / f);
                int n2 = n / 3600;
                int n3 = (n -= n2 * 3600) / 60;
                int n4 = n -= n3 * 60;
                this.setEstimatedTime(ResourceManager.getString((String)"launch.estimatedTimeLeft", (int)n2, (int)n3, (int)n4));
            }
        }
        ++this._timerCount;
    }

    public void resetDownloadTimer() {
        this._timerCount = 0;
        this._timerLastBytesCount = 0L;
    }

    public void progress(URL uRL, String string, long l, long l2, int n) {
        this._timerOn = true;
        this._totalDownloadedBytes = Math.max(0L, l);
        this._estimatedDownloadSize = l2;
        if (uRL != this._currentUrl && uRL != null) {
            String string2 = uRL.getHost();
            String string3 = uRL.getFile();
            int n2 = string3.lastIndexOf(47);
            if (n2 != -1) {
                string3 = string3.substring(n2 + 1);
            }
            if (string3.length() + string2.length() > 40) {
                string3 = this.maxDisplay(string3);
                string2 = this.maxDisplay(string2);
            }
            this.setStatus(ResourceManager.getString((String)"launch.loadingNetStatus", (String)string3, (String)string2));
            this._currentUrl = uRL;
        }
        if (l2 == -1L) {
            this.setProgressText(ResourceManager.getString((String)"launch.loadingNetProgress", (String)this.bytesToString(this._totalDownloadedBytes)));
        } else {
            this.setProgressText(ResourceManager.getString((String)"launch.loadingNetProgressPercent", (String)this.bytesToString(this._totalDownloadedBytes), (String)this.bytesToString(l2), (String)new Long(Math.max(0, n)).toString()));
            this.setProgressBarValue(n);
        }
    }

    public void patching(URL uRL, String string, int n, int n2) {
        this._timerOn = false;
        this.setEstimatedTime(null);
        if (this._currentUrl != uRL || n == 0) {
            String string2 = uRL.getHost();
            String string3 = uRL.getFile();
            int n3 = string3.lastIndexOf(47);
            if (n3 != -1) {
                string3 = string3.substring(n3 + 1);
            }
            if (string3.length() + string2.length() > 40) {
                string3 = this.maxDisplay(string3);
                string2 = this.maxDisplay(string2);
            }
            this.setStatus(ResourceManager.getString((String)"launch.patchingStatus", (String)string3, (String)string2));
            this._currentUrl = uRL;
        }
        this.setProgressText(null);
        this.setProgressBarValue(n2);
    }

    private String maxDisplay(String string) {
        int n = string.length();
        if (n > 20) {
            string = LEAD + string.substring(n - (20 - LEAD.length()), n);
        }
        return string;
    }

    public void validating(URL uRL, String string, long l, long l2, int n) {
        long l3;
        this._timerOn = false;
        this.setEstimatedTime(null);
        long l4 = l3 = l2 == 0L ? 0L : l * 100L / l2;
        if (this._currentUrl != uRL || l == 0L) {
            String string2 = uRL.getHost();
            String string3 = uRL.getFile();
            int n2 = string3.lastIndexOf(47);
            if (n2 != -1) {
                string3 = string3.substring(n2 + 1);
            }
            if (string3.length() + string2.length() > 40) {
                string3 = this.maxDisplay(string3);
                string2 = this.maxDisplay(string2);
            }
            this.setStatus(ResourceManager.getString((String)"launch.validatingStatus", (String)string3, (String)string2));
            this._currentUrl = uRL;
        }
        if (l != 0L) {
            this.setProgressText(ResourceManager.getString((String)"launch.validatingProgress", (int)((int)l3)));
        } else {
            this.setProgressText(null);
        }
        this.setProgressBarValue(n);
    }

    public void downloadFailed(URL uRL, String string) {
        this._timerOn = false;
        this.setEstimatedTime(null);
        this.setStatus(ResourceManager.getString((String)"launch.loadingResourceFailedSts", (String)uRL.toString()));
        this.setProgressText(ResourceManager.getString((String)"launch.loadingResourceFailed"));
        this.setProgressBarVisible(false);
    }

    public void extensionDownload(String string, int n) {
        this._timerOn = false;
        this.setEstimatedTime(null);
        if (string != null) {
            this.setStatus(ResourceManager.getString((String)"launch.extensiondownload-name", (String)string, (int)n));
        } else {
            this.setStatus(ResourceManager.getString((String)"launch.extensiondownload", (String)string, (int)n));
        }
    }

    public void jreDownload(String string, URL uRL) {
        this._timerOn = false;
        this.setEstimatedTime(null);
        String string2 = uRL.getHost();
        string2 = this.maxDisplay(string2);
        this.setStatus(ResourceManager.getString((String)"launch.downloadingJRE", (String)string, (String)string2));
    }

    private void loadingFromNet(URL uRL, int n, int n2) {
    }

    private void setAppImage(Image image) {
        this.updateImage(image, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateImage(Image image, boolean bl) {
        if (image != null) {
            int n = image.getWidth(null);
            int n2 = image.getHeight(null);
            if (n > 64 || n2 > 64) {
                int n3 = 64;
                if (n2 > n && n2 < 2 * n) {
                    n3 = 64 * n / n2;
                }
                BufferedImage bufferedImage = new BufferedImage(64, 64, 1);
                if (!Globals.isHeadless()) {
                    Graphics graphics = ((Image)bufferedImage).getGraphics();
                    try {
                        if (this._imageLabel != null) {
                            graphics.setColor(this._imageLabel.getBackground());
                            graphics.fillRect(0, 0, 64, 64);
                        }
                        graphics.drawImage(image, (64 - n3) / 2, 0, n3, 64, null);
                    }
                    finally {
                        graphics.dispose();
                    }
                }
                image = bufferedImage;
            } else if (n < 64 || n2 < 64) {
                BufferedImage bufferedImage = new BufferedImage(64, 64, 1);
                Graphics graphics = ((Image)bufferedImage).getGraphics();
                try {
                    if (this._imageLabel != null) {
                        graphics.setColor(this._imageLabel.getBackground());
                        graphics.fillRect(0, 0, 64, 64);
                    }
                    graphics.drawImage(image, (64 - n) / 2, (64 - n2) / 2, n, n2, null);
                }
                finally {
                    graphics.dispose();
                }
                image = bufferedImage;
            }
        }
        DownloadWindow downloadWindow = this;
        synchronized (downloadWindow) {
            if (this._appImage == null || bl) {
                this._appImage = image;
            }
        }
        if (this._imageLabel != null) {
            if (this._appImage != null) {
                this._imageLabel.setIcon(new ImageIcon(this._appImage));
            }
            this._imageLabel.repaint();
        }
    }

    private String bytesToString(long l) {
        String string = "";
        double d = l;
        int n = 0;
        if (l > 0x40000000L) {
            d /= 1.073741824E9;
            string = "G";
            n = 1;
        } else if (l > 0x100000L) {
            d /= 1048576.0;
            string = "M";
            n = 1;
        } else if (l > 1024L) {
            d /= 1024.0;
            string = "K";
            n = 0;
        }
        return ResourceManager.formatDouble((double)d, (int)n) + string;
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.cancelAction();
    }

    private void cancelAction() {
        if (this._exitOnCancel) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Main.systemExit(-1);
                    return null;
                }
            });
        } else {
            this._isCanceled = true;
        }
    }

    public boolean isCanceled() {
        return this._isCanceled;
    }

    public void resetCancled() {
        this._isCanceled = false;
    }

    public void setVisible(final boolean bl) {
        final JFrame jFrame = this._frame;
        if (jFrame != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    jFrame.setVisible(bl);
                }
            });
        }
    }

    class BLabel
    extends JLabel {
        int _w;
        int _h;

        public BLabel() {
            this._w = 0;
            this._h = 0;
            this.setOpaque(true);
            this.setForeground(UIManager.getColor("textText"));
        }

        public BLabel(String string, int n, int n2) {
            super(string);
            this._w = n;
            this._h = n2;
            this.setOpaque(true);
            this.setForeground(UIManager.getColor("textText"));
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (this._w > dimension.width) {
                dimension.width = this._w;
            }
            if (this._h > dimension.height) {
                dimension.height = this._h;
            }
            return dimension;
        }
    }
}

