/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.process.factory;

import com.clustercontrol.process.util.SnmpProcConnectionManager;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.snmppoller.SnmpSharedTable;
import com.clustercontrol.util.apllog.AplLogger;
import java.util.ArrayList;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ModifyPollingSchedule {
    protected static Log m_log = LogFactory.getLog(ModifyPollingSchedule.class);

    public boolean addSchedule(String parentFacilityId, int interval) {
        if (parentFacilityId != null && !"".equals(parentFacilityId)) {
            try {
                SnmpSharedTable sst = SnmpProcConnectionManager.getConnectionManager().getSnmpSharedTable();
                RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
                ArrayList facilityList = repository.getNodeFacilityIdList(parentFacilityId, 0);
                if (facilityList.size() == 0) {
                    facilityList.add(parentFacilityId);
                }
                String facilityId = null;
                for (int index = 0; index < facilityList.size(); ++index) {
                    facilityId = (String)facilityList.get(index);
                    if (facilityId == null || "".equals(facilityId)) continue;
                    sst.setPollingSchedule(facilityId, interval);
                }
                return true;
            }
            catch (CreateException e) {
                AplLogger apllog = new AplLogger("PROC", "proc");
                Object[] args = new String[]{parentFacilityId};
                apllog.put("SYS", "001", args);
                m_log.debug((Object)("addSchedule():" + e.getMessage()));
            }
            catch (FinderException e) {
                AplLogger apllog = new AplLogger("PROC", "proc");
                Object[] args = new String[]{parentFacilityId};
                apllog.put("SYS", "001", args);
                m_log.debug((Object)("addSchedule():" + e.getMessage()));
            }
            catch (NamingException e) {
                AplLogger apllog = new AplLogger("PROC", "proc");
                Object[] args = new String[]{parentFacilityId};
                apllog.put("SYS", "001", args);
                m_log.debug((Object)("addSchedule():" + e.getMessage()));
            }
        }
        return false;
    }
}

