/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.syslogng.dialog;

import com.clustercontrol.bean.FacilityInfo;
import com.clustercontrol.bean.FacilityPath;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ScopeTreeDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.notify.composite.NotifyInfoComposite;
import com.clustercontrol.syslogng.action.LogManager;
import com.clustercontrol.syslogng.bean.LogFilterInfo;
import com.clustercontrol.ui.ClusterControlUIPlugin;
import com.clustercontrol.util.Messages;
import java.util.Date;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LogCreateDialog
extends CommonDialog {
    private LogFilterInfo inputData = null;
    private ValidateResult validateResult = null;
    private String logId = null;
    private int order = Integer.MAX_VALUE;
    private String facilityId = null;
    private Text textDescription = null;
    private Text textScope = null;
    private Text textPattern = null;
    private Button radioNotProcessing = null;
    private Button radioProcessing = null;
    private NotifyInfoComposite notifyInfo = null;
    private Label labelPriority = null;
    private Combo comboPriority = null;
    private Label labelMonitorId = null;
    private Text textMonitorId = null;
    private Label labelMessageId = null;
    private Text textMessageId = null;
    private Label labelLogMessage = null;
    private Text textLogMessage = null;
    private Button confirmValid = null;
    private Date regDate = null;

    public LogCreateDialog(Shell parent) {
        super(parent);
    }

    public LogCreateDialog(Shell parent, String logId) {
        super(parent);
        this.logId = logId;
    }

    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString((String)"dialog.syslog-ng.create.modefy"));
        Label label = null;
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 15;
        parent.setLayout((Layout)layout);
        this.labelMonitorId = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.labelMonitorId.setLayoutData((Object)gridData);
        this.labelMonitorId.setText(String.valueOf(Messages.getString((String)"monitor.id")) + " : ");
        this.textMonitorId = new Text(parent, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 9;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.textMonitorId.setLayoutData((Object)gridData);
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"description")) + " : ");
        this.textDescription = new Text(parent, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 9;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.textDescription.setLayoutData((Object)gridData);
        this.labelMonitorId = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.labelMonitorId.setLayoutData((Object)gridData);
        this.labelMonitorId.setText(String.valueOf(Messages.getString((String)"monitor.rule")) + " : ");
        Group monitorRuleGroup1 = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 15;
        monitorRuleGroup1.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        monitorRuleGroup1.setLayoutData((Object)gridData);
        label = new Label((Composite)monitorRuleGroup1, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"scope")) + " : ");
        this.textScope = new Text((Composite)monitorRuleGroup1, 18440);
        gridData = new GridData();
        gridData.horizontalSpan = 9;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.textScope.setLayoutData((Object)gridData);
        Button button = new Button((Composite)monitorRuleGroup1, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)gridData);
        button.setText(Messages.getString((String)"refer"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScopeTreeDialog dialog = new ScopeTreeDialog(LogCreateDialog.this.getParentShell());
                if (dialog.open() == 0) {
                    FacilityTreeItem item = dialog.getSelectItem();
                    FacilityInfo info = item.getData();
                    LogCreateDialog.this.facilityId = info.getFacilityId();
                    if (info.getType() == 1) {
                        LogCreateDialog.this.textScope.setText(info.getFacilityName());
                    } else {
                        FacilityPath path = new FacilityPath(ClusterControlUIPlugin.getDefault().getSeparator());
                        LogCreateDialog.this.textScope.setText(path.getPath(item));
                    }
                }
            }
        });
        label = new Label((Composite)monitorRuleGroup1, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"pattern.matching.expression")) + " : ");
        this.textPattern = new Text((Composite)monitorRuleGroup1, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 9;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.textPattern.setLayoutData((Object)gridData);
        this.radioNotProcessing = new Button(parent, 16);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.radioNotProcessing.setLayoutData((Object)gridData);
        this.radioNotProcessing.setText(Messages.getString((String)"don't.process.if.matched"));
        this.radioProcessing = new Button(parent, 16);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.radioProcessing.setLayoutData((Object)gridData);
        this.radioProcessing.setText(Messages.getString((String)"process.if.matched"));
        this.radioProcessing.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogCreateDialog.this.setEnabledForOutputCondition(LogCreateDialog.this.radioProcessing.getSelection());
            }
        });
        Group group1 = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 15;
        group1.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        group1.setLayoutData((Object)gridData);
        this.notifyInfo = new NotifyInfoComposite((Composite)group1, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.notifyInfo.setLayoutData((Object)gridData);
        this.labelPriority = new Label((Composite)group1, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.labelPriority.setLayoutData((Object)gridData);
        this.labelPriority.setText(String.valueOf(Messages.getString((String)"priority")) + " : ");
        this.comboPriority = new Combo((Composite)group1, 12);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.comboPriority.setLayoutData((Object)gridData);
        this.comboPriority.add(PriorityConstant.STRING_CRITICAL);
        this.comboPriority.add(PriorityConstant.STRING_WARNING);
        this.comboPriority.add(PriorityConstant.STRING_INFO);
        this.comboPriority.add(PriorityConstant.STRING_UNKNOWN);
        this.comboPriority.setText(PriorityConstant.STRING_CRITICAL);
        label = new Label((Composite)group1, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 7;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.labelMessageId = new Label((Composite)group1, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.labelMessageId.setLayoutData((Object)gridData);
        this.labelMessageId.setText(String.valueOf(Messages.getString((String)"message.id")) + " : ");
        this.textMessageId = new Text((Composite)group1, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 10;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.textMessageId.setLayoutData((Object)gridData);
        this.labelLogMessage = new Label((Composite)group1, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.labelLogMessage.setLayoutData((Object)gridData);
        this.labelLogMessage.setText(String.valueOf(Messages.getString((String)"message")) + " : ");
        this.textLogMessage = new Text((Composite)group1, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 10;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.textLogMessage.setLayoutData((Object)gridData);
        this.confirmValid = new Button(parent, 32);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.confirmValid.setLayoutData((Object)gridData);
        this.confirmValid.setText(Messages.getString((String)"setting.valid.confirmed"));
        Label line = new Label(parent, 258);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 15;
        line.setLayoutData((Object)gridData);
        shell.pack();
        shell.setSize(new Point(550, shell.getSize().y));
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2, (display.getBounds().height - shell.getSize().y) / 2);
        LogFilterInfo log = LogManager.getInstance().get(this.logId);
        if (log == null) {
            log = new LogFilterInfo();
        }
        this.setInputData(log);
    }

    public LogFilterInfo getInputData() {
        return this.inputData;
    }

    protected void setInputData(LogFilterInfo log) {
        this.inputData = log;
        this.logId = log.getLogId();
        this.order = log.getOrderNo();
        this.facilityId = log.getFacilityId();
        if (log.getMonitorId() != null) {
            this.textMonitorId.setText(log.getMonitorId());
        }
        if (log.getDescription() != null) {
            this.textDescription.setText(log.getDescription());
        }
        if (log.getScope() != null) {
            this.textScope.setText(log.getScope());
        }
        if (log.getPattern() != null) {
            this.textPattern.setText(log.getPattern());
        }
        if (log.getProsessType() == 1) {
            this.radioProcessing.setSelection(true);
        } else {
            this.radioNotProcessing.setSelection(true);
        }
        if (log.getNotifyId() != null) {
            this.notifyInfo.setText(log.getNotifyId());
        }
        this.comboPriority.setText(PriorityConstant.typeToString((int)log.getPriority()));
        if (log.getApplication() != null) {
            this.notifyInfo.setApplication(log.getApplication());
        }
        if (log.getMessageId() != null) {
            this.textMessageId.setText(log.getMessageId());
        }
        if (log.getMessage() != null) {
            this.textLogMessage.setText(log.getMessage());
        }
        if (log.isValidFlg()) {
            this.confirmValid.setSelection(true);
        }
        this.regDate = log.getRegDate();
        this.setEnabledForOutputCondition(this.radioProcessing.getSelection());
    }

    protected LogFilterInfo createInputData() {
        LogFilterInfo log = new LogFilterInfo();
        log.setLogId(this.logId);
        log.setOrderNo(this.order);
        log.setFacilityId(this.facilityId);
        if (this.textMonitorId.getText() != null && !"".equals(this.textMonitorId.getText().trim())) {
            log.setMonitorId(this.textMonitorId.getText());
        } else if (this.radioProcessing.getSelection()) {
            this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.syslogng.13"));
            return null;
        }
        if (this.textDescription.getText() == null || "".equals(this.textDescription.getText().trim())) {
            this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.syslogng.10"));
            return null;
        }
        log.setDescription(this.textDescription.getText());
        if (this.textScope.getText() == null || "".equals(this.textScope.getText().trim())) {
            this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.hinemos.3"));
            return null;
        }
        log.setScope(this.textScope.getText());
        if (this.textPattern.getText() != null && !"".equals(this.textPattern.getText().trim())) {
            try {
                Pattern.compile(this.textPattern.getText());
                log.setPattern(this.textPattern.getText());
            }
            catch (PatternSyntaxException patternSyntaxException) {
                this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.syslogng.12"));
                return null;
            }
        } else {
            this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.syslogng.12"));
            return null;
        }
        if (this.radioProcessing.getSelection()) {
            log.setProsessType(1);
        } else {
            log.setProsessType(0);
        }
        String priorityText = this.comboPriority.getText();
        log.setPriority(PriorityConstant.stringToType((String)priorityText));
        String notifyId = this.notifyInfo.getText();
        if (notifyId != null && !"".equals(notifyId.trim())) {
            log.setNotifyId(notifyId);
        }
        if (this.notifyInfo.getApplication() != null && !"".equals(this.notifyInfo.getApplication().trim())) {
            log.setApplication(this.notifyInfo.getApplication());
        } else if (this.radioProcessing.getSelection() && notifyId != null && !"".equals(notifyId.trim())) {
            this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.syslogng.14"));
            return null;
        }
        if (this.textMessageId.getText() != null && !"".equals(this.textMessageId.getText().trim())) {
            log.setMessageId(this.textMessageId.getText());
        } else if (this.radioProcessing.getSelection() && notifyId != null && !"".equals(notifyId.trim())) {
            this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.syslogng.15"));
            return null;
        }
        if (this.textLogMessage.getText() != null && !"".equals(this.textLogMessage.getText().trim())) {
            log.setMessage(this.textLogMessage.getText());
        } else if (this.radioProcessing.getSelection() && notifyId != null && !"".equals(notifyId.trim())) {
            this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.syslogng.16"));
            return null;
        }
        if (this.confirmValid.getSelection()) {
            log.setValidFlg(true);
        } else {
            log.setValidFlg(false);
        }
        log.setRegDate(this.regDate);
        return log;
    }

    protected ValidateResult validate() {
        this.inputData = this.createInputData();
        if (this.inputData != null) {
            return super.validate();
        }
        return this.validateResult;
    }

    protected String getOkButtonText() {
        return Messages.getString((String)"ok");
    }

    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }

    private void setEnabledForOutputCondition(boolean enable) {
        this.comboPriority.setEnabled(enable);
        this.notifyInfo.setEnabled(enable);
        this.textMessageId.setEnabled(enable);
        this.textLogMessage.setEnabled(enable);
    }

    private void setValidateResult(String id, String message) {
        this.validateResult = new ValidateResult();
        this.validateResult.setValid(false);
        this.validateResult.setID(id);
        this.validateResult.setMessage(message);
    }
}

