/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.dao;

import com.clustercontrol.jobmanagement.dao.JobStartJobMasterDAO;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartJobMasterBean;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartJobMasterPK;
import com.clustercontrol.jobmanagement.util.ConnectionManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobStartJobMasterDAOImpl
implements JobStartJobMasterDAO {
    protected static Log m_log = LogFactory.getLog(JobStartJobMasterDAOImpl.class);

    public void init() {
    }

    public void load(JobStartJobMasterPK pk, JobStartJobMasterBean ejb) throws EJBException {
        block13: {
            m_log.debug((Object)("load() start : " + pk.toString()));
            Connection conn = null;
            Statement stmt = null;
            ResultSet res = null;
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM cc_job_start_job_mst WHERE job_id = ? AND target_job_id = ? AND target_job_end_status = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.getJob_id());
                stmt.setString(2, pk.getTarget_job_id());
                stmt.setInt(3, pk.getTarget_job_end_status());
                res = stmt.executeQuery();
                if (res.next()) {
                    ejb.setJob_id(res.getString("job_id"));
                    ejb.setTarget_job_end_status(res.getInt("target_job_end_status"));
                    ejb.setTarget_job_id(res.getString("target_job_id"));
                    break block13;
                }
                String msg = "JobStartJobMaster data is not found.";
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + msg));
                throw new EJBException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (res != null) {
                        res.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e1) {
                    m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + e1.getMessage()));
                    throw new EJBException(e1.getMessage());
                }
            }
        }
        m_log.debug((Object)("load() end : " + pk.toString()));
    }

    public void store(JobStartJobMasterBean ejb) throws EJBException {
        m_log.debug((Object)("store() start : " + ejb.getJob_id() + ", " + ejb.getTarget_job_id() + ", " + ejb.getTarget_job_end_status()));
        m_log.debug((Object)("store() end : " + ejb.getJob_id() + ", " + ejb.getTarget_job_id() + ", " + ejb.getTarget_job_end_status()));
    }

    public void remove(JobStartJobMasterPK pk) throws RemoveException, EJBException {
        m_log.debug((Object)("remove() start : " + pk.toString()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "DELETE FROM cc_job_start_job_mst WHERE job_id = ? AND target_job_id = ? AND target_job_end_status = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.getJob_id());
            stmt.setString(2, pk.getTarget_job_id());
            stmt.setInt(3, pk.getTarget_job_end_status());
            int row = stmt.executeUpdate();
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException" + msg));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("remove() end : " + pk.toString()));
    }

    public JobStartJobMasterPK create(JobStartJobMasterBean ejb) throws CreateException, EJBException {
        JobStartJobMasterPK pk;
        m_log.debug((Object)("create() start : " + ejb.getJob_id() + ", " + ejb.getTarget_job_id() + ", " + ejb.getTarget_job_end_status()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            StringBuilder sql = new StringBuilder();
            sql.append("INSERT INTO cc_job_start_job_mst (");
            sql.append("job_id, ");
            sql.append("target_job_id, ");
            sql.append("target_job_end_status) ");
            sql.append("VALUES (?,?,?)");
            stmt = conn.prepareStatement(sql.toString());
            stmt.setString(1, ejb.getJob_id());
            stmt.setString(2, ejb.getTarget_job_id());
            stmt.setInt(3, ejb.getTarget_job_end_status());
            int row = stmt.executeUpdate();
            pk = new JobStartJobMasterPK(ejb.getJob_id(), ejb.getTarget_job_id(), ejb.getTarget_job_end_status());
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("create() error : " + ejb.getJob_id() + ", " + ejb.getTarget_job_id() + ", " + ejb.getTarget_job_end_status() + " SQLException"));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            if (e.getSQLState().equals("23505")) {
                m_log.error((Object)("create() error : " + ejb.getJob_id() + ", " + ejb.getTarget_job_id() + ", " + ejb.getTarget_job_end_status() + " SQLException" + "DuplicateKeyException "));
                throw new DuplicateKeyException(e.getMessage());
            }
            throw new CreateException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("create() error : " + ejb.getJob_id() + ", " + ejb.getTarget_job_id() + ", " + ejb.getTarget_job_end_status() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("create() end : " + ejb.getJob_id() + ", " + ejb.getTarget_job_id() + ", " + ejb.getTarget_job_end_status()));
        return pk;
    }

    public Collection findAll() throws FinderException {
        m_log.debug((Object)"findAll() start : ");
        ArrayList<JobStartJobMasterPK> ret = new ArrayList<JobStartJobMasterPK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_job_start_job_mst";
            stmt = conn.prepareStatement(sql);
            res = stmt.executeQuery();
            while (res.next()) {
                JobStartJobMasterPK pk = new JobStartJobMasterPK(res.getString("job_id"), res.getString("target_job_id"), res.getInt("target_job_end_status"));
                ret.add(pk);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)"findAll() error :  SQLException");
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)"findAll() end : ");
        return ret;
    }

    public JobStartJobMasterPK findByPrimaryKey(JobStartJobMasterPK pk) throws FinderException {
        ResultSet res;
        PreparedStatement stmt;
        Connection conn;
        block14: {
            m_log.debug((Object)("findByPrimaryKey() start : " + pk.toString()));
            conn = null;
            stmt = null;
            res = null;
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_job_start_job_mst WHERE job_id = ? AND target_job_id = ? AND target_job_end_status = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.getJob_id());
            stmt.setString(2, pk.getTarget_job_id());
            stmt.setInt(3, pk.getTarget_job_end_status());
            res = stmt.executeQuery();
            if (!res.next()) break block14;
            JobStartJobMasterPK jobStartJobMasterPK = pk;
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            return jobStartJobMasterPK;
        }
        try {
            try {
                String msg = "id " + pk.toString() + " not found.";
                throw new FinderException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            throw throwable;
        }
    }

    public Collection findByJobId(String job_id) throws FinderException {
        m_log.debug((Object)("findByJobId() start : " + job_id));
        ArrayList<JobStartJobMasterPK> ret = new ArrayList<JobStartJobMasterPK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_job_start_job_mst WHERE job_id = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, job_id);
            res = stmt.executeQuery();
            while (res.next()) {
                JobStartJobMasterPK pk = new JobStartJobMasterPK(res.getString("job_id"), res.getString("target_job_id"), res.getInt("target_job_end_status"));
                ret.add(pk);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("findByJobId() error : " + job_id + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("findByJobId() error : " + job_id + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("findByJobId() end : " + job_id));
        return ret;
    }
}

