/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.dao;

import com.clustercontrol.jobmanagement.dao.JobStartInfoDAO;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartInfoBean;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartInfoPK;
import com.clustercontrol.jobmanagement.util.ConnectionManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobStartInfoDAOImpl
implements JobStartInfoDAO {
    protected static Log m_log = LogFactory.getLog(JobStartInfoDAOImpl.class);

    public void init() {
    }

    public void load(JobStartInfoPK pk, JobStartInfoBean ejb) throws EJBException {
        block13: {
            m_log.debug((Object)("load() start : " + pk.toString()));
            Connection conn = null;
            Statement stmt = null;
            ResultSet res = null;
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM cc_job_start_info WHERE session_id = ? AND job_id = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.getSession_id());
                stmt.setString(2, pk.getJob_id());
                res = stmt.executeQuery();
                if (res.next()) {
                    ejb.setCalendar(res.getInt("calendar"));
                    ejb.setCalendar_end_value(res.getInt("calendar_end_value"));
                    ejb.setCalendar_id(res.getString("calendar_id"));
                    ejb.setCondition_type(res.getInt("condition_type"));
                    ejb.setJob_id(res.getString("job_id"));
                    ejb.setSession_id(res.getString("session_id"));
                    ejb.setSkip(res.getInt("skip"));
                    ejb.setSkip_end_status(res.getInt("skip_end_status"));
                    ejb.setSkip_end_value(res.getInt("skip_end_value"));
                    ejb.setSuspend(res.getInt("suspend"));
                    ejb.setUnmatch_end_flg(res.getInt("unmatch_end_flg"));
                    ejb.setUnmatch_end_status(res.getInt("unmatch_end_status"));
                    ejb.setUnmatch_end_value(res.getInt("unmatch_end_value"));
                    break block13;
                }
                String msg = "JobStartInfo data is not found.";
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + msg));
                throw new EJBException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (res != null) {
                        res.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e1) {
                    m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + e1.getMessage()));
                    throw new EJBException(e1.getMessage());
                }
            }
        }
        m_log.debug((Object)("load() end : " + pk.toString()));
    }

    public void store(JobStartInfoBean ejb) throws EJBException {
        m_log.debug((Object)("store() start : " + ejb.getSession_id() + ", " + ejb.getJob_id()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            StringBuilder sql = new StringBuilder();
            sql.append("UPDATE cc_job_start_info SET ");
            sql.append("condition_type = ?, ");
            sql.append("suspend = ?, ");
            sql.append("skip = ?, ");
            sql.append("skip_end_status = ?, ");
            sql.append("skip_end_value = ?, ");
            sql.append("unmatch_end_flg = ?, ");
            sql.append("unmatch_end_status = ?, ");
            sql.append("unmatch_end_value = ?, ");
            sql.append("calendar = ?, ");
            sql.append("calendar_id = ?, ");
            sql.append("calendar_end_value = ? ");
            sql.append("WHERE session_id = ? AND ");
            sql.append("job_id = ?");
            stmt = conn.prepareStatement(sql.toString());
            stmt.setInt(1, ejb.getCondition_type());
            stmt.setInt(2, ejb.getSuspend());
            stmt.setInt(3, ejb.getSkip());
            stmt.setInt(4, ejb.getSkip_end_status());
            stmt.setInt(5, ejb.getSkip_end_value());
            stmt.setInt(6, ejb.getUnmatch_end_flg());
            stmt.setInt(7, ejb.getUnmatch_end_status());
            stmt.setInt(8, ejb.getUnmatch_end_value());
            stmt.setInt(9, ejb.getCalendar());
            stmt.setString(10, ejb.getCalendar_id());
            stmt.setInt(11, ejb.getCalendar_end_value());
            stmt.setString(12, ejb.getSession_id());
            stmt.setString(13, ejb.getJob_id());
            int row = stmt.executeUpdate();
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("store() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + " SQLException" + msg));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("store() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("store() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("store() end : " + ejb.getSession_id() + ", " + ejb.getJob_id()));
    }

    public void remove(JobStartInfoPK pk) throws RemoveException, EJBException {
        m_log.debug((Object)("remove() start : " + pk.toString()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "DELETE FROM cc_job_start_info WHERE session_id = ? AND job_id = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.getSession_id());
            stmt.setString(2, pk.getJob_id());
            int row = stmt.executeUpdate();
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException" + msg));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("remove() end : " + pk.toString()));
    }

    public JobStartInfoPK create(JobStartInfoBean ejb) throws CreateException, EJBException {
        JobStartInfoPK pk;
        m_log.debug((Object)("create() start : " + ejb.getSession_id() + ", " + ejb.getJob_id()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            StringBuilder sql = new StringBuilder();
            sql.append("INSERT INTO cc_job_start_info (");
            sql.append("session_id, ");
            sql.append("job_id, ");
            sql.append("condition_type, ");
            sql.append("suspend, ");
            sql.append("skip, ");
            sql.append("skip_end_status, ");
            sql.append("skip_end_value, ");
            sql.append("unmatch_end_flg, ");
            sql.append("unmatch_end_status, ");
            sql.append("unmatch_end_value, ");
            sql.append("calendar, ");
            sql.append("calendar_id, ");
            sql.append("calendar_end_value) ");
            sql.append("VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)");
            stmt = conn.prepareStatement(sql.toString());
            stmt.setString(1, ejb.getSession_id());
            stmt.setString(2, ejb.getJob_id());
            stmt.setInt(3, ejb.getCondition_type());
            stmt.setInt(4, ejb.getSuspend());
            stmt.setInt(5, ejb.getSkip());
            stmt.setInt(6, ejb.getSkip_end_status());
            stmt.setInt(7, ejb.getSkip_end_value());
            stmt.setInt(8, ejb.getUnmatch_end_flg());
            stmt.setInt(9, ejb.getUnmatch_end_status());
            stmt.setInt(10, ejb.getUnmatch_end_value());
            stmt.setInt(11, ejb.getCalendar());
            stmt.setString(12, ejb.getCalendar_id());
            stmt.setInt(13, ejb.getCalendar_end_value());
            int row = stmt.executeUpdate();
            pk = new JobStartInfoPK(ejb.getSession_id(), ejb.getJob_id());
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + " SQLException"));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            if (e.getSQLState().equals("23505")) {
                m_log.error((Object)("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + " SQLException" + "DuplicateKeyException "));
                throw new DuplicateKeyException(e.getMessage());
            }
            throw new CreateException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("create() end : " + ejb.getSession_id() + ", " + ejb.getJob_id()));
        return pk;
    }

    public Collection findAll() throws FinderException {
        m_log.debug((Object)"findAll() start : ");
        ArrayList<JobStartInfoPK> ret = new ArrayList<JobStartInfoPK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_job_start_info";
            stmt = conn.prepareStatement(sql);
            res = stmt.executeQuery();
            while (res.next()) {
                JobStartInfoPK pk = new JobStartInfoPK(res.getString("session_id"), res.getString("job_id"));
                ret.add(pk);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)"findAll() error :  SQLException");
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)"findAll() end : ");
        return ret;
    }

    public JobStartInfoPK findByPrimaryKey(JobStartInfoPK pk) throws FinderException {
        ResultSet res;
        PreparedStatement stmt;
        Connection conn;
        block14: {
            m_log.debug((Object)("findByPrimaryKey() start : " + pk.toString()));
            conn = null;
            stmt = null;
            res = null;
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_job_start_info WHERE session_id = ? AND job_id = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.getSession_id());
            stmt.setString(2, pk.getJob_id());
            res = stmt.executeQuery();
            if (!res.next()) break block14;
            JobStartInfoPK jobStartInfoPK = pk;
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            return jobStartInfoPK;
        }
        try {
            try {
                String msg = "id " + pk.toString() + " not found.";
                throw new FinderException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void makeSession(String sessionId, Collection jobs) throws CreateException {
        m_log.debug((Object)("makeSession() start : " + sessionId));
        Connection conn = null;
        Connection conn_mst = null;
        Statement stmt = null;
        Statement stmt_mst = null;
        String jobId = null;
        String parentJobId = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                conn_mst = ConnectionManager.getConnectionManager().getConnection();
                StringBuilder sql = new StringBuilder();
                sql.append("INSERT INTO cc_job_start_info (");
                sql.append("session_id, ");
                sql.append("job_id, ");
                sql.append("condition_type, ");
                sql.append("suspend, ");
                sql.append("skip, ");
                sql.append("skip_end_status, ");
                sql.append("skip_end_value, ");
                sql.append("unmatch_end_flg, ");
                sql.append("unmatch_end_status, ");
                sql.append("unmatch_end_value, ");
                sql.append("calendar, ");
                sql.append("calendar_id, ");
                sql.append("calendar_end_value) ");
                sql.append("VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)");
                StringBuilder sql_mst = new StringBuilder();
                sql_mst.append("SELECT ");
                sql_mst.append("cc_job_mst.job_type, ");
                sql_mst.append("cc_job_start_mst.job_id,");
                sql_mst.append("cc_job_start_mst.condition_type, ");
                sql_mst.append("cc_job_start_mst.suspend, ");
                sql_mst.append("cc_job_start_mst.skip,");
                sql_mst.append("cc_job_start_mst.skip_end_status,");
                sql_mst.append("cc_job_start_mst.skip_end_value, ");
                sql_mst.append("cc_job_start_mst.unmatch_end_flg, ");
                sql_mst.append("cc_job_start_mst.unmatch_end_status, ");
                sql_mst.append("cc_job_start_mst.unmatch_end_value, ");
                sql_mst.append("cc_job_start_mst.calendar, ");
                sql_mst.append("cc_job_start_mst.calendar_id, ");
                sql_mst.append("cc_job_start_mst.calendar_end_value ");
                sql_mst.append("FROM cc_job_mst, cc_job_start_mst ");
                sql_mst.append("WHERE ");
                sql_mst.append("(cc_job_mst.job_id=cc_job_start_mst.job_id ");
                sql_mst.append("AND cc_job_mst.job_id=");
                sql_mst.append(" ? )");
                stmt_mst = conn_mst.prepareStatement(sql_mst.toString());
                stmt = conn.prepareStatement(sql.toString());
                stmt.setString(1, sessionId);
                ResultSet res_mst = null;
                Iterator it = jobs.iterator();
                Hashtable ht = null;
                while (it.hasNext()) {
                    ht = (Hashtable)it.next();
                    jobId = (String)ht.get("jobId");
                    parentJobId = (String)ht.get("parentJobId");
                    stmt_mst.setString(1, jobId);
                    res_mst = stmt_mst.executeQuery();
                    if (res_mst != null && res_mst.next() && parentJobId.compareTo("TOP") != 0 && (res_mst.getInt("job_type") == 1 || res_mst.getInt("job_type") == 2 || res_mst.getInt("job_type") == 3)) {
                        stmt.setString(2, res_mst.getString("job_id"));
                        stmt.setInt(3, res_mst.getInt("condition_type"));
                        stmt.setInt(4, res_mst.getInt("suspend"));
                        stmt.setInt(5, res_mst.getInt("skip"));
                        stmt.setInt(6, res_mst.getInt("skip_end_status"));
                        stmt.setInt(7, res_mst.getInt("skip_end_value"));
                        stmt.setInt(8, res_mst.getInt("unmatch_end_flg"));
                        stmt.setInt(9, res_mst.getInt("unmatch_end_status"));
                        stmt.setInt(10, res_mst.getInt("unmatch_end_value"));
                        stmt.setInt(11, res_mst.getInt("calendar"));
                        stmt.setString(12, res_mst.getString("calendar_id"));
                        stmt.setInt(13, res_mst.getInt("calendar_end_value"));
                        int row = stmt.executeUpdate();
                        if (row != 1) {
                            String msg = "result row is not 1";
                            m_log.error((Object)("makeSession() error : " + sessionId + ", " + res_mst.getString("job_id") + " SQLException"));
                            throw new EJBException(msg);
                        }
                    }
                    res_mst.close();
                }
                Object var17_17 = null;
            }
            catch (SQLException e) {
                if (!e.getSQLState().equals("23505")) throw new CreateException(e.getMessage());
                m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException" + "DuplicateKeyException "));
                throw new DuplicateKeyException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
                if (stmt_mst != null) {
                    stmt_mst.close();
                }
                if (conn_mst == null) throw throwable;
                conn_mst.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        if (stmt_mst != null) {
            stmt_mst.close();
        }
        if (conn_mst != null) {
            conn_mst.close();
        }
        m_log.debug((Object)("makeSession() end : " + sessionId));
    }
}

