/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.ping.util;

import com.clustercontrol.util.Messages;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReachAddress {
    protected static Log m_log = LogFactory.getLog(ReachAddress.class);
    private int m_sentCount = 1;
    private int m_sentInterval = 1000;
    private int m_timeout = 1000;
    private String m_message = null;
    private String m_messageOrg = null;
    private int m_reachRatio = 0;
    private int m_lost = 0;
    private long m_average = 0L;
    private static Object m_syncObj = new Object();

    public ReachAddress(int sentNum, int sentInterval, int timeout) {
        this.m_sentCount = sentNum;
        this.m_sentInterval = sentInterval;
        this.m_timeout = timeout;
    }

    public boolean isReachable(String ipNetworkNumber, String nodeName) {
        String addressText = null;
        if (ipNetworkNumber != null && !"".equals(ipNetworkNumber)) {
            addressText = ipNetworkNumber;
        } else if (nodeName != null && !"".equals(nodeName)) {
            addressText = nodeName;
        } else {
            m_log.debug((Object)("isReachable(): " + Messages.getString((String)"message.ping.14")));
            this.m_message = Messages.getString((String)"message.ping.14");
            this.m_messageOrg = null;
            return false;
        }
        boolean result = this.isReachable(addressText);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReachable(String addressText) {
        this.m_message = null;
        this.m_messageOrg = null;
        this.m_reachRatio = 0;
        this.m_lost = 0;
        this.m_average = 0L;
        try {
            int i;
            long max = 0L;
            long min = 0L;
            long sum = 0L;
            int num = 0;
            StringBuffer buffer = new StringBuffer();
            InetAddress address = InetAddress.getByName(addressText);
            buffer.append("Pinging " + address.getHostName() + " [" + address.getHostAddress() + "].\n\n");
            for (i = 0; i < this.m_sentCount; ++i) {
                boolean isReachable;
                long start = System.currentTimeMillis();
                Object object = m_syncObj;
                synchronized (object) {
                    isReachable = address.isReachable(this.m_timeout);
                }
                long end = System.currentTimeMillis();
                long time = end - start;
                if (isReachable) {
                    buffer.append("Reply from " + address.getHostAddress() + ": ");
                    sum += time;
                    if (i == 0) {
                        max = time;
                        min = time;
                    } else if (time > max) {
                        max = time;
                    } else if (time < min) {
                        min = time;
                    }
                    ++num;
                    if (time > 0L) {
                        buffer.append("time=" + time + "ms\n");
                    } else {
                        buffer.append("time<1ms\n");
                    }
                } else if (time >= (long)this.m_timeout) {
                    buffer.append("Request timed out.\n");
                } else {
                    buffer.append("Reply from " + address.getHostAddress() + ": Destination net unreachable.\n");
                }
                if (i >= this.m_sentCount - 1) continue;
                try {
                    Thread.sleep(this.m_sentInterval);
                    continue;
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            buffer.append("\nPing statistics for " + address.getHostAddress() + ":\n");
            this.m_lost = num == 0 ? 100 : (i - num) * 100 / i;
            this.m_reachRatio = num * 100 / i;
            this.m_message = "Packets: Sent = " + i + ", Received = " + num + ", Lost = " + (i - num) + " (" + this.m_lost + "% loss),";
            buffer.append("\t" + this.m_message + "\n");
            if (num != 0) {
                buffer.append("Approximate round trip times in milli-seconds:\n");
                this.m_average = num != 0 ? sum / (long)num : 0L;
                buffer.append("\tMinimum = " + min + "ms, Maximum = " + max + "ms, Average = " + this.m_average + "ms\n");
            }
            this.m_messageOrg = buffer.toString();
            return true;
        }
        catch (UnknownHostException e) {
            m_log.debug((Object)("isReachable(): " + Messages.getString((String)"message.ping.15") + e.getMessage()));
            this.m_message = Messages.getString((String)"message.ping.15") + " (" + e.getMessage() + ")";
        }
        catch (IOException e) {
            m_log.debug((Object)("isReachable(): " + Messages.getString((String)"message.ping.15") + e.getMessage()));
            this.m_message = Messages.getString((String)"message.ping.15") + " (" + e.getMessage() + ")";
        }
        return false;
    }

    public String getMessage() {
        return this.m_message;
    }

    public String getMessageOrg() {
        return this.m_messageOrg;
    }

    public int getReachRatio() {
        return this.m_reachRatio;
    }

    public int getLost() {
        return this.m_lost;
    }

    public long getAverage() {
        return this.m_average;
    }
}

