/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.ping.factory;

import com.clustercontrol.monitor.run.factory.RunMonitorNumericValueType;
import com.clustercontrol.ping.ejb.entity.MonitorPingInfoLocal;
import com.clustercontrol.ping.ejb.entity.MonitorPingInfoPK;
import com.clustercontrol.ping.ejb.entity.MonitorPingInfoUtil;
import com.clustercontrol.ping.util.ReachAddress;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RunMonitorPing
extends RunMonitorNumericValueType {
    protected static Log m_log = LogFactory.getLog(RunMonitorPing.class);
    public static final String MESSAGE_ID_INFO = "001";
    public static final String MESSAGE_ID_WARNING = "002";
    public static final String MESSAGE_ID_CRITICAL = "003";
    public static final String MESSAGE_ID_UNKNOWN = "004";
    protected static final ArrayList<String> m_attributeList = new ArrayList();
    protected MonitorPingInfoLocal m_ping = null;
    protected ReachAddress m_reachability = null;
    protected int m_runCount = 1;
    protected int m_runInterval = 1000;
    protected int m_timeout;
    protected String m_message = null;
    protected String m_unKnownMessage = null;
    protected String m_messageOrg = null;
    protected int m_lost = 0;
    protected long m_average = 0L;

    public boolean collect(String facilityId) {
        this.m_nodeDate = this.m_now.getTime();
        this.m_message = "";
        this.m_messageOrg = "";
        this.m_lost = 0;
        this.m_average = 0L;
        if (this.m_reachability == null) {
            this.m_reachability = new ReachAddress(this.m_runCount, this.m_runInterval, this.m_timeout);
        }
        try {
            HashMap facilityAttrMap = this.m_repository.getNodeDetail(facilityId, m_attributeList);
            String ipNetworkNumber = (String)facilityAttrMap.get("ipNetworkNumber");
            String nodeName = (String)facilityAttrMap.get("ccNodeName");
            boolean result = this.m_reachability.isReachable(ipNetworkNumber, nodeName);
            this.m_message = this.m_reachability.getMessage();
            this.m_messageOrg = this.m_reachability.getMessageOrg();
            if (result) {
                this.m_lost = this.m_reachability.getLost();
                this.m_average = this.m_reachability.getAverage();
            }
            return result;
        }
        catch (FinderException e) {
            m_log.debug((Object)("run():" + e.getMessage()));
            this.m_message = Messages.getString((String)"message.ping.13") + " (" + e.getMessage() + ")";
            return false;
        }
        catch (NamingException e) {
            m_log.debug((Object)("run():" + e.getMessage()));
            this.m_message = Messages.getString((String)"message.ping.13") + " (" + e.getMessage() + ")";
            return false;
        }
    }

    public void setCheckInfo() throws FinderException, NamingException {
        MonitorPingInfoPK pk = new MonitorPingInfoPK(this.m_monitorId, this.m_monitorTypeId);
        this.m_ping = MonitorPingInfoUtil.getLocalHome().findByPrimaryKey(pk);
        if (this.m_ping.getRunCount() != null) {
            this.m_runCount = this.m_ping.getRunCount();
        }
        if (this.m_ping.getRunInterval() != null) {
            this.m_runInterval = this.m_ping.getRunInterval();
        }
        if (this.m_ping.getTimeout() != null) {
            this.m_timeout = this.m_ping.getTimeout();
        }
    }

    public int getPriority(boolean result) {
        int priority = -1;
        priority = result ? ((float)this.m_lost <= this.m_infoLowerLimit && (float)this.m_average <= this.m_infoUpperLimit ? 3 : ((float)this.m_lost <= this.m_warnLowerLimit && (float)this.m_average <= this.m_warnUpperLimit ? 2 : 0)) : this.m_failurePriority;
        return priority;
    }

    public String getMessageId(int result) {
        if (result == 3) {
            return MESSAGE_ID_INFO;
        }
        if (result == 2) {
            return MESSAGE_ID_WARNING;
        }
        if (result == 0) {
            return MESSAGE_ID_CRITICAL;
        }
        return MESSAGE_ID_UNKNOWN;
    }

    public String getMessage(int result) {
        return this.m_message;
    }

    public String getMessageOrg(int result) {
        return this.m_messageOrg;
    }

    static {
        m_attributeList.add("ccNodeName");
        m_attributeList.add("ipNetworkNumber");
        m_attributeList.add("ccIpNetworkNumberV6");
    }
}

