/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.factory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.notify.bean.NotifyEventInfo;
import com.clustercontrol.notify.bean.NotifyInfo;
import com.clustercontrol.notify.bean.NotifyInfoContext;
import com.clustercontrol.notify.ejb.entity.NotifyEventInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyEventInfoUtil;
import com.clustercontrol.notify.ejb.entity.NotifyInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyInfoUtil;
import com.clustercontrol.notify.util.SendQueue;
import com.clustercontrol.util.apllog.AplLogger;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.ejb.CreateException;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AddNotify {
    protected static Log m_log = LogFactory.getLog(AddNotify.class);

    public boolean add(NotifyInfo info) throws CreateException, NamingException, JMSException {
        AccessLock.lock((String)"NOTIFY");
        SendQueue queue = null;
        try {
            Timestamp now = new Timestamp(new Date().getTime());
            NotifyInfoLocal notify = NotifyInfoUtil.getLocalHome().create(info.getNotifyId(), info.getDescription(), info.getStatusFlg(), info.getStatusValidPeriod(), info.getStatusInvalidFlg(), info.getStatusUpdatePriority(), info.getEventFlg(), info.getInhibitionFlg(), info.getInhibitionFrequency(), info.getInhibitionPeriod(), now, now);
            Collection ct = notify.getNotifyEventInfo();
            ArrayList eventList = info.getNotifyEventInfo();
            ArrayList<NotifyEventInfoLocal> eventLocalList = new ArrayList<NotifyEventInfoLocal>();
            NotifyEventInfo event = null;
            for (int index = 0; index < eventList.size(); ++index) {
                event = (NotifyEventInfo)eventList.get(index);
                if (event == null) continue;
                NotifyEventInfoLocal local = NotifyEventInfoUtil.getLocalHome().create(info.getNotifyId(), event.getPriority(), event.getEventNormalFlg(), event.getEventNormalState(), event.getEventInhibitionFlg(), event.getEventInhibitionState(), event.getMailFlg(), event.getMailAddress());
                eventLocalList.add(local);
            }
            if (eventLocalList != null) {
                ct.addAll(eventLocalList);
                notify.setNotifyEventInfo(ct);
            }
            NotifyInfoContext context = new NotifyInfoContext(0, info.getNotifyId(), info);
            queue = new SendQueue("queue/clustercontrol/Moniter/EventLog");
            queue.put((Serializable)context);
            queue.terminate();
        }
        catch (CreateException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            Object[] args = new String[]{info.getNotifyId()};
            apllog.put("SYS", "001", args);
            m_log.debug((Object)("add():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            Object[] args = new String[]{info.getNotifyId()};
            apllog.put("SYS", "001", args);
            m_log.debug((Object)("add():" + e.getMessage()));
            throw e;
        }
        catch (JMSException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            Object[] args = new String[]{info.getNotifyId()};
            apllog.put("SYS", "001", args);
            m_log.debug((Object)("add():" + e.getMessage()));
            throw e;
        }
        finally {
            if (queue != null) {
                queue.terminate();
            }
        }
        return true;
    }
}

