/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.accesscontrol.factory;

import com.clustercontrol.accesscontrol.bean.RoleConstant;
import com.clustercontrol.accesscontrol.ejb.entity.RoleLocal;
import com.clustercontrol.accesscontrol.ejb.entity.RoleUtil;
import com.clustercontrol.accesscontrol.ejb.entity.UserLocal;
import com.clustercontrol.accesscontrol.ejb.entity.UserUtil;
import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.bean.Property;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.util.apllog.AplLogger;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ModifyUser {
    protected static Log m_log = LogFactory.getLog(ModifyUser.class);

    public void addUser(Property property, String userName) throws NamingException, CreateException, FinderException, ParseException {
        AccessLock.lock("ACCESS");
        String uid = null;
        try {
            ArrayList values = null;
            Date now = new Date();
            values = PropertyUtil.getPropertyValue((Property)property, (String)"uid");
            uid = (String)values.get(0);
            this.checkValidUid(uid);
            UserLocal user = UserUtil.getLocalHome().create(uid);
            values = PropertyUtil.getPropertyValue((Property)property, (String)"namae");
            user.setCn(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"description");
            user.setDescription(this.checkString(values.get(0)));
            user.setCreatorsName(this.checkString(userName));
            user.setCreateTimestamp(now);
            user.setModifiersName(this.checkString(userName));
            user.setModifyTimestamp(now);
            this.assignUser("HinemosUser", user.getDn());
            List<String> roleList = RoleConstant.getRoles();
            for (int i = 0; i < roleList.size(); ++i) {
                String roleName = roleList.get(i);
                values = PropertyUtil.getPropertyValue((Property)property, (String)roleName);
                if (values.size() <= 0 || !((Boolean)values.get(0)).booleanValue()) continue;
                this.assignUser(roleName, user.getDn());
            }
        }
        catch (EJBException e) {
            AplLogger apllog = new AplLogger("ACC", "acc");
            Object[] args = new String[]{uid};
            apllog.put("SYS", "006", args);
            m_log.debug((Object)("addUser() : " + e.getMessage()));
            throw e;
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("ACC", "acc");
            Object[] args = new String[]{uid};
            apllog.put("SYS", "006", args);
            m_log.debug((Object)("addUser() : " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("ACC", "acc");
            Object[] args = new String[]{uid};
            apllog.put("SYS", "006", args);
            m_log.debug((Object)("addUser() : " + e.getMessage()));
            throw e;
        }
    }

    public void modifyUser(Property property, String userName) throws NamingException, FinderException {
        AccessLock.lock("ACCESS");
        String uid = null;
        try {
            ArrayList values = null;
            Date now = new Date();
            values = PropertyUtil.getPropertyValue((Property)property, (String)"uid");
            uid = (String)values.get(0);
            UserLocal user = UserUtil.getLocalHome().findByUid(uid);
            values = PropertyUtil.getPropertyValue((Property)property, (String)"namae");
            user.setCn(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"description");
            user.setDescription(this.checkString(values.get(0)));
            user.setModifiersName(this.checkString(userName));
            user.setModifyTimestamp(now);
            List<String> roleList = RoleConstant.getRoles();
            for (int i = 0; i < roleList.size(); ++i) {
                String roleName = roleList.get(i);
                values = PropertyUtil.getPropertyValue((Property)property, (String)roleName);
                if (values.size() <= 0) continue;
                this.releaseUser(roleName, user.getDn());
                if (!((Boolean)values.get(0)).booleanValue()) continue;
                this.assignUser(roleName, user.getDn());
            }
        }
        catch (EJBException e) {
            AplLogger apllog = new AplLogger("ACC", "acc");
            Object[] args = new String[]{uid};
            apllog.put("SYS", "008", args);
            m_log.debug((Object)("modifyUser() : " + e.getMessage()));
            throw e;
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("ACC", "acc");
            Object[] args = new String[]{uid};
            apllog.put("SYS", "008", args);
            m_log.debug((Object)("modifyUser() : " + e.getMessage()));
            throw e;
        }
    }

    public void deleteUser(String uid) throws NamingException, RemoveException, FinderException {
        AccessLock.lock("ACCESS");
        try {
            UserLocal user = UserUtil.getLocalHome().findByUid(uid);
            String dn = user.getDn();
            user.remove();
            List<String> roleList = RoleConstant.getRoles();
            for (int i = 0; i < roleList.size(); ++i) {
                String roleName = roleList.get(i);
                this.releaseUser(roleName, dn);
            }
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("ACC", "acc");
            Object[] args = new String[]{uid};
            apllog.put("SYS", "007", args);
            m_log.debug((Object)("deleteUser() : " + e.getMessage()));
            throw e;
        }
        catch (RemoveException e) {
            AplLogger apllog = new AplLogger("ACC", "acc");
            Object[] args = new String[]{uid};
            apllog.put("SYS", "007", args);
            m_log.debug((Object)("deleteUser() : " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("ACC", "acc");
            Object[] args = new String[]{uid};
            apllog.put("SYS", "007", args);
            m_log.debug((Object)("deleteUser() : " + e.getMessage()));
            throw e;
        }
    }

    protected void assignUser(String roleName, String dn) throws FinderException, NamingException {
        RoleLocal role = null;
        try {
            role = RoleUtil.getLocalHome().findByCn(roleName);
            ArrayList list = role.getMember();
            list.add(dn);
            role.setMember(list);
        }
        catch (FinderException e) {
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
    }

    protected void releaseUser(String roleName, String dn) throws FinderException, NamingException {
        RoleLocal role = null;
        try {
            role = RoleUtil.getLocalHome().findByCn(roleName);
            String userDn = dn;
            ArrayList list = role.getMember();
            for (int i = 0; i < list.size(); ++i) {
                if (!userDn.equalsIgnoreCase((String)list.get(i))) continue;
                list.remove(i);
                break;
            }
            role.setMember(list);
        }
        catch (FinderException e) {
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
    }

    public void modifyPassword(String uid, String password) throws FinderException, NamingException {
        AccessLock.lock("ACCESS");
        try {
            UserLocal user = UserUtil.getLocalHome().findByUid(uid);
            user.setPassword(password);
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("ACC", "acc");
            Object[] args = new String[]{uid};
            apllog.put("SYS", "009", args);
            m_log.debug((Object)("modifyPassword() : " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("ACC", "acc");
            Object[] args = new String[]{uid};
            apllog.put("SYS", "008", args);
            m_log.debug((Object)("modifyPassword() : " + e.getMessage()));
            throw e;
        }
    }

    private Integer checkInteger(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return null;
    }

    private String checkString(Object value) {
        if (value instanceof String) {
            if (((String)value).compareTo("") == 0) {
                return null;
            }
            return (String)value;
        }
        return null;
    }

    private ArrayList checkArrayList(Object value) {
        if (value instanceof ArrayList) {
            boolean checkNull = true;
            ArrayList list = (ArrayList)value;
            for (int i = 0; i < list.size(); ++i) {
                if (this.checkString(list.get(i)) != null) {
                    list.set(i, this.checkString(list.get(i)));
                    checkNull = false;
                    continue;
                }
                if (this.checkInteger(list.get(i)) != null) {
                    list.set(i, this.checkInteger(list.get(i)));
                    checkNull = false;
                    continue;
                }
                list.set(i, null);
            }
            if (checkNull) {
                list = null;
            }
            return list;
        }
        return null;
    }

    private void checkValidUid(String uid) throws ParseException {
        char charData = '\u0000';
        for (int i = 0; i < uid.length(); ++i) {
            charData = uid.charAt(i);
            if (charData >= 'A' && charData <= 'Z' || charData >= 'a' && charData <= 'z' || charData >= '0' && charData <= '9') continue;
            throw new ParseException(uid, i);
        }
    }
}

