/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.factory;

import com.clustercontrol.bean.ConfirmConstant;
import com.clustercontrol.bean.FacilityTargetConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.ejb.entity.EventLogLocal;
import com.clustercontrol.monitor.ejb.entity.EventLogUtil;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.util.apllog.AplLogger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SelectEvent {
    protected static Log m_log = LogFactory.getLog(SelectEvent.class);
    private int m_eventMaxDisplayNumber = -1;

    public SelectEvent() {
        try {
            InitialContext initialContext = new InitialContext();
            if (initialContext.lookup("java:comp/env/EventMaxDisplayNumber") instanceof Integer) {
                this.m_eventMaxDisplayNumber = (Integer)initialContext.lookup("java:comp/env/EventMaxDisplayNumber");
            }
        }
        catch (NamingException e) {
            m_log.error((Object)("SelectEvent():" + e.getMessage()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ArrayList getEventList(String facilityId, int level) throws CreateException, FinderException, NamingException, IndexOutOfBoundsException {
        ArrayList list = null;
        try {
            String[] facilityIds = null;
            if (facilityId != null && !"".equals(facilityId)) {
                if (level == -1) {
                    if (facilityId == null) return null;
                    if ("".equals(facilityId)) return null;
                    facilityIds = new String[]{facilityId};
                } else {
                    ArrayList facilityIdList = RepositoryControllerUtil.getLocalHome().create().getFacilityIdList(facilityId, level);
                    if (facilityIdList != null && facilityIdList.size() > 0) {
                        facilityIds = new String[facilityIdList.size()];
                        facilityIdList.toArray(facilityIds);
                    } else {
                        if (facilityId == null) return null;
                        facilityIds = new String[]{facilityId};
                    }
                }
            }
            Collection ct = EventLogUtil.getLocalHome().selectEvent(facilityIds, null, null, null, null, null, null, null, new Integer(0));
            if (this.m_eventMaxDisplayNumber == -1) return this.collectionToArray(ct);
            if (ct.size() <= this.m_eventMaxDisplayNumber) return this.collectionToArray(ct);
            throw new IndexOutOfBoundsException();
        }
        catch (CreateException e) {
            AplLogger apllog = new AplLogger("MON", "mon");
            Object[] args = new String[]{facilityId, null, null, null, null, null, null, null, null, null};
            apllog.put("SYS", "003", args);
            m_log.debug((Object)("getEventList():" + e.getMessage()));
            throw e;
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("MON", "mon");
            Object[] args = new String[]{facilityId, null, null, null, null, null, null, null, null, null};
            apllog.put("SYS", "003", args);
            m_log.debug((Object)("getEventList():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("MON", "mon");
            Object[] args = new String[]{facilityId, null, null, null, null, null, null, null, null, null};
            apllog.put("SYS", "003", args);
            m_log.debug((Object)("getEventList():" + e.getMessage()));
            throw e;
        }
    }

    public ArrayList getEventList(String facilityId, Property property) throws CreateException, FinderException, NamingException, IndexOutOfBoundsException {
        ArrayList list = null;
        Integer priority = null;
        Timestamp outputFromDate = null;
        Timestamp outputToDate = null;
        Timestamp generationFromDate = null;
        Timestamp generationToDate = null;
        String facilityType = null;
        String application = null;
        String message = null;
        Integer confirmFlg = null;
        try {
            int confirmFlgType;
            int priorityType;
            ArrayList values = null;
            values = PropertyUtil.getPropertyValue((Property)property, (String)"priority");
            if (!"".equals((String)values.get(0)) && (priorityType = PriorityConstant.stringToType((String)((String)values.get(0)))) != -1) {
                priority = new Integer(priorityType);
            }
            if ((values = PropertyUtil.getPropertyValue((Property)property, (String)"outputFromDate")).get(0) instanceof Date) {
                outputFromDate = new Timestamp(((Date)values.get(0)).getTime());
                outputFromDate.setNanos(0);
            }
            if ((values = PropertyUtil.getPropertyValue((Property)property, (String)"outputToDate")).get(0) instanceof Date) {
                outputToDate = new Timestamp(((Date)values.get(0)).getTime());
                outputToDate.setNanos(999999999);
            }
            if ((values = PropertyUtil.getPropertyValue((Property)property, (String)"generationFromDate")).get(0) instanceof Date) {
                generationFromDate = new Timestamp(((Date)values.get(0)).getTime());
                generationFromDate.setNanos(0);
            }
            if ((values = PropertyUtil.getPropertyValue((Property)property, (String)"generationToDate")).get(0) instanceof Date) {
                generationToDate = new Timestamp(((Date)values.get(0)).getTime());
                generationToDate.setNanos(999999999);
            }
            if (!"".equals((String)(values = PropertyUtil.getPropertyValue((Property)property, (String)"facilityType")).get(0))) {
                facilityType = (String)values.get(0);
            }
            if (!"".equals((String)(values = PropertyUtil.getPropertyValue((Property)property, (String)"application")).get(0))) {
                application = (String)values.get(0);
            }
            if (!"".equals((String)(values = PropertyUtil.getPropertyValue((Property)property, (String)"message")).get(0))) {
                message = (String)values.get(0);
            }
            if ((confirmFlgType = ConfirmConstant.stringToType((String)((String)(values = PropertyUtil.getPropertyValue((Property)property, (String)"confirmed")).get(0)))) != -1) {
                confirmFlg = new Integer(confirmFlgType);
            }
            String[] facilityIds = null;
            if (facilityId != null && !"".equals(facilityId)) {
                ArrayList facilityIdList;
                int level = 0;
                if (FacilityTargetConstant.STRING_BENEATH.equals(facilityType)) {
                    level = 1;
                }
                if ((facilityIdList = RepositoryControllerUtil.getLocalHome().create().getFacilityIdList(facilityId, level)) != null && facilityIdList.size() > 0) {
                    facilityIds = new String[facilityIdList.size()];
                    facilityIdList.toArray(facilityIds);
                } else if (facilityId != null) {
                    facilityIds = new String[]{facilityId};
                } else {
                    return null;
                }
            }
            Collection ct = EventLogUtil.getLocalHome().selectEvent(facilityIds, priority, outputFromDate, outputToDate, generationFromDate, generationToDate, application, message, confirmFlg);
            if (this.m_eventMaxDisplayNumber != -1 && ct.size() > this.m_eventMaxDisplayNumber) {
                throw new IndexOutOfBoundsException();
            }
            list = this.collectionToArray(ct);
        }
        catch (CreateException e) {
            int priorityInt = -1;
            String outputFromDateString = null;
            String outputToDateString = null;
            String generationFromDateString = null;
            String generationToDateString = null;
            int confirmFlgInt = -1;
            if (priority != null) {
                priorityInt = priority;
            }
            if (outputFromDate != null) {
                outputFromDateString = outputFromDate.toString();
            }
            if (outputToDate != null) {
                outputToDateString = outputToDate.toString();
            }
            if (generationFromDate != null) {
                generationFromDateString = generationFromDate.toString();
            }
            if (generationToDate != null) {
                generationToDateString = generationToDate.toString();
            }
            if (confirmFlg != null) {
                confirmFlgInt = confirmFlg;
            }
            AplLogger apllog = new AplLogger("MON", "mon");
            Object[] args = new String[]{facilityId, PriorityConstant.typeToString((int)priorityInt), outputFromDateString, outputToDateString, generationFromDateString, generationToDateString, facilityType, application, message, ConfirmConstant.typeToString((int)confirmFlgInt)};
            apllog.put("SYS", "003", args);
            m_log.debug((Object)("getEventList():" + e.getMessage()));
            throw e;
        }
        catch (FinderException e) {
            int priorityInt = -1;
            String outputFromDateString = null;
            String outputToDateString = null;
            String generationFromDateString = null;
            String generationToDateString = null;
            int confirmFlgInt = -1;
            if (priority != null) {
                priorityInt = priority;
            }
            if (outputFromDate != null) {
                outputFromDateString = outputFromDate.toString();
            }
            if (outputToDate != null) {
                outputToDateString = outputToDate.toString();
            }
            if (generationFromDate != null) {
                generationFromDateString = generationFromDate.toString();
            }
            if (generationToDate != null) {
                generationToDateString = generationToDate.toString();
            }
            if (confirmFlg != null) {
                confirmFlgInt = confirmFlg;
            }
            AplLogger apllog = new AplLogger("MON", "mon");
            Object[] args = new String[]{facilityId, PriorityConstant.typeToString((int)priorityInt), outputFromDateString, outputToDateString, generationFromDateString, generationToDateString, facilityType, application, message, ConfirmConstant.typeToString((int)confirmFlgInt)};
            apllog.put("SYS", "003", args);
            m_log.debug((Object)("getEventList():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            int priorityInt = -1;
            String outputFromDateString = null;
            String outputToDateString = null;
            String generationFromDateString = null;
            String generationToDateString = null;
            int confirmFlgInt = -1;
            if (priority != null) {
                priorityInt = priority;
            }
            if (outputFromDate != null) {
                outputFromDateString = outputFromDate.toString();
            }
            if (outputToDate != null) {
                outputToDateString = outputToDate.toString();
            }
            if (generationFromDate != null) {
                generationFromDateString = generationFromDate.toString();
            }
            if (generationToDate != null) {
                generationToDateString = generationToDate.toString();
            }
            if (confirmFlg != null) {
                confirmFlgInt = confirmFlg;
            }
            AplLogger apllog = new AplLogger("MON", "mon");
            Object[] args = new String[]{facilityId, PriorityConstant.typeToString((int)priorityInt), outputFromDateString, outputToDateString, generationFromDateString, generationToDateString, facilityType, application, message, ConfirmConstant.typeToString((int)confirmFlgInt)};
            apllog.put("SYS", "003", args);
            m_log.debug((Object)("getEventList():" + e.getMessage()));
            throw e;
        }
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EventLogLocal getHighPriorityEvent(String facilityId, int level) throws CreateException, FinderException, NamingException {
        EventLogLocal event = null;
        try {
            String[] facilityIds = null;
            if (level == -1) {
                if (facilityId == null) return null;
                if ("".equals(facilityId)) return null;
                facilityIds = new String[]{facilityId};
            } else {
                ArrayList facilityIdList = RepositoryControllerUtil.getLocalHome().create().getFacilityIdList(facilityId, level);
                if (facilityIdList != null && facilityIdList.size() > 0) {
                    facilityIds = new String[facilityIdList.size()];
                    facilityIdList.toArray(facilityIds);
                } else {
                    if (facilityId == null) return null;
                    facilityIds = new String[]{facilityId};
                }
            }
            Collection ct = EventLogUtil.getLocalHome().selectHighPriorityEvent(facilityIds, null, null, null, null, null, null, null, new Integer(0));
            Iterator itr = ct.iterator();
            if (!itr.hasNext()) return event;
            return (EventLogLocal)itr.next();
        }
        catch (CreateException e) {
            m_log.debug((Object)("getHighPriorityEvent():" + e.getMessage()));
            throw e;
        }
        catch (FinderException e) {
            m_log.debug((Object)("getHighPriorityEvent():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            m_log.debug((Object)("getHighPriorityEvent():" + e.getMessage()));
            throw e;
        }
    }

    private ArrayList collectionToArray(Collection ct) {
        ArrayList list = new ArrayList();
        for (EventLogLocal event : ct) {
            ArrayList<Object> info = new ArrayList<Object>();
            info.add(event.getPriority());
            info.add(new Date(event.getOutputDate().getTime()));
            info.add(new Date(event.getGenerationDate().getTime()));
            info.add(event.getPluginId());
            info.add(event.getMonitorId());
            info.add(event.getFacilityId());
            info.add(event.getScopeText());
            info.add(event.getApplication());
            info.add(event.getMessageId());
            info.add(event.getMessage());
            info.add(event.getConfirmFlg());
            list.add(info);
        }
        return list;
    }
}

