/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.MarkerFilter;
import org.eclipse.ui.views.markers.internal.TaskMarker;

public class TaskFilter
extends MarkerFilter {
    private static final String TAG_CONTAINS = "contains";
    private static final String TAG_DESCRIPTION = "description";
    private static final String TAG_DIALOG_SECTION = "filter";
    private static final String TAG_DONE = "done";
    private static final String TAG_PRIORITY = "priority";
    private static final String TAG_SELECT_BY_DONE = "selectByDone";
    private static final String TAG_SELECT_BY_PRIORITY = "selectByPriority";
    static final boolean DEFAULT_CONTAINS = true;
    static final String DEFAULT_DESCRIPTION = "";
    static final boolean DEFAULT_DONE = false;
    static final int DEFAULT_PRIORITY = 0;
    static final boolean DEFAULT_SELECT_BY_DONE = false;
    static final boolean DEFAULT_SELECT_BY_PRIORITY = false;
    static final int PRIORITY_HIGH = 4;
    static final int PRIORITY_NORMAL = 2;
    static final int PRIORITY_LOW = 1;
    private boolean contains;
    private String description;
    private boolean done;
    private int priority;
    private boolean selectByPriority;
    private boolean selectByDone;

    public TaskFilter() {
        super(new String[]{"org.eclipse.core.resources.taskmarker"});
    }

    public boolean selectMarker(ConcreteMarker marker) {
        if (!(marker instanceof TaskMarker)) {
            return false;
        }
        TaskMarker taskMarker = (TaskMarker)marker;
        return !this.isEnabled() || super.selectMarker(taskMarker) && this.selectByDescription(taskMarker) && this.selectByDone(taskMarker) && this.selectByPriority(taskMarker);
    }

    private boolean selectByDescription(ConcreteMarker marker) {
        if (this.description == null || this.description.equals(DEFAULT_DESCRIPTION)) {
            return true;
        }
        int index = marker.getDescription().indexOf(this.description);
        return this.contains ? index >= 0 : index < 0;
    }

    private boolean selectByDone(TaskMarker item) {
        if (this.selectByDone) {
            return this.done == (item.getDone() == 1);
        }
        return true;
    }

    private boolean selectByPriority(TaskMarker marker) {
        if (this.priority != 0 && this.selectByPriority) {
            int markerPriority = marker.getPriority();
            if (markerPriority == 2) {
                return (this.priority & 4) > 0;
            }
            if (markerPriority == 1) {
                return (this.priority & 2) > 0;
            }
            if (markerPriority == 0) {
                return (this.priority & 1) > 0;
            }
        }
        return true;
    }

    public boolean getContains() {
        return this.contains;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getDone() {
        return this.done;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean getSelectByDone() {
        return this.selectByDone;
    }

    public boolean getSelectByPriority() {
        return this.selectByPriority;
    }

    public void setContains(boolean contains) {
        this.contains = contains;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDone(boolean done) {
        this.done = done;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setSelectByDone(boolean selectByDone) {
        this.selectByDone = selectByDone;
    }

    public void setSelectByPriority(boolean selectByPriority) {
        this.selectByPriority = selectByPriority;
    }

    public void resetState() {
        super.resetState();
        this.contains = true;
        this.description = DEFAULT_DESCRIPTION;
        this.done = false;
        this.priority = 0;
        this.selectByDone = false;
        this.selectByPriority = false;
    }

    public void restoreState(IDialogSettings dialogSettings) {
        super.restoreState(dialogSettings);
        IDialogSettings settings = dialogSettings.getSection(TAG_DIALOG_SECTION);
        if (settings != null) {
            String setting = settings.get(TAG_CONTAINS);
            if (setting != null) {
                this.contains = Boolean.valueOf(setting);
            }
            if ((setting = settings.get(TAG_DESCRIPTION)) != null) {
                this.description = new String(setting);
            }
            if ((setting = settings.get(TAG_DONE)) != null) {
                this.done = Boolean.valueOf(setting);
            }
            if ((setting = settings.get(TAG_PRIORITY)) != null) {
                try {
                    this.priority = Integer.parseInt(setting);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if ((setting = settings.get(TAG_SELECT_BY_DONE)) != null) {
                this.selectByDone = Boolean.valueOf(setting);
            }
            if ((setting = settings.get(TAG_SELECT_BY_PRIORITY)) != null) {
                this.selectByPriority = Boolean.valueOf(setting);
            }
        }
    }

    public void saveState(IDialogSettings dialogSettings) {
        super.saveState(dialogSettings);
        if (dialogSettings != null) {
            IDialogSettings settings = dialogSettings.getSection(TAG_DIALOG_SECTION);
            if (settings == null) {
                settings = dialogSettings.addNewSection(TAG_DIALOG_SECTION);
            }
            settings.put(TAG_CONTAINS, this.contains);
            settings.put(TAG_DESCRIPTION, this.description);
            settings.put(TAG_DONE, this.done);
            settings.put(TAG_PRIORITY, this.priority);
            settings.put(TAG_SELECT_BY_DONE, this.selectByDone);
            settings.put(TAG_SELECT_BY_PRIORITY, this.selectByPriority);
        }
    }
}

