/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performanceMGR.util;

import java.io.Serializable;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SendQueue {
    protected static Log m_log = LogFactory.getLog(SendQueue.class);
    protected String m_queueName;
    protected QueueConnectionFactory m_connectionFactory;
    protected QueueConnection m_connection;
    protected Queue m_queue;
    protected QueueSession m_session;
    static /* synthetic */ Class class$0;

    public SendQueue(String queueName) throws NamingException, JMSException {
        this.m_queueName = queueName;
        this.initial();
    }

    public void put(Serializable orgMessage) throws JMSException {
        try {
            QueueSender sender = this.m_session.createSender(this.m_queue);
            ObjectMessage message = this.m_session.createObjectMessage(orgMessage);
            sender.send((Message)message);
            sender.close();
        }
        catch (JMSException e) {
            m_log.error((Object)("put:" + e.getMessage()));
            this.terminate();
            throw e;
        }
    }

    public void initial() throws NamingException, JMSException {
        try {
            InitialContext context = null;
            String serverName = System.getProperty("jboss.server.name");
            if (serverName.equals("all")) {
                Properties properties = new Properties();
                properties.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
                properties.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
                properties.put("java.naming.provider.url", "jnp://localhost:1100");
                context = new InitialContext(properties);
            } else {
                context = new InitialContext();
            }
            this.m_connectionFactory = (QueueConnectionFactory)context.lookup("ConnectionFactory");
            this.m_connection = this.m_connectionFactory.createQueueConnection();
            this.m_session = this.m_connection.createQueueSession(false, 1);
            this.m_queue = (Queue)context.lookup(this.m_queueName);
            context.close();
        }
        catch (NamingException e) {
            m_log.error((Object)("initial:" + e.getMessage()));
            this.terminate();
            throw e;
        }
        catch (JMSException e) {
            m_log.error((Object)("initial:" + e.getMessage()));
            this.terminate();
            throw e;
        }
    }

    public void terminate() throws JMSException {
        try {
            if (this.m_session != null) {
                this.m_session.close();
            }
        }
        catch (JMSException e) {
            m_log.error((Object)("terminate:" + e.getMessage()));
            throw e;
        }
        try {
            if (this.m_connection != null) {
                this.m_connection.close();
            }
        }
        catch (JMSException e) {
            m_log.error((Object)("terminate:" + e.getMessage()));
            throw e;
        }
    }
}

