/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performanceMGR.dao;

import com.clustercontrol.performanceMGR.bean.ScopeRelationData;
import com.clustercontrol.performanceMGR.util.ConnectionManager;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScopeRelationDAO {
    protected static Log m_log = LogFactory.getLog(ScopeRelationDAO.class);
    static /* synthetic */ Class class$0;

    public Collection selectScopeRelation(String collectorID, String facilityID) throws EJBException {
        m_log.debug((Object)("selectScopeRelation() start :" + collectorID + " " + facilityID));
        ArrayList<ScopeRelationData> ret = new ArrayList<ScopeRelationData>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM SCOPE_RELATION WHERE COLLECTORID=? AND FACILITYID = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, collectorID);
                stmt.setString(2, facilityID);
                res = stmt.executeQuery();
                while (res.next()) {
                    ScopeRelationData finfo = new ScopeRelationData(res.getString("COLLECTORID"), res.getString("FACILITYID"), res.getString("PARENT_FACILITYID"));
                    ret.add(finfo);
                }
            }
            catch (SQLException e) {
                m_log.error((Object)("selectScopeRelation() error :" + collectorID + " EJBException "));
                throw new EJBException(e.getMessage());
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("selectScopeRelation() error :" + collectorID + " EJBException "));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("selectScopeRelation() end :" + collectorID + " " + facilityID));
        return ret;
    }

    public void insertScopeRelation(ScopeRelationData finfo) throws EJBException, CreateException {
        m_log.debug((Object)("insertScopeRelation() start :" + finfo.toString()));
        Connection conn = null;
        Statement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "INSERT INTO SCOPE_RELATION (collectorID, facilityID,parent_facilityID)values (?,?,?);";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, finfo.getCollectorID());
                stmt.setString(2, finfo.getFacilityID());
                stmt.setString(3, finfo.getParentFacilityID());
                int row = stmt.executeUpdate();
                if (row != 1) {
                    String msg = "Insert Error In ScopeSnapDAO";
                    m_log.error((Object)("insertScopeRelation() error :" + finfo.toString() + " CreateException "));
                    throw new CreateException(msg);
                }
            }
            catch (SQLException e) {
                m_log.error((Object)("insertScopeRelation() error :" + finfo.toString() + " SQLException "));
                throw new EJBException(e.getMessage());
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("insertScopeRelation() error :" + finfo.toString() + " SQLException "));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("insertScopeRelation() start :" + finfo.toString()));
        }
    }

    public Collection selectScopeRelationByCollectorID(String collectorID) throws EJBException {
        m_log.debug((Object)("selectScopeRelationByCollectorID() start :" + collectorID));
        ArrayList<ScopeRelationData> ret = new ArrayList<ScopeRelationData>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM SCOPE_RELATION WHERE COLLECTORID=?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, collectorID);
                res = stmt.executeQuery();
                while (res.next()) {
                    ScopeRelationData finfo = new ScopeRelationData(res.getString("COLLECTORID"), res.getString("FACILITYID"), res.getString("PARENT_FACILITYID"));
                    ret.add(finfo);
                }
            }
            catch (SQLException e) {
                m_log.error((Object)("selectScopeRelationByCollectorID() error :" + collectorID + " SQLException "));
                throw new EJBException(e.getMessage());
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("selectScopeRelationByCollectorID() error :" + collectorID + " SQLException "));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("selectScopeRelationByCollectorID() end :" + collectorID));
        return ret;
    }

    public void deleteScopeRelationByCollectorID(String collectorID) throws EJBException {
        m_log.debug((Object)("deleteScopeRelationByCollectorID() start :" + collectorID));
        Connection conn = null;
        Statement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "DELETE FROM SCOPE_RELATION WHERE COLLECTORID = ? ";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, collectorID);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                m_log.error((Object)("deleteScopeRelationByCollectorID() error :" + collectorID + " SQLException "));
                throw new EJBException(e.getMessage());
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("deleteScopeRelationByCollectorID() error :" + collectorID + " SQLException "));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("deleteScopeRelationByCollectorID() end :" + collectorID));
        }
    }
}

