/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performanceMGR.bean;

import com.clustercontrol.performanceMGR.bean.CollectorItemPK;
import com.clustercontrol.performanceMGR.bean.Facility;
import com.clustercontrol.performanceMGR.bean.OIDInfo;
import com.clustercontrol.performanceMGR.dao.RecordDataDAO;
import com.clustercontrol.performanceMGR.util.CalculationMethod;
import com.clustercontrol.performanceMGR.util.JNDIConnectionManager;
import com.clustercontrol.sharedtable.bean.ValueObject;
import com.clustercontrol.snmppoller.SnmpSharedTable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import javax.ejb.EJBException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Node
extends Facility {
    protected static Log m_log = LogFactory.getLog(Node.class);
    private HashMap m_mibValueSet = new HashMap();
    private long lastCollectTime;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    Node(String facilityID, String faclityName) {
        super(facilityID, faclityName, 2);
    }

    public double calcValue(String itemCode, int deviceIndex) {
        double value = CalculationMethod.getPerformance(itemCode, deviceIndex, this.m_mibValueSet);
        m_log.debug((Object)("calcValue() : " + this.m_facilityID + " " + itemCode + " " + deviceIndex + "  " + value));
        if (!Double.isNaN(value)) {
            this.setCalcValueBuffer(new CollectorItemPK(itemCode, deviceIndex), value);
        }
        return value;
    }

    public long fetchMibValue(OIDInfo[] oids, int interval) {
        m_log.debug((Object)"fetchMibValue() start :");
        HashSet<String> checkOid = new HashSet<String>();
        SnmpSharedTable sst = null;
        try {
            InitialContext iniCtx = JNDIConnectionManager.getInitialContext();
            Object obj = iniCtx.lookup("SnmpPerf");
            sst = (SnmpSharedTable)PortableRemoteObject.narrow((Object)obj, SnmpSharedTable.class);
        }
        catch (NamingException e) {
            throw new EJBException(e.getMessage());
        }
        int i = 0;
        while (i < oids.length) {
            if (!oids[i].isAllIndex()) {
                if (!checkOid.contains(oids[i].getOID())) {
                    ValueObject value = sst.getValue(this.getFacilityID(), interval, oids[i].getOID());
                    if (value == null) {
                        m_log.debug((Object)("Node : " + this.getFacilityID() + " can't get value " + oids[i].getOID()));
                        this.setMibValueSet(oids[i].getBaseOid(), oids[i].getOidIndex(), 0L);
                        checkOid.add(oids[i].getOID());
                    } else {
                        String mibValueString = (String)value.getValue();
                        m_log.debug((Object)("Node : " + this.getFacilityID() + " " + oids[i].getOID() + " " + value));
                        this.setMibValueSet(oids[i].getBaseOid(), oids[i].getOidIndex(), Long.parseLong(mibValueString));
                        checkOid.add(oids[i].getOID());
                        this.lastCollectTime = Math.max(this.lastCollectTime, value.getDate());
                    }
                }
            } else {
                int j = 0;
                String oid = String.valueOf(oids[i].getBaseOid()) + "." + j;
                this.setMibValueSet(oids[i].getBaseOid(), j++, Long.MIN_VALUE);
                checkOid.add(oids[i].getOID());
                oid = String.valueOf(oids[i].getBaseOid()) + "." + j;
                ValueObject value = null;
                while ((value = sst.getValue(this.getFacilityID(), interval, oid)) != null) {
                    if (!checkOid.contains(oid)) {
                        m_log.debug((Object)("Node : " + this.getFacilityID() + " " + oids[i].getOID() + " " + value));
                        this.setMibValueSet(oids[i].getBaseOid(), j, Long.parseLong((String)value.getValue()));
                        checkOid.add(oids[i].getOID());
                        this.lastCollectTime = Math.max(this.lastCollectTime, value.getDate());
                    }
                    oid = String.valueOf(oids[i].getBaseOid()) + "." + ++j;
                }
                if (j == 1) {
                    m_log.debug((Object)("Node : " + this.getFacilityID() + " can't get value " + oids[i].getBaseOid() + ".*"));
                }
            }
            ++i;
        }
        m_log.debug((Object)"fetchMibValue() end :");
        return this.lastCollectTime;
    }

    private void setMibValueSet(String baseOid, int tableIndex, long mibValue) {
        m_log.debug((Object)("setMibValueSet() :" + baseOid + " " + tableIndex + "  " + mibValue));
        long[][] mibValueSetList = (long[][])this.m_mibValueSet.get(baseOid);
        if (mibValueSetList == null) {
            mibValueSetList = new long[tableIndex + 1][2];
            this.m_mibValueSet.put(baseOid, mibValueSetList);
        } else if (mibValueSetList.length <= tableIndex) {
            long[][] buffer = new long[tableIndex + 1][2];
            int i = 0;
            while (i < mibValueSetList.length) {
                buffer[i] = mibValueSetList[i];
                ++i;
            }
            mibValueSetList = buffer;
            this.m_mibValueSet.put(baseOid, mibValueSetList);
        }
        mibValueSetList[tableIndex][0] = mibValueSetList[tableIndex][1];
        mibValueSetList[tableIndex][1] = mibValue;
    }

    public HashSet getNode(HashSet nodeSet) {
        nodeSet.add(this);
        return nodeSet;
    }

    public int getNodeCount() {
        return 1;
    }

    public void storeMibValue(String collectorId) {
        m_log.debug((Object)("storeRowMibValue() :" + collectorId));
        Date date = new Date();
        RecordDataDAO dao = new RecordDataDAO();
        for (String baseOid : this.m_mibValueSet.keySet()) {
            long[][] mibValueSetList = (long[][])this.m_mibValueSet.get(baseOid);
            int i = 0;
            while (i < mibValueSetList.length) {
                String fullOid = String.valueOf(baseOid) + "." + i;
                dao.insertRecordData(collectorId, fullOid, date, this.getFacilityID(), mibValueSetList[i][0]);
                ++i;
            }
        }
    }
}

