/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.hinemosagent.factory;

import com.clustercontrol.monitor.run.factory.RunMonitorTruthValueType;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.apllog.AplLogger;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;
import org.jboss.mq.Subscription;
import org.jboss.mq.selectors.Selector;

public class RunMonitorAgent
extends RunMonitorTruthValueType {
    protected static Log m_log = LogFactory.getLog(RunMonitorAgent.class);
    public static final String LOOKUP_NAME = "jmx/invoker/RMIAdaptor";
    public static final String OBJECT_NAME = "jboss.mq.destination:name=clustercontrol/JobManagement/execute,service=Topic";
    public static final String OPERATION_NAME = "listAllSubscriptions";
    public static final String MESSAGE_ID_INFO = "001";
    public static final String MESSAGE_ID_WARNING = "002";
    public static final String MESSAGE_ID_CRITICAL = "003";
    public static final String MESSAGE_ID_UNKNOWN = "004";
    protected String m_message = null;

    public boolean collect(String facilityId) {
        boolean result = false;
        boolean duplication = false;
        this.m_value = false;
        this.m_nodeDate = this.m_now.getTime();
        try {
            InitialContext ic = new InitialContext();
            RMIAdaptor server = (RMIAdaptor)ic.lookup(LOOKUP_NAME);
            ObjectName name = new ObjectName(OBJECT_NAME);
            Object returnObject = server.invoke(name, OPERATION_NAME, null, null);
            if (returnObject instanceof List) {
                String checkString = "FacilityId='" + facilityId + "'";
                HashMap<String, String> map = new HashMap<String, String>();
                for (int i = 0; i < ((List)returnObject).size(); ++i) {
                    Subscription subscription = (Subscription)((List)returnObject).get(i);
                    try {
                        Selector selecter = subscription.getSelector();
                        if (selecter == null || selecter.selector.indexOf(checkString) == -1) continue;
                        if (map.get(facilityId) == null) {
                            this.m_value = true;
                            map.put(facilityId, facilityId);
                            continue;
                        }
                        this.m_value = false;
                        duplication = true;
                        AplLogger apllog = new AplLogger("AGT", "agt");
                        Object[] args = new String[]{facilityId};
                        apllog.put("SYS", MESSAGE_ID_INFO, args);
                        break;
                    }
                    catch (InvalidSelectorException e) {
                        m_log.debug((Object)("collect() : " + e.getMessage()));
                    }
                }
                if (!duplication) {
                    this.m_message = this.m_value ? Messages.getString((String)"message.agent.10") : Messages.getString((String)"message.agent.11");
                } else {
                    Object[] args = new String[]{facilityId};
                    this.m_message = Messages.getString((String)"message.agent.12", (Object[])args);
                }
                result = true;
            } else {
                this.m_message = Messages.getString((String)"message.agent.13");
            }
        }
        catch (NamingException e) {
            m_log.debug((Object)("collect() : " + e.getMessage()));
            this.m_message = Messages.getString((String)"message.agent.13") + " (" + e.getMessage() + ")";
        }
        catch (MalformedObjectNameException e) {
            m_log.debug((Object)("collect() : " + e.getMessage()));
            this.m_message = Messages.getString((String)"message.agent.13") + " (" + e.getMessage() + ")";
        }
        catch (NullPointerException e) {
            m_log.debug((Object)("collect() : " + e.getMessage()));
            this.m_message = Messages.getString((String)"message.agent.13") + " (" + e.getMessage() + ")";
        }
        catch (InstanceNotFoundException e) {
            m_log.debug((Object)("collect() : " + e.getMessage()));
            this.m_message = Messages.getString((String)"message.agent.13") + " (" + e.getMessage() + ")";
        }
        catch (MBeanException e) {
            m_log.debug((Object)("collect() : " + e.getMessage()));
            this.m_message = Messages.getString((String)"message.agent.13") + " (" + e.getMessage() + ")";
        }
        catch (ReflectionException e) {
            m_log.debug((Object)("collect() : " + e.getMessage()));
            this.m_message = Messages.getString((String)"message.agent.13") + " (" + e.getMessage() + ")";
        }
        catch (IOException e) {
            m_log.debug((Object)("collect() : " + e.getMessage()));
            this.m_message = Messages.getString((String)"message.agent.13") + " (" + e.getMessage() + ")";
        }
        return result;
    }

    public void setCheckInfo() throws FinderException, NamingException {
    }

    public String getMessageId(int result) {
        if (result == 3) {
            return MESSAGE_ID_INFO;
        }
        if (result == 2) {
            return MESSAGE_ID_WARNING;
        }
        if (result == 0) {
            return MESSAGE_ID_CRITICAL;
        }
        return MESSAGE_ID_UNKNOWN;
    }

    public String getMessage(int result) {
        return this.m_message;
    }

    public String getMessageOrg(int result) {
        return null;
    }
}

