/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.factory;

import com.clustercontrol.calendar.ejb.session.CalendarControllerLocal;
import com.clustercontrol.calendar.ejb.session.CalendarControllerUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobCommandInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobCommandInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobCommandMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobEndInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobEndInfoPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobEndInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobEndMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobFileInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobFileInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobFileMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobMasterUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobNoticeInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobNoticeInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobNoticeMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationMasterUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodeLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodePK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodeUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartJobInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartJobInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartJobMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartTimeInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartTimeInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartTimeMasterLocal;
import com.clustercontrol.jobmanagement.factory.CreateFileJob;
import com.clustercontrol.jobmanagement.factory.EndJudgment;
import com.clustercontrol.jobmanagement.factory.Notice;
import com.clustercontrol.jobmanagement.message.RunInfo;
import com.clustercontrol.jobmanagement.message.RunInstructionInfo;
import com.clustercontrol.jobmanagement.message.RunResultInfo;
import com.clustercontrol.jobmanagement.util.SendQueue;
import com.clustercontrol.jobmanagement.util.SendTopic;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import java.io.File;
import java.io.FileInputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OperationJob {
    protected static Log m_log = LogFactory.getLog(OperationJob.class);
    protected static Integer m_messageRetry = null;
    protected static Integer m_messageTimeout = null;

    public OperationJob() {
        if (m_messageRetry == null || m_messageTimeout == null) {
            Properties properties = new Properties();
            String homedir = System.getProperty("jboss.server.home.dir");
            String propertyFile = homedir + File.separator + "conf" + File.separator + "jobmanagement.properties";
            if (m_messageRetry == null) {
                try {
                    properties.load(new FileInputStream(propertyFile));
                    String retry = properties.getProperty("message.retry", "false");
                    m_messageRetry = new Integer(retry);
                }
                catch (Exception e) {
                    m_log.error((Object)("OperationJob():" + e.getMessage()));
                    m_messageRetry = new Integer(5);
                }
            }
            if (m_messageTimeout == null) {
                try {
                    properties.load(new FileInputStream(propertyFile));
                    String timeout = properties.getProperty("message.timeout", "false");
                    m_messageTimeout = new Integer(timeout);
                }
                catch (Exception e) {
                    m_log.error((Object)("SelectJob():" + e.getMessage()));
                    m_messageTimeout = new Integer(60);
                }
            }
        }
    }

    public void runJob(String sessionId, String jobId) throws FinderException, NamingException {
        m_log.debug((Object)("runJob() : sessionId=" + sessionId + ", jobId=" + jobId));
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        sessionJob.setStatus(new Integer(100));
        sessionJob.setStart_date(new Date());
        new Notice().notify(sessionId, jobId, new Integer(3));
        JobInfoLocal job = sessionJob.getJobInfo();
        int type = job.getJob_type();
        sessionJob = null;
        job = null;
        if (type == 0) {
            this.startJob(sessionId, jobId);
        } else {
            this.startJobMain1(sessionId, jobId, null);
        }
    }

    public void runJob() throws FinderException, NamingException {
        m_log.debug((Object)"runJob()");
        Collection collection = JobSessionJobUtil.getLocalHome().findByStatus(new Integer(100));
        if (collection != null && collection.size() > 0) {
            for (JobSessionJobLocal sessionJob : collection) {
                String sessionId = sessionJob.getSession_id();
                String jobId = sessionJob.getJob_id();
                JobInfoLocal job = sessionJob.getJobInfo();
                int type = job.getJob_type();
                job = null;
                if (type == 0) {
                    if (this.checkJobNetEnd(sessionId, jobId)) {
                        sessionJob.setStatus(new Integer(300));
                        sessionJob.setEnd_date(new Date());
                        sessionJob = null;
                        Integer endStatus = this.checkEndStatus(sessionId, jobId);
                        this.setEndStaus(sessionId, jobId, new Integer(300), endStatus, null);
                        new Notice().notify(sessionId, jobId, endStatus);
                        continue;
                    }
                    sessionJob = null;
                    this.startJob(sessionId, jobId);
                    continue;
                }
                sessionJob = null;
                this.startJobMain1(sessionId, jobId, null);
            }
        }
    }

    protected void startJob(String sessionId, String jobId) throws FinderException, NamingException {
        m_log.debug((Object)("startJob() : sessionId=" + sessionId + ", jobId=" + jobId));
        Collection collection = JobRelationInfoUtil.getLocalHome().findByStartStatus(sessionId, jobId);
        if (collection != null && collection.size() > 0) {
            for (JobRelationInfoLocal relation : collection) {
                JobSessionJobLocal sessionJob = relation.getJobSessionJob();
                String startSessionId = sessionJob.getSession_id();
                String startJobId = sessionJob.getJob_id();
                sessionJob = null;
                this.startJobMain1(startSessionId, startJobId, null);
            }
        }
    }

    protected void startJobMain1(String sessionId, String jobId, String facilityId) throws FinderException, NamingException {
        m_log.debug((Object)("startJobMain1() : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId));
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        if (sessionJob.getStatus() == 0) {
            sessionJob = null;
            if (this.checkStartCondition(sessionId, jobId) && this.checkCalendar(sessionId, jobId)) {
                this.startJobMain2(sessionId, jobId, facilityId);
            }
        } else if (sessionJob.getStatus() == 100) {
            JobInfoLocal job = sessionJob.getJobInfo();
            int type = job.getJob_type();
            job = null;
            if (type == 2) {
                if (this.checkJobEnd(sessionJob)) {
                    Integer endStatus = this.checkEndStatus(sessionId, jobId);
                    sessionJob.setEnd_date(new Date());
                    sessionJob = null;
                    this.setEndStaus(sessionId, jobId, new Integer(300), endStatus, "");
                    new Notice().notify(sessionId, jobId, endStatus);
                    this.endJob(sessionId, jobId);
                } else {
                    sessionJob = null;
                    this.startNode(sessionId, jobId, null);
                }
            } else if (this.checkJobNetEnd(sessionId, jobId)) {
                sessionJob.setStatus(new Integer(300));
                sessionJob.setEnd_date(new Date());
                sessionJob = null;
                Integer endStatus = this.checkEndStatus(sessionId, jobId);
                this.setEndStaus(sessionId, jobId, new Integer(300), endStatus, null);
                new Notice().notify(sessionId, jobId, endStatus);
                this.endJob(sessionId, jobId);
            } else {
                sessionJob = null;
                this.startJob(sessionId, jobId);
            }
        } else if (sessionJob.getStatus() == 2 && this.checkStartCondition(sessionId, jobId)) {
            sessionJob.setStatus(new Integer(300));
            sessionJob.setEnd_date(new Date());
            sessionJob = null;
            this.endJob(sessionId, jobId);
        }
    }

    protected void startJobMain2(String sessionId, String jobId, String facilityId) throws FinderException, NamingException {
        m_log.debug((Object)("startJobMain2() : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId));
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        sessionJob.setStatus(new Integer(100));
        sessionJob.setStart_date(new Date());
        JobInfoLocal job = sessionJob.getJobInfo();
        int type = job.getJob_type();
        sessionJob = null;
        job = null;
        new Notice().notify(sessionId, jobId, new Integer(3));
        if (type == 2) {
            this.startNode(sessionId, jobId, facilityId);
        } else {
            this.startJob(sessionId, jobId);
        }
    }

    protected boolean checkStartCondition(String sessionId, String jobId) throws FinderException, NamingException {
        m_log.debug((Object)("checkStartCondition() : sessionId=" + sessionId + ", jobId=" + jobId));
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        JobInfoLocal job = sessionJob.getJobInfo();
        JobStartInfoLocal start = job.getJobStartInfo();
        Collection startJobs = start.getJobStartJobInfo();
        JobStartTimeInfoLocal startTime = start.getJobStartTimeInfo();
        ArrayList<Boolean> jobResult = new ArrayList<Boolean>();
        boolean statusCheck = true;
        boolean startCheck = true;
        if (startJobs != null && startJobs.size() > 0 || startTime != null) {
            for (JobStartJobInfoLocal startJob : startJobs) {
                JobSessionJobLocal targetSessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionJob.getSession_id(), startJob.getTarget_job_id()));
                if (targetSessionJob.getStatus() == 300 || targetSessionJob.getStatus() == 301) {
                    Integer endStatus = this.getEndStatus(targetSessionJob);
                    if (endStatus instanceof Integer) {
                        if (endStatus.compareTo(startJob.getTarget_job_end_status()) == 0) {
                            jobResult.add(new Boolean(true));
                            continue;
                        }
                        jobResult.add(new Boolean(false));
                        continue;
                    }
                    jobResult.add(new Boolean(false));
                    continue;
                }
                statusCheck = false;
                startCheck = false;
                break;
            }
            if (statusCheck) {
                int i;
                if (start.getCondition_type() == 0) {
                    startCheck = true;
                    for (i = 0; i < jobResult.size(); ++i) {
                        if (((Boolean)jobResult.get(i)).booleanValue()) continue;
                        startCheck = false;
                        break;
                    }
                } else {
                    startCheck = false;
                    for (i = 0; i < jobResult.size(); ++i) {
                        if (!((Boolean)jobResult.get(i)).booleanValue()) continue;
                        startCheck = true;
                        break;
                    }
                }
                if (startCheck && startTime != null) {
                    JobSessionLocal session = JobSessionUtil.getLocalHome().findByPrimaryKey(sessionId);
                    Date sessionDate = session.getSchedule_date();
                    session = null;
                    Date now = new Date();
                    Calendar work = Calendar.getInstance();
                    Calendar time = Calendar.getInstance();
                    work.setTime(startTime.getStart_time());
                    work.getTime();
                    time.set(11, work.get(11));
                    time.set(12, work.get(12));
                    time.set(13, work.get(13));
                    time.set(14, 0);
                    Date startDate = time.getTime();
                    startCheck = startDate.after(sessionDate) && startDate.before(now);
                }
            }
        }
        if (!startCheck) {
            boolean possibility = true;
            if (start.getCondition_type() == 0) {
                if (statusCheck) {
                    possibility = false;
                }
            } else if (statusCheck && startTime == null) {
                possibility = false;
            }
            if (!possibility && start.getUnmatch_end_flg() == 1) {
                sessionJob.setStatus(new Integer(300));
                sessionJob.setEnd_value(start.getUnmatch_end_value());
                sessionJob.setEnd_date(new Date());
                this.endJob(sessionJob.getSession_id(), sessionJob.getJob_id());
            }
        }
        return startCheck;
    }

    protected Integer getEndStatus(JobSessionJobLocal sessionJob) throws FinderException, NamingException {
        JobInfoLocal job;
        Collection collection;
        m_log.debug((Object)("getEndStatus() : sessionId=" + sessionJob.getSession_id() + ", jobId=" + sessionJob.getJob_id()));
        Integer status = null;
        if (sessionJob.getEnd_value() instanceof Integer && (collection = (job = sessionJob.getJobInfo()).getJobEndInfo()) != null && collection.size() > 0) {
            for (JobEndInfoLocal end : collection) {
                if (end.getEnd_value().compareTo(sessionJob.getEnd_value()) != 0) continue;
                status = end.getEnd_status();
                break;
            }
        }
        return status;
    }

    protected boolean startNode(String sessionId, String jobId, String facilityId) throws FinderException, NamingException {
        m_log.debug((Object)("startNode() : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId));
        this.checkTimeout(sessionId, jobId);
        boolean startCommand = false;
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        JobInfoLocal job = sessionJob.getJobInfo();
        JobCommandInfoLocal command = job.getJobCommandInfo();
        Collection collection = sessionJob.getJobSessionNode();
        if (collection != null && collection.size() > 0) {
            boolean run = true;
            if (command.getProcess_mode() == 1) {
                for (JobSessionNodeLocal sessionNode : collection) {
                    if (sessionNode.getStatus() != 100) continue;
                    run = false;
                }
            }
            if (run) {
                for (JobSessionNodeLocal sessionNode : collection) {
                    if ((facilityId == null || facilityId != null && facilityId.compareTo(sessionNode.getFacility_id()) == 0) && sessionNode.getStatus() == 0) {
                        sessionNode.setStatus(new Integer(100));
                        RunInstructionInfo info = new RunInstructionInfo();
                        info.setSessionId(sessionJob.getSession_id());
                        info.setJobId(sessionJob.getJob_id());
                        info.setFacilityId(sessionNode.getFacility_id());
                        info.setCommandType(3);
                        sessionNode.setAgent_check(new Integer(1));
                        sessionNode.setCheck_date(new Date());
                        try {
                            m_log.debug((Object)("startNode() : \u30a8\u30fc\u30b8\u30a7\u30f3\u30c8\u30c1\u30a7\u30c3\u30af\u9001\u4fe1 : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + sessionNode.getFacility_id()));
                            SendTopic send = new SendTopic("topic/clustercontrol/JobManagement/execute");
                            send.put(info);
                            startCommand = true;
                        }
                        catch (Exception e) {
                            m_log.debug((Object)("startNode() : \u30a8\u30fc\u30b8\u30a7\u30f3\u30c8\u30c1\u30a7\u30c3\u30af\u9001\u4fe1\u30a8\u30e9\u30fc : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + sessionNode.getFacility_id() + ", " + e.getMessage()));
                        }
                        sessionNode = null;
                        if (command.getProcess_mode() == 1) break;
                    }
                    sessionNode = null;
                }
            }
        }
        return startCommand;
    }

    protected void checkTimeout(String sessionId, String jobId) throws FinderException, NamingException {
        m_log.debug((Object)("checkTimeout() : sessionId=" + sessionId + ", jobId=" + jobId));
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        Collection collection = sessionJob.getJobSessionNode();
        if (collection != null && collection.size() > 0) {
            for (JobSessionNodeLocal sessionNode : collection) {
                if (sessionNode.getStatus() == 100) {
                    String facilityId = sessionNode.getFacility_id();
                    Boolean retry = null;
                    Calendar checkTime = Calendar.getInstance();
                    checkTime.setTime(sessionNode.getCheck_date());
                    checkTime.add(13, m_messageTimeout);
                    Date now = new Date();
                    if (sessionNode.getAgent_check() == 1) {
                        if (now.after(checkTime.getTime())) {
                            retry = sessionNode.getRetry_count().compareTo(m_messageRetry) >= 0 ? new Boolean(false) : new Boolean(true);
                        }
                    } else if (sessionNode.getAgent_check() == 2 && sessionNode.getStart_date() == null && now.after(checkTime.getTime())) {
                        retry = sessionNode.getRetry_count().compareTo(m_messageRetry) >= 0 ? new Boolean(false) : new Boolean(true);
                    }
                    if (retry != null) {
                        RunInfo info;
                        if (retry.booleanValue()) {
                            info = new RunInstructionInfo();
                            info.setSessionId(sessionJob.getSession_id());
                            info.setJobId(sessionJob.getJob_id());
                            info.setFacilityId(sessionNode.getFacility_id());
                            info.setCommandType(3);
                            sessionNode.setAgent_check(new Integer(1));
                            sessionNode.setCheck_date(checkTime.getTime());
                            int retryCount = sessionNode.getRetry_count();
                            sessionNode.setRetry_count(new Integer(++retryCount));
                            sessionNode = null;
                            try {
                                m_log.debug((Object)("checkTimeout() : \u30a8\u30fc\u30b8\u30a7\u30f3\u30c8\u30c1\u30a7\u30c3\u30af\u9001\u4fe1 : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId + ", retry=" + retryCount));
                                SendTopic send = new SendTopic("topic/clustercontrol/JobManagement/execute");
                                send.put((RunInstructionInfo)info);
                            }
                            catch (Exception e) {
                                m_log.debug((Object)("checkTimeout() : \u30a8\u30fc\u30b8\u30a7\u30f3\u30c8\u30c1\u30a7\u30c3\u30af\u9001\u4fe1\u30a8\u30e9\u30fc : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId + ", " + e.getMessage()));
                            }
                        } else {
                            sessionNode.setAgent_check(new Integer(3));
                            m_log.debug((Object)("checkTimeout() : \u30a8\u30fc\u30b8\u30a7\u30f3\u30c8\u30c1\u30a7\u30c3\u30afNG : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId));
                            info = new RunResultInfo();
                            info.setSessionId(sessionJob.getSession_id());
                            info.setJobId(sessionJob.getJob_id());
                            info.setFacilityId(sessionNode.getFacility_id());
                            info.setCommandType(0);
                            ((RunResultInfo)info).setStatus(2);
                            ((RunResultInfo)info).setMessage("Agent Timeout Error");
                            ((RunResultInfo)info).setErrorMessage("");
                            sessionNode = null;
                            this.endNode((RunResultInfo)info);
                        }
                    }
                }
                sessionNode = null;
            }
        }
    }

    protected void endJob(String sessionId, String jobId) throws FinderException, NamingException {
        m_log.debug((Object)("endJob() : sessionId=" + sessionId + ", jobId=" + jobId));
        Collection collection = JobStartJobInfoUtil.getLocalHome().findByTargetJobId(sessionId, jobId);
        if (collection != null && collection.size() > 0) {
            for (JobStartJobInfoLocal startJob : collection) {
                JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(startJob.getSession_id(), startJob.getJob_id()));
                String startSessionId = sessionJob.getSession_id();
                String startJobId = sessionJob.getJob_id();
                int status = sessionJob.getStatus();
                sessionJob = null;
                startJob = null;
                if (status == 300 || status == 301) {
                    this.endJob(startSessionId, startJobId);
                    continue;
                }
                this.startJobMain1(startSessionId, startJobId, null);
            }
        } else {
            JobSessionJobLocal parentSessionJob;
            JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
            JobRelationInfoLocal relation = sessionJob.getJobRelationInfo();
            String parentJobId = relation.getParent_job_id();
            relation = null;
            boolean endAll = true;
            Collection sameHierarchy = JobRelationInfoUtil.getLocalHome().findByParentJobId(sessionId, parentJobId);
            for (JobRelationInfoLocal relation1 : sameHierarchy) {
                JobSessionJobLocal sessionJob1 = relation1.getJobSessionJob();
                if (sessionJob1.getStatus() == 300 || sessionJob1.getStatus() == 301) continue;
                endAll = false;
                break;
            }
            if (endAll && parentJobId.compareTo("TOP") != 0 && (parentSessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, parentJobId))).getStatus() == 100) {
                parentSessionJob = null;
                Integer endStatus = this.checkEndStatus(sessionId, parentJobId);
                this.setEndStaus(sessionId, parentJobId, new Integer(300), endStatus, null);
                new Notice().notify(sessionId, parentJobId, endStatus);
                this.endJob(sessionId, parentJobId);
            }
        }
    }

    protected Integer checkEndStatus(String sessionId, String jobId) throws FinderException, NamingException {
        m_log.debug((Object)("checkEndStatus() : sessionId=" + sessionId + ", jobId=" + jobId));
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        JobEndInfoLocal endInfoNormal = JobEndInfoUtil.getLocalHome().findByPrimaryKey(new JobEndInfoPK(sessionId, jobId, new Integer(0)));
        JobEndInfoLocal endInfoWarning = JobEndInfoUtil.getLocalHome().findByPrimaryKey(new JobEndInfoPK(sessionId, jobId, new Integer(1)));
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        if (sessionJob.getJobInfo().getJob_type() == 2) {
            JobInfoLocal job = sessionJob.getJobInfo();
            JobCommandInfoLocal command = job.getJobCommandInfo();
            Collection collection = sessionJob.getJobSessionNode();
            for (JobSessionNodeLocal sessionNode : collection) {
                Integer endValue = sessionNode.getEnd_value();
                if (!(endValue instanceof Integer)) continue;
                Integer status = null;
                if (endValue.compareTo(endInfoNormal.getEnd_value_from()) >= 0 && endValue.compareTo(endInfoNormal.getEnd_value_to()) <= 0) {
                    status = new Integer(0);
                    statusList.add(status);
                } else if (endValue.compareTo(endInfoWarning.getEnd_value_from()) >= 0 && endValue.compareTo(endInfoWarning.getEnd_value_to()) <= 0) {
                    status = new Integer(1);
                    statusList.add(status);
                } else {
                    status = new Integer(2);
                    statusList.add(status);
                }
                if (command.getProcess_mode() != 1 || status != 0) continue;
                statusList.clear();
                statusList.add(new Integer(0));
                break;
            }
        } else {
            Integer endStatusCheck = sessionJob.getEnd_staus_check_flg();
            if (endStatusCheck == null || endStatusCheck != null && endStatusCheck == 0) {
                Collection collection = JobRelationInfoUtil.getLocalHome().findByParentJobId(sessionId, jobId);
                for (JobRelationInfoLocal relation : collection) {
                    JobSessionJobLocal childSessionJob = relation.getJobSessionJob();
                    Collection targetJobList = JobStartJobInfoUtil.getLocalHome().findByTargetJobId(sessionId, childSessionJob.getJob_id());
                    if (targetJobList != null && (targetJobList == null || targetJobList.size() != 0)) continue;
                    Integer endValue = childSessionJob.getEnd_value();
                    if (endValue.compareTo(endInfoNormal.getEnd_value_from()) >= 0 && endValue.compareTo(endInfoNormal.getEnd_value_to()) <= 0) {
                        statusList.add(new Integer(0));
                        continue;
                    }
                    if (endValue.compareTo(endInfoWarning.getEnd_value_from()) >= 0 && endValue.compareTo(endInfoWarning.getEnd_value_to()) <= 0) {
                        statusList.add(new Integer(1));
                        continue;
                    }
                    statusList.add(new Integer(2));
                }
            } else {
                Collection collection = JobRelationInfoUtil.getLocalHome().findByParentJobId(sessionId, jobId);
                for (JobRelationInfoLocal relation : collection) {
                    JobSessionJobLocal childSessionJob = relation.getJobSessionJob();
                    Integer endValue = childSessionJob.getEnd_value();
                    if (endValue.compareTo(endInfoNormal.getEnd_value_from()) >= 0 && endValue.compareTo(endInfoNormal.getEnd_value_to()) <= 0) {
                        statusList.add(new Integer(0));
                        continue;
                    }
                    if (endValue.compareTo(endInfoWarning.getEnd_value_from()) >= 0 && endValue.compareTo(endInfoWarning.getEnd_value_to()) <= 0) {
                        statusList.add(new Integer(1));
                        continue;
                    }
                    statusList.add(new Integer(2));
                }
            }
        }
        Integer endStatus = EndJudgment.judgment(statusList);
        return endStatus;
    }

    protected void setEndStaus(String sessionId, String jobId, Integer status, Integer endStatus, String result) throws FinderException, NamingException {
        m_log.debug((Object)("setEndStaus() : sessionId=" + sessionId + ", jobId=" + jobId));
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        JobEndInfoLocal endInfoNormal = JobEndInfoUtil.getLocalHome().findByPrimaryKey(new JobEndInfoPK(sessionId, jobId, new Integer(0)));
        JobEndInfoLocal endInfoWarning = JobEndInfoUtil.getLocalHome().findByPrimaryKey(new JobEndInfoPK(sessionId, jobId, new Integer(1)));
        JobEndInfoLocal endInfoAbnormal = JobEndInfoUtil.getLocalHome().findByPrimaryKey(new JobEndInfoPK(sessionId, jobId, new Integer(2)));
        sessionJob.setStatus(status);
        sessionJob.setEnd_status(endStatus);
        if (endInfoNormal.getEnd_status().compareTo(endStatus) == 0) {
            sessionJob.setEnd_value(endInfoNormal.getEnd_value());
        } else if (endInfoWarning.getEnd_status().compareTo(endStatus) == 0) {
            sessionJob.setEnd_value(endInfoWarning.getEnd_value());
        } else if (endInfoAbnormal.getEnd_status().compareTo(endStatus) == 0) {
            sessionJob.setEnd_value(endInfoAbnormal.getEnd_value());
        }
        sessionJob.setEnd_date(new Date());
        sessionJob.setResult(result);
    }

    public void endNode(RunResultInfo info) throws FinderException, NamingException {
        m_log.debug((Object)("endNode() : sessionId=" + info.getSessionId() + ", jobId=" + info.getJobId() + ", facilityId=" + info.getFacilityId()));
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(info.getSessionId(), info.getJobId()));
        JobInfoLocal job = sessionJob.getJobInfo();
        JobCommandInfoLocal command = job.getJobCommandInfo();
        if (info.getCommandType() == 3) {
            JobSessionNodeLocal sessionNode = JobSessionNodeUtil.getLocalHome().findByPrimaryKey(new JobSessionNodePK(info.getSessionId(), info.getJobId(), info.getFacilityId()));
            if (sessionNode.getStatus() == 100) {
                if (sessionNode.getAgent_check() == 1) {
                    JobSessionJobLocal argumentSessionJob;
                    sessionNode.setAgent_check(new Integer(2));
                    sessionNode.setCheck_date(new Date());
                    RunInstructionInfo instructionInfo = new RunInstructionInfo();
                    instructionInfo.setSessionId(sessionJob.getSession_id());
                    instructionInfo.setJobId(sessionJob.getJob_id());
                    instructionInfo.setFacilityId(sessionNode.getFacility_id());
                    instructionInfo.setCommand(command.getStart_command());
                    instructionInfo.setUser(command.getEffective_user());
                    instructionInfo.setCommandType(0);
                    if (instructionInfo.getCommand().equals("addPublicKey") || instructionInfo.getCommand().equals("deletePublicKey")) {
                        argumentSessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(info.getSessionId(), command.getArgument_job_id()));
                        String result = argumentSessionJob.getResult();
                        argumentSessionJob = null;
                        instructionInfo.setPublicKey(result);
                    } else if (instructionInfo.getCommand().equals("getFileList")) {
                        instructionInfo.setFilePath(command.getArgument());
                    } else if (instructionInfo.getCommand().equals("getCheckSum")) {
                        instructionInfo.setFilePath(command.getArgument());
                    } else if (instructionInfo.getCommand().equals("checkCheckSum")) {
                        argumentSessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(info.getSessionId(), command.getArgument_job_id()));
                        String result = argumentSessionJob.getResult();
                        argumentSessionJob = null;
                        instructionInfo.setCheckSum(result);
                        instructionInfo.setFilePath(command.getArgument());
                    }
                    sessionNode = null;
                    try {
                        SendTopic send = new SendTopic("topic/clustercontrol/JobManagement/execute");
                        send.put(instructionInfo);
                    }
                    catch (Exception e) {
                        m_log.debug((Object)("endNode() : \u5b9f\u884c\u6307\u793a\u9001\u4fe1\u30a8\u30e9\u30fc : " + e.getMessage()));
                    }
                }
            } else if (sessionNode.getStatus() != 300 && sessionNode.getStatus() != 301 && sessionNode.getStatus() != 400 && sessionNode.getStatus() != 201 && sessionNode.getStatus() != 200) {
                sessionNode = null;
                try {
                    m_log.debug((Object)"endNode() : \u5b9f\u884c\u7d50\u679c\u3092Queue\u306e\u6700\u5f8c\u306b\u307e\u308f\u3059");
                    SendQueue queue = new SendQueue("queue/clustercontrol/JobManagement/status");
                    queue.put(info);
                }
                catch (Exception e) {
                    m_log.debug((Object)("endNode() : \u5b9f\u884c\u7d50\u679c\u3092\u518d\u53d7\u4fe1 : " + e.getMessage()));
                }
            }
        } else if (info.getCommandType() == 0) {
            JobSessionNodeLocal sessionNode = JobSessionNodeUtil.getLocalHome().findByPrimaryKey(new JobSessionNodePK(info.getSessionId(), info.getJobId(), info.getFacilityId()));
            if (info.getStatus() == 0) {
                if (sessionNode.getStart_date() == null) {
                    sessionNode.setStart_date(info.getTime());
                } else {
                    m_log.debug((Object)("endNode() : \u53d7\u4fe1\u6e08\u307f\u306e\u5b9f\u884c\u958b\u59cb\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u53d7\u4fe1\u3057\u307e\u3057\u305f\u3002 \u7834\u68c4\u3057\u307e\u3059\u3002 sessionId=" + info.getSessionId() + ", jobId=" + info.getJobId() + ", facilityId=" + info.getFacilityId()));
                }
                sessionNode = null;
            } else {
                if (info.getStatus() == 1) {
                    if (sessionJob.getStart_date() instanceof Date || sessionNode.getStart_date() instanceof Date) {
                        if (sessionJob.getEnd_date() == null || sessionJob.getStatus() == 200) {
                            if (sessionNode.getStatus() == 100) {
                                sessionNode.setStatus(new Integer(300));
                                sessionNode.setEnd_date(info.getTime());
                            } else if (sessionNode.getStatus() == 101) {
                                sessionNode.setStatus(new Integer(201));
                            }
                            sessionNode.setEnd_value(new Integer(info.getEndValue()));
                            sessionNode.setMessage(info.getMessage() + info.getErrorMessage());
                            if (info.getCommand().equals("getPublicKey")) {
                                sessionNode.setResult(info.getPublicKey());
                            } else if (info.getCommand().equals("getCheckSum")) {
                                sessionNode.setResult(info.getCheckSum());
                            }
                        } else {
                            m_log.debug((Object)("endNode() : \u53d7\u4fe1\u6e08\u307f\u306e\u5b9f\u884c\u7d42\u4e86\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u53d7\u4fe1\u3057\u307e\u3057\u305f\u3002 \u7834\u68c4\u3057\u307e\u3059\u3002 sessionId=" + info.getSessionId() + ", jobId=" + info.getJobId() + ", facilityId=" + info.getFacilityId()));
                        }
                    } else {
                        try {
                            m_log.debug((Object)"endNode() : \u5b9f\u884c\u7d50\u679c\u3092Queue\u306e\u6700\u5f8c\u306b\u307e\u308f\u3059");
                            SendQueue queue = new SendQueue("queue/clustercontrol/JobManagement/status");
                            queue.put(info);
                        }
                        catch (Exception e) {
                            m_log.debug((Object)("endNode() : \u5b9f\u884c\u7d50\u679c\u9001\u4fe1\u30a8\u30e9\u30fc : " + e.getMessage()));
                        }
                    }
                } else if (info.getStatus() == 2) {
                    if (sessionNode.getStatus() == 100) {
                        if (command.getError_end_flg() == 1) {
                            sessionNode.setStatus(new Integer(300));
                            sessionNode.setEnd_date(new Date());
                            sessionNode.setEnd_value(command.getError_end_value());
                        } else {
                            sessionNode.setStatus(new Integer(400));
                        }
                    } else if (sessionNode.getStatus() == 101) {
                        sessionNode.setStatus(new Integer(201));
                    }
                    sessionNode.setMessage(info.getMessage() + info.getErrorMessage());
                }
                if (sessionNode.getStatus() == 201) {
                    sessionNode = null;
                    if (sessionJob.getStatus() == 101 && this.checkAllNodeStop(sessionJob)) {
                        sessionJob.setStatus(new Integer(201));
                        this.stopJob(info.getSessionId(), info.getJobId());
                    }
                } else {
                    String result = sessionNode.getResult();
                    sessionNode = null;
                    if (sessionJob.getStatus() != 200 && this.checkJobEnd(sessionJob)) {
                        Integer endStatus = this.checkEndStatus(info.getSessionId(), info.getJobId());
                        if (endStatus == 0 && info.getCommand().equals("getFileList")) {
                            new CreateFileJob().createFileJobNet(info.getSessionId(), info.getJobId(), info.getFileList());
                        }
                        this.setEndStaus(info.getSessionId(), info.getJobId(), new Integer(300), endStatus, result);
                        new Notice().notify(info.getSessionId(), info.getJobId(), endStatus);
                        this.endJob(info.getSessionId(), info.getJobId());
                    }
                }
            }
        } else if (info.getCommandType() == 1 && info.getStatus() == 1) {
            JobSessionNodeLocal sessionNode = JobSessionNodeUtil.getLocalHome().findByPrimaryKey(new JobSessionNodePK(info.getSessionId(), info.getJobId(), info.getFacilityId()));
            sessionNode.setStatus(new Integer(201));
            sessionNode = null;
            if (sessionJob.getStatus() == 101 && this.checkAllNodeStop(sessionJob)) {
                sessionJob.setStatus(new Integer(201));
                this.stopJob(info.getSessionId(), info.getJobId());
            }
        }
    }

    protected boolean checkJobNetEnd(String sessionId, String jobId) throws FinderException, NamingException {
        m_log.debug((Object)("checkJobNetEnd() : sessionId=" + sessionId + ", jobId=" + jobId));
        boolean endAll = true;
        Collection sameHierarchy = JobRelationInfoUtil.getLocalHome().findByParentJobId(sessionId, jobId);
        for (JobRelationInfoLocal relation1 : sameHierarchy) {
            JobSessionJobLocal sessionJob1 = relation1.getJobSessionJob();
            if (sessionJob1.getStatus() == 300 || sessionJob1.getStatus() == 301) continue;
            endAll = false;
            break;
        }
        return endAll;
    }

    protected boolean checkJobEnd(JobSessionJobLocal sessionJob) throws FinderException, NamingException {
        m_log.debug((Object)("checkJobEnd() : sessionId=" + sessionJob.getSession_id() + ", jobId=" + sessionJob.getJob_id()));
        JobInfoLocal job = sessionJob.getJobInfo();
        JobCommandInfoLocal command = job.getJobCommandInfo();
        boolean end = false;
        if (command.getProcess_mode() == 1) {
            Integer endStatus = this.checkEndStatus(sessionJob.getSession_id(), sessionJob.getJob_id());
            if (endStatus instanceof Integer && endStatus == 0) {
                end = true;
            } else if (!this.startNode(sessionJob.getSession_id(), sessionJob.getJob_id(), null)) {
                end = true;
            }
        } else {
            end = this.checkAllNodeEnd(sessionJob);
        }
        return end;
    }

    protected boolean checkAllNodeEnd(JobSessionJobLocal sessionJob) throws FinderException, NamingException {
        m_log.debug((Object)("checkAllNodeEnd() : sessionId=" + sessionJob.getSession_id() + ", jobId=" + sessionJob.getJob_id()));
        boolean end = false;
        boolean runNode = false;
        Collection collection = sessionJob.getJobSessionNode();
        if (collection != null && collection.size() > 0) {
            for (JobSessionNodeLocal sessionNode : collection) {
                if (sessionNode.getStatus() == 300 || sessionNode.getStatus() == 301) continue;
                runNode = true;
            }
        }
        if (!runNode) {
            end = true;
        }
        return end;
    }

    protected boolean checkAllNodeStop(JobSessionJobLocal sessionJob) throws FinderException, NamingException {
        m_log.debug((Object)("checkAllNodeStop() : sessionId=" + sessionJob.getSession_id() + ", jobId=" + sessionJob.getJob_id()));
        boolean stop = false;
        boolean runNode = false;
        Collection collection = sessionJob.getJobSessionNode();
        if (collection != null && collection.size() > 0) {
            for (JobSessionNodeLocal sessionNode : collection) {
                if (sessionNode.getStatus() != 101 && sessionNode.getStatus() != 100) continue;
                runNode = true;
            }
        }
        if (!runNode) {
            stop = true;
        }
        return stop;
    }

    public void startJob(String sessionId, String jobId, String facilityId) throws FinderException, NamingException, EJBException, RemoveException {
        m_log.debug((Object)("startJob() : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId));
        this.clearStatus(sessionId, jobId, facilityId);
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        JobRelationInfoLocal relation = sessionJob.getJobRelationInfo();
        String parentJobId = relation.getParent_job_id();
        relation = null;
        if (parentJobId.compareTo("TOP") == 0) {
            sessionJob.setStatus(new Integer(100));
            sessionJob.setStart_date(new Date());
            new Notice().notify(sessionId, jobId, new Integer(3));
        } else {
            this.setStatus(sessionId, parentJobId, new Integer(100));
        }
        JobInfoLocal job = sessionJob.getJobInfo();
        sessionJob = null;
        if (job.getJob_type() == 0) {
            this.startJob(sessionId, jobId);
        } else {
            this.startJobMain1(sessionId, jobId, facilityId);
        }
    }

    protected void clearStatus(String sessionId, String jobId, String facilityId) throws FinderException, NamingException, EJBException, RemoveException {
        block11: {
            JobSessionJobLocal sessionJob;
            block14: {
                JobInfoLocal job;
                block12: {
                    block13: {
                        m_log.debug((Object)("clearStatus() : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId));
                        sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
                        if (sessionJob == null) break block11;
                        job = sessionJob.getJobInfo();
                        JobStartInfoLocal start = job.getJobStartInfo();
                        sessionJob.setEnd_status(null);
                        sessionJob.setEnd_value(null);
                        sessionJob.setEnd_date(null);
                        sessionJob.setStart_date(null);
                        sessionJob.setResult(null);
                        if (start != null) {
                            if (start.getSuspend() == 1) {
                                sessionJob.setStatus(new Integer(1));
                            } else if (start.getSkip() == 1) {
                                sessionJob.setStatus(new Integer(2));
                                sessionJob.setEnd_value(start.getSkip_end_value());
                            } else {
                                sessionJob.setStatus(new Integer(0));
                            }
                        } else {
                            sessionJob.setStatus(new Integer(0));
                        }
                        if (job.getJob_type() != 2) break block12;
                        if (facilityId == null || facilityId.length() <= 0) break block13;
                        sessionJob = null;
                        JobSessionNodeLocal sessionNode = JobSessionNodeUtil.getLocalHome().findByPrimaryKey(new JobSessionNodePK(sessionId, jobId, facilityId));
                        sessionNode.setStatus(new Integer(0));
                        sessionNode.setEnd_value(null);
                        sessionNode.setEnd_date(null);
                        sessionNode.setStart_date(null);
                        sessionNode.setAgent_check(null);
                        sessionNode.setCheck_date(null);
                        sessionNode.setRetry_count(new Integer(0));
                        sessionNode.setResult(null);
                        break block11;
                    }
                    Collection collection = sessionJob.getJobSessionNode();
                    sessionJob = null;
                    if (collection == null || collection.size() <= 0) break block11;
                    for (JobSessionNodeLocal sessionNode : collection) {
                        sessionNode.setStatus(new Integer(0));
                        sessionNode.setEnd_value(null);
                        sessionNode.setEnd_date(null);
                        sessionNode.setStart_date(null);
                        sessionNode.setAgent_check(null);
                        sessionNode.setCheck_date(null);
                        sessionNode.setRetry_count(new Integer(0));
                        sessionNode.setResult(null);
                    }
                    break block11;
                }
                if (job.getJob_type() != 3) break block14;
                sessionJob = null;
                Collection collection = JobRelationInfoUtil.getLocalHome().findByParentJobId(sessionId, jobId);
                if (collection == null || collection.size() <= 0) break block11;
                for (JobRelationInfoLocal relation : collection) {
                    if (relation.getJob_id().equals(jobId + "_FILE_LIST")) {
                        this.clearStatus(relation.getSession_id(), relation.getJob_id(), null);
                        continue;
                    }
                    this.clearJob(relation.getSession_id(), relation.getJob_id());
                }
                break block11;
            }
            sessionJob = null;
            Collection collection = JobRelationInfoUtil.getLocalHome().findByParentJobId(sessionId, jobId);
            if (collection != null && collection.size() > 0) {
                for (JobRelationInfoLocal relation : collection) {
                    this.clearStatus(relation.getSession_id(), relation.getJob_id(), null);
                }
            }
        }
    }

    protected void clearJob(String sessionId, String jobId) throws FinderException, NamingException, EJBException, RemoveException {
        m_log.debug((Object)("clearJob() : sessionId=" + sessionId + ", jobId=" + jobId));
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        if (sessionJob != null) {
            JobInfoLocal job = sessionJob.getJobInfo();
            if (job.getJob_type() == 2) {
                int j;
                JobStartInfoLocal start;
                JobFileInfoLocal file;
                JobCommandInfoLocal command;
                JobRelationInfoLocal relation;
                Collection collection = sessionJob.getJobSessionNode();
                if (collection != null && collection.size() > 0) {
                    Object[] sessionNodeArray = collection.toArray();
                    for (int j2 = 0; j2 < sessionNodeArray.length; ++j2) {
                        JobSessionNodeLocal sessionNode = (JobSessionNodeLocal)sessionNodeArray[j2];
                        if (sessionNode == null) continue;
                        sessionNode.remove();
                    }
                }
                if ((relation = sessionJob.getJobRelationInfo()) != null) {
                    relation.remove();
                }
                if ((command = job.getJobCommandInfo()) != null) {
                    command.remove();
                }
                if ((file = job.getJobFileInfo()) != null) {
                    file.remove();
                }
                if ((start = job.getJobStartInfo()) != null) {
                    start.remove();
                }
                if ((collection = job.getJobNoticeInfo()) != null && collection.size() > 0) {
                    Object[] noticeArray = collection.toArray();
                    for (j = 0; j < noticeArray.length; ++j) {
                        JobNoticeInfoLocal notice = (JobNoticeInfoLocal)noticeArray[j];
                        if (notice == null) continue;
                        notice.remove();
                    }
                }
                if ((collection = job.getJobEndInfo()) != null && collection.size() > 0) {
                    Object[] endArray = collection.toArray();
                    for (j = 0; j < endArray.length; ++j) {
                        JobEndInfoLocal end = (JobEndInfoLocal)endArray[j];
                        if (end == null) continue;
                        end.remove();
                    }
                }
                job.remove();
                sessionJob.remove();
            } else {
                int j;
                JobStartInfoLocal start;
                JobFileInfoLocal file;
                JobCommandInfoLocal command;
                JobRelationInfoLocal relation;
                Collection collection = JobRelationInfoUtil.getLocalHome().findByParentJobId(sessionId, jobId);
                if (collection != null && collection.size() > 0) {
                    for (JobRelationInfoLocal relation2 : collection) {
                        this.clearJob(relation2.getSession_id(), relation2.getJob_id());
                    }
                }
                if ((relation = sessionJob.getJobRelationInfo()) != null) {
                    relation.remove();
                }
                if ((command = job.getJobCommandInfo()) != null) {
                    command.remove();
                }
                if ((file = job.getJobFileInfo()) != null) {
                    file.remove();
                }
                if ((start = job.getJobStartInfo()) != null) {
                    start.remove();
                }
                if ((collection = job.getJobNoticeInfo()) != null && collection.size() > 0) {
                    Object[] noticeArray = collection.toArray();
                    for (j = 0; j < noticeArray.length; ++j) {
                        JobNoticeInfoLocal notice = (JobNoticeInfoLocal)noticeArray[j];
                        if (notice == null) continue;
                        notice.remove();
                    }
                }
                if ((collection = job.getJobEndInfo()) != null && collection.size() > 0) {
                    Object[] endArray = collection.toArray();
                    for (j = 0; j < endArray.length; ++j) {
                        JobEndInfoLocal end = (JobEndInfoLocal)endArray[j];
                        if (end == null) continue;
                        end.remove();
                    }
                }
                job.remove();
                sessionJob.remove();
            }
        }
    }

    protected void setStatus(String sessionId, String jobId, Integer status) throws FinderException, NamingException {
        m_log.debug((Object)("setStatus() : sessionId=" + sessionId + ", jobId=" + jobId + ", status=" + status));
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        if (sessionJob != null) {
            sessionJob.setStatus(status);
            JobRelationInfoLocal relation = sessionJob.getJobRelationInfo();
            String parentJobId = relation.getParent_job_id();
            relation = null;
            if (parentJobId.compareTo("TOP") != 0) {
                this.setStatus(sessionId, parentJobId, status);
            }
        }
    }

    public void waitJob(String sessionId, String jobId) throws FinderException, NamingException {
        m_log.debug((Object)("waitJob() : sessionId=" + sessionId + ", jobId=" + jobId));
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        if (sessionJob != null && sessionJob.getStatus() == 0) {
            sessionJob.setStatus(new Integer(1));
        }
    }

    public void releaseWaitJob(String sessionId, String jobId) throws FinderException, NamingException {
        m_log.debug((Object)("releaseWaitJob() : sessionId=" + sessionId + ", jobId=" + jobId));
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        if (sessionJob != null && sessionJob.getStatus() == 1) {
            sessionJob.setStatus(new Integer(0));
        }
    }

    public void skipJob(String sessionId, String jobId, Integer endValue) throws FinderException, NamingException {
        m_log.debug((Object)("skipJob() : sessionId=" + sessionId + ", jobId=" + jobId + ", endValue=" + endValue));
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        if (sessionJob != null && sessionJob.getStatus() == 0) {
            sessionJob.setStatus(new Integer(2));
            sessionJob.setEnd_value(endValue);
        }
    }

    public void releaseSkipJob(String sessionId, String jobId) throws FinderException, NamingException {
        m_log.debug((Object)("releaseSkipJob() : sessionId=" + sessionId + ", jobId=" + jobId));
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        if (sessionJob != null && sessionJob.getStatus() == 2) {
            sessionJob.setStatus(new Integer(0));
            sessionJob.setEnd_value(null);
        }
    }

    public void suspendJob(String sessionId, String jobId) throws FinderException, NamingException {
        m_log.debug((Object)("suspendJob() : sessionId=" + sessionId + ", jobId=" + jobId));
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        if (sessionJob != null && sessionJob.getStatus() == 100) {
            sessionJob.setStatus(new Integer(200));
            sessionJob.setEnd_date(new Date());
            Collection collection = JobRelationInfoUtil.getLocalHome().findByStatus(sessionId, jobId, new Integer(100));
            if (collection != null && collection.size() > 0) {
                for (JobRelationInfoLocal relation : collection) {
                    this.suspendJob(relation.getSession_id(), relation.getJob_id());
                }
            }
        }
    }

    public void releaseSuspendJob(String sessionId, String jobId) throws FinderException, NamingException {
        m_log.debug((Object)("releaseSuspendJob() : sessionId=" + sessionId + ", jobId=" + jobId));
        this.releaseSuspend(sessionId, jobId);
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        Collection collection = JobRelationInfoUtil.getLocalHome().findByStatus(sessionId, jobId, new Integer(200));
        if (collection != null && collection.size() > 0) {
            for (JobRelationInfoLocal relation : collection) {
                String relationJobId = relation.getJob_id();
                relation = null;
                this.releaseSuspendJob(sessionId, relationJobId);
            }
        }
        if (sessionJob != null) {
            boolean endAll = true;
            if (sessionJob.getJobInfo().getJob_type() == 2) {
                endAll = this.checkJobEnd(sessionJob);
            } else {
                Collection sameHierarchy = JobRelationInfoUtil.getLocalHome().findByParentJobId(sessionId, jobId);
                for (JobRelationInfoLocal relation1 : sameHierarchy) {
                    JobSessionJobLocal sessionJob1 = relation1.getJobSessionJob();
                    if (sessionJob1.getStatus() == 300 || sessionJob1.getStatus() == 301) continue;
                    endAll = false;
                    break;
                }
                Iterator itr = null;
                sameHierarchy = null;
            }
            if (endAll) {
                Integer endStatus = this.checkEndStatus(sessionId, jobId);
                this.setEndStaus(sessionId, jobId, new Integer(300), endStatus, null);
                new Notice().notify(sessionId, jobId, endStatus);
                JobRelationInfoLocal relation = sessionJob.getJobRelationInfo();
                String parentJobId = relation.getParent_job_id();
                relation = null;
                if (parentJobId.compareTo("TOP") != 0) {
                    this.endJob(sessionId, jobId);
                }
            }
        }
    }

    protected void releaseSuspend(String sessionId, String jobId) throws FinderException, NamingException {
        m_log.debug((Object)("releaseSuspend() : sessionId=" + sessionId + ", jobId=" + jobId));
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        if (sessionJob != null && sessionJob.getStatus() == 200) {
            sessionJob.setStatus(new Integer(100));
            JobRelationInfoLocal relation = sessionJob.getJobRelationInfo();
            String parentJobId = relation.getParent_job_id();
            relation = null;
            sessionJob = null;
            if (parentJobId.compareTo("TOP") != 0) {
                this.releaseSuspend(sessionId, parentJobId);
            }
        }
    }

    public void stopJob(String sessionId, String jobId, String facilityId) throws FinderException, NamingException {
        m_log.debug((Object)("stopJob() : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId));
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        if (sessionJob != null && sessionJob.getStatus() == 100) {
            if (facilityId != null && facilityId.length() > 0) {
                this.stopNode(sessionId, jobId, facilityId);
            } else {
                sessionJob.setStatus(new Integer(101));
                JobInfoLocal job = sessionJob.getJobInfo();
                if (job.getJob_type() == 2) {
                    this.stopNode(sessionId, jobId, null);
                    if (this.checkAllNodeStop(sessionJob)) {
                        sessionJob.setStatus(new Integer(201));
                        sessionJob = null;
                        this.stopJob(sessionId, jobId);
                    }
                } else {
                    Collection collection = JobRelationInfoUtil.getLocalHome().findByStatus(sessionId, jobId, new Integer(100));
                    if (collection != null && collection.size() > 0) {
                        for (JobRelationInfoLocal relation : collection) {
                            this.stopJob(relation.getSession_id(), relation.getJob_id(), null);
                        }
                    }
                    boolean endAll = true;
                    collection = JobRelationInfoUtil.getLocalHome().findByParentJobId(sessionId, jobId);
                    if (collection != null && collection.size() > 0) {
                        for (JobRelationInfoLocal relation1 : collection) {
                            JobSessionJobLocal sessionJob1 = relation1.getJobSessionJob();
                            relation1 = null;
                            int status = sessionJob1.getStatus();
                            sessionJob1 = null;
                            if (status != 101 && status != 100) continue;
                            endAll = false;
                            break;
                        }
                    }
                    if (endAll) {
                        sessionJob.setStatus(new Integer(201));
                        sessionJob = null;
                    }
                }
            }
        }
    }

    protected void stopJob(String sessionId, String jobId) throws FinderException, NamingException {
        JobSessionJobLocal parentSessionJob;
        m_log.debug((Object)("stopJob() : sessionId=" + sessionId + ", jobId=" + jobId));
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        JobRelationInfoLocal relation = sessionJob.getJobRelationInfo();
        String parentJobId = relation.getParent_job_id();
        relation = null;
        boolean endAll = true;
        Collection sameHierarchy = JobRelationInfoUtil.getLocalHome().findByParentJobId(sessionId, parentJobId);
        for (JobRelationInfoLocal relation1 : sameHierarchy) {
            JobSessionJobLocal sessionJob1 = relation1.getJobSessionJob();
            relation1 = null;
            int status = sessionJob1.getStatus();
            sessionJob1 = null;
            if (status != 101 && status != 100) continue;
            endAll = false;
            break;
        }
        sessionJob = null;
        if (endAll && parentJobId.compareTo("TOP") != 0 && (parentSessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, parentJobId))).getStatus() == 101) {
            parentSessionJob.setStatus(new Integer(201));
            parentSessionJob = null;
            this.stopJob(sessionId, parentJobId);
        }
    }

    protected void stopNode(String sessionId, String jobId, String facilityId) throws FinderException, NamingException {
        m_log.debug((Object)("stopNode() : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId));
        this.checkTimeout(sessionId, jobId);
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        JobInfoLocal job = sessionJob.getJobInfo();
        JobCommandInfoLocal command = job.getJobCommandInfo();
        if (facilityId != null && facilityId.length() > 0) {
            JobSessionNodeLocal sessionNode = JobSessionNodeUtil.getLocalHome().findByPrimaryKey(new JobSessionNodePK(sessionId, jobId, facilityId));
            if (sessionNode.getStatus() == 100) {
                if (sessionNode.getAgent_check() == 2 && command.getStop_command() != null && command.getStop_command().length() > 0) {
                    sessionNode.setStatus(new Integer(101));
                    RunInstructionInfo instructionInfo = new RunInstructionInfo();
                    instructionInfo.setSessionId(sessionNode.getSession_id());
                    instructionInfo.setJobId(sessionNode.getJob_id());
                    instructionInfo.setFacilityId(sessionNode.getFacility_id());
                    instructionInfo.setCommand(command.getStop_command());
                    instructionInfo.setUser(command.getEffective_user());
                    instructionInfo.setCommandType(1);
                    try {
                        SendTopic send = new SendTopic("topic/clustercontrol/JobManagement/execute");
                        send.put(instructionInfo);
                    }
                    catch (Exception e) {
                        m_log.debug((Object)("stopNode() : \u5b9f\u884c\u505c\u6b62\u9001\u4fe1\u30a8\u30e9\u30fc : " + e.getMessage()));
                    }
                } else {
                    sessionNode.setStatus(new Integer(201));
                }
            }
        } else {
            Collection collection = sessionJob.getJobSessionNode();
            if (collection != null && collection.size() > 0) {
                for (JobSessionNodeLocal sessionNode : collection) {
                    if (sessionNode.getStatus() != 100) continue;
                    if (sessionNode.getAgent_check() == 2 && command.getStop_command() != null && command.getStop_command().length() > 0) {
                        sessionNode.setStatus(new Integer(101));
                        RunInstructionInfo instructionInfo = new RunInstructionInfo();
                        instructionInfo.setSessionId(sessionNode.getSession_id());
                        instructionInfo.setJobId(sessionNode.getJob_id());
                        instructionInfo.setFacilityId(sessionNode.getFacility_id());
                        instructionInfo.setCommand(command.getStop_command());
                        instructionInfo.setUser(command.getEffective_user());
                        instructionInfo.setCommandType(1);
                        try {
                            SendTopic send = new SendTopic("topic/clustercontrol/JobManagement/execute");
                            send.put(instructionInfo);
                        }
                        catch (Exception e) {
                            m_log.debug((Object)("stopNode() : \u5b9f\u884c\u505c\u6b62\u9001\u4fe1\u30a8\u30e9\u30fc : " + e.getMessage()));
                        }
                        continue;
                    }
                    sessionNode.setStatus(new Integer(201));
                }
            }
        }
    }

    public void maintenanceJob(String sessionId, String jobId, String facilityId, Integer endValue) throws FinderException, NamingException {
        m_log.debug((Object)("maintenanceJob() : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId + ", endValue=" + endValue));
        if (facilityId != null && facilityId.length() > 0) {
            JobSessionNodeLocal sessionNode = JobSessionNodeUtil.getLocalHome().findByPrimaryKey(new JobSessionNodePK(sessionId, jobId, facilityId));
            if (sessionNode != null) {
                sessionNode.setStatus(new Integer(301));
                sessionNode.setEnd_value(endValue);
                sessionNode.setEnd_date(new Date());
                sessionNode = null;
                JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
                if (this.checkJobEnd(sessionJob)) {
                    sessionJob = null;
                    Integer endStatus = this.checkEndStatus(sessionId, jobId);
                    this.setEndStaus(sessionId, jobId, new Integer(300), endStatus, null);
                    new Notice().notify(sessionId, jobId, endStatus);
                    this.endJob(sessionId, jobId);
                }
            }
        } else {
            JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
            if (sessionJob != null) {
                sessionJob.setStatus(new Integer(301));
                sessionJob.setEnd_status(null);
                sessionJob.setEnd_value(endValue);
                sessionJob.setEnd_date(new Date());
                sessionJob = null;
                this.endJob(sessionId, jobId);
            }
        }
    }

    public String createJobInfo(String jobId) throws CreateException, FinderException, NamingException {
        m_log.debug((Object)("createJobInfo() : jobId=" + jobId));
        String sessionId = null;
        Date createTime = new Date();
        JobMasterLocal job = JobMasterUtil.getLocalHome().findByPrimaryKey(jobId);
        if (job != null) {
            boolean createFlg = false;
            int i = 0;
            while (!createFlg) {
                try {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                    sessionId = dateFormat.format(createTime);
                    DecimalFormat format = new DecimalFormat("-000");
                    sessionId = sessionId + format.format(i);
                    JobSessionUtil.getLocalHome().create(sessionId, job.getJob_id(), new Date(), new Integer(0));
                    createFlg = true;
                }
                catch (DuplicateKeyException e) {
                }
                catch (CreateException e) {
                    if (e.getMessage().indexOf("duplicate") != -1) {
                        throw new DuplicateKeyException();
                    }
                    throw e;
                }
                ++i;
            }
            this.createJobInfo(job, "TOP", sessionId);
        }
        return sessionId;
    }

    protected void createJobInfo(JobMasterLocal job, String parentJobId, String sessionId) throws CreateException, FinderException, NamingException {
        this.createJobInfoData(job, parentJobId, sessionId);
        Collection collection = null;
        try {
            collection = JobRelationMasterUtil.getLocalHome().findByParentJobId(job.getJob_id());
        }
        catch (FinderException e) {
        }
        catch (NamingException e) {
            // empty catch block
        }
        if (collection != null && collection.size() > 0) {
            for (JobRelationMasterLocal children : collection) {
                JobMasterLocal childJob = children.getJobMaster();
                this.createJobInfo(childJob, job.getJob_id(), sessionId);
            }
        }
    }

    protected void createJobInfoData(JobMasterLocal job, String parentJobId, String sessionId) throws CreateException, FinderException, NamingException {
        Collection endList;
        Collection noticeList;
        RepositoryControllerLocal repository = null;
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().create(sessionId, job.getJob_id(), null, new Integer(0), null, null, null, null, null, new Integer(0));
        JobRelationInfoUtil.getLocalHome().create(sessionId, job.getJob_id(), parentJobId);
        JobInfoUtil.getLocalHome().create(sessionId, job.getJob_id(), job.getJob_name(), job.getDescription(), job.getJob_type(), job.getReg_date(), job.getUpdate_date(), job.getReg_user(), job.getUpdate_user());
        JobStartMasterLocal start = null;
        if (parentJobId.compareTo("TOP") != 0 && (job.getJob_type() == 1 || job.getJob_type() == 2 || job.getJob_type() == 3) && (start = job.getJobStartMaster()) != null) {
            JobStartTimeMasterLocal startTime;
            JobStartInfoUtil.getLocalHome().create(sessionId, job.getJob_id(), start.getCondition_type(), start.getSuspend(), start.getSkip(), start.getSkip_end_status(), start.getSkip_end_value(), start.getUnmatch_end_flg(), start.getUnmatch_end_status(), start.getUnmatch_end_value(), start.getCalendar(), start.getCalendar_id(), start.getCalendar_end_value());
            Collection startJobList = start.getJobStartJobMaster();
            if (startJobList != null && startJobList.size() > 0) {
                for (JobStartJobMasterLocal startJob : startJobList) {
                    if (startJob == null) continue;
                    JobStartJobInfoUtil.getLocalHome().create(sessionId, job.getJob_id(), startJob.getTarget_job_id(), startJob.getTarget_job_end_status());
                }
            }
            if ((startTime = start.getJobStartTimeMaster()) != null) {
                JobStartTimeInfoUtil.getLocalHome().create(sessionId, job.getJob_id(), startTime.getStart_time());
            }
            if (start.getSuspend() == 1) {
                sessionJob.setStatus(new Integer(1));
            } else if (start.getSkip() == 1) {
                sessionJob.setStatus(new Integer(2));
                sessionJob.setEnd_value(start.getSkip_end_value());
            }
        }
        JobCommandMasterLocal command = null;
        if (job.getJob_type() == 2) {
            command = job.getJobCommandMaster();
            if (command != null) {
                JobCommandInfoUtil.getLocalHome().create(sessionId, job.getJob_id(), command.getFacility_id(), command.getProcess_mode(), command.getStart_command(), command.getStop_command(), command.getEffective_user(), command.getError_end_flg(), command.getError_end_value(), command.getArgument_job_id(), command.getArgument());
            }
            if (repository == null) {
                repository = RepositoryControllerUtil.getLocalHome().create();
            }
            sessionJob.setScope_text(repository.getFacilityPath(command.getFacility_id(), null));
            ArrayList nodeIdList = null;
            if (repository.isNode(command.getFacility_id())) {
                nodeIdList = new ArrayList();
                nodeIdList.add(command.getFacility_id());
            } else {
                nodeIdList = repository.getNodeFacilityIdList(command.getFacility_id(), 0);
            }
            if (nodeIdList instanceof ArrayList) {
                for (int i = 0; i < nodeIdList.size(); ++i) {
                    ArrayList<String> Attribute2 = new ArrayList<String>();
                    Attribute2.add("cn");
                    HashMap map = repository.getNodeDetail((String)nodeIdList.get(i), Attribute2);
                    JobSessionNodeUtil.getLocalHome().create(sessionId, job.getJob_id(), (String)nodeIdList.get(i), (String)map.get("cn"), new Integer(0), null, null, null, null, null, null, new Integer(0), null);
                }
            }
        }
        JobFileMasterLocal file = null;
        if (job.getJob_type() == 3) {
            file = job.getJobFileMaster();
            if (file != null) {
                JobFileInfoUtil.getLocalHome().create(sessionId, job.getJob_id(), file.getProcess_mode(), file.getSrc_facility_id(), file.getDest_facility_id(), file.getSrc_file(), file.getSrc_work_dir(), file.getDest_directory(), file.getDest_work_dir(), file.getCompression_flg(), file.getCheck_flg(), file.getEffective_user());
            }
            new CreateFileJob().createGetFileListJob(job, sessionId);
        }
        if ((noticeList = job.getJobNoticeMaster()) != null) {
            for (JobNoticeMasterLocal notice : noticeList) {
                if (notice == null) continue;
                JobNoticeInfoUtil.getLocalHome().create(sessionId, job.getJob_id(), notice.getNotice_type(), notice.getPriority(), notice.getNotify_id());
            }
        }
        if ((endList = job.getJobEndMaster()) != null) {
            for (JobEndMasterLocal end : endList) {
                if (end == null) continue;
                JobEndInfoUtil.getLocalHome().create(sessionId, job.getJob_id(), end.getEnd_status(), end.getEnd_value(), end.getEnd_value_from(), end.getEnd_value_to());
            }
        }
    }

    protected boolean checkCalendar(String sessionId, String jobId) throws FinderException, NamingException {
        m_log.debug((Object)("checkCalendar() : sessionId=" + sessionId + ", jobId=" + jobId));
        boolean check = false;
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        JobSessionLocal session = sessionJob.getJobSession();
        JobInfoLocal job = sessionJob.getJobInfo();
        JobStartInfoLocal start = job.getJobStartInfo();
        if (start.getCalendar() == 1) {
            try {
                CalendarControllerLocal calendar = CalendarControllerUtil.getLocalHome().create();
                if (calendar.isRun(start.getCalendar_id(), session.getSchedule_date()).booleanValue()) {
                    check = true;
                }
            }
            catch (CreateException e) {
            }
            catch (NamingException e) {}
        } else {
            check = true;
        }
        if (!check) {
            sessionJob.setStatus(new Integer(300));
            sessionJob.setEnd_date(new Date());
            sessionJob.setEnd_value(start.getCalendar_end_value());
            sessionJob = null;
            this.endJob(sessionId, jobId);
        }
        return check;
    }
}

