/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performanceMGR.util.code;

import com.clustercontrol.performanceMGR.bean.CollectorItemInfo;
import com.clustercontrol.performanceMGR.bean.DeviceData;
import com.clustercontrol.performanceMGR.dao.DeviceDAO;
import com.clustercontrol.performanceMGR.util.Messages;
import com.clustercontrol.performanceMGR.util.Repository;
import com.clustercontrol.performanceMGR.util.code.CollectorItemCategoryInfo;
import com.clustercontrol.performanceMGR.util.code.CollectorItemCodeInfo;
import com.clustercontrol.performanceMGR.util.code.CollectorItemTreeItem;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.TreeSet;

public class CollectorItemCodeTable {
    private static final ArrayList<CollectorItemCategoryInfo> m_categoryList = new ArrayList();
    private static final ArrayList<CollectorItemTreeItem> m_itemTree = new ArrayList();
    private static final HashMap<String, CollectorItemTreeItem> m_codeTable = new HashMap();

    static {
        HashMap<String, CollectorItemTreeItem> categoryTable = new HashMap<String, CollectorItemTreeItem>();
        Properties properties = new Properties();
        try {
            Locale locale = Locale.getDefault();
            String homeDir = System.getProperty("jboss.server.home.dir");
            String confDir = String.valueOf(homeDir) + File.separator + "conf" + File.separator;
            String propertyFile = locale.getLanguage().equals("ja") ? String.valueOf(confDir) + "performance_ja.properties" : String.valueOf(confDir) + "performance.properties";
            properties.load(new FileInputStream(propertyFile));
            int num = Integer.parseInt(properties.getProperty("collector.category.num"));
            int i = 0;
            while (i < num) {
                String categoryCode = properties.getProperty("collector.category.code." + i);
                String categoryName = properties.getProperty("collector.category.name." + i);
                if (categoryCode != null && categoryName != null) {
                    CollectorItemCategoryInfo category = new CollectorItemCategoryInfo(categoryCode, categoryName);
                    m_categoryList.add(category);
                    CollectorItemTreeItem categoryItem = new CollectorItemTreeItem(null, category, null);
                    m_itemTree.add(categoryItem);
                    categoryTable.put(categoryCode, categoryItem);
                }
                ++i;
            }
            num = Integer.parseInt(properties.getProperty("collector.item.num"));
            i = 0;
            while (i < num) {
                String itemCode = properties.getProperty("collector.item.code." + i);
                String categoryCode = properties.getProperty("collector.item.category.code." + i);
                String parentCode = properties.getProperty("collector.item.parent.code." + i);
                String itemName = properties.getProperty("collector.item.name." + i);
                String measure = properties.getProperty("collector.item.measure." + i);
                String deviceFlagString = properties.getProperty("collector.device.support." + i);
                String deviceType = properties.getProperty("collector.device.type." + i);
                String rangeFixedString = properties.getProperty("collector.graph.range." + i);
                if (itemCode != null && categoryCode != null && deviceFlagString != null && rangeFixedString != null) {
                    boolean deviceFlag = Boolean.parseBoolean(deviceFlagString);
                    boolean rangeFixed = rangeFixedString.equals("fix");
                    CollectorItemTreeItem categoryTreeItem = (CollectorItemTreeItem)categoryTable.get(categoryCode);
                    String category = null;
                    if (categoryTreeItem != null) {
                        category = categoryTreeItem.getCategory().getCategoryName();
                    }
                    CollectorItemCodeInfo codeInfo = new CollectorItemCodeInfo(itemCode, categoryCode, parentCode, category, itemName, measure, deviceFlag, deviceType, rangeFixed);
                    CollectorItemTreeItem parentItem = m_codeTable.get(parentCode);
                    if (parentItem == null) {
                        parentItem = categoryTreeItem;
                    }
                    CollectorItemTreeItem ctItem = new CollectorItemTreeItem(parentItem, codeInfo, null);
                    m_codeTable.put(itemCode, ctItem);
                }
                ++i;
            }
        }
        catch (Exception e) {
            m_codeTable.clear();
            m_itemTree.clear();
            m_codeTable.clear();
            e.printStackTrace();
        }
    }

    public static String getItemName(String itemCode) {
        return m_codeTable.get(itemCode).getItemName();
    }

    public static String getFullItemName(String itemCode, String deviceName) {
        String name = deviceName == null || deviceName.equals(Messages.getString((String)"none")) ? m_codeTable.get(itemCode).getItemName() : String.valueOf(m_codeTable.get(itemCode).getItemName()) + "(" + deviceName + ")";
        return name;
    }

    public static String getFullItemName(CollectorItemInfo collectorItemInfo) {
        String itemCode = collectorItemInfo.getCollectorItemCode();
        if (CollectorItemCodeTable.isDeviceSupport(itemCode)) {
            return CollectorItemCodeTable.getFullItemName(collectorItemInfo.getCollectorItemCode(), collectorItemInfo.getDeviceName());
        }
        return CollectorItemCodeTable.getItemName(itemCode);
    }

    public static String getMeasure(String itemCode) {
        return m_codeTable.get(itemCode).getMeasure();
    }

    public static boolean isRangeFixed(String itemCode) {
        return m_codeTable.get(itemCode).isRangeFixed();
    }

    public static boolean isDeviceSupport(String itemCode) {
        return m_codeTable.get(itemCode).isDeviceFlag();
    }

    public static String getDeviceType(String itemCode) {
        return m_codeTable.get(itemCode).getDeviceType();
    }

    public static int getCategorySize() {
        return m_categoryList.size();
    }

    public static String getCategoryName(int index) {
        return m_categoryList.get(index).getCategoryName();
    }

    public static String getCategoryName(String itemCode) {
        return m_codeTable.get(itemCode).getCategory().getCategoryName();
    }

    public static String getCategoryCode(int index) {
        return m_categoryList.get(index).getCategoryCode();
    }

    public static String getCategoryCode(String itemCode) {
        return m_codeTable.get(itemCode).getCategory().getCategoryCode();
    }

    public static String[] getCodeAll() {
        TreeSet set = new TreeSet(m_codeTable.keySet());
        return set.toArray(new String[set.size()]);
    }

    public static CollectorItemTreeItem[] getCollectorTree(String facilityId, String collectorId) {
        List<DeviceData> deviceList = new ArrayList();
        if (collectorId == null) {
            Repository repository;
            if (facilityId != null && (repository = new Repository()).isNode(facilityId)) {
                deviceList = repository.getDeviceList(facilityId);
            }
        } else {
            DeviceDAO dao = new DeviceDAO();
            Collection devicList = dao.selectDeviceByCollectorID(collectorId);
            for (DeviceData device : devicList) {
                if (!device.getFacilityId().equals(facilityId)) continue;
                deviceList.add(device);
            }
        }
        return CollectorItemCodeTable.getCollectorTree(facilityId, deviceList);
    }

    public static CollectorItemTreeItem[] getCollectorTree(String facilityId, List deviceList) {
        CollectorItemTreeItem[] returnTrees = new CollectorItemTreeItem[m_categoryList.size()];
        int i = 0;
        while (i < returnTrees.length) {
            CollectorItemTreeItem masterTree = m_itemTree.get(i);
            returnTrees[i] = new CollectorItemTreeItem(null, masterTree.getData(), null);
            ArrayList children = masterTree.getChildrens();
            for (CollectorItemTreeItem masterTreeChild : children) {
                CollectorItemCodeInfo masterCodeInfo = (CollectorItemCodeInfo)masterTreeChild.getData();
                if (masterCodeInfo.isDeviceFlag()) {
                    if (deviceList == null) continue;
                    String deviceType = masterCodeInfo.getDeviceType();
                    for (DeviceData device : deviceList) {
                        if (!device.getDeviceType().equals(deviceType)) continue;
                        CollectorItemCodeTable.makeTree(returnTrees[i], masterTreeChild, device);
                    }
                    continue;
                }
                CollectorItemCodeTable.makeTree(returnTrees[i], masterTreeChild, null);
            }
            ++i;
        }
        return returnTrees;
    }

    public static List getAvailableCollectorItemList(String facilityId) {
        Repository repository;
        List deviceList = new ArrayList();
        ArrayList<CollectorItemInfo> retItemList = new ArrayList<CollectorItemInfo>();
        int collectorItemId = 0;
        if (facilityId != null && (repository = new Repository()).isNode(facilityId)) {
            deviceList = repository.getDeviceList(facilityId);
        }
        String[] codes = CollectorItemCodeTable.getCodeAll();
        int i = 0;
        while (i < codes.length) {
            String itemCode = codes[i];
            CollectorItemInfo itemInfo = null;
            int deviceIndex = 0;
            String deviceName = Messages.getString((String)"none");
            if (!CollectorItemCodeTable.isDeviceSupport(itemCode)) {
                itemInfo = new CollectorItemInfo(null, collectorItemId, itemCode, deviceIndex, deviceName, false);
                retItemList.add(collectorItemId, itemInfo);
                ++collectorItemId;
            } else if (deviceList != null) {
                for (DeviceData deviceData : deviceList) {
                    String deviceType = CollectorItemCodeTable.getDeviceType(itemCode);
                    if (!deviceData.getDeviceType().equals(deviceType)) continue;
                    deviceIndex = deviceData.getDeviceIndex();
                    deviceName = deviceData.getDeviceName();
                    itemInfo = new CollectorItemInfo(null, collectorItemId, itemCode, deviceIndex, deviceName, false);
                    retItemList.add(collectorItemId, itemInfo);
                    ++collectorItemId;
                }
            }
            ++i;
        }
        return retItemList;
    }

    private static void makeTree(CollectorItemTreeItem parent, CollectorItemTreeItem masterItem, DeviceData deviceData) {
        CollectorItemTreeItem treeItem = new CollectorItemTreeItem(parent, masterItem.getData(), deviceData);
        ArrayList children = masterItem.getChildrens();
        for (CollectorItemTreeItem masterTreeChild : children) {
            CollectorItemCodeTable.makeTree(treeItem, masterTreeChild, deviceData);
        }
    }

    public static HashMap getItemCodeMap() {
        return m_codeTable;
    }
}

