/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.collectiverun.factory;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.StatusConstant;
import com.clustercontrol.collectiverun.bean.TypeMstConstant;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionDetailLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionDetailUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import javax.ejb.FinderException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SelectSession {
    protected static Log m_log = LogFactory.getLog(SelectSession.class);
    private int m_historyMaxDisplayNumber = -1;

    public SelectSession() {
        try {
            InitialContext initialContext = new InitialContext();
            if (initialContext.lookup("java:comp/env/CRunHistoryDisplayNumber") instanceof Integer) {
                this.m_historyMaxDisplayNumber = (Integer)initialContext.lookup("java:comp/env/CRunHistoryDisplayNumber");
            }
        }
        catch (NamingException e) {
            m_log.error((Object)("SelectSession():" + e.getMessage()));
        }
    }

    public ArrayList getHistoryList(Locale locale) throws FinderException, NamingException {
        ArrayList history = new ArrayList();
        Collection sessionList = CRunSessionUtil.getLocalHome().findAll();
        if (sessionList != null) {
            if (this.m_historyMaxDisplayNumber != -1 && sessionList.size() > this.m_historyMaxDisplayNumber) {
                throw new IndexOutOfBoundsException();
            }
            for (CRunSessionLocal session : sessionList) {
                CRunCmdMstLocal cmd = null;
                try {
                    cmd = CRunCmdMstUtil.getLocalHome().findByPrimaryKey(session.getCommand_id());
                }
                catch (FinderException e) {
                    // empty catch block
                }
                ArrayList<Object> info = new ArrayList<Object>();
                info.add(session.getStatus());
                info.add(session.getSession_id());
                info.add(session.getStart_date());
                info.add(session.getEnd_date());
                info.add(TypeMstConstant.idToString(session.getType_id()));
                if (cmd != null) {
                    info.add(Messages.getString((String)cmd.getName_id(), (Locale)locale));
                } else {
                    info.add("");
                }
                info.add(session.getFacility_id());
                info.add(session.getScope_text());
                info.add(session.getNode_cnt());
                info.add(session.getEnd_nomal_cnt());
                info.add(session.getEnd_warning_cnt());
                info.add(session.getEnd_abnomal_cnt());
                info.add(session.getWait_cnt());
                info.add(session.getRunning_cnt());
                history.add(info);
            }
        }
        return history;
    }

    public ArrayList getHistoryList(Property property, Locale locale) throws FinderException, NamingException {
        ArrayList values = null;
        values = PropertyUtil.getPropertyValue((Property)property, (String)"startFromDate");
        Date startFromDate = null;
        if (values.get(0) != null && values.get(0) instanceof Date) {
            startFromDate = (Date)values.get(0);
        }
        values = PropertyUtil.getPropertyValue((Property)property, (String)"startToDate");
        Date startToDate = null;
        if (values.get(0) != null && values.get(0) instanceof Date) {
            startToDate = (Date)values.get(0);
        }
        values = PropertyUtil.getPropertyValue((Property)property, (String)"endFromDate");
        Date endFromDate = null;
        if (values.get(0) != null && values.get(0) instanceof Date) {
            endFromDate = (Date)values.get(0);
        }
        values = PropertyUtil.getPropertyValue((Property)property, (String)"endToDate");
        Date endToDate = null;
        if (values.get(0) != null && values.get(0) instanceof Date) {
            endToDate = (Date)values.get(0);
        }
        values = PropertyUtil.getPropertyValue((Property)property, (String)"type");
        String type = null;
        if (values.get(0) instanceof String && ((String)values.get(0)).length() > 0) {
            String typeString = (String)values.get(0);
            type = TypeMstConstant.stringToId(typeString);
        }
        values = PropertyUtil.getPropertyValue((Property)property, (String)"status");
        Integer status = null;
        if (values.get(0) instanceof String) {
            String statusString = (String)values.get(0);
            status = new Integer(StatusConstant.stringToType((String)statusString));
        }
        ArrayList history = new ArrayList();
        Collection sessionList = CRunSessionUtil.getLocalHome().selectHistoryFilter(startFromDate, startToDate, endFromDate, endToDate, type, status);
        if (sessionList != null) {
            if (this.m_historyMaxDisplayNumber != -1 && sessionList.size() > this.m_historyMaxDisplayNumber) {
                throw new IndexOutOfBoundsException();
            }
            for (CRunSessionLocal session : sessionList) {
                CRunCmdMstLocal cmd = null;
                try {
                    cmd = CRunCmdMstUtil.getLocalHome().findByPrimaryKey(session.getCommand_id());
                }
                catch (FinderException e) {
                    // empty catch block
                }
                ArrayList<Object> info = new ArrayList<Object>();
                info.add(session.getStatus());
                info.add(session.getSession_id());
                info.add(session.getStart_date());
                info.add(session.getEnd_date());
                info.add(TypeMstConstant.idToString(session.getType_id()));
                if (cmd != null) {
                    info.add(Messages.getString((String)cmd.getName_id(), (Locale)locale));
                } else {
                    info.add("");
                }
                info.add(session.getFacility_id());
                info.add(session.getScope_text());
                info.add(session.getNode_cnt());
                info.add(session.getEnd_nomal_cnt());
                info.add(session.getEnd_warning_cnt());
                info.add(session.getEnd_abnomal_cnt());
                info.add(session.getWait_cnt());
                info.add(session.getRunning_cnt());
                history.add(info);
            }
        }
        return history;
    }

    public ArrayList getDetailList(String sessionId, Locale locale) throws FinderException, NamingException {
        ArrayList list = new ArrayList();
        Collection detailList = CRunSessionDetailUtil.getLocalHome().findBySessionId(sessionId);
        if (detailList != null) {
            for (CRunSessionDetailLocal detail : detailList) {
                ArrayList<Object> info = new ArrayList<Object>();
                info.add(detail.getStatus());
                info.add(detail.getEnd_status());
                info.add(detail.getEnd_value());
                info.add(detail.getFacility_id());
                info.add(detail.getFacility_name());
                info.add(detail.getStart_date());
                info.add(detail.getEnd_date());
                StringBuffer message = new StringBuffer();
                if (detail.getMessage() != null) {
                    message.append(detail.getMessage());
                }
                if (detail.getError_message() != null) {
                    message.append(detail.getError_message());
                }
                info.add(message.toString());
                list.add(info);
            }
        }
        return list;
    }
}

