/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.ping.ejb.session;

import com.clustercontrol.ping.ejb.session.MonitorPingControllerHome;
import com.clustercontrol.ping.ejb.session.MonitorPingControllerLocalHome;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.Remote;
import java.security.SecureRandom;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

public class MonitorPingControllerUtil {
    private static MonitorPingControllerHome cachedRemoteHome = null;
    private static MonitorPingControllerLocalHome cachedLocalHome = null;
    private static String hexServerIP = null;
    private static final SecureRandom seeder = new SecureRandom();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object lookupHome(Hashtable environment, String jndiName, Class narrowTo) throws NamingException {
        InitialContext initialContext = new InitialContext(environment);
        try {
            Object objRef = initialContext.lookup(jndiName);
            if (Remote.class.isAssignableFrom(narrowTo)) {
                Object object = PortableRemoteObject.narrow((Object)objRef, (Class)narrowTo);
                return object;
            }
            Object object = objRef;
            return object;
        }
        finally {
            initialContext.close();
        }
    }

    public static MonitorPingControllerHome getHome() throws NamingException {
        if (cachedRemoteHome == null) {
            cachedRemoteHome = (MonitorPingControllerHome)MonitorPingControllerUtil.lookupHome(null, "MonitorPingController", MonitorPingControllerHome.class);
        }
        return cachedRemoteHome;
    }

    public static MonitorPingControllerHome getHome(Hashtable environment) throws NamingException {
        return (MonitorPingControllerHome)MonitorPingControllerUtil.lookupHome(environment, "MonitorPingController", MonitorPingControllerHome.class);
    }

    public static MonitorPingControllerLocalHome getLocalHome() throws NamingException {
        if (cachedLocalHome == null) {
            cachedLocalHome = (MonitorPingControllerLocalHome)MonitorPingControllerUtil.lookupHome(null, "MonitorPingControllerLocal", MonitorPingControllerLocalHome.class);
        }
        return cachedLocalHome;
    }

    public static final String generateGUID(Object o) {
        StringBuffer tmpBuffer = new StringBuffer(16);
        if (hexServerIP == null) {
            InetAddress localInetAddress = null;
            try {
                localInetAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException uhe) {
                System.err.println("MonitorPingControllerUtil: Could not get the local IP address using InetAddress.getLocalHost()!");
                uhe.printStackTrace();
                return null;
            }
            byte[] serverIP = localInetAddress.getAddress();
            hexServerIP = MonitorPingControllerUtil.hexFormat(MonitorPingControllerUtil.getInt(serverIP), 8);
        }
        String hashcode = MonitorPingControllerUtil.hexFormat(System.identityHashCode(o), 8);
        tmpBuffer.append(hexServerIP);
        tmpBuffer.append(hashcode);
        long timeNow = System.currentTimeMillis();
        int timeLow = (int)timeNow & 0xFFFFFFFF;
        int node = seeder.nextInt();
        StringBuffer guid = new StringBuffer(32);
        guid.append(MonitorPingControllerUtil.hexFormat(timeLow, 8));
        guid.append(tmpBuffer.toString());
        guid.append(MonitorPingControllerUtil.hexFormat(node, 8));
        return guid.toString();
    }

    private static int getInt(byte[] bytes) {
        int i = 0;
        int j = 24;
        int k = 0;
        while (j >= 0) {
            int l = bytes[k] & 0xFF;
            i += l << j;
            j -= 8;
            ++k;
        }
        return i;
    }

    private static String hexFormat(int i, int j) {
        String s = Integer.toHexString(i);
        return MonitorPingControllerUtil.padHex(s, j) + s;
    }

    private static String padHex(String s, int i) {
        StringBuffer tmpBuffer = new StringBuffer();
        if (s.length() < i) {
            for (int j = 0; j < i - s.length(); ++j) {
                tmpBuffer.append('0');
            }
        }
        return tmpBuffer.toString();
    }
}

