/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.PathIterator;
import sun.awt.X11GraphicsEnvironment;
import sun.awt.X11SurfaceData;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.loops.XORComposite;
import sun.java2d.pipe.LoopPipe;
import sun.java2d.pipe.PixelDrawPipe;
import sun.java2d.pipe.PixelFillPipe;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.ShapeDrawPipe;
import sun.java2d.pipe.ShapeSpanIterator;
import sun.java2d.pipe.SpanIterator;

public class X11Renderer
implements PixelDrawPipe,
PixelFillPipe,
ShapeDrawPipe {
    private static final Object AWT_LOCK = X11GraphicsEnvironment.class;
    private long xgc;
    private Region validatedClip;
    private XORComposite validatedXorComp;
    private int xorpixelmod;
    private int validatedPixel;

    private native long XCreateGC(long var1);

    private static native void XSetClip(long var0, int var2, int var3, int var4, int var5, Region var6);

    private static native void XSetCopyMode(long var0);

    private static native void XSetXorMode(long var0);

    private static native void XSetForeground(long var0, int var2);

    public static X11Renderer getInstance(X11SurfaceData x11SurfaceData) {
        return GraphicsPrimitive.tracingEnabled() ? new X11TracingRenderer(x11SurfaceData) : new X11Renderer(x11SurfaceData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected X11Renderer(X11SurfaceData x11SurfaceData) {
        long l2 = x11SurfaceData.getNativeOps();
        Object object = AWT_LOCK;
        synchronized (object) {
            this.xgc = this.XCreateGC(l2);
        }
    }

    private final void validate(SunGraphics2D sunGraphics2D) {
        int n2;
        Region region = sunGraphics2D.getCompClip();
        if (region != this.validatedClip) {
            this.validatedClip = region;
            X11Renderer.XSetClip(this.xgc, region.getLoX(), region.getLoY(), region.getHiX(), region.getHiY(), region.isRectangular() ? null : region);
        }
        if (sunGraphics2D.compositeState == 0) {
            if (this.validatedXorComp != null) {
                this.validatedXorComp = null;
                this.xorpixelmod = 0;
                X11Renderer.XSetCopyMode(this.xgc);
            }
        } else if (this.validatedXorComp != sunGraphics2D.composite) {
            this.validatedXorComp = (XORComposite)sunGraphics2D.composite;
            this.xorpixelmod = this.validatedXorComp.getXorPixel();
            X11Renderer.XSetXorMode(this.xgc);
        }
        if ((n2 = sunGraphics2D.pixel ^ this.xorpixelmod) != this.validatedPixel) {
            this.validatedPixel = n2;
            X11Renderer.XSetForeground(this.xgc, n2);
        }
    }

    native void XDrawLine(long var1, long var3, int var5, int var6, int var7, int var8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawLine(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5) {
        Object object = AWT_LOCK;
        synchronized (object) {
            this.validate(sunGraphics2D);
            int n6 = sunGraphics2D.transX;
            int n7 = sunGraphics2D.transY;
            this.XDrawLine(sunGraphics2D.surfaceData.getNativeOps(), this.xgc, n2 + n6, n3 + n7, n4 + n6, n5 + n7);
        }
    }

    native void XDrawRect(long var1, long var3, int var5, int var6, int var7, int var8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawRect(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5) {
        Object object = AWT_LOCK;
        synchronized (object) {
            this.validate(sunGraphics2D);
            this.XDrawRect(sunGraphics2D.surfaceData.getNativeOps(), this.xgc, n2 + sunGraphics2D.transX, n3 + sunGraphics2D.transY, n4, n5);
        }
    }

    native void XDrawRoundRect(long var1, long var3, int var5, int var6, int var7, int var8, int var9, int var10);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawRoundRect(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5, int n6, int n7) {
        Object object = AWT_LOCK;
        synchronized (object) {
            this.validate(sunGraphics2D);
            this.XDrawRoundRect(sunGraphics2D.surfaceData.getNativeOps(), this.xgc, n2 + sunGraphics2D.transX, n3 + sunGraphics2D.transY, n4, n5, n6, n7);
        }
    }

    native void XDrawOval(long var1, long var3, int var5, int var6, int var7, int var8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawOval(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5) {
        Object object = AWT_LOCK;
        synchronized (object) {
            this.validate(sunGraphics2D);
            this.XDrawOval(sunGraphics2D.surfaceData.getNativeOps(), this.xgc, n2 + sunGraphics2D.transX, n3 + sunGraphics2D.transY, n4, n5);
        }
    }

    native void XDrawArc(long var1, long var3, int var5, int var6, int var7, int var8, int var9, int var10);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawArc(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5, int n6, int n7) {
        Object object = AWT_LOCK;
        synchronized (object) {
            this.validate(sunGraphics2D);
            this.XDrawArc(sunGraphics2D.surfaceData.getNativeOps(), this.xgc, n2 + sunGraphics2D.transX, n3 + sunGraphics2D.transY, n4, n5, n6, n7);
        }
    }

    native void XDrawPoly(long var1, long var3, int var5, int var6, int[] var7, int[] var8, int var9, boolean var10);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPolyline(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n2) {
        Object object = AWT_LOCK;
        synchronized (object) {
            this.validate(sunGraphics2D);
            this.XDrawPoly(sunGraphics2D.surfaceData.getNativeOps(), this.xgc, sunGraphics2D.transX, sunGraphics2D.transY, nArray, nArray2, n2, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n2) {
        Object object = AWT_LOCK;
        synchronized (object) {
            this.validate(sunGraphics2D);
            this.XDrawPoly(sunGraphics2D.surfaceData.getNativeOps(), this.xgc, sunGraphics2D.transX, sunGraphics2D.transY, nArray, nArray2, n2, true);
        }
    }

    native void XFillRect(long var1, long var3, int var5, int var6, int var7, int var8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillRect(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5) {
        Object object = AWT_LOCK;
        synchronized (object) {
            this.validate(sunGraphics2D);
            this.XFillRect(sunGraphics2D.surfaceData.getNativeOps(), this.xgc, n2 + sunGraphics2D.transX, n3 + sunGraphics2D.transY, n4, n5);
        }
    }

    native void XFillRoundRect(long var1, long var3, int var5, int var6, int var7, int var8, int var9, int var10);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillRoundRect(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5, int n6, int n7) {
        Object object = AWT_LOCK;
        synchronized (object) {
            this.validate(sunGraphics2D);
            this.XFillRoundRect(sunGraphics2D.surfaceData.getNativeOps(), this.xgc, n2 + sunGraphics2D.transX, n3 + sunGraphics2D.transY, n4, n5, n6, n7);
        }
    }

    native void XFillOval(long var1, long var3, int var5, int var6, int var7, int var8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillOval(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5) {
        Object object = AWT_LOCK;
        synchronized (object) {
            this.validate(sunGraphics2D);
            this.XFillOval(sunGraphics2D.surfaceData.getNativeOps(), this.xgc, n2 + sunGraphics2D.transX, n3 + sunGraphics2D.transY, n4, n5);
        }
    }

    native void XFillArc(long var1, long var3, int var5, int var6, int var7, int var8, int var9, int var10);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillArc(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5, int n6, int n7) {
        Object object = AWT_LOCK;
        synchronized (object) {
            this.validate(sunGraphics2D);
            this.XFillArc(sunGraphics2D.surfaceData.getNativeOps(), this.xgc, n2 + sunGraphics2D.transX, n3 + sunGraphics2D.transY, n4, n5, n6, n7);
        }
    }

    native void XFillPoly(long var1, long var3, int var5, int var6, int[] var7, int[] var8, int var9);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n2) {
        Object object = AWT_LOCK;
        synchronized (object) {
            this.validate(sunGraphics2D);
            this.XFillPoly(sunGraphics2D.surfaceData.getNativeOps(), this.xgc, sunGraphics2D.transX, sunGraphics2D.transY, nArray, nArray2, n2);
        }
    }

    native void XFillSpans(long var1, long var3, SpanIterator var5, long var6, int var8, int var9);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(SunGraphics2D sunGraphics2D, Shape shape) {
        block21: {
            if (sunGraphics2D.strokeState == 0) {
                AffineTransform affineTransform;
                if (sunGraphics2D.transformState < 3) {
                    if (shape instanceof Polygon) {
                        Polygon polygon = (Polygon)shape;
                        this.drawPolygon(sunGraphics2D, polygon.xpoints, polygon.ypoints, polygon.npoints);
                        return;
                    }
                    affineTransform = null;
                } else {
                    affineTransform = sunGraphics2D.transform;
                }
                PathIterator pathIterator = shape.getPathIterator(affineTransform, 0.5);
                Polygon polygon = new Polygon();
                float[] fArray = new float[2];
                while (!pathIterator.isDone()) {
                    switch (pathIterator.currentSegment(fArray)) {
                        case 0: {
                            if (polygon.npoints > 1) {
                                this.drawPolyline(sunGraphics2D, polygon.xpoints, polygon.ypoints, polygon.npoints);
                            }
                            polygon.reset();
                            polygon.addPoint((int)Math.floor(fArray[0]), (int)Math.floor(fArray[1]));
                            break;
                        }
                        case 1: {
                            if (polygon.npoints == 0) {
                                throw new IllegalPathStateException("missing initial moveto in path definition");
                            }
                            polygon.addPoint((int)Math.floor(fArray[0]), (int)Math.floor(fArray[1]));
                            break;
                        }
                        case 4: {
                            if (polygon.npoints <= 0) break;
                            polygon.addPoint(polygon.xpoints[0], polygon.ypoints[0]);
                            break;
                        }
                        default: {
                            throw new IllegalPathStateException("path not flattened");
                        }
                    }
                    pathIterator.next();
                }
                if (polygon.npoints > 1) {
                    this.drawPolyline(sunGraphics2D, polygon.xpoints, polygon.ypoints, polygon.npoints);
                }
            } else {
                if (sunGraphics2D.strokeState < 3) {
                    ShapeSpanIterator shapeSpanIterator = LoopPipe.getStrokeSpans(sunGraphics2D, shape);
                    try {
                        Object object = AWT_LOCK;
                        synchronized (object) {
                            this.validate(sunGraphics2D);
                            this.XFillSpans(sunGraphics2D.surfaceData.getNativeOps(), this.xgc, shapeSpanIterator, shapeSpanIterator.getNativeIterator(), 0, 0);
                            break block21;
                        }
                    }
                    finally {
                        shapeSpanIterator.dispose();
                    }
                }
                this.fill(sunGraphics2D, sunGraphics2D.stroke.createStrokedShape(shape));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fill(SunGraphics2D sunGraphics2D, Shape shape) {
        int n2;
        int n3;
        AffineTransform affineTransform;
        if (sunGraphics2D.transformState < 3) {
            if (shape instanceof Polygon) {
                Polygon polygon = (Polygon)shape;
                this.fillPolygon(sunGraphics2D, polygon.xpoints, polygon.ypoints, polygon.npoints);
                return;
            }
            affineTransform = null;
            n3 = sunGraphics2D.transX;
            n2 = sunGraphics2D.transY;
        } else {
            affineTransform = sunGraphics2D.transform;
            n2 = 0;
            n3 = 0;
        }
        ShapeSpanIterator shapeSpanIterator = new ShapeSpanIterator(sunGraphics2D, false);
        try {
            Region region = sunGraphics2D.getCompClip();
            shapeSpanIterator.setOutputAreaXYXY(region.getLoX() - n3, region.getLoY() - n2, region.getHiX() - n3, region.getHiY() - n2);
            shapeSpanIterator.appendPath(shape.getPathIterator(affineTransform));
            Object object = AWT_LOCK;
            synchronized (object) {
                this.validate(sunGraphics2D);
                this.XFillSpans(sunGraphics2D.surfaceData.getNativeOps(), this.xgc, shapeSpanIterator, shapeSpanIterator.getNativeIterator(), n3, n2);
            }
        }
        finally {
            shapeSpanIterator.dispose();
        }
    }

    native void devCopyArea(SurfaceData var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public static class X11TracingRenderer
    extends X11Renderer {
        public X11TracingRenderer(X11SurfaceData x11SurfaceData) {
            super(x11SurfaceData);
        }

        void XDrawLine(long l2, long l3, int n2, int n3, int n4, int n5) {
            GraphicsPrimitive.tracePrimitive("X11DrawLine");
            super.XDrawLine(l2, l3, n2, n3, n4, n5);
        }

        void XDrawRect(long l2, long l3, int n2, int n3, int n4, int n5) {
            GraphicsPrimitive.tracePrimitive("X11DrawRect");
            super.XDrawRect(l2, l3, n2, n3, n4, n5);
        }

        void XDrawRoundRect(long l2, long l3, int n2, int n3, int n4, int n5, int n6, int n7) {
            GraphicsPrimitive.tracePrimitive("X11DrawRoundRect");
            super.XDrawRoundRect(l2, l3, n2, n3, n4, n5, n6, n7);
        }

        void XDrawOval(long l2, long l3, int n2, int n3, int n4, int n5) {
            GraphicsPrimitive.tracePrimitive("X11DrawOval");
            super.XDrawOval(l2, l3, n2, n3, n4, n5);
        }

        void XDrawArc(long l2, long l3, int n2, int n3, int n4, int n5, int n6, int n7) {
            GraphicsPrimitive.tracePrimitive("X11DrawArc");
            super.XDrawArc(l2, l3, n2, n3, n4, n5, n6, n7);
        }

        void XDrawPoly(long l2, long l3, int n2, int n3, int[] nArray, int[] nArray2, int n4, boolean bl2) {
            GraphicsPrimitive.tracePrimitive("X11DrawPoly");
            super.XDrawPoly(l2, l3, n2, n3, nArray, nArray2, n4, bl2);
        }

        void XFillRect(long l2, long l3, int n2, int n3, int n4, int n5) {
            GraphicsPrimitive.tracePrimitive("X11FillRect");
            super.XFillRect(l2, l3, n2, n3, n4, n5);
        }

        void XFillRoundRect(long l2, long l3, int n2, int n3, int n4, int n5, int n6, int n7) {
            GraphicsPrimitive.tracePrimitive("X11FillRoundRect");
            super.XFillRoundRect(l2, l3, n2, n3, n4, n5, n6, n7);
        }

        void XFillOval(long l2, long l3, int n2, int n3, int n4, int n5) {
            GraphicsPrimitive.tracePrimitive("X11FillOval");
            super.XFillOval(l2, l3, n2, n3, n4, n5);
        }

        void XFillArc(long l2, long l3, int n2, int n3, int n4, int n5, int n6, int n7) {
            GraphicsPrimitive.tracePrimitive("X11FillArc");
            super.XFillArc(l2, l3, n2, n3, n4, n5, n6, n7);
        }

        void XFillPoly(long l2, long l3, int n2, int n3, int[] nArray, int[] nArray2, int n4) {
            GraphicsPrimitive.tracePrimitive("X11FillPoly");
            super.XFillPoly(l2, l3, n2, n3, nArray, nArray2, n4);
        }

        void XFillSpans(long l2, long l3, SpanIterator spanIterator, long l4, int n2, int n3) {
            GraphicsPrimitive.tracePrimitive("X11FillSpans");
            super.XFillSpans(l2, l3, spanIterator, l4, n2, n3);
        }

        void devCopyArea(SurfaceData surfaceData, int n2, int n3, int n4, int n5, int n6, int n7) {
            GraphicsPrimitive.tracePrimitive("X11CopyArea");
            super.devCopyArea(surfaceData, n2, n3, n4, n5, n6, n7);
        }
    }
}

