/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.datatransfer.Transferable;
import java.awt.dnd.InvalidDnDOperationException;
import java.util.Map;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XDragSourceProtocolListener;
import sun.awt.X11.XException;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;
import sun.awt.X11.XWindowAttributes;
import sun.awt.X11.XlibWrapper;

abstract class XDragSourceProtocol {
    private final XDragSourceProtocolListener listener;
    private boolean initialized = false;
    private long targetWindow = 0L;
    private long targetProxyWindow = 0L;
    private int targetProtocolVersion = 0;
    private long targetWindowMask = 0L;

    static long getDragSourceWindow() {
        return XWindow.getXAWTRootWindow().getWindow();
    }

    protected XDragSourceProtocol(XDragSourceProtocolListener xDragSourceProtocolListener) {
        if (xDragSourceProtocolListener == null) {
            throw new NullPointerException("Null XDragSourceProtocolListener");
        }
        this.listener = xDragSourceProtocolListener;
    }

    protected final XDragSourceProtocolListener getProtocolListener() {
        return this.listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void initializeDrag(int n2, Transferable transferable, Map map, long[] lArray) throws InvalidDnDOperationException, IllegalArgumentException, XException {
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            try {
                if (this.initialized) {
                    throw new InvalidDnDOperationException("Already initialized");
                }
                this.initializeDragImpl(n2, transferable, map, lArray);
                this.initialized = true;
            }
            finally {
                if (!this.initialized) {
                    this.cleanup();
                }
            }
        }
    }

    protected abstract void initializeDragImpl(int var1, Transferable var2, Map var3, long[] var4) throws InvalidDnDOperationException, IllegalArgumentException, XException;

    public void cleanup() {
        this.initialized = false;
        this.cleanupTargetInfo();
    }

    public void cleanupTargetInfo() {
        this.targetWindow = 0L;
        this.targetProxyWindow = 0L;
        this.targetProtocolVersion = 0;
    }

    public abstract boolean processClientMessage(XClientMessageEvent var1) throws XException;

    public abstract boolean attachTargetWindow(long var1, long var3);

    public abstract void sendEnterMessage(long[] var1, int var2, int var3, long var4);

    public abstract void sendMoveMessage(int var1, int var2, int var3, int var4, long var5);

    public abstract void sendLeaveMessage(long var1);

    protected abstract void sendDropMessage(int var1, int var2, int var3, int var4, long var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void initiateDrop(int n2, int n3, int n4, int n5, long l2) {
        XWindowAttributes xWindowAttributes = new XWindowAttributes();
        try {
            XToolkit.WITH_XERROR_HANDLER(XToolkit.IgnoreBadWindowHandler);
            int n6 = XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), this.targetWindow, xWindowAttributes.pData);
            XToolkit.RESTORE_XERROR_HANDLER();
            if (n6 == 0 || XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                throw new XException("XGetWindowAttributes failed");
            }
            this.targetWindowMask = xWindowAttributes.get_your_event_mask();
        }
        finally {
            xWindowAttributes.dispose();
        }
        XToolkit.WITH_XERROR_HANDLER(XToolkit.IgnoreBadWindowHandler);
        XlibWrapper.XSelectInput(XToolkit.getDisplay(), this.targetWindow, this.targetWindowMask | 0x20000L);
        XToolkit.RESTORE_XERROR_HANDLER();
        if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
            throw new XException("XSelectInput failed");
        }
        this.sendDropMessage(n2, n3, n4, n5, l2);
    }

    protected final void finalizeDrop() {
        XToolkit.WITH_XERROR_HANDLER(XToolkit.IgnoreBadWindowHandler);
        XlibWrapper.XSelectInput(XToolkit.getDisplay(), this.targetWindow, this.targetWindowMask);
        XToolkit.RESTORE_XERROR_HANDLER();
    }

    protected final long getTargetWindow() {
        return this.targetWindow;
    }

    protected final long getTargetProxyWindow() {
        if (this.targetProxyWindow != 0L) {
            return this.targetProxyWindow;
        }
        return this.targetWindow;
    }

    protected final int getTargetProtocolVersion() {
        return this.targetProtocolVersion;
    }

    protected final void setTargetWindow(long l2) {
        this.targetWindow = l2;
    }

    protected final void setTargetProxyWindow(long l2) {
        this.targetProxyWindow = l2;
    }

    protected final void setTargetProtocolVersion(int n2) {
        this.targetProtocolVersion = n2;
    }
}

