/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JTextField;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class MetalComboBoxEditor
extends BasicComboBoxEditor {
    protected static Insets editorBorderInsets = new Insets(2, 2, 2, 0);
    private static final Insets SAFE_EDITOR_BORDER_INSETS = new Insets(2, 2, 2, 0);

    public MetalComboBoxEditor() {
        this.editor = new JTextField("", 9){

            public void setText(String string) {
                if (this.getText().equals(string)) {
                    return;
                }
                super.setText(string);
            }

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.height += 4;
                return dimension;
            }

            public Dimension getMinimumSize() {
                Dimension dimension = super.getMinimumSize();
                dimension.height += 4;
                return dimension;
            }
        };
        this.editor.setBorder(new EditorBorder());
    }

    class EditorBorder
    extends AbstractBorder {
        EditorBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            graphics.translate(n2, n3);
            if (MetalLookAndFeel.usingOcean()) {
                graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                graphics.drawRect(0, 0, n4, n5 - 1);
                graphics.setColor(MetalLookAndFeel.getControlShadow());
                graphics.drawRect(1, 1, n4 - 2, n5 - 3);
            } else {
                graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                graphics.drawLine(0, 0, n4 - 1, 0);
                graphics.drawLine(0, 0, 0, n5 - 2);
                graphics.drawLine(0, n5 - 2, n4 - 1, n5 - 2);
                graphics.setColor(MetalLookAndFeel.getControlHighlight());
                graphics.drawLine(1, 1, n4 - 1, 1);
                graphics.drawLine(1, 1, 1, n5 - 1);
                graphics.drawLine(1, n5 - 1, n4 - 1, n5 - 1);
                graphics.setColor(MetalLookAndFeel.getControl());
                graphics.drawLine(1, n5 - 2, 1, n5 - 2);
            }
            graphics.translate(-n2, -n3);
        }

        public Insets getBorderInsets(Component component) {
            if (System.getSecurityManager() != null) {
                return SAFE_EDITOR_BORDER_INSETS;
            }
            return editorBorderInsets;
        }
    }

    public static class UIResource
    extends MetalComboBoxEditor
    implements javax.swing.plaf.UIResource {
    }
}

