/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanParameterInfo;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularType;

public class OpenMBeanParameterInfoSupport
extends MBeanParameterInfo
implements OpenMBeanParameterInfo,
Serializable {
    static final long serialVersionUID = -7235016873758443122L;
    private OpenType openType;
    private Object defaultValue = null;
    private Set legalValues = null;
    private Comparable minValue = null;
    private Comparable maxValue = null;
    private transient Integer myHashCode = null;
    private transient String myToString = null;

    public OpenMBeanParameterInfoSupport(String string, String string2, OpenType openType) {
        super(string, openType == null ? null : openType.getClassName(), string2);
        if (string == null || string.trim().equals("")) {
            throw new IllegalArgumentException("Argument name cannot be null or empty.");
        }
        if (string2 == null || string2.trim().equals("")) {
            throw new IllegalArgumentException("Argument description cannot be null or empty.");
        }
        if (openType == null) {
            throw new IllegalArgumentException("Argument openType cannot be null.");
        }
        this.openType = openType;
    }

    public OpenMBeanParameterInfoSupport(String string, String string2, OpenType openType, Object object) throws OpenDataException {
        this(string, string2, openType);
        if (object != null) {
            if (openType.isArray() || openType instanceof TabularType) {
                throw new OpenDataException("Default value not supported for ArrayType and TabularType.");
            }
            if (!openType.isValue(object)) {
                throw new OpenDataException("Argument defaultValue's class [\"" + object.getClass().getName() + "\"] does not match the one defined in openType[\"" + openType.getClassName() + "\"].");
            }
            this.defaultValue = object;
        }
    }

    public OpenMBeanParameterInfoSupport(String string, String string2, OpenType openType, Object object, Object[] objectArray) throws OpenDataException {
        this(string, string2, openType, object);
        if (objectArray != null && objectArray.length > 0) {
            if (openType instanceof TabularType || openType.isArray()) {
                throw new OpenDataException("Legal values not supported for TabularType and arrays");
            }
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                if (openType.isValue(objectArray[i2])) continue;
                throw new OpenDataException("Element legalValues[" + i2 + "]=" + objectArray[i2] + " is not a valid value for the specified openType [" + openType.toString() + "].");
            }
            HashSet<Object> hashSet = new HashSet<Object>(objectArray.length + 1, 1.0f);
            for (int i3 = 0; i3 < objectArray.length; ++i3) {
                hashSet.add(objectArray[i3]);
            }
            this.legalValues = Collections.unmodifiableSet(hashSet);
        }
        if (this.hasDefaultValue() && this.hasLegalValues() && !this.legalValues.contains(object)) {
            throw new OpenDataException("defaultValue is not contained in legalValues");
        }
    }

    public OpenMBeanParameterInfoSupport(String string, String string2, OpenType openType, Object object, Comparable comparable, Comparable comparable2) throws OpenDataException {
        this(string, string2, openType, object);
        if (comparable != null) {
            if (!openType.isValue(comparable)) {
                throw new OpenDataException("Argument minValue's class [\"" + comparable.getClass().getName() + "\"] does not match openType's definition [\"" + openType.getClassName() + "\"].");
            }
            this.minValue = comparable;
        }
        if (comparable2 != null) {
            if (!openType.isValue(comparable2)) {
                throw new OpenDataException("Argument maxValue's class [\"" + comparable2.getClass().getName() + "\"] does not match openType's definition [\"" + openType.getClassName() + "\"].");
            }
            this.maxValue = comparable2;
        }
        if (this.hasMinValue() && this.hasMaxValue() && comparable.compareTo(comparable2) > 0) {
            throw new OpenDataException("minValue cannot be greater than maxValue.");
        }
        if (this.hasDefaultValue() && this.hasMinValue() && comparable.compareTo((Comparable)object) > 0) {
            throw new OpenDataException("minValue cannot be greater than defaultValue.");
        }
        if (this.hasDefaultValue() && this.hasMaxValue() && ((Comparable)object).compareTo(comparable2) > 0) {
            throw new OpenDataException("defaultValue cannot be greater than maxValue.");
        }
    }

    public OpenType getOpenType() {
        return this.openType;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public Set getLegalValues() {
        return this.legalValues;
    }

    public Comparable getMinValue() {
        return this.minValue;
    }

    public Comparable getMaxValue() {
        return this.maxValue;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public boolean hasLegalValues() {
        return this.legalValues != null;
    }

    public boolean hasMinValue() {
        return this.minValue != null;
    }

    public boolean hasMaxValue() {
        return this.maxValue != null;
    }

    public boolean isValue(Object object) {
        boolean bl2 = this.hasDefaultValue() && object == null ? true : (!this.openType.isValue(object) ? false : (this.hasLegalValues() && !this.legalValues.contains(object) ? false : (this.hasMinValue() && this.minValue.compareTo(object) > 0 ? false : !this.hasMaxValue() || this.maxValue.compareTo(object) >= 0)));
        return bl2;
    }

    public boolean equals(Object object) {
        OpenMBeanParameterInfo openMBeanParameterInfo;
        if (object == null) {
            return false;
        }
        try {
            openMBeanParameterInfo = (OpenMBeanParameterInfo)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (!this.getName().equals(openMBeanParameterInfo.getName())) {
            return false;
        }
        if (!this.getOpenType().equals(openMBeanParameterInfo.getOpenType())) {
            return false;
        }
        if (this.hasDefaultValue() ? !this.defaultValue.equals(openMBeanParameterInfo.getDefaultValue()) : openMBeanParameterInfo.hasDefaultValue()) {
            return false;
        }
        if (this.hasMinValue() ? !this.minValue.equals(openMBeanParameterInfo.getMinValue()) : openMBeanParameterInfo.hasMinValue()) {
            return false;
        }
        if (this.hasMaxValue() ? !this.maxValue.equals(openMBeanParameterInfo.getMaxValue()) : openMBeanParameterInfo.hasMaxValue()) {
            return false;
        }
        return !(this.hasLegalValues() ? !((Object)this.legalValues).equals(openMBeanParameterInfo.getLegalValues()) : openMBeanParameterInfo.hasLegalValues());
    }

    public int hashCode() {
        if (this.myHashCode == null) {
            int n2 = 0;
            n2 += this.getName().hashCode();
            n2 += this.openType.hashCode();
            if (this.hasDefaultValue()) {
                n2 += this.defaultValue.hashCode();
            }
            if (this.hasMinValue()) {
                n2 += this.minValue.hashCode();
            }
            if (this.hasMaxValue()) {
                n2 += this.maxValue.hashCode();
            }
            if (this.hasLegalValues()) {
                n2 += ((Object)this.legalValues).hashCode();
            }
            this.myHashCode = new Integer(n2);
        }
        return this.myHashCode;
    }

    public String toString() {
        if (this.myToString == null) {
            this.myToString = new StringBuffer().append(this.getClass().getName()).append("(name=").append(this.getName()).append(",openType=").append(this.openType.toString()).append(",default=").append(String.valueOf(this.defaultValue)).append(",min=").append(String.valueOf(this.minValue)).append(",max=").append(String.valueOf(this.maxValue)).append(",legals=").append(String.valueOf(this.legalValues)).append(")").toString();
        }
        return this.myToString;
    }
}

