/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import sun.nio.ByteBuffered;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipFile
implements ZipConstants {
    private long jzfile;
    private String name;
    private int total;
    private MappedByteBuffer mappedBuffer;
    private ZipCloser closer;
    private boolean mbUsed;
    private boolean closeRequested;
    private static final int STORED = 0;
    private static final int DEFLATED = 8;
    public static final int OPEN_READ = 1;
    public static final int OPEN_DELETE = 4;
    private static Constructor directByteBufferConstructor;
    private Vector inflaters = new Vector();

    private static native void initIDs();

    public ZipFile(String string) throws IOException {
        this(new File(string), 1);
    }

    private static void initDBBConstructor() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Class<?> clazz = Class.forName("java.nio.DirectByteBuffer");
                    directByteBufferConstructor = clazz.getDeclaredConstructor(Integer.TYPE, Long.TYPE, Runnable.class);
                    directByteBufferConstructor.setAccessible(true);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new InternalError();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new InternalError();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new InternalError();
                }
                catch (ClassCastException classCastException) {
                    throw new InternalError();
                }
                return null;
            }
        });
    }

    private static MappedByteBuffer newMappedByteBuffer(int n2, long l2, Runnable runnable) {
        MappedByteBuffer mappedByteBuffer;
        if (directByteBufferConstructor == null) {
            ZipFile.initDBBConstructor();
        }
        try {
            mappedByteBuffer = (MappedByteBuffer)directByteBufferConstructor.newInstance(new Integer(n2), new Long(l2), runnable);
        }
        catch (InstantiationException instantiationException) {
            throw new InternalError();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InternalError();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new InternalError();
        }
        return mappedByteBuffer;
    }

    public ZipFile(File file, int n2) throws IOException {
        if ((n2 & 1) == 0 || (n2 & 0xFFFFFFFA) != 0) {
            throw new IllegalArgumentException("Illegal mode: 0x" + Integer.toHexString(n2));
        }
        String string = file.getPath();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string);
            if ((n2 & 4) != 0) {
                securityManager.checkDelete(string);
            }
        }
        long l2 = ZipFile.open(string, n2, file.lastModified());
        this.name = string;
        this.total = ZipFile.getTotal(l2);
        this.mbUsed = false;
        long l3 = ZipFile.getMappedAddr(l2);
        long l4 = ZipFile.getMappedLen(l2);
        if (l3 != 0L && l4 < Integer.MAX_VALUE) {
            this.closer = new ZipCloser(l2);
            this.mappedBuffer = ZipFile.newMappedByteBuffer((int)l4, l3, this.closer);
        }
        this.jzfile = l2;
    }

    private static native long open(String var0, int var1, long var2);

    private static native int getTotal(long var0);

    private static native long getMappedAddr(long var0);

    private static native long getMappedLen(long var0);

    public ZipFile(File file) throws ZipException, IOException {
        this(file, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipEntry getEntry(String string) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        long l2 = 0L;
        ZipFile zipFile = this;
        synchronized (zipFile) {
            this.ensureOpen();
            l2 = ZipFile.getEntry(this.jzfile, string, true);
            if (l2 != 0L) {
                ZipEntry zipEntry = new ZipEntry(string, l2);
                ZipFile.freeEntry(this.jzfile, l2);
                return zipEntry;
            }
        }
        return null;
    }

    private static native long getEntry(long var0, String var2, boolean var3);

    private static native void freeEntry(long var0, long var2);

    public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        return this.getInputStream(zipEntry.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getInputStream(String string) throws IOException {
        if (string == null) {
            throw new NullPointerException("name");
        }
        long l2 = 0L;
        ZipFileInputStream zipFileInputStream = null;
        Object object = this;
        synchronized (object) {
            this.ensureOpen();
            l2 = ZipFile.getEntry(this.jzfile, string, false);
            if (l2 == 0L) {
                return null;
            }
            zipFileInputStream = this.mappedBuffer != null ? new MappedZipFileInputStream(l2, string) : new ZipFileInputStream(l2);
        }
        object = zipFileInputStream;
        switch (ZipFile.getMethod(l2)) {
            case 0: {
                return object;
            }
            case 8: {
                long l3 = ZipFile.getSize(l2);
                if (l3 > 65536L) {
                    l3 = 8192L;
                }
                if (l3 <= 0L) {
                    l3 = 4096L;
                }
                return new InflaterInputStream((InputStream)object, this.getInflater(), (int)l3, (ZipFileInputStream)object){
                    private boolean isClosed;
                    private boolean eof;
                    final /* synthetic */ ZipFileInputStream val$zfin;
                    {
                        this.val$zfin = zipFileInputStream;
                        super(inputStream, inflater, n2);
                        this.isClosed = false;
                    }

                    public void close() throws IOException {
                        if (!this.isClosed) {
                            ZipFile.this.releaseInflater(this.inf);
                            this.in.close();
                            this.isClosed = true;
                        }
                    }

                    protected void fill() throws IOException {
                        if (this.eof) {
                            throw new EOFException("Unexpected end of ZLIB input stream");
                        }
                        this.len = this.in.read(this.buf, 0, this.buf.length);
                        if (this.len == -1) {
                            this.buf[0] = 0;
                            this.len = 1;
                            this.eof = true;
                        }
                        this.inf.setInput(this.buf, 0, this.len);
                    }

                    public int available() throws IOException {
                        if (this.isClosed) {
                            return 0;
                        }
                        long l2 = this.val$zfin.size() - this.inf.getBytesWritten();
                        return l2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
                    }
                };
            }
        }
        throw new ZipException("invalid compression method");
    }

    private static native int getMethod(long var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Inflater getInflater() {
        Vector vector = this.inflaters;
        synchronized (vector) {
            int n2 = this.inflaters.size();
            if (n2 > 0) {
                Inflater inflater = (Inflater)this.inflaters.remove(n2 - 1);
                inflater.reset();
                return inflater;
            }
            return new Inflater(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseInflater(Inflater inflater) {
        Vector vector = this.inflaters;
        synchronized (vector) {
            this.inflaters.add(inflater);
        }
    }

    public String getName() {
        return this.name;
    }

    public Enumeration<? extends ZipEntry> entries() {
        this.ensureOpen();
        return new Enumeration<ZipEntry>(){
            private int i = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasMoreElements() {
                ZipFile zipFile = ZipFile.this;
                synchronized (zipFile) {
                    ZipFile.this.ensureOpen();
                    return this.i < ZipFile.this.total;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ZipEntry nextElement() throws NoSuchElementException {
                ZipFile zipFile = ZipFile.this;
                synchronized (zipFile) {
                    ZipFile.this.ensureOpen();
                    if (this.i >= ZipFile.this.total) {
                        throw new NoSuchElementException();
                    }
                    long l2 = ZipFile.getNextEntry(ZipFile.this.jzfile, this.i++);
                    if (l2 == 0L) {
                        String string = ZipFile.this.closeRequested ? "ZipFile concurrently closed" : ZipFile.getZipMessage(ZipFile.this.jzfile);
                        throw new InternalError("jzentry == 0,\n jzfile = " + ZipFile.this.jzfile + ",\n total = " + ZipFile.this.total + ",\n name = " + ZipFile.this.name + ",\n i = " + this.i + ",\n message = " + string);
                    }
                    ZipEntry zipEntry = new ZipEntry(l2);
                    ZipFile.freeEntry(ZipFile.this.jzfile, l2);
                    return zipEntry;
                }
            }
        };
    }

    private static native long getNextEntry(long var0, int var2);

    public int size() {
        this.ensureOpen();
        return this.total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        ZipFile zipFile = this;
        synchronized (zipFile) {
            this.closeRequested = true;
            if (this.jzfile != 0L) {
                long l2 = this.jzfile;
                this.jzfile = 0L;
                if (this.closer != null) {
                    if (!this.mbUsed) {
                        this.closer.setClosed();
                        ZipFile.close(l2);
                    }
                } else {
                    ZipFile.close(l2);
                }
                Vector vector = this.inflaters;
                synchronized (vector) {
                    int n2 = this.inflaters.size();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        Inflater inflater = (Inflater)this.inflaters.get(i2);
                        inflater.end();
                    }
                }
            }
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    private static native void close(long var0);

    private void ensureOpen() {
        if (this.closeRequested) {
            throw new IllegalStateException("zip file closed");
        }
    }

    private void ensureOpenOrZipException() throws IOException {
        if (this.closeRequested) {
            throw new ZipException("ZipFile closed");
        }
    }

    private static native int read(long var0, long var2, long var4, byte[] var6, int var7, int var8);

    private static native long getCSize(long var0);

    private static native long getSize(long var0);

    private static native long getEntryOffset(long var0);

    private static native String getZipMessage(long var0);

    static {
        ZipFile.initIDs();
        directByteBufferConstructor = null;
    }

    private class MappedZipFileInputStream
    extends ZipFileInputStream
    implements ByteBuffered {
        private ByteBuffer directBuffer;
        private String name;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        MappedZipFileInputStream(long l2, String string) {
            MappedByteBuffer mappedByteBuffer;
            super(l2);
            this.directBuffer = null;
            this.name = string;
            int n2 = (int)ZipFile.getEntryOffset(l2);
            MappedByteBuffer mappedByteBuffer2 = mappedByteBuffer = ZipFile.this.mappedBuffer;
            synchronized (mappedByteBuffer2) {
                mappedByteBuffer.position(n2);
                mappedByteBuffer.limit((int)((long)n2 + this.rem));
                this.directBuffer = mappedByteBuffer.slice();
                mappedByteBuffer.position(0);
                mappedByteBuffer.limit(mappedByteBuffer.capacity());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ByteBuffer getByteBuffer() throws IOException {
            ZipFile zipFile = ZipFile.this;
            synchronized (zipFile) {
                ZipFile.this.ensureOpenOrZipException();
                ZipFile.this.mbUsed = true;
                return this.directBuffer;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] byArray, int n2, int n3) throws IOException {
            int n4 = this.directBuffer.remaining();
            if (n4 == 0) {
                return -1;
            }
            if (n3 <= 0) {
                return 0;
            }
            if (n3 > n4) {
                n3 = n4;
            }
            ZipFile zipFile = ZipFile.this;
            synchronized (zipFile) {
                ZipFile.this.ensureOpenOrZipException();
                this.directBuffer.get(byArray, n2, n3);
            }
            if (n3 == n4) {
                this.close();
            }
            return n3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            ZipFile zipFile = ZipFile.this;
            synchronized (zipFile) {
                ZipFile.this.ensureOpenOrZipException();
                if (this.directBuffer.remaining() == 0) {
                    return -1;
                }
                return this.directBuffer.get() & 0xFF;
            }
        }

        public long skip(long l2) {
            int n2 = this.directBuffer.remaining();
            int n3 = l2 > (long)n2 ? n2 : (int)l2;
            this.directBuffer.position(this.directBuffer.position() + n3);
            if (n3 == n2) {
                this.close();
            }
            return n3;
        }

        public int available() {
            return this.directBuffer.remaining();
        }

        public long size() {
            return this.size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            this.directBuffer.position(this.directBuffer.limit());
            ZipFile zipFile = ZipFile.this;
            synchronized (zipFile) {
                if (this.jzentry != 0L && ZipFile.this.jzfile != 0L) {
                    ZipFile.freeEntry(ZipFile.this.jzfile, this.jzentry);
                    this.jzentry = 0L;
                }
            }
        }
    }

    private static class ZipCloser
    implements Runnable {
        private long mappedFileID;

        private ZipCloser(long l2) {
            this.mappedFileID = l2;
        }

        public synchronized void setClosed() {
            this.mappedFileID = 0L;
        }

        public synchronized void run() {
            if (this.mappedFileID != 0L) {
                ZipFile.close(this.mappedFileID);
                this.mappedFileID = 0L;
            }
        }
    }

    private class ZipFileInputStream
    extends InputStream {
        protected long jzentry;
        private long pos = 0L;
        protected long rem;
        protected long size;

        ZipFileInputStream(long l2) {
            this.rem = ZipFile.getCSize(l2);
            this.size = ZipFile.getSize(l2);
            this.jzentry = l2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] byArray, int n2, int n3) throws IOException {
            if (this.rem == 0L) {
                return -1;
            }
            if (n3 <= 0) {
                return 0;
            }
            if ((long)n3 > this.rem) {
                n3 = (int)this.rem;
            }
            ZipFile zipFile = ZipFile.this;
            synchronized (zipFile) {
                ZipFile.this.ensureOpenOrZipException();
                n3 = ZipFile.read(ZipFile.this.jzfile, this.jzentry, this.pos, byArray, n2, n3);
            }
            if (n3 > 0) {
                this.pos += (long)n3;
                this.rem -= (long)n3;
            }
            if (this.rem == 0L) {
                this.close();
            }
            return n3;
        }

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            if (this.read(byArray, 0, 1) == 1) {
                return byArray[0] & 0xFF;
            }
            return -1;
        }

        public long skip(long l2) {
            if (l2 > this.rem) {
                l2 = this.rem;
            }
            this.pos += l2;
            this.rem -= l2;
            if (this.rem == 0L) {
                this.close();
            }
            return l2;
        }

        public int available() {
            return this.rem > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.rem;
        }

        public long size() {
            return this.size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            this.rem = 0L;
            ZipFile zipFile = ZipFile.this;
            synchronized (zipFile) {
                if (this.jzentry != 0L && ZipFile.this.jzfile != 0L) {
                    ZipFile.freeEntry(ZipFile.this.jzfile, this.jzentry);
                    this.jzentry = 0L;
                }
            }
        }
    }
}

