/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import sun.nio.cs.ThreadLocalCoders;
import sun.text.Normalizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class URI
implements Comparable<URI>,
Serializable {
    static final long serialVersionUID = -6052424284110960213L;
    private transient String scheme;
    private transient String fragment;
    private transient String authority;
    private transient String userInfo;
    private transient String host;
    private transient int port = -1;
    private transient String path;
    private transient String query;
    private volatile transient String schemeSpecificPart;
    private volatile transient int hash;
    private volatile transient String decodedUserInfo = null;
    private volatile transient String decodedAuthority = null;
    private volatile transient String decodedPath = null;
    private volatile transient String decodedQuery = null;
    private volatile transient String decodedFragment = null;
    private volatile transient String decodedSchemeSpecificPart = null;
    private volatile String string;
    private static final long L_DIGIT = URI.lowMask('0', '9');
    private static final long H_DIGIT = 0L;
    private static final long L_UPALPHA = 0L;
    private static final long H_UPALPHA = URI.highMask('A', 'Z');
    private static final long L_LOWALPHA = 0L;
    private static final long H_LOWALPHA = URI.highMask('a', 'z');
    private static final long L_ALPHA = 0L;
    private static final long H_ALPHA = H_LOWALPHA | H_UPALPHA;
    private static final long L_ALPHANUM = L_DIGIT | 0L;
    private static final long H_ALPHANUM = 0L | H_ALPHA;
    private static final long L_HEX = L_DIGIT;
    private static final long H_HEX = URI.highMask('A', 'F') | URI.highMask('a', 'f');
    private static final long L_MARK = URI.lowMask("-_.!~*'()");
    private static final long H_MARK = URI.highMask("-_.!~*'()");
    private static final long L_UNRESERVED = L_ALPHANUM | L_MARK;
    private static final long H_UNRESERVED = H_ALPHANUM | H_MARK;
    private static final long L_RESERVED = URI.lowMask(";/?:@&=+$,[]");
    private static final long H_RESERVED = URI.highMask(";/?:@&=+$,[]");
    private static final long L_ESCAPED = 1L;
    private static final long H_ESCAPED = 0L;
    private static final long L_URIC = L_RESERVED | L_UNRESERVED | 1L;
    private static final long H_URIC = H_RESERVED | H_UNRESERVED | 0L;
    private static final long L_PCHAR = L_UNRESERVED | 1L | URI.lowMask(":@&=+$,");
    private static final long H_PCHAR = H_UNRESERVED | 0L | URI.highMask(":@&=+$,");
    private static final long L_PATH = L_PCHAR | URI.lowMask(";/");
    private static final long H_PATH = H_PCHAR | URI.highMask(";/");
    private static final long L_DASH = URI.lowMask("-");
    private static final long H_DASH = URI.highMask("-");
    private static final long L_DOT = URI.lowMask(".");
    private static final long H_DOT = URI.highMask(".");
    private static final long L_USERINFO = L_UNRESERVED | 1L | URI.lowMask(";:&=+$,");
    private static final long H_USERINFO = H_UNRESERVED | 0L | URI.highMask(";:&=+$,");
    private static final long L_REG_NAME = L_UNRESERVED | 1L | URI.lowMask("$,;:@&=+");
    private static final long H_REG_NAME = H_UNRESERVED | 0L | URI.highMask("$,;:@&=+");
    private static final long L_SERVER = L_USERINFO | L_ALPHANUM | L_DASH | URI.lowMask(".:@[]");
    private static final long H_SERVER = H_USERINFO | H_ALPHANUM | H_DASH | URI.highMask(".:@[]");
    private static final long L_SERVER_PERCENT = L_SERVER | URI.lowMask("%");
    private static final long H_SERVER_PERCENT = H_SERVER | URI.highMask("%");
    private static final long L_LEFT_BRACKET = URI.lowMask("[");
    private static final long H_LEFT_BRACKET = URI.highMask("[");
    private static final long L_SCHEME = 0L | L_DIGIT | URI.lowMask("+-.");
    private static final long H_SCHEME = H_ALPHA | 0L | URI.highMask("+-.");
    private static final long L_URIC_NO_SLASH = L_UNRESERVED | 1L | URI.lowMask(";?:@&=+$,");
    private static final long H_URIC_NO_SLASH = H_UNRESERVED | 0L | URI.highMask(";?:@&=+$,");
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private URI() {
    }

    public URI(String string) throws URISyntaxException {
        new Parser(string).parse(false);
    }

    public URI(String string, String string2, String string3, int n2, String string4, String string5, String string6) throws URISyntaxException {
        String string7 = this.toString(string, null, null, string2, string3, n2, string4, string5, string6);
        URI.checkPath(string7, string, string4);
        new Parser(string7).parse(true);
    }

    public URI(String string, String string2, String string3, String string4, String string5) throws URISyntaxException {
        String string6 = this.toString(string, null, string2, null, null, -1, string3, string4, string5);
        URI.checkPath(string6, string, string3);
        new Parser(string6).parse(false);
    }

    public URI(String string, String string2, String string3, String string4) throws URISyntaxException {
        this(string, null, string2, -1, string3, null, string4);
    }

    public URI(String string, String string2, String string3) throws URISyntaxException {
        new Parser(this.toString(string, string2, null, null, null, -1, null, null, string3)).parse(false);
    }

    public static URI create(String string) {
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            illegalArgumentException.initCause(uRISyntaxException);
            throw illegalArgumentException;
        }
    }

    public URI parseServerAuthority() throws URISyntaxException {
        if (this.host != null || this.authority == null) {
            return this;
        }
        this.defineString();
        new Parser(this.string).parse(true);
        return this;
    }

    public URI normalize() {
        return URI.normalize(this);
    }

    public URI resolve(URI uRI) {
        return URI.resolve(this, uRI);
    }

    public URI resolve(String string) {
        return this.resolve(URI.create(string));
    }

    public URI relativize(URI uRI) {
        return URI.relativize(this, uRI);
    }

    public URL toURL() throws MalformedURLException {
        if (!this.isAbsolute()) {
            throw new IllegalArgumentException("URI is not absolute");
        }
        return new URL(this.toString());
    }

    public String getScheme() {
        return this.scheme;
    }

    public boolean isAbsolute() {
        return this.scheme != null;
    }

    public boolean isOpaque() {
        return this.path == null;
    }

    public String getRawSchemeSpecificPart() {
        this.defineSchemeSpecificPart();
        return this.schemeSpecificPart;
    }

    public String getSchemeSpecificPart() {
        if (this.decodedSchemeSpecificPart == null) {
            this.decodedSchemeSpecificPart = URI.decode(this.getRawSchemeSpecificPart());
        }
        return this.decodedSchemeSpecificPart;
    }

    public String getRawAuthority() {
        return this.authority;
    }

    public String getAuthority() {
        if (this.decodedAuthority == null) {
            this.decodedAuthority = URI.decode(this.authority);
        }
        return this.decodedAuthority;
    }

    public String getRawUserInfo() {
        return this.userInfo;
    }

    public String getUserInfo() {
        if (this.decodedUserInfo == null && this.userInfo != null) {
            this.decodedUserInfo = URI.decode(this.userInfo);
        }
        return this.decodedUserInfo;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getRawPath() {
        return this.path;
    }

    public String getPath() {
        if (this.decodedPath == null && this.path != null) {
            this.decodedPath = URI.decode(this.path);
        }
        return this.decodedPath;
    }

    public String getRawQuery() {
        return this.query;
    }

    public String getQuery() {
        if (this.decodedQuery == null && this.query != null) {
            this.decodedQuery = URI.decode(this.query);
        }
        return this.decodedQuery;
    }

    public String getRawFragment() {
        return this.fragment;
    }

    public String getFragment() {
        if (this.decodedFragment == null && this.fragment != null) {
            this.decodedFragment = URI.decode(this.fragment);
        }
        return this.decodedFragment;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof URI)) {
            return false;
        }
        URI uRI = (URI)object;
        if (this.isOpaque() != uRI.isOpaque()) {
            return false;
        }
        if (!URI.equalIgnoringCase(this.scheme, uRI.scheme)) {
            return false;
        }
        if (!URI.equal(this.fragment, uRI.fragment)) {
            return false;
        }
        if (this.isOpaque()) {
            return URI.equal(this.schemeSpecificPart, uRI.schemeSpecificPart);
        }
        if (!URI.equal(this.path, uRI.path)) {
            return false;
        }
        if (!URI.equal(this.query, uRI.query)) {
            return false;
        }
        if (this.authority == uRI.authority) {
            return true;
        }
        if (this.host != null) {
            if (!URI.equal(this.userInfo, uRI.userInfo)) {
                return false;
            }
            if (!URI.equalIgnoringCase(this.host, uRI.host)) {
                return false;
            }
            if (this.port != uRI.port) {
                return false;
            }
        } else if (this.authority != null ? !URI.equal(this.authority, uRI.authority) : this.authority != uRI.authority) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        int n2 = URI.hashIgnoringCase(0, this.scheme);
        n2 = URI.hash(n2, this.fragment);
        if (this.isOpaque()) {
            n2 = URI.hash(n2, this.schemeSpecificPart);
        } else {
            n2 = URI.hash(n2, this.path);
            n2 = URI.hash(n2, this.query);
            if (this.host != null) {
                n2 = URI.hash(n2, this.userInfo);
                n2 = URI.hashIgnoringCase(n2, this.host);
                n2 += 1949 * this.port;
            } else {
                n2 = URI.hash(n2, this.authority);
            }
        }
        this.hash = n2;
        return n2;
    }

    @Override
    public int compareTo(URI uRI) {
        int n2 = URI.compareIgnoringCase(this.scheme, uRI.scheme);
        if (n2 != 0) {
            return n2;
        }
        if (this.isOpaque()) {
            if (uRI.isOpaque()) {
                n2 = URI.compare(this.schemeSpecificPart, uRI.schemeSpecificPart);
                if (n2 != 0) {
                    return n2;
                }
                return URI.compare(this.fragment, uRI.fragment);
            }
            return 1;
        }
        if (uRI.isOpaque()) {
            return -1;
        }
        if (this.host != null && uRI.host != null) {
            n2 = URI.compare(this.userInfo, uRI.userInfo);
            if (n2 != 0) {
                return n2;
            }
            n2 = URI.compareIgnoringCase(this.host, uRI.host);
            if (n2 != 0) {
                return n2;
            }
            n2 = this.port - uRI.port;
            if (n2 != 0) {
                return n2;
            }
        } else {
            n2 = URI.compare(this.authority, uRI.authority);
            if (n2 != 0) {
                return n2;
            }
        }
        if ((n2 = URI.compare(this.path, uRI.path)) != 0) {
            return n2;
        }
        n2 = URI.compare(this.query, uRI.query);
        if (n2 != 0) {
            return n2;
        }
        return URI.compare(this.fragment, uRI.fragment);
    }

    public String toString() {
        this.defineString();
        return this.string;
    }

    public String toASCIIString() {
        this.defineString();
        return URI.encode(this.string);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.defineString();
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        this.port = -1;
        objectInputStream.defaultReadObject();
        try {
            new Parser(this.string).parse(false);
        }
        catch (URISyntaxException uRISyntaxException) {
            InvalidObjectException invalidObjectException = new InvalidObjectException("Invalid URI");
            invalidObjectException.initCause(uRISyntaxException);
            throw invalidObjectException;
        }
    }

    private static int toLower(char c2) {
        if (c2 >= 'A' && c2 <= 'Z') {
            return c2 + 32;
        }
        return c2;
    }

    private static boolean equal(String string, String string2) {
        if (string == string2) {
            return true;
        }
        if (string != null && string2 != null) {
            if (string.length() != string2.length()) {
                return false;
            }
            if (string.indexOf(37) < 0) {
                return string.equals(string2);
            }
            int n2 = string.length();
            int n3 = 0;
            while (n3 < n2) {
                char c2 = string.charAt(n3);
                char c3 = string2.charAt(n3);
                if (c2 != '%') {
                    if (c2 != c3) {
                        return false;
                    }
                    ++n3;
                    continue;
                }
                if (URI.toLower(string.charAt(++n3)) != URI.toLower(string2.charAt(n3))) {
                    return false;
                }
                if (URI.toLower(string.charAt(++n3)) != URI.toLower(string2.charAt(n3))) {
                    return false;
                }
                ++n3;
            }
            return true;
        }
        return false;
    }

    private static boolean equalIgnoringCase(String string, String string2) {
        if (string == string2) {
            return true;
        }
        if (string != null && string2 != null) {
            int n2 = string.length();
            if (string2.length() != n2) {
                return false;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                if (URI.toLower(string.charAt(i2)) == URI.toLower(string2.charAt(i2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static int hash(int n2, String string) {
        if (string == null) {
            return n2;
        }
        return n2 * 127 + string.hashCode();
    }

    private static int hashIgnoringCase(int n2, String string) {
        if (string == null) {
            return n2;
        }
        int n3 = n2;
        int n4 = string.length();
        for (int i2 = 0; i2 < n4; ++i2) {
            n3 = 31 * n3 + URI.toLower(string.charAt(i2));
        }
        return n3;
    }

    private static int compare(String string, String string2) {
        if (string == string2) {
            return 0;
        }
        if (string != null) {
            if (string2 != null) {
                return string.compareTo(string2);
            }
            return 1;
        }
        return -1;
    }

    private static int compareIgnoringCase(String string, String string2) {
        if (string == string2) {
            return 0;
        }
        if (string != null) {
            if (string2 != null) {
                int n2;
                int n3 = string.length();
                int n4 = n3 < (n2 = string2.length()) ? n3 : n2;
                for (int i2 = 0; i2 < n4; ++i2) {
                    int n5 = URI.toLower(string.charAt(i2)) - URI.toLower(string2.charAt(i2));
                    if (n5 == 0) continue;
                    return n5;
                }
                return n3 - n2;
            }
            return 1;
        }
        return -1;
    }

    private static void checkPath(String string, String string2, String string3) throws URISyntaxException {
        if (string2 != null && string3 != null && string3.length() > 0 && string3.charAt(0) != '/') {
            throw new URISyntaxException(string, "Relative path in absolute URI");
        }
    }

    private void appendAuthority(StringBuffer stringBuffer, String string, String string2, String string3, int n2) {
        if (string3 != null) {
            boolean bl2;
            stringBuffer.append("//");
            if (string2 != null) {
                stringBuffer.append(URI.quote(string2, L_USERINFO, H_USERINFO));
                stringBuffer.append('@');
            }
            boolean bl3 = bl2 = string3.indexOf(58) >= 0 && !string3.startsWith("[") && !string3.endsWith("]");
            if (bl2) {
                stringBuffer.append('[');
            }
            stringBuffer.append(string3);
            if (bl2) {
                stringBuffer.append(']');
            }
            if (n2 != -1) {
                stringBuffer.append(':');
                stringBuffer.append(n2);
            }
        } else if (string != null) {
            stringBuffer.append("//");
            if (string.startsWith("[")) {
                int n3 = string.indexOf("]");
                if (n3 != -1 && string.indexOf(":") != -1) {
                    String string4;
                    String string5;
                    if (n3 == string.length()) {
                        string5 = string;
                        string4 = "";
                    } else {
                        string5 = string.substring(0, n3 + 1);
                        string4 = string.substring(n3 + 1);
                    }
                    stringBuffer.append(string5);
                    stringBuffer.append(URI.quote(string4, L_REG_NAME | L_SERVER, H_REG_NAME | H_SERVER));
                }
            } else {
                stringBuffer.append(URI.quote(string, L_REG_NAME | L_SERVER, H_REG_NAME | H_SERVER));
            }
        }
    }

    private void appendSchemeSpecificPart(StringBuffer stringBuffer, String string, String string2, String string3, String string4, int n2, String string5, String string6) {
        if (string != null) {
            if (string.startsWith("//[")) {
                int n3 = string.indexOf("]");
                if (n3 != -1 && string.indexOf(":") != -1) {
                    String string7;
                    String string8;
                    if (n3 == string.length()) {
                        string8 = string;
                        string7 = "";
                    } else {
                        string8 = string.substring(0, n3 + 1);
                        string7 = string.substring(n3 + 1);
                    }
                    stringBuffer.append(string8);
                    stringBuffer.append(URI.quote(string7, L_URIC, H_URIC));
                }
            } else {
                stringBuffer.append(URI.quote(string, L_URIC, H_URIC));
            }
        } else {
            this.appendAuthority(stringBuffer, string2, string3, string4, n2);
            if (string5 != null) {
                stringBuffer.append(URI.quote(string5, L_PATH, H_PATH));
            }
            if (string6 != null) {
                stringBuffer.append('?');
                stringBuffer.append(URI.quote(string6, L_URIC, H_URIC));
            }
        }
    }

    private void appendFragment(StringBuffer stringBuffer, String string) {
        if (string != null) {
            stringBuffer.append('#');
            stringBuffer.append(URI.quote(string, L_URIC, H_URIC));
        }
    }

    private String toString(String string, String string2, String string3, String string4, String string5, int n2, String string6, String string7, String string8) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append(':');
        }
        this.appendSchemeSpecificPart(stringBuffer, string2, string3, string4, string5, n2, string6, string7);
        this.appendFragment(stringBuffer, string8);
        return stringBuffer.toString();
    }

    private void defineSchemeSpecificPart() {
        if (this.schemeSpecificPart != null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.appendSchemeSpecificPart(stringBuffer, null, this.getAuthority(), this.getUserInfo(), this.host, this.port, this.getPath(), this.getQuery());
        if (stringBuffer.length() == 0) {
            return;
        }
        this.schemeSpecificPart = stringBuffer.toString();
    }

    private void defineString() {
        if (this.string != null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.scheme != null) {
            stringBuffer.append(this.scheme);
            stringBuffer.append(':');
        }
        if (this.isOpaque()) {
            stringBuffer.append(this.schemeSpecificPart);
        } else {
            if (this.host != null) {
                boolean bl2;
                stringBuffer.append("//");
                if (this.userInfo != null) {
                    stringBuffer.append(this.userInfo);
                    stringBuffer.append('@');
                }
                boolean bl3 = bl2 = this.host.indexOf(58) >= 0 && !this.host.startsWith("[") && !this.host.endsWith("]");
                if (bl2) {
                    stringBuffer.append('[');
                }
                stringBuffer.append(this.host);
                if (bl2) {
                    stringBuffer.append(']');
                }
                if (this.port != -1) {
                    stringBuffer.append(':');
                    stringBuffer.append(this.port);
                }
            } else if (this.authority != null) {
                stringBuffer.append("//");
                stringBuffer.append(this.authority);
            }
            if (this.path != null) {
                stringBuffer.append(this.path);
            }
            if (this.query != null) {
                stringBuffer.append('?');
                stringBuffer.append(this.query);
            }
        }
        if (this.fragment != null) {
            stringBuffer.append('#');
            stringBuffer.append(this.fragment);
        }
        this.string = stringBuffer.toString();
    }

    private static String resolvePath(String string, String string2, boolean bl2) {
        CharSequence charSequence;
        int n2 = string.lastIndexOf(47);
        int n3 = string2.length();
        String string3 = "";
        if (n3 == 0) {
            if (n2 >= 0) {
                string3 = string.substring(0, n2 + 1);
            }
        } else {
            charSequence = new StringBuffer(string.length() + n3);
            if (n2 >= 0) {
                ((StringBuffer)charSequence).append(string.substring(0, n2 + 1));
            }
            ((StringBuffer)charSequence).append(string2);
            string3 = ((StringBuffer)charSequence).toString();
        }
        charSequence = URI.normalize(string3);
        return charSequence;
    }

    private static URI resolve(URI uRI, URI uRI2) {
        if (uRI2.isOpaque() || uRI.isOpaque()) {
            return uRI2;
        }
        if (uRI2.scheme == null && uRI2.authority == null && uRI2.path.equals("") && uRI2.fragment != null && uRI2.query == null) {
            if (uRI.fragment != null && uRI2.fragment.equals(uRI.fragment)) {
                return uRI;
            }
            URI uRI3 = new URI();
            uRI3.scheme = uRI.scheme;
            uRI3.authority = uRI.authority;
            uRI3.userInfo = uRI.userInfo;
            uRI3.host = uRI.host;
            uRI3.port = uRI.port;
            uRI3.path = uRI.path;
            uRI3.fragment = uRI2.fragment;
            uRI3.query = uRI.query;
            return uRI3;
        }
        if (uRI2.scheme != null) {
            return uRI2;
        }
        URI uRI4 = new URI();
        uRI4.scheme = uRI.scheme;
        uRI4.query = uRI2.query;
        uRI4.fragment = uRI2.fragment;
        if (uRI2.authority == null) {
            String string;
            uRI4.authority = uRI.authority;
            uRI4.host = uRI.host;
            uRI4.userInfo = uRI.userInfo;
            uRI4.port = uRI.port;
            String string2 = string = uRI2.path == null ? "" : uRI2.path;
            uRI4.path = string.length() > 0 && string.charAt(0) == '/' ? uRI2.path : URI.resolvePath(uRI.path, string, uRI.isAbsolute());
        } else {
            uRI4.authority = uRI2.authority;
            uRI4.host = uRI2.host;
            uRI4.userInfo = uRI2.userInfo;
            uRI4.host = uRI2.host;
            uRI4.port = uRI2.port;
            uRI4.path = uRI2.path;
        }
        return uRI4;
    }

    private static URI normalize(URI uRI) {
        if (uRI.isOpaque() || uRI.path == null || uRI.path.length() == 0) {
            return uRI;
        }
        String string = URI.normalize(uRI.path);
        if (string == uRI.path) {
            return uRI;
        }
        URI uRI2 = new URI();
        uRI2.scheme = uRI.scheme;
        uRI2.fragment = uRI.fragment;
        uRI2.authority = uRI.authority;
        uRI2.userInfo = uRI.userInfo;
        uRI2.host = uRI.host;
        uRI2.port = uRI.port;
        uRI2.path = string;
        uRI2.query = uRI.query;
        return uRI2;
    }

    private static URI relativize(URI uRI, URI uRI2) {
        String string;
        if (uRI2.isOpaque() || uRI.isOpaque()) {
            return uRI2;
        }
        if (!URI.equalIgnoringCase(uRI.scheme, uRI2.scheme) || !URI.equal(uRI.authority, uRI2.authority)) {
            return uRI2;
        }
        String string2 = URI.normalize(uRI.path);
        if (!string2.equals(string = URI.normalize(uRI2.path))) {
            if (!string2.endsWith("/")) {
                string2 = string2 + "/";
            }
            if (!string.startsWith(string2)) {
                return uRI2;
            }
        }
        URI uRI3 = new URI();
        uRI3.path = string.substring(string2.length());
        uRI3.query = uRI2.query;
        uRI3.fragment = uRI2.fragment;
        return uRI3;
    }

    private static int needsNormalization(String string) {
        int n2;
        boolean bl2 = true;
        int n3 = 0;
        int n4 = string.length() - 1;
        for (n2 = 0; n2 <= n4 && string.charAt(n2) == '/'; ++n2) {
        }
        if (n2 > 1) {
            bl2 = false;
        }
        block1: while (n2 <= n4) {
            if (string.charAt(n2) == '.' && (n2 == n4 || string.charAt(n2 + 1) == '/' || string.charAt(n2 + 1) == '.' && (n2 + 1 == n4 || string.charAt(n2 + 2) == '/'))) {
                bl2 = false;
            }
            ++n3;
            while (n2 <= n4) {
                if (string.charAt(n2++) != '/') continue;
                while (n2 <= n4 && string.charAt(n2) == '/') {
                    bl2 = false;
                    ++n2;
                }
                continue block1;
            }
        }
        return bl2 ? -1 : n3;
    }

    private static void split(char[] cArray, int[] nArray) {
        int n2;
        int n3 = cArray.length - 1;
        int n4 = 0;
        for (n2 = 0; n2 <= n3 && cArray[n2] == '/'; ++n2) {
            cArray[n2] = '\u0000';
        }
        block1: while (n2 <= n3) {
            nArray[n4++] = n2++;
            while (n2 <= n3) {
                if (cArray[n2++] != '/') continue;
                cArray[n2 - 1] = '\u0000';
                while (n2 <= n3 && cArray[n2] == '/') {
                    cArray[n2++] = '\u0000';
                }
                continue block1;
            }
        }
        if (n4 != nArray.length) {
            throw new InternalError();
        }
    }

    private static int join(char[] cArray, int[] nArray) {
        int n2 = nArray.length;
        int n3 = cArray.length - 1;
        int n4 = 0;
        if (cArray[n4] == '\u0000') {
            cArray[n4++] = 47;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            int n5 = nArray[i2];
            if (n5 == -1) continue;
            if (n4 == n5) {
                while (n4 <= n3 && cArray[n4] != '\u0000') {
                    ++n4;
                }
                if (n4 > n3) continue;
                cArray[n4++] = 47;
                continue;
            }
            if (n4 < n5) {
                while (n5 <= n3 && cArray[n5] != '\u0000') {
                    cArray[n4++] = cArray[n5++];
                }
                if (n5 > n3) continue;
                cArray[n4++] = 47;
                continue;
            }
            throw new InternalError();
        }
        return n4;
    }

    private static void removeDots(char[] cArray, int[] nArray) {
        int n2 = nArray.length;
        int n3 = cArray.length - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4;
            int n5;
            int n6 = 0;
            do {
                if (cArray[n5 = nArray[i2]] != '.') continue;
                if (n5 == n3) {
                    n6 = 1;
                    break;
                }
                if (cArray[n5 + 1] == '\u0000') {
                    n6 = 1;
                    break;
                }
                if (cArray[n5 + 1] != '.' || n5 + 1 != n3 && cArray[n5 + 2] != '\u0000') continue;
                n6 = 2;
                break;
            } while (++i2 < n2);
            if (i2 > n2 || n6 == 0) break;
            if (n6 == 1) {
                nArray[i2] = -1;
                continue;
            }
            for (n5 = i2 - 1; n5 >= 0 && nArray[n5] == -1; --n5) {
            }
            if (n5 < 0 || cArray[n4 = nArray[n5]] == '.' && cArray[n4 + 1] == '.' && cArray[n4 + 2] == '\u0000') continue;
            nArray[i2] = -1;
            nArray[n5] = -1;
        }
    }

    private static void maybeAddLeadingDot(char[] cArray, int[] nArray) {
        int n2;
        int n3;
        if (cArray[0] == '\u0000') {
            return;
        }
        int n4 = nArray.length;
        for (n3 = 0; n3 < n4 && nArray[n3] < 0; ++n3) {
        }
        if (n3 >= n4 || n3 == 0) {
            return;
        }
        for (n2 = nArray[n3]; n2 < cArray.length && cArray[n2] != ':' && cArray[n2] != '\u0000'; ++n2) {
        }
        if (n2 >= cArray.length || cArray[n2] == '\u0000') {
            return;
        }
        cArray[0] = 46;
        cArray[1] = '\u0000';
        nArray[0] = 0;
    }

    private static String normalize(String string) {
        int n2 = URI.needsNormalization(string);
        if (n2 < 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int[] nArray = new int[n2];
        URI.split(cArray, nArray);
        URI.removeDots(cArray, nArray);
        URI.maybeAddLeadingDot(cArray, nArray);
        String string2 = new String(cArray, 0, URI.join(cArray, nArray));
        if (string2.equals(string)) {
            return string;
        }
        return string2;
    }

    private static long lowMask(String string) {
        int n2 = string.length();
        long l2 = 0L;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= '@') continue;
            l2 |= 1L << c2;
        }
        return l2;
    }

    private static long highMask(String string) {
        int n2 = string.length();
        long l2 = 0L;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 < '@' || c2 >= '\u0080') continue;
            l2 |= 1L << c2 - 64;
        }
        return l2;
    }

    private static long lowMask(char c2, char c3) {
        long l2 = 0L;
        int n2 = Math.max(Math.min(c2, 63), 0);
        int n3 = Math.max(Math.min(c3, 63), 0);
        for (int i2 = n2; i2 <= n3; ++i2) {
            l2 |= 1L << i2;
        }
        return l2;
    }

    private static long highMask(char c2, char c3) {
        long l2 = 0L;
        int n2 = Math.max(Math.min(c2, 127), 64) - 64;
        int n3 = Math.max(Math.min(c3, 127), 64) - 64;
        for (int i2 = n2; i2 <= n3; ++i2) {
            l2 |= 1L << i2;
        }
        return l2;
    }

    private static boolean match(char c2, long l2, long l3) {
        if (c2 < '@') {
            return (1L << c2 & l2) != 0L;
        }
        if (c2 < '\u0080') {
            return (1L << c2 - 64 & l3) != 0L;
        }
        return false;
    }

    private static void appendEscape(StringBuffer stringBuffer, byte by) {
        stringBuffer.append('%');
        stringBuffer.append(hexDigits[by >> 4 & 0xF]);
        stringBuffer.append(hexDigits[by >> 0 & 0xF]);
    }

    private static void appendEncoded(StringBuffer stringBuffer, char c2) {
        Buffer buffer;
        block4: {
            buffer = null;
            try {
                buffer = ThreadLocalCoders.encoderFor("UTF-8").encode(CharBuffer.wrap("" + c2));
            }
            catch (CharacterCodingException characterCodingException) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        while (buffer.hasRemaining()) {
            int n2 = ((ByteBuffer)buffer).get() & 0xFF;
            if (n2 >= 128) {
                URI.appendEscape(stringBuffer, (byte)n2);
                continue;
            }
            stringBuffer.append((char)n2);
        }
    }

    private static String quote(String string, long l2, long l3) {
        int n2 = string.length();
        StringBuffer stringBuffer = null;
        boolean bl2 = (l2 & 1L) != 0L;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 < '\u0080') {
                if (!URI.match(c2, l2, l3)) {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                        stringBuffer.append(string.substring(0, i2));
                    }
                    URI.appendEscape(stringBuffer, (byte)c2);
                    continue;
                }
                if (stringBuffer == null) continue;
                stringBuffer.append(c2);
                continue;
            }
            if (bl2 && (Character.isSpaceChar(c2) || Character.isISOControl(c2))) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                    stringBuffer.append(string.substring(0, i2));
                }
                URI.appendEncoded(stringBuffer, c2);
                continue;
            }
            if (stringBuffer == null) continue;
            stringBuffer.append(c2);
        }
        return stringBuffer == null ? string : stringBuffer.toString();
    }

    private static String encode(String string) {
        ByteBuffer byteBuffer;
        block6: {
            int n2 = string.length();
            if (n2 == 0) {
                return string;
            }
            int n3 = 0;
            while (string.charAt(n3) < '\u0080') {
                if (++n3 < n2) continue;
                return string;
            }
            String string2 = Normalizer.normalize(string, Normalizer.COMPOSE, 0);
            byteBuffer = null;
            try {
                byteBuffer = ThreadLocalCoders.encoderFor("UTF-8").encode(CharBuffer.wrap(string2));
            }
            catch (CharacterCodingException characterCodingException) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (byteBuffer.hasRemaining()) {
            int n4 = byteBuffer.get() & 0xFF;
            if (n4 >= 128) {
                URI.appendEscape(stringBuffer, (byte)n4);
                continue;
            }
            stringBuffer.append((char)n4);
        }
        return stringBuffer.toString();
    }

    private static int decode(char c2) {
        if (c2 >= '0' && c2 <= '9') {
            return c2 - 48;
        }
        if (c2 >= 'a' && c2 <= 'f') {
            return c2 - 97 + 10;
        }
        if (c2 >= 'A' && c2 <= 'F') {
            return c2 - 65 + 10;
        }
        assert (false);
        return -1;
    }

    private static byte decode(char c2, char c3) {
        return (byte)((URI.decode(c2) & 0xF) << 4 | (URI.decode(c3) & 0xF) << 0);
    }

    private static String decode(String string) {
        if (string == null) {
            return string;
        }
        int n2 = string.length();
        if (n2 == 0) {
            return string;
        }
        if (string.indexOf(37) < 0) {
            return string;
        }
        byte[] byArray = new byte[n2];
        StringBuffer stringBuffer = new StringBuffer(n2);
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        CharBuffer charBuffer = CharBuffer.allocate(n2);
        CharsetDecoder charsetDecoder = ThreadLocalCoders.decoderFor("UTF-8").onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        char c2 = string.charAt(0);
        boolean bl2 = false;
        int n3 = 0;
        while (n3 < n2) {
            assert (c2 == string.charAt(n3));
            if (c2 == '[') {
                bl2 = true;
            } else if (bl2 && c2 == ']') {
                bl2 = false;
            }
            if (c2 != '%' || bl2) {
                stringBuffer.append(c2);
                if (++n3 >= n2) break;
                c2 = string.charAt(n3);
                continue;
            }
            byteBuffer.clear();
            int n4 = n3;
            do {
                assert (n2 - n3 >= 2);
                byteBuffer.put(URI.decode(string.charAt(++n3), string.charAt(++n3)));
            } while (++n3 < n2 && (c2 = string.charAt(n3)) == '%');
            byteBuffer.flip();
            charBuffer.clear();
            charsetDecoder.reset();
            CoderResult coderResult = charsetDecoder.decode(byteBuffer, charBuffer, true);
            assert (coderResult.isUnderflow());
            coderResult = charsetDecoder.flush(charBuffer);
            assert (coderResult.isUnderflow());
            stringBuffer.append(charBuffer.flip().toString());
        }
        return stringBuffer.toString();
    }

    private class Parser {
        private String input;
        private boolean requireServerAuthority = false;
        private int ipv6byteCount = 0;

        Parser(String string) {
            this.input = string;
            URI.this.string = string;
        }

        private void fail(String string) throws URISyntaxException {
            throw new URISyntaxException(this.input, string);
        }

        private void fail(String string, int n2) throws URISyntaxException {
            throw new URISyntaxException(this.input, string, n2);
        }

        private void failExpecting(String string, int n2) throws URISyntaxException {
            this.fail("Expected " + string, n2);
        }

        private void failExpecting(String string, String string2, int n2) throws URISyntaxException {
            this.fail("Expected " + string + " following " + string2, n2);
        }

        private String substring(int n2, int n3) {
            return this.input.substring(n2, n3);
        }

        private char charAt(int n2) {
            return this.input.charAt(n2);
        }

        private boolean at(int n2, int n3, char c2) {
            return n2 < n3 && this.charAt(n2) == c2;
        }

        private boolean at(int n2, int n3, String string) {
            int n4;
            int n5 = n2;
            int n6 = string.length();
            if (n6 > n3 - n5) {
                return false;
            }
            for (n4 = 0; n4 < n6 && this.charAt(n5++) == string.charAt(n4); ++n4) {
            }
            return n4 == n6;
        }

        private int scan(int n2, int n3, char c2) {
            if (n2 < n3 && this.charAt(n2) == c2) {
                return n2 + 1;
            }
            return n2;
        }

        private int scan(int n2, int n3, String string, String string2) {
            int n4;
            for (n4 = n2; n4 < n3; ++n4) {
                char c2 = this.charAt(n4);
                if (string.indexOf(c2) >= 0) {
                    return -1;
                }
                if (string2.indexOf(c2) >= 0) break;
            }
            return n4;
        }

        private int scanEscape(int n2, int n3, char c2) throws URISyntaxException {
            int n4 = n2;
            char c3 = c2;
            if (c3 == '%') {
                if (n4 + 3 <= n3 && URI.match(this.charAt(n4 + 1), L_HEX, H_HEX) && URI.match(this.charAt(n4 + 2), L_HEX, H_HEX)) {
                    return n4 + 3;
                }
                this.fail("Malformed escape pair", n4);
            } else if (c3 > '\u0080' && !Character.isSpaceChar(c3) && !Character.isISOControl(c3)) {
                return n4 + 1;
            }
            return n4;
        }

        private int scan(int n2, int n3, long l2, long l3) throws URISyntaxException {
            int n4 = n2;
            while (n4 < n3) {
                int n5;
                char c2 = this.charAt(n4);
                if (URI.match(c2, l2, l3)) {
                    ++n4;
                    continue;
                }
                if ((l2 & 1L) == 0L || (n5 = this.scanEscape(n4, n3, c2)) <= n4) break;
                n4 = n5;
            }
            return n4;
        }

        private void checkChars(int n2, int n3, long l2, long l3, String string) throws URISyntaxException {
            int n4 = this.scan(n2, n3, l2, l3);
            if (n4 < n3) {
                this.fail("Illegal character in " + string, n4);
            }
        }

        private void checkChar(int n2, long l2, long l3, String string) throws URISyntaxException {
            this.checkChars(n2, n2 + 1, l2, l3, string);
        }

        void parse(boolean bl2) throws URISyntaxException {
            int n2;
            this.requireServerAuthority = bl2;
            int n3 = this.input.length();
            int n4 = this.scan(0, n3, "/?#", ":");
            if (n4 >= 0 && this.at(n4, n3, ':')) {
                if (n4 == 0) {
                    this.failExpecting("scheme name", 0);
                }
                this.checkChar(0, 0L, H_ALPHA, "scheme name");
                this.checkChars(1, n4, L_SCHEME, H_SCHEME, "scheme name");
                URI.this.scheme = this.substring(0, n4);
                n2 = ++n4;
                if (this.at(n4, n3, '/')) {
                    n4 = this.parseHierarchical(n4, n3);
                } else {
                    int n5 = this.scan(n4, n3, "", "#");
                    if (n5 <= n4) {
                        this.failExpecting("scheme-specific part", n4);
                    }
                    this.checkChars(n4, n5, L_URIC, H_URIC, "opaque part");
                    n4 = n5;
                }
            } else {
                n2 = 0;
                n4 = this.parseHierarchical(0, n3);
            }
            URI.this.schemeSpecificPart = this.substring(n2, n4);
            if (this.at(n4, n3, '#')) {
                this.checkChars(n4 + 1, n3, L_URIC, H_URIC, "fragment");
                URI.this.fragment = this.substring(n4 + 1, n3);
                n4 = n3;
            }
            if (n4 < n3) {
                this.fail("end of URI", n4);
            }
        }

        private int parseHierarchical(int n2, int n3) throws URISyntaxException {
            int n4;
            int n5 = n2;
            if (this.at(n5, n3, '/') && this.at(n5 + 1, n3, '/')) {
                n4 = this.scan(n5 += 2, n3, "", "/?#");
                if (n4 > n5) {
                    n5 = this.parseAuthority(n5, n4);
                } else if (n4 >= n3) {
                    this.failExpecting("authority", n5);
                }
            }
            n4 = this.scan(n5, n3, "", "?#");
            this.checkChars(n5, n4, L_PATH, H_PATH, "path");
            URI.this.path = this.substring(n5, n4);
            n5 = n4;
            if (this.at(n5, n3, '?')) {
                n4 = this.scan(++n5, n3, "", "#");
                this.checkChars(n5, n4, L_URIC, H_URIC, "query");
                URI.this.query = this.substring(n5, n4);
                n5 = n4;
            }
            return n5;
        }

        private int parseAuthority(int n2, int n3) throws URISyntaxException {
            boolean bl2;
            int n4;
            int n5 = n4 = n2;
            URISyntaxException uRISyntaxException = null;
            boolean bl3 = this.scan(n4, n3, "", "]") > n4 ? this.scan(n4, n3, L_SERVER_PERCENT, H_SERVER_PERCENT) == n3 : this.scan(n4, n3, L_SERVER, H_SERVER) == n3;
            boolean bl4 = bl2 = this.scan(n4, n3, L_REG_NAME, H_REG_NAME) == n3;
            if (bl2 && !bl3) {
                URI.this.authority = this.substring(n4, n3);
                return n3;
            }
            if (bl3) {
                try {
                    n5 = this.parseServer(n4, n3);
                    if (n5 < n3) {
                        this.failExpecting("end of authority", n5);
                    }
                    URI.this.authority = this.substring(n4, n3);
                }
                catch (URISyntaxException uRISyntaxException2) {
                    URI.this.userInfo = null;
                    URI.this.host = null;
                    URI.this.port = -1;
                    if (this.requireServerAuthority) {
                        throw uRISyntaxException2;
                    }
                    uRISyntaxException = uRISyntaxException2;
                    n5 = n4;
                }
            }
            if (n5 < n3) {
                if (bl2) {
                    URI.this.authority = this.substring(n4, n3);
                } else {
                    if (uRISyntaxException != null) {
                        throw uRISyntaxException;
                    }
                    this.fail("Illegal character in authority", n5);
                }
            }
            return n3;
        }

        private int parseServer(int n2, int n3) throws URISyntaxException {
            int n4 = n2;
            int n5 = this.scan(n4, n3, "/?#", "@");
            if (n5 >= n4 && this.at(n5, n3, '@')) {
                this.checkChars(n4, n5, L_USERINFO, H_USERINFO, "user info");
                URI.this.userInfo = this.substring(n4, n5);
                n4 = n5 + 1;
            }
            if (this.at(n4, n3, '[')) {
                if ((n5 = this.scan(++n4, n3, "/?#", "]")) > n4 && this.at(n5, n3, ']')) {
                    int n6 = this.scan(n4, n5, "", "%");
                    if (n6 > n4) {
                        this.parseIPv6Reference(n4, n6);
                        if (n6 + 1 == n5) {
                            this.fail("scope id expected");
                        }
                        this.checkChars(n6 + 1, n5, L_ALPHANUM, H_ALPHANUM, "scope id");
                    } else {
                        this.parseIPv6Reference(n4, n5);
                    }
                    URI.this.host = this.substring(n4 - 1, n5 + 1);
                    n4 = n5 + 1;
                } else {
                    this.failExpecting("closing bracket for IPv6 address", n5);
                }
            } else {
                n5 = this.parseIPv4Address(n4, n3);
                if (n5 <= n4) {
                    n5 = this.parseHostname(n4, n3);
                }
                n4 = n5;
            }
            if (this.at(n4, n3, ':') && (n5 = this.scan(++n4, n3, "", "/")) > n4) {
                this.checkChars(n4, n5, L_DIGIT, 0L, "port number");
                try {
                    URI.this.port = Integer.parseInt(this.substring(n4, n5));
                }
                catch (NumberFormatException numberFormatException) {
                    this.fail("Malformed port number", n4);
                }
                n4 = n5;
            }
            if (n4 < n3) {
                this.failExpecting("port number", n4);
            }
            return n4;
        }

        private int scanByte(int n2, int n3) throws URISyntaxException {
            int n4 = n2;
            int n5 = this.scan(n4, n3, L_DIGIT, 0L);
            if (n5 <= n4) {
                return n5;
            }
            if (Integer.parseInt(this.substring(n4, n5)) > 255) {
                return n4;
            }
            return n5;
        }

        private int scanIPv4Address(int n2, int n3, boolean bl2) throws URISyntaxException {
            int n4 = n2;
            int n5 = this.scan(n4, n3, L_DIGIT | L_DOT, 0L | H_DOT);
            if (n5 <= n4 || bl2 && n5 != n3) {
                return -1;
            }
            int n6 = this.scanByte(n4, n5);
            if (n6 > n4 && (n6 = this.scan(n4 = n6, n5, '.')) > n4 && (n6 = this.scanByte(n4 = n6, n5)) > n4 && (n6 = this.scan(n4 = n6, n5, '.')) > n4 && (n6 = this.scanByte(n4 = n6, n5)) > n4 && (n6 = this.scan(n4 = n6, n5, '.')) > n4 && (n6 = this.scanByte(n4 = n6, n5)) > n4) {
                n4 = n6;
                if (n6 >= n5) {
                    return n6;
                }
            }
            this.fail("Malformed IPv4 address", n6);
            return -1;
        }

        private int takeIPv4Address(int n2, int n3, String string) throws URISyntaxException {
            int n4 = this.scanIPv4Address(n2, n3, true);
            if (n4 <= n2) {
                this.failExpecting(string, n2);
            }
            return n4;
        }

        private int parseIPv4Address(int n2, int n3) {
            int n4;
            try {
                n4 = this.scanIPv4Address(n2, n3, false);
            }
            catch (URISyntaxException uRISyntaxException) {
                return -1;
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
            if (n4 > n2 && n4 < n3 && this.charAt(n4) != ':') {
                n4 = -1;
            }
            if (n4 > n2) {
                URI.this.host = this.substring(n2, n4);
            }
            return n4;
        }

        private int parseHostname(int n2, int n3) throws URISyntaxException {
            int n4;
            int n5 = n2;
            int n6 = -1;
            while ((n4 = this.scan(n5, n3, L_ALPHANUM, H_ALPHANUM)) > n5) {
                n6 = n5;
                if (n4 > n5 && (n4 = this.scan(n5 = n4, n3, L_ALPHANUM | L_DASH, H_ALPHANUM | H_DASH)) > n5) {
                    if (this.charAt(n4 - 1) == '-') {
                        this.fail("Illegal character in hostname", n4 - 1);
                    }
                    n5 = n4;
                }
                if ((n4 = this.scan(n5, n3, '.')) > n5 && (n5 = n4) < n3) continue;
            }
            if (n5 < n3 && !this.at(n5, n3, ':')) {
                this.fail("Illegal character in hostname", n5);
            }
            if (n6 < 0) {
                this.failExpecting("hostname", n2);
            }
            if (n6 > n2 && !URI.match(this.charAt(n6), 0L, H_ALPHA)) {
                this.fail("Illegal character in hostname", n6);
            }
            URI.this.host = this.substring(n2, n5);
            return n5;
        }

        private int parseIPv6Reference(int n2, int n3) throws URISyntaxException {
            int n4 = n2;
            boolean bl2 = false;
            int n5 = this.scanHexSeq(n4, n3);
            if (n5 > n4) {
                n4 = n5;
                if (this.at(n4, n3, "::")) {
                    bl2 = true;
                    n4 = this.scanHexPost(n4 + 2, n3);
                } else if (this.at(n4, n3, ':')) {
                    n4 = this.takeIPv4Address(n4 + 1, n3, "IPv4 address");
                    this.ipv6byteCount += 4;
                }
            } else if (this.at(n4, n3, "::")) {
                bl2 = true;
                n4 = this.scanHexPost(n4 + 2, n3);
            }
            if (n4 < n3) {
                this.fail("Malformed IPv6 address", n2);
            }
            if (this.ipv6byteCount > 16) {
                this.fail("IPv6 address too long", n2);
            }
            if (!bl2 && this.ipv6byteCount < 16) {
                this.fail("IPv6 address too short", n2);
            }
            if (bl2 && this.ipv6byteCount == 16) {
                this.fail("Malformed IPv6 address", n2);
            }
            return n4;
        }

        private int scanHexPost(int n2, int n3) throws URISyntaxException {
            int n4 = n2;
            if (n4 == n3) {
                return n4;
            }
            int n5 = this.scanHexSeq(n4, n3);
            if (n5 > n4) {
                n4 = n5;
                if (this.at(n4, n3, ':')) {
                    ++n4;
                    n4 = this.takeIPv4Address(n4, n3, "hex digits or IPv4 address");
                    this.ipv6byteCount += 4;
                }
            } else {
                n4 = this.takeIPv4Address(n4, n3, "hex digits or IPv4 address");
                this.ipv6byteCount += 4;
            }
            return n4;
        }

        private int scanHexSeq(int n2, int n3) throws URISyntaxException {
            int n4 = n2;
            int n5 = this.scan(n4, n3, L_HEX, H_HEX);
            if (n5 <= n4) {
                return -1;
            }
            if (this.at(n5, n3, '.')) {
                return -1;
            }
            if (n5 > n4 + 4) {
                this.fail("IPv6 hexadecimal digit sequence too long", n4);
            }
            this.ipv6byteCount += 2;
            n4 = n5;
            while (n4 < n3 && this.at(n4, n3, ':') && !this.at(n4 + 1, n3, ':')) {
                if ((n5 = this.scan(++n4, n3, L_HEX, H_HEX)) <= n4) {
                    this.failExpecting("digits for an IPv6 address", n4);
                }
                if (this.at(n5, n3, '.')) {
                    --n4;
                    break;
                }
                if (n5 > n4 + 4) {
                    this.fail("IPv6 hexadecimal digit sequence too long", n4);
                }
                this.ipv6byteCount += 2;
                n4 = n5;
            }
            return n4;
        }
    }
}

