/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.orbutil;

import com.sun.corba.se.impl.io.ObjectStreamClass;
import com.sun.corba.se.impl.io.ValueUtility;
import com.sun.corba.se.impl.orbutil.ObjectStreamField;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import org.omg.CORBA.ValueMember;

public class ObjectStreamClass_1_3_1
implements Serializable {
    public static final long kDefaultUID = -1L;
    private static Object[] noArgsList = new Object[0];
    private static Class[] noTypesList = new Class[0];
    private static Hashtable translatedFields;
    private static ObjectStreamClassEntry[] descriptorFor;
    private String name;
    private ObjectStreamClass_1_3_1 superclass;
    private boolean serializable;
    private boolean externalizable;
    private ObjectStreamField[] fields;
    private Class ofClass;
    boolean forProxyClass;
    private long suid = -1L;
    private String suidStr = null;
    private long actualSuid = -1L;
    private String actualSuidStr = null;
    int primBytes;
    int objFields;
    private Object lock = new Object();
    private boolean hasWriteObjectMethod;
    private boolean hasExternalizableBlockData;
    Method writeObjectMethod;
    Method readObjectMethod;
    private Method writeReplaceObjectMethod;
    private Method readResolveObjectMethod;
    private ObjectStreamClass_1_3_1 localClassDesc;
    private static Class classSerializable;
    private static Class classExternalizable;
    private static final long serialVersionUID = -6120832682080437368L;
    public static final ObjectStreamField[] NO_FIELDS;
    private static Comparator compareClassByName;
    private static Comparator compareMemberByName;

    static final ObjectStreamClass_1_3_1 lookup(Class clazz) {
        ObjectStreamClass_1_3_1 objectStreamClass_1_3_1 = ObjectStreamClass_1_3_1.lookupInternal(clazz);
        if (objectStreamClass_1_3_1.isSerializable() || objectStreamClass_1_3_1.isExternalizable()) {
            return objectStreamClass_1_3_1;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ObjectStreamClass_1_3_1 lookupInternal(Class clazz) {
        ObjectStreamClass_1_3_1 objectStreamClass_1_3_1 = null;
        ObjectStreamClassEntry[] objectStreamClassEntryArray = descriptorFor;
        synchronized (descriptorFor) {
            Class clazz2;
            objectStreamClass_1_3_1 = ObjectStreamClass_1_3_1.findDescriptorFor(clazz);
            if (objectStreamClass_1_3_1 != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return objectStreamClass_1_3_1;
            }
            boolean bl2 = classSerializable.isAssignableFrom(clazz);
            ObjectStreamClass_1_3_1 objectStreamClass_1_3_12 = null;
            if (bl2 && (clazz2 = clazz.getSuperclass()) != null) {
                objectStreamClass_1_3_12 = ObjectStreamClass_1_3_1.lookup(clazz2);
            }
            boolean bl3 = false;
            if (bl2) {
                boolean bl4 = bl3 = objectStreamClass_1_3_12 != null && objectStreamClass_1_3_12.isExternalizable() || classExternalizable.isAssignableFrom(clazz);
                if (bl3) {
                    bl2 = false;
                }
            }
            objectStreamClass_1_3_1 = new ObjectStreamClass_1_3_1(clazz, objectStreamClass_1_3_12, bl2, bl3);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            objectStreamClass_1_3_1.init();
            return objectStreamClass_1_3_1;
        }
    }

    public final String getName() {
        return this.name;
    }

    public static final long getSerialVersionUID(Class clazz) {
        ObjectStreamClass_1_3_1 objectStreamClass_1_3_1 = ObjectStreamClass_1_3_1.lookup(clazz);
        if (objectStreamClass_1_3_1 != null) {
            return objectStreamClass_1_3_1.getSerialVersionUID();
        }
        return 0L;
    }

    public final long getSerialVersionUID() {
        return this.suid;
    }

    public final String getSerialVersionUIDStr() {
        if (this.suidStr == null) {
            this.suidStr = Long.toHexString(this.suid).toUpperCase();
        }
        return this.suidStr;
    }

    public static final long getActualSerialVersionUID(Class clazz) {
        ObjectStreamClass_1_3_1 objectStreamClass_1_3_1 = ObjectStreamClass_1_3_1.lookup(clazz);
        if (objectStreamClass_1_3_1 != null) {
            return objectStreamClass_1_3_1.getActualSerialVersionUID();
        }
        return 0L;
    }

    public final long getActualSerialVersionUID() {
        return this.actualSuid;
    }

    public final String getActualSerialVersionUIDStr() {
        if (this.actualSuidStr == null) {
            this.actualSuidStr = Long.toHexString(this.actualSuid).toUpperCase();
        }
        return this.actualSuidStr;
    }

    public final Class forClass() {
        return this.ofClass;
    }

    public ObjectStreamField[] getFields() {
        if (this.fields.length > 0) {
            ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[this.fields.length];
            System.arraycopy(this.fields, 0, objectStreamFieldArray, 0, this.fields.length);
            return objectStreamFieldArray;
        }
        return this.fields;
    }

    public boolean hasField(ValueMember valueMember) {
        for (int i2 = 0; i2 < this.fields.length; ++i2) {
            try {
                if (!this.fields[i2].getName().equals(valueMember.name) || !this.fields[i2].getSignature().equals(ValueUtility.getSignature(valueMember))) continue;
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    final ObjectStreamField[] getFieldsNoCopy() {
        return this.fields;
    }

    public final ObjectStreamField getField(String string) {
        for (int i2 = this.fields.length - 1; i2 >= 0; --i2) {
            if (!string.equals(this.fields[i2].getName())) continue;
            return this.fields[i2];
        }
        return null;
    }

    public Serializable writeReplace(Serializable serializable) {
        if (this.writeReplaceObjectMethod != null) {
            try {
                return (Serializable)this.writeReplaceObjectMethod.invoke(serializable, noArgsList);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable.getMessage());
            }
        }
        return serializable;
    }

    public Object readResolve(Object object) {
        if (this.readResolveObjectMethod != null) {
            try {
                return this.readResolveObjectMethod.invoke(object, noArgsList);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable.getMessage());
            }
        }
        return object;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name);
        stringBuffer.append(": static final long serialVersionUID = ");
        stringBuffer.append(Long.toString(this.suid));
        stringBuffer.append("L;");
        return stringBuffer.toString();
    }

    private ObjectStreamClass_1_3_1(Class clazz, ObjectStreamClass_1_3_1 objectStreamClass_1_3_1, boolean bl2, boolean bl3) {
        this.ofClass = clazz;
        if (Proxy.isProxyClass(clazz)) {
            this.forProxyClass = true;
        }
        this.name = clazz.getName();
        this.superclass = objectStreamClass_1_3_1;
        this.serializable = bl2;
        if (!this.forProxyClass) {
            this.externalizable = bl3;
        }
        ObjectStreamClass_1_3_1.insertDescriptorFor(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Object object = this.lock;
        synchronized (object) {
            final Class clazz = this.ofClass;
            if (this.fields != null) {
                return;
            }
            if (!this.serializable || this.externalizable || this.forProxyClass || this.name.equals("java.lang.String")) {
                this.fields = NO_FIELDS;
            } else if (this.serializable) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Object object;
                        Field[] fieldArray;
                        try {
                            fieldArray = clazz.getDeclaredField("serialPersistentFields");
                            fieldArray.setAccessible(true);
                            object = (java.io.ObjectStreamField[])fieldArray.get(clazz);
                            int n2 = fieldArray.getModifiers();
                            if (Modifier.isPrivate(n2) && Modifier.isStatic(n2) && Modifier.isFinal(n2)) {
                                ObjectStreamClass_1_3_1.access$002(ObjectStreamClass_1_3_1.this, (ObjectStreamField[])ObjectStreamClass_1_3_1.translateFields((Object[])fieldArray.get(clazz)));
                            }
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                            ObjectStreamClass_1_3_1.access$002(ObjectStreamClass_1_3_1.this, null);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            ObjectStreamClass_1_3_1.access$002(ObjectStreamClass_1_3_1.this, null);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            ObjectStreamClass_1_3_1.access$002(ObjectStreamClass_1_3_1.this, null);
                        }
                        catch (ClassCastException classCastException) {
                            ObjectStreamClass_1_3_1.access$002(ObjectStreamClass_1_3_1.this, null);
                        }
                        if (ObjectStreamClass_1_3_1.this.fields == null) {
                            fieldArray = clazz.getDeclaredFields();
                            int n3 = 0;
                            ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[fieldArray.length];
                            for (int i2 = 0; i2 < fieldArray.length; ++i2) {
                                int n4 = fieldArray[i2].getModifiers();
                                if (Modifier.isStatic(n4) || Modifier.isTransient(n4)) continue;
                                objectStreamFieldArray[n3++] = new ObjectStreamField(fieldArray[i2]);
                            }
                            ObjectStreamClass_1_3_1.access$002(ObjectStreamClass_1_3_1.this, new ObjectStreamField[n3]);
                            System.arraycopy(objectStreamFieldArray, 0, ObjectStreamClass_1_3_1.this.fields, 0, n3);
                        } else {
                            for (int i3 = ObjectStreamClass_1_3_1.this.fields.length - 1; i3 >= 0; --i3) {
                                try {
                                    object = clazz.getDeclaredField(ObjectStreamClass_1_3_1.this.fields[i3].getName());
                                    if (ObjectStreamClass_1_3_1.this.fields[i3].getType() != ((Field)object).getType()) continue;
                                    ObjectStreamClass_1_3_1.this.fields[i3].setField((Field)object);
                                    continue;
                                }
                                catch (NoSuchFieldException noSuchFieldException) {
                                    // empty catch block
                                }
                            }
                        }
                        return null;
                    }
                });
                if (this.fields.length > 1) {
                    Arrays.sort(this.fields);
                }
                this.computeFieldInfo();
            }
            if (this.isNonSerializable()) {
                this.suid = 0L;
            } else {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        int n2;
                        Class[] classArray;
                        if (ObjectStreamClass_1_3_1.this.forProxyClass) {
                            ObjectStreamClass_1_3_1.this.suid = 0L;
                        } else {
                            try {
                                classArray = clazz.getDeclaredField("serialVersionUID");
                                n2 = classArray.getModifiers();
                                if (Modifier.isStatic(n2) && Modifier.isFinal(n2)) {
                                    classArray.setAccessible(true);
                                    ObjectStreamClass_1_3_1.this.suid = classArray.getLong(clazz);
                                } else {
                                    ObjectStreamClass_1_3_1.this.suid = ObjectStreamClass.getSerialVersionUID(clazz);
                                }
                            }
                            catch (NoSuchFieldException noSuchFieldException) {
                                ObjectStreamClass_1_3_1.this.suid = ObjectStreamClass.getSerialVersionUID(clazz);
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                ObjectStreamClass_1_3_1.this.suid = ObjectStreamClass.getSerialVersionUID(clazz);
                            }
                        }
                        try {
                            ObjectStreamClass_1_3_1.this.writeReplaceObjectMethod = clazz.getDeclaredMethod("writeReplace", noTypesList);
                            if (Modifier.isStatic(ObjectStreamClass_1_3_1.this.writeReplaceObjectMethod.getModifiers())) {
                                ObjectStreamClass_1_3_1.this.writeReplaceObjectMethod = null;
                            } else {
                                ObjectStreamClass_1_3_1.this.writeReplaceObjectMethod.setAccessible(true);
                            }
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                        try {
                            ObjectStreamClass_1_3_1.this.readResolveObjectMethod = clazz.getDeclaredMethod("readResolve", noTypesList);
                            if (Modifier.isStatic(ObjectStreamClass_1_3_1.this.readResolveObjectMethod.getModifiers())) {
                                ObjectStreamClass_1_3_1.this.readResolveObjectMethod = null;
                            } else {
                                ObjectStreamClass_1_3_1.this.readResolveObjectMethod.setAccessible(true);
                            }
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                        if (ObjectStreamClass_1_3_1.this.serializable && !ObjectStreamClass_1_3_1.this.forProxyClass) {
                            try {
                                classArray = new Class[]{ObjectOutputStream.class};
                                ObjectStreamClass_1_3_1.this.writeObjectMethod = clazz.getDeclaredMethod("writeObject", classArray);
                                ObjectStreamClass_1_3_1.this.hasWriteObjectMethod = true;
                                n2 = ObjectStreamClass_1_3_1.this.writeObjectMethod.getModifiers();
                                if (!Modifier.isPrivate(n2) || Modifier.isStatic(n2)) {
                                    ObjectStreamClass_1_3_1.this.writeObjectMethod = null;
                                    ObjectStreamClass_1_3_1.this.hasWriteObjectMethod = false;
                                }
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                // empty catch block
                            }
                            try {
                                classArray = new Class[]{ObjectInputStream.class};
                                ObjectStreamClass_1_3_1.this.readObjectMethod = clazz.getDeclaredMethod("readObject", classArray);
                                n2 = ObjectStreamClass_1_3_1.this.readObjectMethod.getModifiers();
                                if (!Modifier.isPrivate(n2) || Modifier.isStatic(n2)) {
                                    ObjectStreamClass_1_3_1.this.readObjectMethod = null;
                                }
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                // empty catch block
                            }
                        }
                        return null;
                    }
                });
            }
            this.actualSuid = ObjectStreamClass_1_3_1.computeStructuralUID(this, clazz);
        }
    }

    ObjectStreamClass_1_3_1(String string, long l2) {
        this.name = string;
        this.suid = l2;
        this.superclass = null;
    }

    private static Object[] translateFields(Object[] objectArray) throws NoSuchFieldException {
        try {
            java.io.ObjectStreamField[] objectStreamFieldArray = (java.io.ObjectStreamField[])objectArray;
            Object[] objectArray2 = null;
            if (translatedFields == null) {
                translatedFields = new Hashtable();
            }
            if ((objectArray2 = (Object[])translatedFields.get(objectStreamFieldArray)) != null) {
                return objectArray2;
            }
            Class<ObjectStreamField> clazz = ObjectStreamField.class;
            objectArray2 = (Object[])Array.newInstance(clazz, objectArray.length);
            Object[] objectArray3 = new Object[2];
            Class[] classArray = new Class[]{String.class, Class.class};
            Constructor constructor = clazz.getDeclaredConstructor(classArray);
            for (int i2 = objectStreamFieldArray.length - 1; i2 >= 0; --i2) {
                objectArray3[0] = objectStreamFieldArray[i2].getName();
                objectArray3[1] = objectStreamFieldArray[i2].getType();
                objectArray2[i2] = constructor.newInstance(objectArray3);
            }
            translatedFields.put(objectStreamFieldArray, objectArray2);
            return objectArray2;
        }
        catch (Throwable throwable) {
            throw new NoSuchFieldException();
        }
    }

    static boolean compareClassNames(String string, String string2, char c2) {
        int n2;
        int n3 = string.lastIndexOf(c2);
        if (n3 < 0) {
            n3 = 0;
        }
        if ((n2 = string2.lastIndexOf(c2)) < 0) {
            n2 = 0;
        }
        return string.regionMatches(false, n3, string2, n2, string.length() - n3);
    }

    final boolean typeEquals(ObjectStreamClass_1_3_1 objectStreamClass_1_3_1) {
        return this.suid == objectStreamClass_1_3_1.suid && ObjectStreamClass_1_3_1.compareClassNames(this.name, objectStreamClass_1_3_1.name, '.');
    }

    final void setSuperclass(ObjectStreamClass_1_3_1 objectStreamClass_1_3_1) {
        this.superclass = objectStreamClass_1_3_1;
    }

    final ObjectStreamClass_1_3_1 getSuperclass() {
        return this.superclass;
    }

    final boolean hasWriteObject() {
        return this.hasWriteObjectMethod;
    }

    final boolean isCustomMarshaled() {
        return this.hasWriteObject() || this.isExternalizable();
    }

    boolean hasExternalizableBlockDataMode() {
        return this.hasExternalizableBlockData;
    }

    final ObjectStreamClass_1_3_1 localClassDescriptor() {
        return this.localClassDesc;
    }

    boolean isSerializable() {
        return this.serializable;
    }

    boolean isExternalizable() {
        return this.externalizable;
    }

    boolean isNonSerializable() {
        return !this.externalizable && !this.serializable;
    }

    private void computeFieldInfo() {
        this.primBytes = 0;
        this.objFields = 0;
        block7: for (int i2 = 0; i2 < this.fields.length; ++i2) {
            switch (this.fields[i2].getTypeCode()) {
                case 'B': 
                case 'Z': {
                    ++this.primBytes;
                    continue block7;
                }
                case 'C': 
                case 'S': {
                    this.primBytes += 2;
                    continue block7;
                }
                case 'F': 
                case 'I': {
                    this.primBytes += 4;
                    continue block7;
                }
                case 'D': 
                case 'J': {
                    this.primBytes += 8;
                    continue block7;
                }
                case 'L': 
                case '[': {
                    ++this.objFields;
                }
            }
        }
    }

    private static long computeStructuralUID(ObjectStreamClass_1_3_1 objectStreamClass_1_3_1, Class clazz) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        long l2 = 0L;
        try {
            int n2;
            if (!Serializable.class.isAssignableFrom(clazz) || clazz.isInterface()) {
                return 0L;
            }
            if (Externalizable.class.isAssignableFrom(clazz)) {
                return 1L;
            }
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            DigestOutputStream digestOutputStream = new DigestOutputStream(byteArrayOutputStream, messageDigest);
            DataOutputStream dataOutputStream = new DataOutputStream(digestOutputStream);
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 != null) {
                dataOutputStream.writeLong(ObjectStreamClass_1_3_1.computeStructuralUID(ObjectStreamClass_1_3_1.lookup(clazz2), clazz2));
            }
            if (objectStreamClass_1_3_1.hasWriteObject()) {
                dataOutputStream.writeInt(2);
            } else {
                dataOutputStream.writeInt(1);
            }
            ObjectStreamField[] objectStreamFieldArray = objectStreamClass_1_3_1.getFields();
            int n3 = 0;
            for (int i2 = 0; i2 < objectStreamFieldArray.length; ++i2) {
                if (objectStreamFieldArray[i2].getField() == null) continue;
                ++n3;
            }
            Field[] fieldArray = new Field[n3];
            int n4 = 0;
            for (n2 = 0; n2 < objectStreamFieldArray.length; ++n2) {
                if (objectStreamFieldArray[n2].getField() == null) continue;
                fieldArray[n4++] = objectStreamFieldArray[n2].getField();
            }
            if (fieldArray.length > 1) {
                Arrays.sort(fieldArray, compareMemberByName);
            }
            for (n2 = 0; n2 < fieldArray.length; ++n2) {
                Field field = fieldArray[n2];
                int n5 = field.getModifiers();
                dataOutputStream.writeUTF(field.getName());
                dataOutputStream.writeUTF(ObjectStreamClass_1_3_1.getSignature(field.getType()));
            }
            dataOutputStream.flush();
            byte[] byArray = messageDigest.digest();
            for (n4 = 0; n4 < Math.min(8, byArray.length); ++n4) {
                l2 += (long)(byArray[n4] & 0xFF) << n4 * 8;
            }
        }
        catch (IOException iOException) {
            l2 = -1L;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityException(noSuchAlgorithmException.getMessage());
        }
        return l2;
    }

    static String getSignature(Class clazz) {
        String string = null;
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz;
            int n2 = 0;
            while (clazz2.isArray()) {
                ++n2;
                clazz2 = clazz2.getComponentType();
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuffer.append("[");
            }
            stringBuffer.append(ObjectStreamClass_1_3_1.getSignature(clazz2));
            string = stringBuffer.toString();
        } else if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                string = "I";
            } else if (clazz == Byte.TYPE) {
                string = "B";
            } else if (clazz == Long.TYPE) {
                string = "J";
            } else if (clazz == Float.TYPE) {
                string = "F";
            } else if (clazz == Double.TYPE) {
                string = "D";
            } else if (clazz == Short.TYPE) {
                string = "S";
            } else if (clazz == Character.TYPE) {
                string = "C";
            } else if (clazz == Boolean.TYPE) {
                string = "Z";
            } else if (clazz == Void.TYPE) {
                string = "V";
            }
        } else {
            string = "L" + clazz.getName().replace('.', '/') + ";";
        }
        return string;
    }

    static String getSignature(Method method) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        Class<?>[] classArray = method.getParameterTypes();
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            stringBuffer.append(ObjectStreamClass_1_3_1.getSignature(classArray[i2]));
        }
        stringBuffer.append(")");
        stringBuffer.append(ObjectStreamClass_1_3_1.getSignature(method.getReturnType()));
        return stringBuffer.toString();
    }

    static String getSignature(Constructor constructor) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        Class<?>[] classArray = constructor.getParameterTypes();
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            stringBuffer.append(ObjectStreamClass_1_3_1.getSignature(classArray[i2]));
        }
        stringBuffer.append(")V");
        return stringBuffer.toString();
    }

    private static ObjectStreamClass_1_3_1 findDescriptorFor(Class clazz) {
        ObjectStreamClassEntry objectStreamClassEntry;
        int n2 = clazz.hashCode();
        int n3 = (n2 & Integer.MAX_VALUE) % descriptorFor.length;
        while ((objectStreamClassEntry = descriptorFor[n3]) != null && objectStreamClassEntry.get() == null) {
            ObjectStreamClass_1_3_1.descriptorFor[n3] = objectStreamClassEntry.next;
        }
        ObjectStreamClassEntry objectStreamClassEntry2 = objectStreamClassEntry;
        while (objectStreamClassEntry != null) {
            ObjectStreamClass_1_3_1 objectStreamClass_1_3_1 = (ObjectStreamClass_1_3_1)objectStreamClassEntry.get();
            if (objectStreamClass_1_3_1 == null) {
                objectStreamClassEntry2.next = objectStreamClassEntry.next;
            } else {
                if (objectStreamClass_1_3_1.ofClass == clazz) {
                    return objectStreamClass_1_3_1;
                }
                objectStreamClassEntry2 = objectStreamClassEntry;
            }
            objectStreamClassEntry = objectStreamClassEntry.next;
        }
        return null;
    }

    private static void insertDescriptorFor(ObjectStreamClass_1_3_1 objectStreamClass_1_3_1) {
        if (ObjectStreamClass_1_3_1.findDescriptorFor(objectStreamClass_1_3_1.ofClass) != null) {
            return;
        }
        int n2 = objectStreamClass_1_3_1.ofClass.hashCode();
        int n3 = (n2 & Integer.MAX_VALUE) % descriptorFor.length;
        ObjectStreamClassEntry objectStreamClassEntry = new ObjectStreamClassEntry(objectStreamClass_1_3_1);
        objectStreamClassEntry.next = descriptorFor[n3];
        ObjectStreamClass_1_3_1.descriptorFor[n3] = objectStreamClassEntry;
    }

    private static Field[] getDeclaredFields(final Class clazz) {
        return (Field[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz.getDeclaredFields();
            }
        });
    }

    static /* synthetic */ ObjectStreamField[] access$002(ObjectStreamClass_1_3_1 objectStreamClass_1_3_1, ObjectStreamField[] objectStreamFieldArray) {
        objectStreamClass_1_3_1.fields = objectStreamFieldArray;
        return objectStreamFieldArray;
    }

    static {
        descriptorFor = new ObjectStreamClassEntry[61];
        classSerializable = null;
        classExternalizable = null;
        try {
            classSerializable = Class.forName("java.io.Serializable");
            classExternalizable = Class.forName("java.io.Externalizable");
        }
        catch (Throwable throwable) {
            System.err.println("Could not load java.io.Serializable or java.io.Externalizable.");
        }
        NO_FIELDS = new ObjectStreamField[0];
        compareClassByName = new CompareClassByName();
        compareMemberByName = new CompareMemberByName();
    }

    private static class CompareClassByName
    implements Comparator {
        private CompareClassByName() {
        }

        public int compare(Object object, Object object2) {
            Class clazz = (Class)object;
            Class clazz2 = (Class)object2;
            return clazz.getName().compareTo(clazz2.getName());
        }
    }

    private static class CompareMemberByName
    implements Comparator {
        private CompareMemberByName() {
        }

        public int compare(Object object, Object object2) {
            String string = ((Member)object).getName();
            String string2 = ((Member)object2).getName();
            if (object instanceof Method) {
                string = string + ObjectStreamClass_1_3_1.getSignature((Method)object);
                string2 = string2 + ObjectStreamClass_1_3_1.getSignature((Method)object2);
            } else if (object instanceof Constructor) {
                string = string + ObjectStreamClass_1_3_1.getSignature((Constructor)object);
                string2 = string2 + ObjectStreamClass_1_3_1.getSignature((Constructor)object2);
            }
            return string.compareTo(string2);
        }
    }

    private static class MethodSignature
    implements Comparator {
        Member member;
        String signature;

        static MethodSignature[] removePrivateAndSort(Member[] memberArray) {
            int n2 = 0;
            for (int i2 = 0; i2 < memberArray.length; ++i2) {
                if (Modifier.isPrivate(memberArray[i2].getModifiers())) continue;
                ++n2;
            }
            MethodSignature[] methodSignatureArray = new MethodSignature[n2];
            int n3 = 0;
            for (int i3 = 0; i3 < memberArray.length; ++i3) {
                if (Modifier.isPrivate(memberArray[i3].getModifiers())) continue;
                methodSignatureArray[n3] = new MethodSignature(memberArray[i3]);
                ++n3;
            }
            if (n3 > 0) {
                Arrays.sort(methodSignatureArray, methodSignatureArray[0]);
            }
            return methodSignatureArray;
        }

        public int compare(Object object, Object object2) {
            int n2;
            if (object == object2) {
                return 0;
            }
            MethodSignature methodSignature = (MethodSignature)object;
            MethodSignature methodSignature2 = (MethodSignature)object2;
            if (this.isConstructor()) {
                n2 = methodSignature.signature.compareTo(methodSignature2.signature);
            } else {
                n2 = methodSignature.member.getName().compareTo(methodSignature2.member.getName());
                if (n2 == 0) {
                    n2 = methodSignature.signature.compareTo(methodSignature2.signature);
                }
            }
            return n2;
        }

        private final boolean isConstructor() {
            return this.member instanceof Constructor;
        }

        private MethodSignature(Member member) {
            this.member = member;
            this.signature = this.isConstructor() ? ObjectStreamClass_1_3_1.getSignature((Constructor)member) : ObjectStreamClass_1_3_1.getSignature((Method)member);
        }
    }

    private static class ObjectStreamClassEntry {
        ObjectStreamClassEntry next;
        private ObjectStreamClass_1_3_1 c;

        ObjectStreamClassEntry(ObjectStreamClass_1_3_1 objectStreamClass_1_3_1) {
            this.c = objectStreamClass_1_3_1;
        }

        public Object get() {
            return this.c;
        }
    }
}

