/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.syslogng.util;

import com.clustercontrol.syslogng.message.UpdateMonitorRuleInfo;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SendTopic {
    protected static Log m_log = LogFactory.getLog(SendTopic.class);
    protected String m_topicName;
    protected TopicConnectionFactory m_connectionFactory;
    protected TopicConnection m_connection;
    protected Topic m_topic;
    protected TopicSession m_session;

    public SendTopic(String topicName) throws NamingException, JMSException {
        this.m_topicName = topicName;
        this.connect();
    }

    protected void connect() throws NamingException, JMSException {
        InitialContext context = new InitialContext();
        this.m_connectionFactory = (TopicConnectionFactory)context.lookup("ConnectionFactory");
        this.m_connection = this.m_connectionFactory.createTopicConnection();
        this.m_session = this.m_connection.createTopicSession(false, 1);
        this.m_topic = (Topic)context.lookup(this.m_topicName);
        context.close();
    }

    public void put(UpdateMonitorRuleInfo info) throws JMSException {
        TopicPublisher publisher = this.m_session.createPublisher(this.m_topic);
        ObjectMessage message = this.m_session.createObjectMessage((Serializable)info);
        publisher.publish((Message)message);
        m_log.debug((Object)"put() topic ");
        publisher.close();
        this.m_session.close();
        this.m_connection.close();
    }
}

