/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.components;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.internal.components.framework.ComponentException;
import org.eclipse.ui.internal.components.framework.ComponentFactory;
import org.eclipse.ui.internal.components.framework.ComponentHandle;
import org.eclipse.ui.internal.components.framework.IServiceProvider;
import org.eclipse.ui.internal.components.framework.ReflectionFactory;
import org.eclipse.ui.internal.components.framework.SingletonFactory;

public class ExecutableExtensionFactory
extends ComponentFactory {
    private String attributeId;
    private IConfigurationElement configElement;
    private ComponentFactory cachedAdapter = null;

    public ExecutableExtensionFactory(IConfigurationElement configElement, String attributeId) {
        this.configElement = configElement;
        this.attributeId = attributeId;
    }

    public ComponentHandle createHandle(IServiceProvider availableServices) throws ComponentException {
        if (this.cachedAdapter != null) {
            try {
                ComponentHandle result = this.cachedAdapter.createHandle(availableServices);
                return result;
            }
            catch (ComponentException e) {
                if (this.cachedAdapter instanceof ReflectionFactory || this.cachedAdapter instanceof SingletonFactory) {
                    throw e;
                }
                throw new ComponentException(this.cachedAdapter.getClass(), (Throwable)e);
            }
        }
        IServiceProvider actualContainer = availableServices;
        try {
            this.cachedAdapter = (ComponentFactory)this.configElement.createExecutableExtension("class");
        }
        catch (CoreException e) {
            throw new ComponentException(this.configElement, (Throwable)e);
        }
        return this.cachedAdapter.createHandle(actualContainer);
    }

    public int hashCode() {
        return this.configElement.hashCode() + this.attributeId.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExecutableExtensionFactory)) {
            return false;
        }
        ExecutableExtensionFactory t = (ExecutableExtensionFactory)obj;
        return this.configElement == t.configElement && this.attributeId.equals(t.attributeId);
    }

    public void dispose() {
        this.cachedAdapter = null;
    }
}

