/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.export.conf.monitor;

import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.performance.bean.CollectorItemInfo;
import com.clustercontrol.performance.monitor.bean.MonitorPerfCheckInfo;
import com.clustercontrol.performance.monitor.ejb.session.MonitorPerfController;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import jp.co.intellilink.hinemos.export.conf.monitor.ExportMonitorNumeric;
import jp.co.intellilink.hinemos.export.conf.performance.CollectorItemCodeFactory;
import jp.co.intellilink.hinemos.export.util.Config;
import jp.co.intellilink.hinemos.export.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.export.util.Messages;
import jp.co.intellilink.hinemos.export.util.StringListComparator;
import jp.co.intellilink.hinemos.export.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportMonitorPerformance
extends ExportMonitorNumeric {
    private static Log log = LogFactory.getLog(ExportMonitorPerformance.class);

    public ExportMonitorPerformance() {
        super(1);
    }

    public void exportPerformance() {
        log.info((Object)Messages.getMsg("ExportTool.Resource.Start"));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList arrayList2 = this.getPerformanceList();
        if (arrayList2 instanceof ArrayList) {
            for (ArrayList arrayList3 : arrayList2) {
                Object[] objectArray = new Object[]{(String)arrayList3.get(0)};
                log.info((Object)Messages.getMsg("ExportTool.MonitorID", objectArray));
                MonitorInfo monitorInfo = this.getPerformance((String)arrayList3.get(0));
                arrayList.add(this.createCsvFormat(monitorInfo));
            }
            Collections.sort(arrayList, new StringListComparator(0));
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        WriteCsvFile.writeCsvFile(Config.getConfig("Output.Dir.Conf") + "/RESOURCE_" + simpleDateFormat.format(new Date()) + ".csv", arrayList);
        log.info((Object)Messages.getMsg("ExportTool.Resource.End"));
    }

    @Override
    public ArrayList<String> createMonitorInfo(MonitorInfo monitorInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("");
        MonitorPerfCheckInfo monitorPerfCheckInfo = (MonitorPerfCheckInfo)monitorInfo.getCheckInfo();
        if (monitorPerfCheckInfo != null) {
            List<CollectorItemInfo> list = CollectorItemCodeFactory.getAvailableCollectorItemList(monitorInfo.getFacilityId());
            for (CollectorItemInfo collectorItemInfo : list) {
                if (!collectorItemInfo.getItemCode().equals(monitorPerfCheckInfo.getItemCode()) || !collectorItemInfo.getDeviceName().equals(monitorPerfCheckInfo.getDeviceName())) continue;
                String string = CollectorItemCodeFactory.getFullItemName(collectorItemInfo);
                arrayList.set(0, string);
                break;
            }
        }
        return arrayList;
    }

    protected MonitorInfo getPerformance(String string) {
        MonitorPerfController monitorPerfController = EjbConnectionManager.getConnectionManager().getMonitorPerfController();
        MonitorInfo monitorInfo = null;
        try {
            monitorInfo = monitorPerfController.getPerformance(string);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ExportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return monitorInfo;
    }

    protected ArrayList getPerformanceList() {
        MonitorPerfController monitorPerfController = EjbConnectionManager.getConnectionManager().getMonitorPerfController();
        ArrayList arrayList = null;
        try {
            arrayList = monitorPerfController.getPerformanceList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ExportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

