/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.export.conf.monitor;

import com.clustercontrol.http.bean.MonitorHttpInfo;
import com.clustercontrol.http.ejb.session.MonitorHttpController;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorTypeConstant;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import jp.co.intellilink.hinemos.export.conf.monitor.ExportMonitorString;
import jp.co.intellilink.hinemos.export.util.Config;
import jp.co.intellilink.hinemos.export.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.export.util.IntegerListComparator;
import jp.co.intellilink.hinemos.export.util.Messages;
import jp.co.intellilink.hinemos.export.util.StringListComparator;
import jp.co.intellilink.hinemos.export.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportMonitorHttpString
extends ExportMonitorString {
    private static Log log = LogFactory.getLog(ExportMonitorHttpString.class);

    public void exportHttp() {
        log.info((Object)Messages.getMsg("ExportTool.Http.Start"));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList<ArrayList<String>> arrayList2 = new ArrayList<ArrayList<String>>();
        ArrayList arrayList3 = this.getHttpList();
        if (arrayList3 instanceof ArrayList) {
            for (ArrayList arrayList4 : arrayList3) {
                int n = MonitorTypeConstant.stringToType((String)((String)arrayList4.get(3)));
                if (n != 2) continue;
                Object[] objectArray = new Object[]{(String)arrayList4.get(0)};
                log.info((Object)Messages.getMsg("ExportTool.MonitorID", objectArray));
                MonitorInfo monitorInfo = this.getHttp((String)arrayList4.get(0), n);
                arrayList.add(this.createCsvFormat(monitorInfo));
                arrayList2.addAll(this.createMonitorJudgement(monitorInfo));
            }
            Collections.sort(arrayList, new StringListComparator(0));
            Collections.sort(arrayList2, new IntegerListComparator(1));
            Collections.sort(arrayList2, new StringListComparator(0));
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        WriteCsvFile.writeCsvFile(Config.getConfig("Output.Dir.Conf") + "/HTTP_STR_" + simpleDateFormat.format(new Date()) + ".csv", arrayList);
        WriteCsvFile.writeCsvFile(Config.getConfig("Output.Dir.Conf") + "/HTTP_STR_RULE_" + simpleDateFormat.format(new Date()) + ".csv", arrayList2);
        log.info((Object)Messages.getMsg("ExportTool.Http.End"));
    }

    @Override
    public ArrayList<String> createMonitorInfo(MonitorInfo monitorInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        MonitorHttpInfo monitorHttpInfo = (MonitorHttpInfo)monitorInfo.getCheckInfo();
        if (monitorHttpInfo == null) {
            monitorHttpInfo = new MonitorHttpInfo();
        }
        if (monitorHttpInfo.getRequestUrl() != null) {
            arrayList.add(monitorHttpInfo.getRequestUrl());
        } else {
            arrayList.add("");
        }
        arrayList.add(String.valueOf(monitorHttpInfo.getTimeout()));
        return arrayList;
    }

    protected MonitorInfo getHttp(String string, int n) {
        MonitorHttpController monitorHttpController = EjbConnectionManager.getConnectionManager().getMonitorHttpController();
        MonitorInfo monitorInfo = null;
        try {
            monitorInfo = monitorHttpController.getHttpInfo(string, n);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ExportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return monitorInfo;
    }

    protected ArrayList getHttpList() {
        MonitorHttpController monitorHttpController = EjbConnectionManager.getConnectionManager().getMonitorHttpController();
        ArrayList arrayList = null;
        try {
            arrayList = monitorHttpController.getHttpList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ExportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

