/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.export.conf.job;

import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.bean.JobConstant;
import com.clustercontrol.bean.JobParamTypeConstant;
import com.clustercontrol.bean.JudgmentObjectConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.jobmanagement.bean.ConditionTypeConstant;
import com.clustercontrol.jobmanagement.bean.JobCommandInfo;
import com.clustercontrol.jobmanagement.bean.JobEndStatusInfo;
import com.clustercontrol.jobmanagement.bean.JobFileInfo;
import com.clustercontrol.jobmanagement.bean.JobInfo;
import com.clustercontrol.jobmanagement.bean.JobNotificationsInfo;
import com.clustercontrol.jobmanagement.bean.JobObjectInfo;
import com.clustercontrol.jobmanagement.bean.JobParameterInfo;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.bean.JobWaitRuleInfo;
import com.clustercontrol.jobmanagement.bean.OperationConstant;
import com.clustercontrol.jobmanagement.ejb.session.JobController;
import com.clustercontrol.notify.bean.NotifyRelationInfo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import jp.co.intellilink.hinemos.export.util.Config;
import jp.co.intellilink.hinemos.export.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.export.util.Messages;
import jp.co.intellilink.hinemos.export.util.StringListComparator;
import jp.co.intellilink.hinemos.export.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportJob {
    private static Log log = LogFactory.getLog(ExportJob.class);

    public void exportJob() {
        log.info((Object)Messages.getMsg("ExportTool.Job.Start"));
        JobTreeItem jobTreeItem = this.getJobTree();
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        this.getJobData(jobTreeItem, arrayList);
        Collections.sort(arrayList, new StringListComparator(0));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        WriteCsvFile.writeCsvFile(Config.getConfig("Output.Dir.Conf") + "/JOB_" + simpleDateFormat.format(new Date()) + ".csv", arrayList);
        ArrayList<ArrayList<String>> arrayList2 = new ArrayList<ArrayList<String>>();
        this.getJobWaitRule(jobTreeItem, arrayList2);
        Collections.sort(arrayList2, new StringListComparator(0));
        WriteCsvFile.writeCsvFile(Config.getConfig("Output.Dir.Conf") + "/JOB_WAIT_" + simpleDateFormat.format(new Date()) + ".csv", arrayList2);
        ArrayList<ArrayList<String>> arrayList3 = new ArrayList<ArrayList<String>>();
        this.getJobNotify(jobTreeItem, arrayList3);
        Collections.sort(arrayList3, new StringListComparator(0));
        WriteCsvFile.writeCsvFile(Config.getConfig("Output.Dir.Conf") + "/JOB_NOTIFY_" + simpleDateFormat.format(new Date()) + ".csv", arrayList3);
        ArrayList<ArrayList<String>> arrayList4 = new ArrayList<ArrayList<String>>();
        this.getJobDelay(jobTreeItem, arrayList4);
        Collections.sort(arrayList4, new StringListComparator(0));
        WriteCsvFile.writeCsvFile(Config.getConfig("Output.Dir.Conf") + "/JOB_DELAY_" + simpleDateFormat.format(new Date()) + ".csv", arrayList4);
        ArrayList<ArrayList<String>> arrayList5 = new ArrayList<ArrayList<String>>();
        this.getJobParam(jobTreeItem, arrayList5);
        Collections.sort(arrayList5, new StringListComparator(1));
        Collections.sort(arrayList5, new StringListComparator(0));
        WriteCsvFile.writeCsvFile(Config.getConfig("Output.Dir.Conf") + "/JOB_PARAM_" + simpleDateFormat.format(new Date()) + ".csv", arrayList5);
        log.info((Object)Messages.getMsg("ExportTool.Job.End"));
    }

    public void getJobData(JobTreeItem jobTreeItem, ArrayList<ArrayList<String>> arrayList) {
        JobTreeItem[] jobTreeItemArray;
        if (jobTreeItem.getData() instanceof JobInfo && (jobTreeItemArray = jobTreeItem.getData()).getId() != null && jobTreeItemArray.getId().compareTo("") != 0) {
            JobTreeItem jobTreeItem2;
            Object[] objectArray = new Object[]{jobTreeItemArray.getId()};
            log.info((Object)Messages.getMsg("ExportTool.JobID", objectArray));
            ArrayList<String> arrayList2 = this.createCsvFormat((JobInfo)jobTreeItemArray);
            String string = "";
            if (jobTreeItem.getParent() != null && jobTreeItem.getParent().getData() instanceof JobInfo && (jobTreeItem2 = jobTreeItem.getParent().getData()).getId() != null && jobTreeItem2.getId().compareTo("") != 0) {
                string = jobTreeItem2.getId();
            }
            arrayList2.add(4, string);
            arrayList.add(arrayList2);
        }
        jobTreeItemArray = jobTreeItem.getChildren();
        for (JobTreeItem jobTreeItem2 : jobTreeItemArray) {
            this.getJobData(jobTreeItem2, arrayList);
        }
    }

    public ArrayList<String> createBaseOutput(JobInfo jobInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(jobInfo.getId());
        arrayList.add(jobInfo.getName());
        if (jobInfo.getDescription() != null) {
            arrayList.add(jobInfo.getDescription());
        } else {
            arrayList.add("");
        }
        arrayList.add(JobConstant.typeToString((int)jobInfo.getType()));
        return arrayList;
    }

    public ArrayList<String> createCsvFormat(JobInfo jobInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.createBaseOutput(jobInfo));
        arrayList.addAll(this.createEndStatus(jobInfo));
        arrayList.addAll(this.createRule(jobInfo));
        arrayList.addAll(this.createCommand(jobInfo));
        arrayList.addAll(this.createFile(jobInfo));
        return arrayList;
    }

    public ArrayList<String> createEndStatus(JobInfo jobInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        for (int i = 0; i < 3; ++i) {
            arrayList2.add("");
            arrayList3.add("");
        }
        arrayList4.add("");
        for (JobEndStatusInfo jobEndStatusInfo : jobInfo.getEndStatus()) {
            Object var8_9 = null;
            if (jobEndStatusInfo.getType() == 0) {
                arrayList2.set(0, String.valueOf(jobEndStatusInfo.getValue()));
                arrayList2.set(1, String.valueOf(jobEndStatusInfo.getStartRangeValue()));
                arrayList2.set(2, String.valueOf(jobEndStatusInfo.getEndRangeValue()));
                continue;
            }
            if (jobEndStatusInfo.getType() == 1) {
                arrayList3.set(0, String.valueOf(jobEndStatusInfo.getValue()));
                arrayList3.set(1, String.valueOf(jobEndStatusInfo.getStartRangeValue()));
                arrayList3.set(2, String.valueOf(jobEndStatusInfo.getEndRangeValue()));
                continue;
            }
            if (jobEndStatusInfo.getType() != 2) continue;
            arrayList4.set(0, String.valueOf(jobEndStatusInfo.getValue()));
        }
        arrayList.addAll(arrayList2);
        arrayList.addAll(arrayList3);
        arrayList.addAll(arrayList4);
        return arrayList;
    }

    public ArrayList<String> createRule(JobInfo jobInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        JobWaitRuleInfo jobWaitRuleInfo = jobInfo.getWaitRule();
        if (jobWaitRuleInfo instanceof JobWaitRuleInfo) {
            arrayList.add(ConditionTypeConstant.typeToString((int)jobWaitRuleInfo.getCondition()));
            arrayList.add(YesNoConstant.typeToString((int)jobWaitRuleInfo.getEndCondition()));
            arrayList.add(String.valueOf(jobWaitRuleInfo.getEndValue()));
            arrayList.add(YesNoConstant.typeToString((int)jobWaitRuleInfo.getCalendar()));
            if (jobWaitRuleInfo.getCalendarId() != null) {
                arrayList.add(jobWaitRuleInfo.getCalendarId());
            } else {
                arrayList.add("");
            }
            arrayList.add(String.valueOf(jobWaitRuleInfo.getCalendarEndValue()));
            arrayList.add(YesNoConstant.typeToString((int)jobWaitRuleInfo.getSuspend()));
            arrayList.add(YesNoConstant.typeToString((int)jobWaitRuleInfo.getSkip()));
            arrayList.add(String.valueOf(jobWaitRuleInfo.getSkipEndValue()));
        } else {
            for (int i = 0; i < 9; ++i) {
                arrayList.add("");
            }
        }
        return arrayList;
    }

    public ArrayList<String> createCommand(JobInfo jobInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        JobCommandInfo jobCommandInfo = jobInfo.getCommand();
        if (jobCommandInfo instanceof JobCommandInfo) {
            if (jobCommandInfo.getFacilityID().equals("${FACILITY_ID}")) {
                arrayList.add(com.clustercontrol.util.Messages.getString((String)"job.parameter"));
                arrayList.add("");
            } else {
                arrayList.add(com.clustercontrol.util.Messages.getString((String)"fixed.value"));
                arrayList.add(jobCommandInfo.getFacilityID());
            }
            if (jobCommandInfo.getProcessingMethod() == 0) {
                arrayList.add(com.clustercontrol.util.Messages.getString((String)"scope.process.all.nodes"));
            } else {
                arrayList.add(com.clustercontrol.util.Messages.getString((String)"scope.process.retry.nodes"));
            }
            if (jobCommandInfo.getStartCommand() != null) {
                arrayList.add(jobCommandInfo.getStartCommand());
            } else {
                arrayList.add("");
            }
            if (jobCommandInfo.getStopCommand() != null) {
                arrayList.add(jobCommandInfo.getStopCommand());
            } else {
                arrayList.add("");
            }
            if (jobCommandInfo.getUser() != null) {
                arrayList.add(jobCommandInfo.getUser());
            } else {
                arrayList.add("");
            }
            arrayList.add(YesNoConstant.typeToString((int)jobCommandInfo.getErrorEndFlg()));
            arrayList.add(String.valueOf(jobCommandInfo.getErrorEndValue()));
        } else {
            for (int i = 0; i < 8; ++i) {
                arrayList.add("");
            }
        }
        return arrayList;
    }

    public ArrayList<String> createFile(JobInfo jobInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        JobFileInfo jobFileInfo = jobInfo.getFile();
        if (jobFileInfo instanceof JobFileInfo) {
            if (jobFileInfo.getSrcFacilityID() != null) {
                arrayList.add(jobFileInfo.getSrcFacilityID());
            } else {
                arrayList.add("");
            }
            if (jobFileInfo.getSrcFile() != null) {
                arrayList.add(jobFileInfo.getSrcFile());
            } else {
                arrayList.add("");
            }
            if (jobFileInfo.getDestFacilityID() != null) {
                arrayList.add(jobFileInfo.getDestFacilityID());
            } else {
                arrayList.add("");
            }
            if (jobFileInfo.getProcessingMethod() == 0) {
                arrayList.add(com.clustercontrol.util.Messages.getString((String)"scope.process.all.nodes"));
            } else {
                arrayList.add(com.clustercontrol.util.Messages.getString((String)"scope.process.retry.nodes"));
            }
            if (jobFileInfo.getDestDirectory() != null) {
                arrayList.add(jobFileInfo.getDestDirectory());
            } else {
                arrayList.add("");
            }
            arrayList.add(YesNoConstant.typeToString((int)jobFileInfo.getCompressionFlg()));
            arrayList.add(YesNoConstant.typeToString((int)jobFileInfo.getCheckFlg()));
            if (jobFileInfo.getUser() != null) {
                arrayList.add(jobFileInfo.getUser());
            } else {
                arrayList.add("");
            }
        } else {
            for (int i = 0; i < 8; ++i) {
                arrayList.add("");
            }
        }
        return arrayList;
    }

    public void getJobWaitRule(JobTreeItem jobTreeItem, ArrayList<ArrayList<String>> arrayList) {
        JobTreeItem[] jobTreeItemArray;
        if (jobTreeItem.getData() instanceof JobInfo && (jobTreeItemArray = jobTreeItem.getData()).getId() != null && jobTreeItemArray.getId().compareTo("") != 0) {
            Object[] objectArray = new Object[]{jobTreeItemArray.getId()};
            log.info((Object)Messages.getMsg("ExportTool.JobID", objectArray));
            if (jobTreeItemArray.getWaitRule() instanceof JobWaitRuleInfo) {
                for (JobObjectInfo jobObjectInfo : jobTreeItemArray.getWaitRule().getObject()) {
                    ArrayList<String> object = new ArrayList<String>();
                    object.add(jobTreeItemArray.getId());
                    object.addAll(this.createWairRuleCsvFormat(jobObjectInfo));
                    if (object.size() <= 1) continue;
                    arrayList.add(object);
                }
            }
        }
        jobTreeItemArray = jobTreeItem.getChildren();
        for (JobTreeItem jobTreeItem2 : jobTreeItemArray) {
            this.getJobWaitRule(jobTreeItem2, arrayList);
        }
    }

    public ArrayList<String> createWairRuleCsvFormat(JobObjectInfo jobObjectInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SimpleDateFormat simpleDateFormat = null;
        if (jobObjectInfo instanceof JobObjectInfo) {
            arrayList.add(JudgmentObjectConstant.typeToString((int)jobObjectInfo.getType()));
            if (jobObjectInfo.getType() == 0) {
                arrayList.add(jobObjectInfo.getJobId());
                arrayList.add(EndStatusConstant.typeToString((int)jobObjectInfo.getValue()));
            } else if (jobObjectInfo.getType() == 1) {
                arrayList.add(jobObjectInfo.getJobId());
                arrayList.add(String.valueOf(jobObjectInfo.getValue()));
            } else if (jobObjectInfo.getType() == 2) {
                arrayList.add("");
                if (simpleDateFormat == null) {
                    simpleDateFormat = new SimpleDateFormat("HH:mm");
                }
                arrayList.add(simpleDateFormat.format(jobObjectInfo.getTime()));
            }
        }
        return arrayList;
    }

    public void getJobNotify(JobTreeItem jobTreeItem, ArrayList<ArrayList<String>> arrayList) {
        JobTreeItem[] jobTreeItemArray;
        if (jobTreeItem.getData() instanceof JobInfo && (jobTreeItemArray = jobTreeItem.getData()).getId() != null && jobTreeItemArray.getId().compareTo("") != 0) {
            Object[] objectArray = new Object[]{jobTreeItemArray.getId()};
            log.info((Object)Messages.getMsg("ExportTool.JobID", objectArray));
            arrayList.add(this.createNotifyCsvFormat((JobInfo)jobTreeItemArray));
        }
        jobTreeItemArray = jobTreeItem.getChildren();
        for (JobTreeItem jobTreeItem2 : jobTreeItemArray) {
            this.getJobNotify(jobTreeItem2, arrayList);
        }
    }

    public ArrayList<String> createNotifyCsvFormat(JobInfo jobInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        JobNotificationsInfo jobNotificationsInfo = null;
        arrayList.add(jobInfo.getId());
        for (JobNotificationsInfo jobNotificationsInfo2 : jobInfo.getNotifications()) {
            if (jobNotificationsInfo2.getType() == 3) {
                string = PriorityConstant.typeToString((int)jobNotificationsInfo2.getPriority());
                continue;
            }
            if (jobNotificationsInfo2.getType() == 0) {
                jobNotificationsInfo = jobNotificationsInfo2;
                string2 = PriorityConstant.typeToString((int)jobNotificationsInfo2.getPriority());
                continue;
            }
            if (jobNotificationsInfo2.getType() == 1) {
                string3 = PriorityConstant.typeToString((int)jobNotificationsInfo2.getPriority());
                continue;
            }
            if (jobNotificationsInfo2.getType() != 2) continue;
            string4 = PriorityConstant.typeToString((int)jobNotificationsInfo2.getPriority());
        }
        arrayList.add(string);
        arrayList.add(string2);
        arrayList.add(string3);
        arrayList.add(string4);
        arrayList.addAll(this.createNotify(jobNotificationsInfo));
        return arrayList;
    }

    protected ArrayList<String> createNotify(JobNotificationsInfo jobNotificationsInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (jobNotificationsInfo != null && jobNotificationsInfo.getNotifyId() != null) {
            Collection collection = jobNotificationsInfo.getNotifyId();
            for (int i = 0; i < collection.size(); ++i) {
                NotifyRelationInfo notifyRelationInfo = (NotifyRelationInfo)((ArrayList)collection).get(i);
                if (notifyRelationInfo.getNotifyType() == 0) {
                    string = notifyRelationInfo.getNotifyId();
                    continue;
                }
                if (notifyRelationInfo.getNotifyType() == 1) {
                    string2 = notifyRelationInfo.getNotifyId();
                    continue;
                }
                if (notifyRelationInfo.getNotifyType() == 2) {
                    string3 = notifyRelationInfo.getNotifyId();
                    continue;
                }
                if (notifyRelationInfo.getNotifyType() == 3) {
                    string4 = notifyRelationInfo.getNotifyId();
                    continue;
                }
                if (notifyRelationInfo.getNotifyType() != 4) continue;
                string5 = notifyRelationInfo.getNotifyId();
            }
        }
        arrayList.add(string);
        arrayList.add(string2);
        arrayList.add(string3);
        arrayList.add(string4);
        arrayList.add(string5);
        return arrayList;
    }

    public void getJobDelay(JobTreeItem jobTreeItem, ArrayList<ArrayList<String>> arrayList) {
        JobTreeItem[] jobTreeItemArray;
        if (jobTreeItem.getData() instanceof JobInfo && (jobTreeItemArray = jobTreeItem.getData()).getId() != null && jobTreeItemArray.getId().compareTo("") != 0) {
            Object[] objectArray = new Object[]{jobTreeItemArray.getId()};
            log.info((Object)Messages.getMsg("ExportTool.JobID", objectArray));
            if (jobTreeItemArray.getType() != 0 && jobTreeItemArray.getWaitRule() instanceof JobWaitRuleInfo) {
                arrayList.add(this.createDelayCsvFormat((JobInfo)jobTreeItemArray));
            }
        }
        jobTreeItemArray = jobTreeItem.getChildren();
        for (JobTreeItem jobTreeItem2 : jobTreeItemArray) {
            this.getJobDelay(jobTreeItem2, arrayList);
        }
    }

    public ArrayList<String> createDelayCsvFormat(JobInfo jobInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        JobWaitRuleInfo jobWaitRuleInfo = jobInfo.getWaitRule();
        arrayList.add(jobInfo.getId());
        if (jobWaitRuleInfo instanceof JobWaitRuleInfo) {
            SimpleDateFormat simpleDateFormat;
            arrayList.add(YesNoConstant.typeToString((int)jobWaitRuleInfo.getStart_delay()));
            arrayList.add(YesNoConstant.typeToString((int)jobWaitRuleInfo.getStart_delay_session()));
            arrayList.add(String.valueOf(jobWaitRuleInfo.getStart_delay_session_value()));
            arrayList.add(YesNoConstant.typeToString((int)jobWaitRuleInfo.getStart_delay_time()));
            if (jobWaitRuleInfo.getStart_delay_time_value() instanceof Date) {
                simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
                arrayList.add(simpleDateFormat.format(jobWaitRuleInfo.getStart_delay_time_value()));
            } else {
                arrayList.add("");
            }
            arrayList.add(ConditionTypeConstant.typeToString((int)jobWaitRuleInfo.getStart_delay_condition_type()));
            arrayList.add(YesNoConstant.typeToString((int)jobWaitRuleInfo.getStart_delay_notify()));
            arrayList.add(PriorityConstant.typeToString((int)jobWaitRuleInfo.getStart_delay_notify_priority()));
            arrayList.add(YesNoConstant.typeToString((int)jobWaitRuleInfo.getStart_delay_operation()));
            if (jobWaitRuleInfo.getStart_delay_operation_type() == 4) {
                arrayList.add(OperationConstant.STRING_STOP_SKIP);
            } else if (jobWaitRuleInfo.getStart_delay_operation_type() == 6) {
                arrayList.add(OperationConstant.STRING_STOP_WAIT);
            } else {
                arrayList.add(OperationConstant.STRING_STOP_SKIP);
            }
            arrayList.add(String.valueOf(jobWaitRuleInfo.getStart_delay_operation_end_value()));
            arrayList.add(YesNoConstant.typeToString((int)jobWaitRuleInfo.getEnd_delay()));
            arrayList.add(YesNoConstant.typeToString((int)jobWaitRuleInfo.getEnd_delay_session()));
            arrayList.add(String.valueOf(jobWaitRuleInfo.getEnd_delay_session_value()));
            arrayList.add(YesNoConstant.typeToString((int)jobWaitRuleInfo.getEnd_delay_job()));
            arrayList.add(String.valueOf(jobWaitRuleInfo.getEnd_delay_job_value()));
            arrayList.add(YesNoConstant.typeToString((int)jobWaitRuleInfo.getEnd_delay_time()));
            if (jobWaitRuleInfo.getEnd_delay_time_value() instanceof Date) {
                simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
                arrayList.add(simpleDateFormat.format(jobWaitRuleInfo.getEnd_delay_time_value()));
            } else {
                arrayList.add("");
            }
            arrayList.add(ConditionTypeConstant.typeToString((int)jobWaitRuleInfo.getEnd_delay_condition_type()));
            arrayList.add(YesNoConstant.typeToString((int)jobWaitRuleInfo.getEnd_delay_notify()));
            arrayList.add(PriorityConstant.typeToString((int)jobWaitRuleInfo.getEnd_delay_notify_priority()));
            arrayList.add(YesNoConstant.typeToString((int)jobWaitRuleInfo.getEnd_delay_operation()));
            if (jobWaitRuleInfo.getEnd_delay_operation_type() == 0) {
                arrayList.add(OperationConstant.STRING_STOP_AT_ONCE);
            } else if (jobWaitRuleInfo.getEnd_delay_operation_type() == 2) {
                arrayList.add(OperationConstant.STRING_STOP_SUSPEND);
            } else if (jobWaitRuleInfo.getEnd_delay_operation_type() == 10) {
                arrayList.add(OperationConstant.STRING_STOP_SET_END_VALUE);
            } else {
                arrayList.add(OperationConstant.STRING_STOP_AT_ONCE);
            }
            arrayList.add(String.valueOf(jobWaitRuleInfo.getEnd_delay_operation_end_value()));
        } else {
            for (int i = 0; i < 24; ++i) {
                arrayList.add("");
            }
        }
        return arrayList;
    }

    public void getJobParam(JobTreeItem jobTreeItem, ArrayList<ArrayList<String>> arrayList) {
        JobTreeItem[] jobTreeItemArray;
        if (jobTreeItem.getData() instanceof JobInfo && (jobTreeItemArray = jobTreeItem.getData()).getId() != null && jobTreeItemArray.getId().compareTo("") != 0) {
            Object[] objectArray = new Object[]{jobTreeItemArray.getId()};
            log.info((Object)Messages.getMsg("ExportTool.JobID", objectArray));
            if (jobTreeItemArray.getParam() != null) {
                ArrayList arrayList2 = jobTreeItemArray.getParam();
                for (JobTreeItem jobTreeItem2 : arrayList2) {
                    ArrayList<String> arrayList3 = new ArrayList<String>();
                    arrayList3.add(jobTreeItemArray.getId());
                    arrayList3.addAll(this.createParamCsvFormat((JobParameterInfo)jobTreeItem2));
                    if (arrayList3.size() <= 1) continue;
                    arrayList.add(arrayList3);
                }
            }
        }
        jobTreeItemArray = jobTreeItem.getChildren();
        for (JobTreeItem jobTreeItem2 : jobTreeItemArray) {
            this.getJobParam(jobTreeItem2, arrayList);
        }
    }

    public ArrayList<String> createParamCsvFormat(JobParameterInfo jobParameterInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (jobParameterInfo instanceof JobParameterInfo) {
            arrayList.add(jobParameterInfo.getParamId());
            arrayList.add(JobParamTypeConstant.typeToString((int)jobParameterInfo.getType()));
            if (jobParameterInfo.getType() == 1) {
                arrayList.add(String.valueOf(jobParameterInfo.getValue()));
            } else {
                arrayList.add("");
            }
            arrayList.add(jobParameterInfo.getDescription());
        }
        return arrayList;
    }

    protected JobTreeItem getJobTree() {
        JobController jobController = EjbConnectionManager.getConnectionManager().getJobController();
        JobTreeItem jobTreeItem = null;
        try {
            jobTreeItem = jobController.getJobTree(false, Locale.getDefault());
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ExportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return jobTreeItem;
    }
}

