/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.export.conf.performance;

import com.clustercontrol.performance.bean.CollectorItemInfo;
import com.clustercontrol.performance.ejb.session.CollectorController;
import com.clustercontrol.performance.util.code.CollectorItemTreeItem;
import java.util.HashMap;
import java.util.List;
import jp.co.intellilink.hinemos.export.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.export.util.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectorItemCodeFactory {
    private static HashMap<String, CollectorItemTreeItem> m_codeTable = null;
    private static Log log = LogFactory.getLog(CollectorItemCodeFactory.class);

    private CollectorItemCodeFactory() {
    }

    public static void init() {
        m_codeTable = CollectorItemCodeFactory.getItemCodeTreeMap();
    }

    public static String getItemName(String string) {
        if (m_codeTable == null) {
            CollectorItemCodeFactory.init();
        }
        return m_codeTable.get(string).getItemName();
    }

    public static String getFullItemName(String string, String string2) {
        if (m_codeTable == null) {
            CollectorItemCodeFactory.init();
        }
        String string3 = string2 == null || string2.equals("none") || string2.equals("") ? m_codeTable.get(string).getItemName() : m_codeTable.get(string).getItemName() + "[" + string2 + "]";
        return string3;
    }

    public static String getFullItemName(CollectorItemInfo collectorItemInfo) {
        String string;
        if (m_codeTable == null) {
            CollectorItemCodeFactory.init();
        }
        if (CollectorItemCodeFactory.isDeviceSupport(string = collectorItemInfo.getItemCode())) {
            return CollectorItemCodeFactory.getFullItemName(collectorItemInfo.getItemCode(), collectorItemInfo.getDeviceName());
        }
        return CollectorItemCodeFactory.getItemName(string);
    }

    public static boolean isDeviceSupport(String string) {
        if (m_codeTable == null) {
            CollectorItemCodeFactory.init();
        }
        return m_codeTable.get(string).isDeviceFlag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CollectorItemInfo> getAvailableCollectorItemList(String string) {
        List list = null;
        CollectorController collectorController = EjbConnectionManager.getConnectionManager().getCollectorController();
        try {
            list = collectorController.getAvailableCollectorItemList(string);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ExportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        finally {
            if (collectorController != null) {
                try {
                    collectorController.remove();
                }
                catch (Exception exception) {}
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, CollectorItemTreeItem> getItemCodeTreeMap() {
        HashMap hashMap = null;
        CollectorController collectorController = EjbConnectionManager.getConnectionManager().getCollectorController();
        try {
            hashMap = collectorController.getItemCodeMap();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ExportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        finally {
            if (collectorController != null) {
                try {
                    collectorController.remove();
                }
                catch (Exception exception) {}
            }
        }
        return hashMap;
    }

    public static String getMeasure(String string) {
        if (m_codeTable == null) {
            CollectorItemCodeFactory.init();
        }
        return m_codeTable.get(string).getMeasure();
    }
}

