/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.export.performance;

import com.clustercontrol.bean.RunIntervalConstant;
import com.clustercontrol.performance.bean.CollectorItemInfo;
import com.clustercontrol.performance.bean.CollectorProperty;
import com.clustercontrol.performance.ejb.bmp.RecordCollectorData;
import com.clustercontrol.performance.ejb.session.CollectorController;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import jp.co.intellilink.hinemos.export.performance.CollectorItemCodeFactory;
import jp.co.intellilink.hinemos.export.util.Config;
import jp.co.intellilink.hinemos.export.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.export.util.Messages;
import jp.co.intellilink.hinemos.export.util.StringListComparator;
import jp.co.intellilink.hinemos.export.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportPerformance {
    private static Log log = LogFactory.getLog(ExportPerformance.class);

    public void exportPerformance() {
        log.info((Object)Messages.getMsg("ExportTool.Performance.Start"));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList arrayList2 = this.getPerformanceList();
        if (arrayList2 instanceof ArrayList) {
            for (ArrayList arrayList3 : arrayList2) {
                Object[] objectArray = new Object[]{(String)arrayList3.get(2)};
                log.info((Object)Messages.getMsg("ExportTool.CollectorID", objectArray));
                CollectorProperty collectorProperty = this.getPerformance((String)arrayList3.get(2));
                arrayList.add(this.createCsvFormat(collectorProperty));
            }
            Collections.sort(arrayList, new StringListComparator(0));
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        WriteCsvFile.writeCsvFile(Config.getConfig("Output.Dir") + "/PERFORMANCE_" + simpleDateFormat.format(new Date()) + ".csv", arrayList);
        log.info((Object)Messages.getMsg("ExportTool.Performance.End"));
    }

    public ArrayList<String> createCsvFormat(CollectorProperty collectorProperty) {
        ArrayList<String> arrayList = new ArrayList<String>();
        RecordCollectorData recordCollectorData = collectorProperty.getCollectorData();
        arrayList.add(recordCollectorData.getCollectorID());
        arrayList.add(recordCollectorData.getLabel());
        arrayList.add(recordCollectorData.getFacilityID());
        arrayList.add(RunIntervalConstant.typeToString((int)recordCollectorData.getIntervalSec()));
        int n = recordCollectorData.getPeriodMin();
        if (n != -1) {
            arrayList.add(Messages.getMsg("PERIOD_SETTING"));
        } else {
            arrayList.add(Messages.getMsg("UNLIMIT_COLLECT"));
        }
        if (n != -1) {
            arrayList.add(Integer.toString(n / 60 / 24));
            arrayList.add(Integer.toString(n / 60 % 24));
            arrayList.add(Integer.toString(n % 60));
            arrayList.add("");
        } else {
            arrayList.add("");
            arrayList.add("");
            arrayList.add("");
            arrayList.add(Integer.toString(recordCollectorData.getPresavePeriod()));
        }
        List list = collectorProperty.getItemList();
        for (CollectorItemInfo collectorItemInfo : list) {
            String string = CollectorItemCodeFactory.getFullItemName(collectorItemInfo);
            arrayList.add(string);
        }
        return arrayList;
    }

    protected CollectorProperty getPerformance(String string) {
        CollectorController collectorController = EjbConnectionManager.getConnectionManager().getCollectorController();
        CollectorProperty collectorProperty = null;
        try {
            collectorProperty = collectorController.getCollectorProperty(string);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ExportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return collectorProperty;
    }

    protected ArrayList getPerformanceList() {
        CollectorController collectorController = EjbConnectionManager.getConnectionManager().getCollectorController();
        ArrayList arrayList = null;
        try {
            arrayList = collectorController.getCollectionList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ExportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

