/*
 
Copyright (C) 2008 NTT DATA INTELLILINK CORPORATION
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.snmptrap.factory;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import javax.ejb.CreateException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;

import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterData;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterUtil;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterData;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterUtil;

/**
 * Add MIB Info
 *
 * @version 2.3.0
 * @since 2.3.0
 */
public class AddMibInfo {
	protected static Log m_log = LogFactory.getLog( AddMibInfo.class );
	
	protected static final String LOOKUP_NAME = "jmx/invoker/RMIAdaptor";
	protected static final String TRAP_OBJECT_NAME = "jboss.j2ee:jndiName=SnmpTrapMaster,service=EJB";
	protected static final String MIB_OBJECT_NAME = "jboss.j2ee:jndiName=SnmpTrapMibMaster,service=EJB";
	protected static final String OPERATION_NAME = "flushCache";
	
	/**
	 * Add MIB Info
	 * 
	 * @param mib
	 * @param traps
	 * @param user
	 * @return true/false
	 * @throws CreateException 
	 * @throws NamingException
	 */
	public void add(SnmpTrapMibMasterData mib, List<SnmpTrapMasterData> traps, String user) throws CreateException, NamingException {

		try {
			Timestamp now = new Timestamp(new Date().getTime());
			
			SnmpTrapMibMasterUtil.getLocalHome().create(
					mib.getMib(), 
					mib.getOrderNo(),  
					mib.getDescription(), 
					now, 
					now, 
					user, 
					user);
			
			Iterator itr = traps.iterator();
			while(itr.hasNext()){
				SnmpTrapMasterData trap = (SnmpTrapMasterData)itr.next();
				SnmpTrapMasterUtil.getLocalHome().create(
						trap.getMib(), 
						trap.getTrapOid(), 
						trap.getGenericId(), 
						trap.getSpecificId(), 
						trap.getUei(), 
						trap.getPriority(), 
						trap.getLogmsg(), 
						trap.getDescr());
			}
			
			flushCache(MIB_OBJECT_NAME);
			flushCache(TRAP_OBJECT_NAME);
			
		} catch (CreateException e) {
			m_log.debug("add() : " + e.getMessage());
			throw e;
		} catch (NamingException e) {
			m_log.debug("add() : " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * flush entity Cache 
	 * 
	 * @param objectName
	 */
	public void flushCache(String objectName) {
		
		try{
	        InitialContext ic = new InitialContext();
	        
	        //RMIAdaptorを取得
	        RMIAdaptor server = (RMIAdaptor) ic.lookup(LOOKUP_NAME);

	        //ObjectNameを設定
	        ObjectName name = new ObjectName(objectName);
	        
	        //ObjectNameのOperationNameのメソッドを実行
	        server.invoke(name, OPERATION_NAME, null, null);
	        
		} catch (NamingException e) {
			m_log.debug("flushCache() : " + e.getMessage());
		} catch (MalformedObjectNameException e) {
			m_log.debug("flushCache() : " + e.getMessage());
		} catch (NullPointerException e) {
			m_log.debug("flushCache() : " + e.getMessage());
		} catch (InstanceNotFoundException e) {
			m_log.debug("flushCache() : " + e.getMessage());
		} catch (MBeanException e) {
			m_log.debug("flushCache() : " + e.getMessage());
		} catch (ReflectionException e) {
			m_log.debug("flushCache() : " + e.getMessage());
		} catch (IOException e) {
			m_log.debug("flushCache() : " + e.getMessage());
		}
	}
}
