/*
 
Copyright (C) 2008 NTT DATA INTELLILINK CORPORATION
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.snmptrap.mibloader.etc.action;

import java.io.File;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.snmptrap.mibloader.action.AddMibFile;
import com.clustercontrol.snmptrap.mibloader.util.Messages;

/**
 * Select MIB file Action Class
 * 
 * @version 2.3.0
 * @since 2.3.0
 */
public class SelectMibFile implements IWorkbenchWindowActionDelegate {

    /**
     * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#dispose()
     */
    public void dispose() {
    }

    /**
     * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#init(org.eclipse.ui.IWorkbenchWindow)
     */
    public void init(IWorkbenchWindow window) {
    }

    /**
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run(IAction action) {
        Shell shell = 
        	PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();

        FileDialog dialog = new FileDialog(shell, SWT.OPEN|SWT.MULTI);
        dialog.setText(Messages.getString("message.snmptrap.trap.4"));
        dialog.open();
        String[] filePaths = dialog.getFileNames();
        
		if(filePaths.length > 0){
	        for(int i = 0; i < filePaths.length; i++)
	        	filePaths[i] = dialog.getFilterPath() +  File.separator  + filePaths[i];
	        
	        AddMibFile add = new AddMibFile();
	        add.add(filePaths);
		}
		else{
			return;
		}
    }

    /**
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {
    }
}