/*
 
Copyright (C) 2008 NTT DATA INTELLILINK CORPORATION
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.snmptrap.mibloader.action;

import java.io.File;
import java.io.IOException;
import java.util.List;

import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibLoader;
import net.percederberg.mibble.MibLoaderException;

import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterData;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterData;

/**
 * Create MIB data entiy
 * 
 * @version 2.3.0
 * @since 2.3.0
 */
public class EntityFactory {
	protected SnmpTrapMibMasterData mibData = null;
	protected List<SnmpTrapMasterData> trapsData = null;
	
	public EntityFactory(){
		
	}
	
    /**
     * Create MIB data entiy
     * 
     * @param filePath
     * @throws MibLoaderException 
     * @throws IOException 
     */
    public void create(String filePath) throws IOException, MibLoaderException {
		File file = new File(filePath);
		MibLoader loader = new MibLoader();
		loader.addDir(file.getParentFile());
		Mib mib;
		try {
			mib = loader.load(file);
		} catch (NullPointerException e) {
			e.printStackTrace();
			throw new IOException();
		}
		
		MibFactory mibFactory = new MibFactory();
		mibData = mibFactory.create(mib);
		
		TrapsFactory trapsFactory = new TrapsFactory();
		trapsData = trapsFactory.create(mib);
    }

	public SnmpTrapMibMasterData getMibData() {
		return mibData;
	}

	public void setMibData(SnmpTrapMibMasterData mibData) {
		this.mibData = mibData;
	}

	public List<SnmpTrapMasterData> getTrapsData() {
		return trapsData;
	}

	public void setTrapsData(List<SnmpTrapMasterData> trapsData) {
		this.trapsData = trapsData;
	}
}