/*
 
Copyright (C) 2008 NTT DATA INTELLILINK CORPORATION
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.snmptrap.mibloader.action;

import java.io.UnsupportedEncodingException;

import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.snmp.SnmpTrapType;
import net.percederberg.mibble.value.NumberValue;
import net.percederberg.mibble.value.ObjectIdentifierValue;

import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterData;

/**
 * Create V1 Trap SnmpTrapMasterData
 * 
 * @version 2.3.0
 * @since 2.3.0
 */
public class TrapV1Factory extends TrapFactory {

	/**
	 * Create SnmpTrapMasterData(snmpv1)
	 * 
	 */
	public SnmpTrapMasterData create(MibSymbol symbol) {
		if(symbol == null)
			return null;
		
		SnmpTrapMasterData trap = new SnmpTrapMasterData();
		
		MibValueSymbol valueSymbol = (MibValueSymbol)symbol;
		SnmpTrapType trapType = (SnmpTrapType)valueSymbol.getType();
		if(!(trapType.getEnterprise() instanceof ObjectIdentifierValue))
			return null;
		ObjectIdentifierValue enterpriseValue = (ObjectIdentifierValue)trapType.getEnterprise();
		NumberValue value = (NumberValue)valueSymbol.getValue();
		
		// set oid
//TODO standard trapsの判断はどうする？
//		if(enterpriseValue.getName().equals("snmp")){
//			trap.setTrapOid(DOT_CHAR + enterpriseValue.toString());
//			trap.setGenericId(Integer.valueOf(value.toString()));
//			trap.setSpecificId(0);
//		}
//		else{
			trap.setTrapOid(DOT_CHAR + enterpriseValue.toString());
			trap.setGenericId(6);
			trap.setSpecificId(Integer.valueOf(value.toString()));
//		}
		
		// set uei
		String uei = enterpriseValue.toDetailString() + "/" + valueSymbol.getName();
		uei = uei.replaceAll("\\([0-9]*\\)", "");
		uei = uei.replaceAll("\\.", "/");
		uei = uei.replaceAll(".*(mib-2|enterprises)/", "");
		trap.setUei(uei);
			
		// set long message & description
		StringBuilder longmsg = new StringBuilder();
		StringBuilder description = new StringBuilder();
		longmsg.append(valueSymbol.getName() + " trap received");
		description.append(trapType.getDescription());
		for(int i = 0; i < trapType.getVariables().size(); i++){
			ObjectIdentifierValue tempValue = 
				(ObjectIdentifierValue)trapType.getVariables().get(i);
			longmsg.append(" " + tempValue.getName() + "=%parm[#" + Integer.toString(i + 1) + "]%");
			description.append("\n" + tempValue.getName() + "=%parm[#" + Integer.toString(i + 1) + "]%");
		}
		
		try {
			if(longmsg.toString().getBytes("UTF-8").length > 256){
				trap.setLogmsg(valueSymbol.getName() + " trap received");
			}
			else{
				trap.setLogmsg(longmsg.toString());
			}
		} catch (UnsupportedEncodingException e) {
			trap.setLogmsg(longmsg.toString());
		}
		trap.setDescr(description.toString());
		
		return trap;
	}
}