/*
 
Copyright (C) 2008 NTT DATA INTELLILINK CORPORATION
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.snmptrap.mibloader;

import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * SnmpTrap Mib Loader Class
 * 
 * @version 2.3.0
 * @since 2.3.0
 */
public class SnmpTrapMibLoaderPlugin extends AbstractUIPlugin {
	
	private static SnmpTrapMibLoaderPlugin plugin;
	
	public static SnmpTrapMibLoaderPlugin getDefault() {
		return plugin;
	}
	
	/**
	 * Get Resource String
	 * 
	 * @param key
	 * @return
	 */
	public static String getResourceString(String key) {
		ResourceBundle bundle = getDefault().getResourceBundle();
		try {
			return (bundle != null) ? bundle.getString(key) : key;
		} catch (MissingResourceException e) {
			return key;
		}
	}
	
	/**
	 * Get Resource String
	 *
	 * @param key
	 * @param arguments
	 * @return
	 */
	public static String getResourceString(String key, Object[] arguments) {
		ResourceBundle bundle = getDefault().getResourceBundle();
		try {
			String message = (bundle != null) ? bundle.getString(key) : key;
			return MessageFormat.format(message, arguments);
		} catch (MissingResourceException e) {
			return key;
		}
	}
	
	/**
	 * Output log
	 * 
	 * @param message
	 * @param e
	 */
	public static void log(String message, Exception e) {
		IStatus status = new Status(IStatus.ERROR, getPluginId(),
				IStatus.ERROR, message, e);
		getDefault().getLog().log(status);
	}
	
	/**
	 * Output log
	 * 
	 * @param message
	 */
	public static void log(String message) {
		log(message, null);
	}
	
	/**
	 * Output log
	 * 
	 * @param e
	 */
	public static void log(Exception e) {
		StringWriter stringWriter = new StringWriter();
		String message = stringWriter.getBuffer().toString();
		log(message, e);
	}
	
	/**
	 * Get Plugin Id
	 * 
	 * @return PluginId
	 */
	public static String getPluginId() {
		return getDefault().getBundle().getSymbolicName();
	}
	
	private ResourceBundle resourceBundle = null;
	
	public SnmpTrapMibLoaderPlugin() {
		super();
		plugin = this;
		try {
			resourceBundle = ResourceBundle
			.getBundle("com.clustercontrol.snmptrap.mibloader.SnmpTrapMibLoaderPluginResources");
		} catch (MissingResourceException x) {
			resourceBundle = null;
		}
	}
	
	/* (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}
	
	/* (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
	}
	
	/**
	 * Get ResourceBundle
	 * 
	 * @return Resource Bundle
	 */
	public ResourceBundle getResourceBundle() {
		return resourceBundle;
	}
}
