/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser.re;

import java.io.PrintWriter;
import java.util.BitSet;
import net.percederberg.grammatica.parser.re.CharBuffer;
import net.percederberg.grammatica.parser.re.Element;
import net.percederberg.grammatica.parser.re.Matcher;

class RepeatElement
extends Element {
    public static final int GREEDY = 1;
    public static final int RELUCTANT = 2;
    public static final int POSSESSIVE = 3;
    private Element elem;
    private int min;
    private int max;
    private int type;
    private int matchStart;
    private BitSet matches;

    public RepeatElement(Element element, int n, int n2, int n3) {
        this.elem = element;
        this.min = n;
        this.max = n2 <= 0 ? Integer.MAX_VALUE : n2;
        this.type = n3;
        this.matchStart = -1;
        this.matches = null;
    }

    public Object clone() {
        return new RepeatElement((Element)this.elem.clone(), this.min, this.max, this.type);
    }

    public int match(Matcher matcher, CharBuffer charBuffer, int n, int n2) {
        if (n2 == 0) {
            this.matchStart = -1;
            this.matches = null;
        }
        switch (this.type) {
            case 1: {
                return this.matchGreedy(matcher, charBuffer, n, n2);
            }
            case 2: {
                return this.matchReluctant(matcher, charBuffer, n, n2);
            }
            case 3: {
                if (n2 != 0) break;
                return this.matchPossessive(matcher, charBuffer, n, 0);
            }
        }
        return -1;
    }

    private int matchGreedy(Matcher matcher, CharBuffer charBuffer, int n, int n2) {
        if (n2 == 0) {
            return this.matchPossessive(matcher, charBuffer, n, 0);
        }
        if (this.matchStart != n) {
            this.matchStart = n;
            this.matches = new BitSet();
            this.findMatches(matcher, charBuffer, n, 0, 0, 0);
        }
        int n3 = this.matches.size();
        while (n3 >= 0) {
            if (this.matches.get(n3)) {
                if (n2 == 0) {
                    return n3;
                }
                --n2;
            }
            --n3;
        }
        return -1;
    }

    private int matchReluctant(Matcher matcher, CharBuffer charBuffer, int n, int n2) {
        if (this.matchStart != n) {
            this.matchStart = n;
            this.matches = new BitSet();
            this.findMatches(matcher, charBuffer, n, 0, 0, 0);
        }
        int n3 = 0;
        while (n3 <= this.matches.size()) {
            if (this.matches.get(n3)) {
                if (n2 == 0) {
                    return n3;
                }
                --n2;
            }
            ++n3;
        }
        return -1;
    }

    private int matchPossessive(Matcher matcher, CharBuffer charBuffer, int n, int n2) {
        int n3 = 0;
        int n4 = 1;
        while (n4 > 0 && n2 < this.max) {
            n4 = this.elem.match(matcher, charBuffer, n + n3, 0);
            if (n4 < 0) continue;
            ++n2;
            n3 += n4;
        }
        if (this.min <= n2 && n2 <= this.max) {
            return n3;
        }
        return -1;
    }

    private void findMatches(Matcher matcher, CharBuffer charBuffer, int n, int n2, int n3, int n4) {
        int n5;
        if (n3 > this.max) {
            return;
        }
        if (this.min <= n3 && n4 == 0) {
            this.matches.set(n2);
        }
        if ((n5 = this.elem.match(matcher, charBuffer, n, n4)) < 0) {
            return;
        }
        if (n5 == 0) {
            if (this.min == n3 + 1) {
                this.matches.set(n2);
            }
            return;
        }
        this.findMatches(matcher, charBuffer, n, n2, n3, n4 + 1);
        this.findMatches(matcher, charBuffer, n + n5, n2 + n5, n3 + 1, 0);
    }

    public void printTo(PrintWriter printWriter, String string) {
        printWriter.print(string + "Repeat (" + this.min + "," + this.max + ")");
        if (this.type == 2) {
            printWriter.print("?");
        } else if (this.type == 3) {
            printWriter.print("+");
        }
        printWriter.println();
        this.elem.printTo(printWriter, string + "  ");
    }
}

